/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.inventory;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.inventory.IInventoryPixelmon;
import com.pixelmonmod.pixelmon.client.gui.inventory.SlotInventoryPixelmon;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiPokeCheckerTabs;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetHeldItem;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.ClientData;
import com.pixelmonmod.pixelmon.storage.PCClient;
import com.pixelmonmod.pixelmon.storage.PCPos;
import java.awt.Rectangle;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

class InventoryPixelmon<T extends InventoryEffectRenderer> {
    private T gui;
    private int partyWidth;
    private SlotInventoryPixelmon[] pixelmonSlots;
    private boolean pixelmonMenuOpen;
    private int menuX;
    private int menuY;
    private GuiPokeCheckerTabs pMenuButtonSumm;
    private GuiPokeCheckerTabs pMenuButtonMove;
    private GuiPokeCheckerTabs pMenuButtonStat;
    private PixelmonData selected;
    private PCClient pcClient = new PCClient();
    private Rectangle buttonBounds;
    private Rectangle buttonBoundsMoves;
    private Rectangle buttonBoundsStat;
    private boolean hasActivePotionEffects;
    int ticksTillClick = 0;

    InventoryPixelmon(T gui, int partyWidth) {
        this.gui = gui;
        this.pixelmonMenuOpen = false;
        this.pixelmonSlots = new SlotInventoryPixelmon[6];
        this.pcClient.unselectAll();
        this.partyWidth = partyWidth;
    }

    private void drawButtonContainer() {
        if (this.pixelmonMenuOpen) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pokecheckerPopup);
            this.gui.func_73729_b(this.menuX + ((IInventoryPixelmon)this.gui).getGUILeft() - 73, this.menuY - 10, 0, 0, 67, 76);
            int xOffset = this.menuX + ((IInventoryPixelmon)this.gui).getGUILeft() - 63;
            this.pMenuButtonSumm.setXPosition(xOffset);
            this.pMenuButtonMove.setXPosition(xOffset);
            this.pMenuButtonStat.setXPosition(xOffset);
            this.buttonBounds.x = xOffset;
            this.buttonBoundsMoves.x = xOffset;
            this.buttonBoundsStat.x = xOffset;
        }
    }

    void initGui() {
        this.fillSlots();
    }

    private void fillSlots() {
        for (int i = 0; i < this.pixelmonSlots.length; ++i) {
            this.pixelmonSlots[i] = null;
        }
        for (PixelmonData p : ServerStorageDisplay.getPokemon()) {
            if (p == null) continue;
            int i = p.order;
            int x = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 9;
            int y = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + i * 18 - 65;
            this.pixelmonSlots[i] = new SlotInventoryPixelmon(x, y, p);
        }
    }

    void drawScreen(int mouseX, int mouseY, float partialTicks) {
        boolean recipeBookVisible;
        this.hasActivePotionEffects = ((InventoryEffectRenderer)this.gui).field_147045_u;
        boolean bl = recipeBookVisible = this.gui instanceof GuiInventory && ((GuiInventory)this.gui).func_194310_f().func_191878_b();
        if (((InventoryEffectRenderer)this.gui).field_147045_u && !recipeBookVisible) {
            ((InventoryEffectRenderer)this.gui).field_147045_u = false;
            ((IInventoryPixelmon)this.gui).superDrawScreen(mouseX, mouseY, partialTicks);
            ((InventoryEffectRenderer)this.gui).field_147045_u = true;
        } else {
            ((IInventoryPixelmon)this.gui).superDrawScreen(mouseX, mouseY, partialTicks);
        }
        if (recipeBookVisible) {
            return;
        }
        GlStateManager.func_179140_f();
        if (this.pixelmonMenuOpen) {
            this.gui.func_73732_a(((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p, this.selected.getNickname(), this.menuX + ((IInventoryPixelmon)this.gui).getGUILeft() - 40, this.menuY - 8, 0xFFFFFF);
        } else {
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(true);
            for (SlotInventoryPixelmon s : this.pixelmonSlots) {
                if (s == null) continue;
                if (s.getBounds().contains(mouseX, mouseY)) {
                    this.drawPokemonInfo(mouseX, mouseY, s);
                }
                if (s.pokemonData.isEgg || !s.getHeldItemBounds().contains(mouseX, mouseY) || !this.heldItemQualifies(s) || this.ticksTillClick > 0) continue;
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonCreativeInventory);
                GuiHelper.drawImageQuad(s.heldItemX - 2, s.heldItemY - 2, 20.0, 20.0f, 0.2265625, 0.72265625, 0.3046875, 0.80078125, ((IInventoryPixelmon)this.gui).getZLevel());
                if (s.pokemonData.heldItem.func_190926_b()) continue;
                int x = Math.max(s.x - 84, 0);
                ((IInventoryPixelmon)this.gui).subDrawGradientRect(x, s.y - 2, x + 60, s.y + 20, -13158600, -13158600);
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(s.pokemonData.heldItem.func_82833_r(), x + 2, s.y, 0xFFFFFF);
            }
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(false);
        }
    }

    void drawGuiContainerBackgroundLayer(float renderPartialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71460_t.func_78478_c();
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(true);
        for (SlotInventoryPixelmon slot : this.pixelmonSlots) {
            PixelmonData p;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (slot == null || (p = slot.pokemonData) == null) continue;
            int x = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 9;
            slot.setX(x);
            GuiHelper.bindPokemonSprite(p, ((InventoryEffectRenderer)this.gui).field_146297_k);
            GlStateManager.func_179140_f();
            GuiHelper.drawImageQuad(slot.x, slot.y - (p.isGen6Sprite() ? 0 : 3), 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
            if (!p.isEgg) {
                if (p.heldItem != ItemStack.field_190927_a) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.func_175599_af().func_175042_a(p.heldItem, slot.heldItemX, slot.heldItemY);
                } else {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.heldItem);
                    GuiHelper.drawImageQuad(slot.heldItemX + 3, slot.heldItemY + 3, 10.0, 10.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                }
            }
            if (!p.selected) continue;
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pcBox);
            GuiHelper.drawImageQuad(slot.x, slot.y - 1, 16.0, 17.0f, 0.0, 0.55859375, 0.12109375, 0.68359375, ((IInventoryPixelmon)this.gui).getZLevel());
        }
        int slotleft = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 25;
        int slottop = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + 49;
        EnumMegaItem megaItem = EntityPlayerExtension.getPlayerMegaItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (megaItem != EnumMegaItem.Disabled) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.keyStoneSprite);
            GuiHelper.drawImageQuad(slotleft - 18, slottop, 14.0, 14.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
            if (megaItem == EnumMegaItem.BraceletORAS) {
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.megaBraceletORAS);
                GuiHelper.drawImageQuad(slotleft, slottop, 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
            }
            if (mouseX >= slotleft && mouseX <= slotleft + 16 && mouseY >= slottop && mouseY <= slottop + 16) {
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonCreativeInventory);
                GuiHelper.drawImageQuad(slotleft - 2, slottop - 2, 20.0, 20.0f, 0.2265625, 0.72265625, 0.3046875, 0.80078125, ((IInventoryPixelmon)this.gui).getZLevel());
            }
        }
        if (megaItem == EnumMegaItem.Disabled || megaItem == EnumMegaItem.None) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.noItem);
            GuiHelper.drawImageQuad(slotleft, slottop, 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
        }
        String money = NumberFormat.getInstance().format(ClientData.playerMoney);
        GuiHelper.drawStringRightAligned(money, ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 44, ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + 70, 0, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(false);
        this.drawButtonContainer();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
    }

    private boolean heldItemQualifies(SlotInventoryPixelmon s) {
        InventoryPlayer inv = ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by;
        ItemStack stack = inv.func_70445_o();
        if (stack.func_190926_b() && !s.pokemonData.heldItem.func_190926_b()) {
            return true;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemHeld;
    }

    private void drawPokemonInfo(int mouseX, int mouseY, SlotInventoryPixelmon s) {
        if (s == null) {
            return;
        }
        int x = Math.max(s.x - 84, 0);
        ((IInventoryPixelmon)this.gui).subDrawGradientRect(x, s.y - 2, x + 80, s.y + 20, -13158600, -13158600);
        PixelmonData p = s.pokemonData;
        String displayName = p.getNickname();
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(displayName, x + 2, s.y, 0xFFFFFF);
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonOverlay);
        if (!p.isEgg) {
            if (p.gender == Gender.Male) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.male);
                GuiHelper.drawImageQuad(((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(displayName) + x + 3, s.y, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            } else if (p.gender == Gender.Female) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.female);
                GuiHelper.drawImageQuad(((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(displayName) + x + 3, s.y, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            }
            String levelString = I18n.func_74838_a((String)"gui.screenpokechecker.lvl") + " " + p.lvl;
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(levelString, x + 3, s.y + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
            if (p.health <= 0) {
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.creativeinv.fainted"), x + 7 + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(levelString), s.y + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
            } else {
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.creativeinv.hp") + " " + p.health + "/" + p.hp, x + 7 + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(levelString), s.y + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
            }
        }
    }

    boolean mouseClicked(int x, int y, int mouseButton) throws IOException {
        List<GuiButton> buttonList = ((IInventoryPixelmon)this.gui).getButtonList();
        if (mouseButton == 0) {
            if (this.pixelmonMenuOpen && this.buttonBounds.contains(x, y)) {
                SoundHelper.playButtonPressSound();
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.PokeChecker.getIndex().intValue(), (World)((InventoryEffectRenderer)this.gui).field_146297_k.field_71441_e, this.selected.pokemonID[0], this.selected.pokemonID[1], 0);
            }
            if (this.pixelmonMenuOpen && this.buttonBoundsMoves.contains(x, y)) {
                SoundHelper.playButtonPressSound();
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.PokeCheckerMoves.getIndex().intValue(), (World)((InventoryEffectRenderer)this.gui).field_146297_k.field_71441_e, this.selected.pokemonID[0], this.selected.pokemonID[1], 0);
            }
            if (this.pixelmonMenuOpen && this.buttonBoundsStat.contains(x, y)) {
                SoundHelper.playButtonPressSound();
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.PokeCheckerStats.getIndex().intValue(), (World)((InventoryEffectRenderer)this.gui).field_146297_k.field_71441_e, this.selected.pokemonID[0], this.selected.pokemonID[1], 0);
            }
            if (this.pixelmonMenuOpen) {
                buttonList.remove((Object)this.pMenuButtonSumm);
                buttonList.remove((Object)this.pMenuButtonMove);
                buttonList.remove((Object)this.pMenuButtonStat);
                this.pMenuButtonSumm = null;
                this.pMenuButtonMove = null;
                this.pMenuButtonStat = null;
                this.pixelmonMenuOpen = false;
                this.selected = null;
            }
        }
        int slotleft = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 25;
        int slottop = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + 49;
        if (EntityPlayerExtension.getPlayerMegaItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g) != EnumMegaItem.Disabled && x >= slotleft && x <= slotleft + 16 && y >= slottop && y <= slottop + 16) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.MegaItem.getIndex().intValue(), (World)((InventoryEffectRenderer)this.gui).field_146297_k.field_71441_e, 0, 0, 0);
            return false;
        }
        for (int i = 0; i < this.pixelmonSlots.length; ++i) {
            ItemStack oldItem;
            SlotInventoryPixelmon s = this.pixelmonSlots[i];
            int xSlot = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 9;
            int ySlot = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + i * 18 - 65;
            if (x >= xSlot && x <= xSlot + 16 && y >= ySlot && y <= ySlot + 16 && mouseButton == 0) {
                if (s != null && s.pokemonData.selected) {
                    s.pokemonData.selected = false;
                } else if (s != null && this.pcClient.numSelected() < 1) {
                    s.pokemonData.selected = true;
                } else {
                    if (s != null) {
                        this.pcClient.swapPokemonWithSelected(s.pokemonData);
                    } else {
                        this.pcClient.swapPositionWithSelected(new PCPos(-1, i));
                    }
                    this.fillSlots();
                }
            }
            if (s == null) continue;
            if (s.getBounds().contains(x, y) && mouseButton == 1) {
                if (this.pixelmonMenuOpen) {
                    buttonList.remove((Object)this.pMenuButtonSumm);
                    buttonList.remove((Object)this.pMenuButtonMove);
                    buttonList.remove((Object)this.pMenuButtonStat);
                    this.pMenuButtonSumm = null;
                    this.pMenuButtonMove = null;
                    this.pMenuButtonStat = null;
                    this.pixelmonMenuOpen = false;
                    this.selected = null;
                }
                int xOffset = x - ((IInventoryPixelmon)this.gui).getGUILeft() - 63;
                this.pMenuButtonSumm = new GuiPokeCheckerTabs(6, 3, xOffset, y + 5, 47, 13, I18n.func_74838_a((String)"gui.screenpokechecker.summary"));
                this.pMenuButtonMove = new GuiPokeCheckerTabs(6, 4, xOffset, y + 24, 47, 13, I18n.func_74838_a((String)"gui.screenpokechecker.moves"));
                this.pMenuButtonStat = new GuiPokeCheckerTabs(6, 5, xOffset, y + 43, 47, 13, I18n.func_74838_a((String)"gui.screenpokechecker.stats"));
                this.menuX = x - ((IInventoryPixelmon)this.gui).getGUILeft();
                this.menuY = y;
                this.buttonBounds = new Rectangle(xOffset, y + 5, 47, 13);
                this.buttonBoundsMoves = new Rectangle(xOffset, y + 24, 47, 13);
                this.buttonBoundsStat = new Rectangle(xOffset, y + 43, 47, 13);
                buttonList.add(this.pMenuButtonSumm);
                buttonList.add(this.pMenuButtonMove);
                buttonList.add(this.pMenuButtonStat);
                this.pixelmonMenuOpen = true;
                this.selected = s.pokemonData;
                return false;
            }
            if (s.pokemonData.isEgg || !s.getHeldItemBounds().contains(x, y) || !this.heldItemQualifies(s) || this.ticksTillClick > 0) continue;
            SetHeldItem packet = new SetHeldItem(s.pokemonData.pokemonID);
            InventoryPlayer inventory = ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by;
            ItemStack currentItem = inventory.func_70445_o();
            ItemStack itemStack = oldItem = s.pokemonData.heldItem == null ? ItemStack.field_190927_a : s.pokemonData.heldItem;
            if (((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                if (!currentItem.func_190926_b()) {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    s.pokemonData.heldItem = singleItem;
                    packet.setItem(currentItem.func_77973_b());
                } else {
                    s.pokemonData.heldItem = ItemStack.field_190927_a;
                    packet.setItem(null);
                }
                s.pokemonData.resetMoves = true;
                Pixelmon.network.sendToServer((IMessage)packet);
            } else {
                if (oldItem.func_190926_b()) {
                    if (!currentItem.func_190926_b()) {
                        ItemStack singleItem = currentItem.func_77946_l();
                        singleItem.func_190920_e(1);
                        s.pokemonData.heldItem = singleItem;
                        if (currentItem.func_190916_E() <= 1) {
                            inventory.func_70437_b(ItemStack.field_190927_a);
                        } else {
                            currentItem.func_190918_g(1);
                        }
                    }
                } else if (currentItem.func_190926_b()) {
                    s.pokemonData.heldItem = ItemStack.field_190927_a;
                    inventory.func_70437_b(oldItem);
                } else if (oldItem.func_77973_b() == currentItem.func_77973_b()) {
                    s.pokemonData.heldItem = ItemStack.field_190927_a;
                    currentItem.func_190917_f(1);
                } else if (currentItem.func_190916_E() <= 1) {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    s.pokemonData.heldItem = singleItem;
                    inventory.func_70437_b(oldItem);
                } else {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    s.pokemonData.heldItem = singleItem;
                    currentItem.func_190918_g(1);
                    inventory.func_70441_a(oldItem);
                }
                s.pokemonData.resetMoves = true;
                Pixelmon.network.sendToServer((IMessage)packet);
                this.ticksTillClick = 10;
                ItemStack playerItem = inventory.func_70445_o();
                if (!playerItem.func_190926_b() && playerItem.func_190916_E() > 64) {
                    playerItem.func_190920_e(64);
                }
            }
            return false;
        }
        return true;
    }

    public void tick() {
        if (this.ticksTillClick > 0) {
            --this.ticksTillClick;
        }
    }
}

