/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.cosmetics;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayerCosmeticPacket;
import com.pixelmonmod.pixelmon.cosmetics.Cosmetic;
import com.pixelmonmod.pixelmon.cosmetics.CosmeticType;
import com.pixelmonmod.pixelmon.cosmetics.PlayerCosmetics;
import com.pixelmonmod.pixelmon.gui.ContainerEmpty;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCosmetics
extends GuiContainer {
    private int guiWidth = 800;
    private int guiHeight = 500;
    private final PlayerCosmetics clientCosmetics;
    private CosmeticType currentType = CosmeticType.Head;
    private boolean flipped = false;
    private int currentPage = 0;
    private int maxPages = 1;
    private int menuLeft;
    private int menuRight;
    private int menuTop;
    private int menuBottom;

    public GuiCosmetics() {
        super((Container)new ContainerEmpty());
        this.clientCosmetics = new PlayerCosmetics(Minecraft.func_71410_x().field_71439_g.func_110124_au());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.menuLeft = this.field_146294_l / 2 - 275;
        this.menuRight = this.menuLeft + 210;
        this.menuTop = this.field_146295_m / 2 - 203;
        this.menuBottom = this.menuTop + 210;
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 40, this.field_147009_r - 54, 20, 20, "<"));
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 - 20, this.field_147009_r - 54, 150, 20, "Head"));
        this.func_189646_b(new GuiButton(2, this.field_146294_l / 2 + 130, this.field_147009_r - 54, 20, 20, ">"));
        this.func_189646_b(new GuiButton(3, this.field_146294_l / 2 - 155 - 10, this.field_147009_r + 190, 50, 20, "Flip"));
        this.func_189646_b(new GuiButton(4, this.field_146294_l / 2 - 105 - 10, this.field_147009_r + 190, 50, 20, "Reset"));
        this.maxPages = (int)Math.ceil((double)this.clientCosmetics.getCosmeticType(CosmeticType.Head).size() / 16.0);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.func_73732_a(this.field_146289_q, "Page: " + (this.currentPage + 1) + "/" + this.maxPages, 130, -65, 0xFFFFFF);
        for (int col = 0; col < 4; ++col) {
            for (int row = 0; row < 4; ++row) {
                Cosmetic toRender;
                int index = this.currentPage * 16 + col * 4 + row;
                List<Cosmetic> types = this.clientCosmetics.getCosmeticType(this.currentType);
                if (index >= types.size() || index < 0 || (toRender = types.get(index)) == null || toRender.getModelEnum() == null || toRender.getTexture() == null) continue;
                Cosmetic activeCosmetic = this.clientCosmetics.getActiveCosmetic(toRender.getType());
                if (activeCosmetic != null && activeCosmetic.getModelEnum() == toRender.getModelEnum() && activeCosmetic.getTexture().equals(toRender.getTexture())) {
                    System.out.println("Drew Active Square.");
                    GuiCosmetics.func_73734_a((int)(43 + row * 53), (int)(-20 + col * 59), (int)(43 + row * 53 + 45), (int)(-20 + col * 59 + 47), (int)-5601211);
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("pixelmon:textures/gui/cosmetics/icons/" + toRender.getModelEnum().name().toLowerCase() + "-" + toRender.getTexture().toLowerCase() + ".png"));
                GuiCosmetics.drawImageQuad(42 + row * 53, -20 + col * 59, 48.0, 48.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
        }
    }

    public void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        if (!this.flipped) {
            if (mouseY > 0.0f) {
                mouseY = 0.0f;
            }
        } else if (mouseY < 0.0f) {
            mouseY = 0.0f;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)(this.flipped ? 0.0f : 1.0f));
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("pixelmon:textures/gui/cosmetics/main.png"));
        GuiCosmetics.drawImageQuad(this.field_146294_l / 2 - this.guiWidth / 2, this.field_147009_r - 130, this.guiWidth, this.guiHeight, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        this.drawEntityOnScreen(i - 30, j + 170, 100, (float)(i + 51) - (float)mouseX, (float)(j + 75 - 50) - (float)mouseY, (EntityLivingBase)this.field_146297_k.field_71439_g);
    }

    public static void drawImageQuad(double x, double y, double w, float h, double us, double vs, double ue, double ve, float zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + (double)h, (double)zLevel).func_187315_a(us, ve).func_181675_d();
        buffer.func_181662_b(x + w, y + (double)h, (double)zLevel).func_187315_a(ue, ve).func_181675_d();
        buffer.func_181662_b(x + w, y, (double)zLevel).func_187315_a(ue, vs).func_181675_d();
        buffer.func_181662_b(x, y, (double)zLevel).func_187315_a(us, vs).func_181675_d();
        tessellator.func_78381_a();
    }

    protected int getIndexAt(int x, int y) {
        if (x >= this.menuLeft + 275 - 50 && x < this.menuRight + 225 && y >= this.menuTop + 100 && y <= this.menuBottom + 115) {
            double xInd = ((double)x - (double)(this.menuLeft + 275 - 50)) / 55.0;
            double yInd = ((double)y - (double)(this.menuTop + 100)) / 55.0;
            int ind = (int)Math.floor(yInd) * 4 + (int)Math.floor(xInd);
            if (ind > 15) {
                return -1;
            }
            return ind;
        }
        return -1;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int index = this.currentPage * 16 + this.getIndexAt(mouseX, mouseY);
        if (this.getIndexAt(mouseX, mouseY) == -1) {
            return;
        }
        List<Cosmetic> currentCosmetics = this.clientCosmetics.getCosmeticType(this.currentType);
        if (index >= currentCosmetics.size()) {
            return;
        }
        Cosmetic cosmetic = currentCosmetics.get(index);
        for (int i = 0; i < this.clientCosmetics.getAllCosmetics().length; ++i) {
            Cosmetic current = this.clientCosmetics.getAllCosmetics()[i];
            if (!current.getTexture().equals(cosmetic.getTexture()) || current.getModelEnum() != cosmetic.getModelEnum()) continue;
            Pixelmon.network.sendToServer((IMessage)new PlayerCosmeticPacket(cosmetic.getType(), i));
            this.clientCosmetics.setActiveCosmetic(cosmetic);
            break;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 0: {
                if (this.currentPage > 0) {
                    --this.currentPage;
                    break;
                }
                this.currentPage = this.maxPages - 1;
                break;
            }
            case 1: {
                if (button.field_146126_j.equalsIgnoreCase("Head")) {
                    this.currentType = CosmeticType.Back;
                    button.field_146126_j = "Back";
                } else if (button.field_146126_j.equalsIgnoreCase("Back")) {
                    this.currentType = CosmeticType.Hand;
                    button.field_146126_j = "Hand";
                } else if (button.field_146126_j.equalsIgnoreCase("Hand")) {
                    this.currentType = CosmeticType.Head;
                    button.field_146126_j = "Head";
                }
                this.currentPage = 0;
                this.maxPages = (int)Math.ceil((double)this.clientCosmetics.getCosmeticType(this.currentType).size() / 16.0);
                break;
            }
            case 2: {
                if (this.currentPage + 1 < this.maxPages) {
                    ++this.currentPage;
                    break;
                }
                this.currentPage = 0;
                break;
            }
            case 3: {
                this.flipped = !this.flipped;
                break;
            }
            case 4: {
                for (CosmeticType cosmeticType : CosmeticType.values()) {
                    Pixelmon.network.sendToServer((IMessage)new PlayerCosmeticPacket(cosmeticType, -1));
                }
                break;
            }
        }
    }
}

