/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.attacks.IBattleMessage;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetEntity;
import com.pixelmonmod.pixelmon.client.camera.EntityCamera;
import com.pixelmonmod.pixelmon.client.camera.ICameraTarget;
import com.pixelmonmod.pixelmon.client.gui.GuiEvolve;
import com.pixelmonmod.pixelmon.client.gui.battles.AttackData;
import com.pixelmonmod.pixelmon.client.gui.battles.EvoInfo;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.choosePokemon.EnforcedSwitch;
import com.pixelmonmod.pixelmon.client.gui.battles.timerTasks.AFKTask;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUp;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ChooseAttack;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.Flee;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ParticipantReady;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SwitchPokemon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.battle.BagSection;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.items.ItemData;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class ClientBattleManager {
    public int battleControllerIndex = -1;
    public BattleMode mode;
    public BagSection bagSection;
    public boolean battleEnded = true;
    public boolean isSpectating = false;
    private ArrayList<String> messageList = new ArrayList();
    public int[][] teamPokemon;
    public PixelmonInGui[] displayedEnemyPokemon;
    public PixelmonInGui[] displayedOurPokemon;
    public PixelmonInGui[] displayedAllyPokemon;
    public ArrayList<IBattleMessage> battleMessages = new ArrayList();
    public ArrayList<ItemData> bagStore = new ArrayList();
    public ArrayList<LevelUp> levelUpList = new ArrayList(6);
    public ArrayList<AttackData> newAttackList = new ArrayList();
    public boolean goBackToMainMenu;
    public int startIndex = 0;
    public ItemData itemToUse = null;
    public IMessage sendPacket;
    public BattleMode oldMode;
    public BattleMode yesNoOrigin;
    public List<EvoInfo> evolveList = new ArrayList<EvoInfo>(6);
    public boolean isHealing = false;
    public int healAmount = 0;
    public PixelmonData pixelmonToHeal = null;
    public int selectedAttack = -1;
    public int currentPokemon = -1;
    public boolean[][] targetted = new boolean[2][];
    public boolean choosingPokemon;
    public ArrayList<IMessage> selectedActions = new ArrayList();
    public EnumBattleType battleType;
    public Queue<com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnforcedSwitch> enforcedSwitches = new LinkedList<com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnforcedSwitch>();
    public boolean afkOn;
    public boolean afkActive;
    public int afkActivate;
    public int afkTurn;
    public int afkTime;
    private Timer afkTimer;
    public boolean waitingText;
    public boolean megaEvolving;
    public int[] megaEvolution;
    public BattleRules rules = new BattleRules();
    public boolean canSwitch = true;
    public boolean canFlee = true;
    public ParticipantType[][] battleSetup;
    public boolean healFinished = false;
    int ticksSincePicked = 0;
    public ArrayList<int[]> pokemonToChoose;
    public UUID spectatingUUID;
    private EntityPlayer spectating;
    private int thirdP = 0;

    public boolean isBattling() {
        return this.battleControllerIndex != -1 && !this.battleEnded && !this.isSpectating;
    }

    public void addMessage(String s) {
        this.messageList.add(s);
    }

    public String getNextMessage() {
        if (this.hasMoreMessages()) {
            return this.messageList.get(0);
        }
        return "";
    }

    public void removeMessage() {
        if (this.hasMoreMessages()) {
            this.messageList.remove(0);
        }
    }

    public boolean hasMoreMessages() {
        return !this.messageList.isEmpty();
    }

    public PixelmonData getUserPokemonPacket() {
        if (this.currentPokemon != -1) {
            if (this.teamPokemon != null) {
                if (this.currentPokemon < this.teamPokemon.length) {
                    return ServerStorageDisplay.get(this.teamPokemon[this.currentPokemon]);
                }
            } else {
                return ServerStorageDisplay.getPokemon()[this.currentPokemon];
            }
        }
        return null;
    }

    public EntityPixelmon getUserPokemon() {
        return this.getUserPokemon(CameraMode.Battle);
    }

    public EntityPixelmon getUserPokemon(CameraMode mode) {
        if (mode == CameraMode.Battle) {
            if ((this.currentPokemon != -1 || this.isSpectating) && this.teamPokemon != null && this.teamPokemon.length > 0) {
                if (this.currentPokemon == -1) {
                    this.currentPokemon = 0;
                }
                int pokemonIndex = Math.min(this.currentPokemon, this.teamPokemon.length - 1);
                return this.getEntity(this.teamPokemon[pokemonIndex]);
            }
        } else if (mode == CameraMode.Evolution) {
            return GuiEvolve.currentPokemon;
        }
        return null;
    }

    public EntityPixelmon getEntity(int[] id) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            List loadedEntityList = mc.field_71441_e.field_72996_f;
            for (int i = 0; i < loadedEntityList.size(); ++i) {
                EntityPixelmon pokemon;
                Entity e = (Entity)loadedEntityList.get(i);
                if (!(e instanceof EntityPixelmon) || !PixelmonMethods.isIDSame(pokemon = (EntityPixelmon)e, id)) continue;
                return pokemon;
            }
        }
        return null;
    }

    public void clearMessages() {
        this.messageList.clear();
    }

    public boolean hasLevelUps() {
        return !this.levelUpList.isEmpty();
    }

    public boolean hasNewAttacks() {
        return !this.newAttackList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBattle(int battleControllerIndex, ParticipantType[][] battleSetup, int afkActivate, int afkTurn, BattleRules rules) {
        this.battleControllerIndex = battleControllerIndex;
        this.battleSetup = battleSetup;
        this.rules = rules;
        this.displayedOurPokemon = null;
        this.displayedEnemyPokemon = null;
        this.displayedAllyPokemon = null;
        this.teamPokemon = null;
        this.targetted = new boolean[2][];
        this.mode = BattleMode.Waiting;
        this.clearMessages();
        this.canSwitch = true;
        this.canFlee = true;
        this.battleEnded = false;
        this.megaEvolution = null;
        if (afkActivate == -1) {
            this.afkOn = false;
        } else {
            this.afkOn = true;
            this.afkActivate = afkActivate;
            this.afkTurn = afkTurn;
            this.afkActive = false;
            this.resetAFKTime();
        }
        ServerStorageDisplay.clearBattle();
        ArrayList<IBattleMessage> arrayList = this.battleMessages;
        synchronized (arrayList) {
            this.battleMessages.clear();
        }
    }

    public void startSpectate(EnumBattleType battleType) {
        ClientProxy.battleManager.isSpectating = true;
        ClientProxy.battleManager.battleType = battleType;
        this.spectating = null;
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.Battle.ordinal(), (World)mc.field_71441_e, 0, 0, 0);
    }

    public void endSpectate() {
        if (ClientProxy.battleManager.isSpectating) {
            ClientProxy.battleManager.isSpectating = false;
            ClientProxy.battleManager.battleEnded = true;
            this.spectating = null;
            this.spectatingUUID = null;
            this.resetViewEntity();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.battleEnded) {
            this.tick();
        }
    }

    private void tick() {
        ICameraTarget tar;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!(minecraft.field_71462_r instanceof GuiBattle) && minecraft.field_71439_g != null) {
            minecraft.field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.Battle.ordinal(), (World)minecraft.field_71441_e, 0, 0, 0);
        }
        if (this.ticksSincePicked > 0) {
            --this.ticksSincePicked;
        }
        boolean doCameraTick = true;
        if (ClientProxy.camera != null && (tar = ClientProxy.camera.getTarget()) != null) {
            EntityPixelmon userPokemon = this.getUserPokemon();
            if (tar.getTargetData() == userPokemon && (userPokemon == null || userPokemon.field_70128_L || userPokemon.func_110143_aJ() <= 0.0f)) {
                this.setCameraToPlayer();
                doCameraTick = false;
            }
        }
        if (PixelmonConfig.useBattleCamera && doCameraTick && this.ticksSincePicked <= 0 && this.getUserPokemon() != null) {
            Entity viewEntity = minecraft.func_175606_aa();
            if (viewEntity instanceof EntityCamera && viewEntity != ClientProxy.camera) {
                minecraft.func_175607_a((Entity)ClientProxy.camera);
            }
            this.setCameraToPixelmon();
        }
    }

    public void restoreSettingsAndClose() {
        this.battleEnded = true;
        if (this.afkTimer != null) {
            this.afkTimer.cancel();
        }
        this.resetViewEntity();
        this.spectating = null;
        this.spectatingUUID = null;
        this.selectedActions.clear();
        this.enforcedSwitches.clear();
        EnforcedSwitch.failFlee = false;
        this.megaEvolution = null;
    }

    public boolean canCatchOpponent() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t != ParticipantType.WildPokemon || this.displayedEnemyPokemon[i].bossLevel != EnumBossMode.NotBoss.index) continue;
            return true;
        }
        return false;
    }

    public boolean canRunFromBattle() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t != ParticipantType.WildPokemon) continue;
            return this.canFlee;
        }
        return !this.rules.hasClause("forfeit");
    }

    public boolean canForfeit() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t == ParticipantType.WildPokemon) continue;
            return true;
        }
        return false;
    }

    public EntityPlayer getViewPlayer() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.isSpectating && this.spectatingUUID != null) {
            if (this.spectating == null) {
                this.spectating = minecraft.field_71441_e.func_152378_a(this.spectatingUUID);
            }
            if (this.spectating != null) {
                return this.spectating;
            }
        }
        return minecraft.field_71439_g;
    }

    public void startPicking(boolean canSwitch, boolean canFlee, ArrayList<int[]> pokemonToChoose) {
        this.setCameraToPlayer();
        this.ticksSincePicked = 50;
        if (!this.isSpectating) {
            this.canSwitch = canSwitch;
            this.canFlee = canFlee;
            this.oldMode = BattleMode.MainMenu;
            this.mode = BattleMode.MainMenu;
            this.pokemonToChoose = pokemonToChoose;
            for (int i = 0; i < this.teamPokemon.length; ++i) {
                int[] id = this.teamPokemon[i];
                if (!ServerStorageDisplay.has(id) || !this.hasTurn(id)) continue;
                this.currentPokemon = i;
                break;
            }
        }
    }

    private boolean hasTurn(int[] id) {
        for (int[] pid : this.pokemonToChoose) {
            if (!PixelmonMethods.isIDSame(pid, id)) continue;
            return true;
        }
        return false;
    }

    public void selectedMove() {
        this.selectedMove(false);
    }

    public void selectedMove(boolean isEnforcedSwitch) {
        this.afkActive = false;
        this.megaEvolving = false;
        if (!this.enforcedSwitches.isEmpty()) {
            this.enforcedSwitches.poll().processMessage();
            return;
        }
        if (!isEnforcedSwitch && this.teamPokemon.length > this.currentPokemon + 1 && this.teamPokemon.length > this.selectedActions.size()) {
            int prevCurrentPokemon = this.currentPokemon;
            for (int i = this.currentPokemon + 1; i < this.teamPokemon.length; ++i) {
                int[] id = this.teamPokemon[i];
                if (ServerStorageDisplay.has(id)) {
                    if (!this.hasTurn(id)) continue;
                    this.currentPokemon = i;
                    break;
                }
                this.finishSelection();
                return;
            }
            if (prevCurrentPokemon == this.currentPokemon) {
                this.finishSelection();
                return;
            }
            this.mode = BattleMode.MainMenu;
        } else {
            this.finishSelection();
        }
    }

    public void afkSelectMove() {
        if (this.mode != BattleMode.Waiting) {
            if (this.mode == BattleMode.EnforcedSwitch) {
                ArrayList<PixelmonData> inBattle = new ArrayList<PixelmonData>(3);
                if (this.teamPokemon != null) {
                    for (int[] id : this.teamPokemon) {
                        if (!ServerStorageDisplay.has(id)) continue;
                        inBattle.add(ServerStorageDisplay.get(id));
                    }
                    PixelmonData currentData = (PixelmonData)inBattle.get(this.currentPokemon % inBattle.size());
                    this.selectedActions.add(new SwitchPokemon(-1, this.battleControllerIndex, currentData.pokemonID, true));
                }
            } else {
                for (int i = this.currentPokemon; i < this.teamPokemon.length; ++i) {
                    int[] id = this.teamPokemon[i];
                    if (!ServerStorageDisplay.has(id) || !this.hasTurn(id)) continue;
                    this.currentPokemon = i;
                    PixelmonData currentData = this.getUserPokemonPacket();
                    Object action = currentData.health <= 0 ? new SwitchPokemon(-1, this.battleControllerIndex, currentData.pokemonID, false) : new ChooseAttack(this.getUserPokemonPacket().pokemonID, new boolean[0][0], -1, this.battleControllerIndex, this.megaEvolving);
                    this.megaEvolving = false;
                    this.selectedActions.add((IMessage)action);
                }
            }
            this.finishSelection();
        }
    }

    public void finishSelection() {
        this.mode = BattleMode.Waiting;
        this.selectedActions.stream().filter(action -> action != null).forEach(arg_0 -> ((SimpleNetworkWrapper)Pixelmon.network).sendToServer(arg_0));
        this.selectedActions.clear();
        for (PixelmonData data : ServerStorageDisplay.getPokemon()) {
            if (data == null) continue;
            data.selected = false;
        }
    }

    public void setTeamPokemon(int[][] pokemon) {
        this.teamPokemon = pokemon;
        this.targetted[0] = new boolean[pokemon.length];
        if (this.displayedOurPokemon == null) {
            ArrayList<PixelmonInGui> ourPokemon = new ArrayList<PixelmonInGui>();
            for (int[] id : pokemon) {
                if (ServerStorageDisplay.get(id) == null) continue;
                ourPokemon.add(new PixelmonInGui(ServerStorageDisplay.get(id)));
            }
            for (PixelmonInGui pig : this.displayedOurPokemon = ourPokemon.toArray(new PixelmonInGui[ourPokemon.size()])) {
                pig.xPos = 120;
            }
        }
    }

    public void setTeamPokemon(PixelmonInGui[] data) {
        if (this.displayedOurPokemon != null && data != null) {
            for (PixelmonInGui replacement : data) {
                for (PixelmonInGui current : this.displayedOurPokemon) {
                    if (!PixelmonMethods.isIDSame(replacement.pokemonID, current.pokemonID)) continue;
                    replacement.health = current.health;
                }
            }
        }
        this.displayedOurPokemon = data;
        this.targetted[0] = new boolean[this.displayedOurPokemon.length];
        for (PixelmonInGui pig : this.displayedOurPokemon) {
            pig.xPos = 120;
        }
    }

    public void setOpponents(PixelmonInGui[] data) {
        if (this.displayedEnemyPokemon != null && data != null) {
            for (PixelmonInGui replacement : data) {
                for (PixelmonInGui current : this.displayedEnemyPokemon) {
                    if (!PixelmonMethods.isIDSame(replacement.pokemonID, current.pokemonID)) continue;
                    replacement.health = current.health;
                }
            }
        }
        this.displayedEnemyPokemon = data;
        this.targetted[1] = new boolean[this.displayedEnemyPokemon.length];
    }

    public void setTeamData(PixelmonInGui[] data) {
        if (this.displayedAllyPokemon != null && data != null) {
            for (PixelmonInGui replacement : data) {
                for (PixelmonInGui current : this.displayedAllyPokemon) {
                    if (!PixelmonMethods.isIDSame(replacement.pokemonID, current.pokemonID)) continue;
                    replacement.health = current.health;
                }
            }
        }
        this.displayedAllyPokemon = data;
        for (PixelmonInGui pig : this.displayedAllyPokemon) {
            pig.xPos = 120;
        }
    }

    public PixelmonInGui getUncontrolledTeamPokemon(int[] id) {
        if (this.displayedAllyPokemon == null) {
            return null;
        }
        for (PixelmonInGui data : this.displayedAllyPokemon) {
            if (!PixelmonMethods.isIDSame(id, data.pokemonID)) continue;
            return data;
        }
        return null;
    }

    public PixelmonInGui getPokemon(int[] id) {
        if (this.displayedOurPokemon != null) {
            for (PixelmonInGui pig : this.displayedOurPokemon) {
                if (!PixelmonMethods.isIDSame(id, pig.pokemonID)) continue;
                return pig;
            }
        }
        if (this.displayedEnemyPokemon != null) {
            for (PixelmonInGui pig : this.displayedEnemyPokemon) {
                if (!PixelmonMethods.isIDSame(id, pig.pokemonID)) continue;
                return pig;
            }
        }
        if (this.displayedAllyPokemon != null) {
            for (PixelmonInGui pig : this.displayedAllyPokemon) {
                if (!PixelmonMethods.isIDSame(id, pig.pokemonID)) continue;
                return pig;
            }
        }
        return null;
    }

    public boolean isEnemyPokemon(PixelmonInGui pokemon) {
        for (PixelmonInGui p : this.displayedEnemyPokemon) {
            if (p != pokemon) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBattleMessage(IBattleMessage message) {
        ArrayList<IBattleMessage> arrayList = this.battleMessages;
        synchronized (arrayList) {
            this.battleMessages.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBattleMessage(IBattleMessage message) {
        ArrayList<IBattleMessage> arrayList = this.battleMessages;
        synchronized (arrayList) {
            this.battleMessages.remove(message);
            if (this.battleMessages.isEmpty()) {
                this.onClearedMessages();
            }
        }
    }

    public void onClearedMessages() {
        if (!this.isSpectating && !this.hasMoreMessages() && this.battleMessages.isEmpty()) {
            Pixelmon.network.sendToServer((IMessage)new ParticipantReady(this.battleControllerIndex, Minecraft.func_71410_x().field_71439_g.func_110124_au().toString()));
        }
    }

    public void setCameraToPixelmon() {
        if (ClientProxy.camera != null) {
            ICameraTarget tar = ClientProxy.camera.getTarget();
            if (tar != null) {
                EntityPixelmon userPokemon = this.getUserPokemon();
                if (tar.getTargetData() != userPokemon) {
                    if (tar instanceof CameraTargetEntity) {
                        tar.setTargetData((Object)userPokemon);
                    } else if (!PixelmonConfig.playerControlCamera) {
                        ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)userPokemon));
                    }
                }
            } else if (!PixelmonConfig.playerControlCamera) {
                ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)Minecraft.func_71410_x().field_71439_g));
            }
        }
    }

    public void setCameraToPlayer() {
        if (ClientProxy.camera != null) {
            ICameraTarget tar = ClientProxy.camera.getTarget();
            if (tar != null) {
                if (tar.getTargetData() != this.getViewPlayer()) {
                    if (tar instanceof CameraTargetEntity) {
                        tar.setTargetData(this.getViewPlayer());
                    } else if (!PixelmonConfig.playerControlCamera) {
                        ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)this.getViewPlayer()));
                    }
                }
            } else if (ClientProxy.camera == null || this.getViewPlayer() == null) {
                Pixelmon.LOGGER.warn("Problem finding battle camera.");
            } else if (!PixelmonConfig.playerControlCamera) {
                ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)this.getViewPlayer()));
            }
        }
    }

    public void setViewEntity(Entity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_175607_a(entity);
        mc.field_71474_y.field_74319_N = true;
        this.thirdP = mc.field_71474_y.field_74320_O;
        mc.field_71474_y.field_74320_O = 0;
        GuiIngameForge.renderHotbar = false;
        GuiIngameForge.renderCrosshairs = false;
        GuiIngameForge.renderExperiance = false;
        GuiIngameForge.renderAir = false;
        GuiIngameForge.renderHealth = false;
        GuiIngameForge.renderFood = false;
        GuiIngameForge.renderArmor = false;
    }

    public Entity getViewEntity() {
        return Minecraft.func_71410_x().func_175606_aa();
    }

    public void resetViewEntity() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_175607_a((Entity)mc.field_71439_g);
        GuiIngameForge.renderHotbar = true;
        GuiIngameForge.renderCrosshairs = true;
        GuiIngameForge.renderExperiance = true;
        GuiIngameForge.renderAir = true;
        GuiIngameForge.renderHealth = true;
        GuiIngameForge.renderFood = true;
        GuiIngameForge.renderArmor = true;
        mc.field_71474_y.field_74319_N = false;
        mc.field_71474_y.field_74320_O = this.thirdP;
        if (ClientProxy.camera != null) {
            ClientProxy.camera.func_70106_y();
        }
        ClientProxy.camera = null;
    }

    public void resetAFKTime() {
        this.setAFKTimer(this.afkActive ? this.afkTurn : this.afkActivate);
    }

    private void setAFKTimer(int time) {
        this.afkTime = time;
        if (this.afkTimer != null) {
            this.afkTimer.cancel();
        }
        this.afkTimer = new Timer();
        this.afkTimer.scheduleAtFixedRate((TimerTask)new AFKTask(this), 1000L, 1000L);
    }

    public void setTeamSelectTime() {
        if (this.rules.teamSelectTime > 0) {
            this.afkOn = true;
            this.setAFKTimer(this.rules.teamSelectTime);
        } else {
            this.afkOn = false;
        }
    }

    public void selectRunAction(int[] pokemonID) {
        if (this.canForfeit()) {
            this.oldMode = this.mode;
            this.mode = BattleMode.YesNoForfeit;
        } else {
            Pixelmon.network.sendToServer((IMessage)new Flee(pokemonID));
            this.mode = BattleMode.Waiting;
        }
    }

    public void checkClearedMessages() {
        if (!(this.hasMoreMessages() || this.mode != BattleMode.Waiting && this.mode != BattleMode.MainMenu || this.choosingPokemon || this.hasLevelUps())) {
            this.onClearedMessages();
            if (this.afkOn) {
                this.resetAFKTime();
            }
        }
    }

    public boolean canMegaEvolve() {
        if (this.megaEvolution != null) {
            return false;
        }
        for (IMessage message : this.selectedActions) {
            if (!(message instanceof ChooseAttack)) continue;
            ChooseAttack attackMessage = (ChooseAttack)message;
            if (!attackMessage.megaEvolving) continue;
            return false;
        }
        return true;
    }
}

