/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileEntities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.BreedEvent;
import com.pixelmonmod.pixelmon.blocks.IPokemonOwner;
import com.pixelmonmod.pixelmon.blocks.ranch.RanchBounds;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity10CanBreed;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumAggression;
import com.pixelmonmod.pixelmon.enums.EnumBreedingStrength;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.util.Bounds;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileEntityRanchBase
extends TileEntity
implements IPokemonOwner,
ITickable {
    public static final String RANCH_ID_COUNT = "idCount";
    public static boolean enabled = PixelmonConfig.allowBreeding;
    private static final int REFRESH_RATE = 100;
    private static final int UPDATE_BREEDING_RATE = 400;
    protected ArrayList<RanchPokemon> ids = new ArrayList();
    protected final ArrayList<EntityPixelmon> entities = new ArrayList();
    protected RanchBounds ranchBounds = new RanchBounds(this);
    public int ranchWidth = 4;
    public int ranchLength = 4;
    int tick = 0;
    public boolean aboveGround = false;
    public int percentAbove = 0;

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a(RANCH_ID_COUNT, this.ids.size());
        for (int i = 0; i < this.ids.size(); ++i) {
            nbt.func_74783_a("ID" + i, this.ids.get((int)i).pokemonID);
            nbt.func_74772_a("ownerLeast" + i, this.ids.get((int)i).ownerUUID.getLeastSignificantBits());
            nbt.func_74772_a("ownerMost" + i, this.ids.get((int)i).ownerUUID.getMostSignificantBits());
        }
        this.ranchBounds.writeToNBT(nbt);
        try {
            for (EntityPixelmon p : this.entities) {
                PlayerComputerStorage storage;
                EntityPlayerMP owner = (EntityPlayerMP)p.func_70902_q();
                if (owner == null || (storage = PixelmonStorage.computerManager.getPlayerStorage(owner)) == null) continue;
                storage.updatePokemonEntry(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b(RANCH_ID_COUNT)) {
            int count = nbt.func_74762_e(RANCH_ID_COUNT);
            this.ids.clear();
            for (int i = 0; i < count; ++i) {
                this.ids.add(new RanchPokemon(new UUID(nbt.func_74763_f("ownerMost" + i), nbt.func_74763_f("ownerLeast" + i)), nbt.func_74759_k("ID" + i)));
            }
        }
        this.ranchBounds.readFromNBT(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.updateStatus();
    }

    public void func_73660_a() {
        ++this.tick;
        if (!this.field_145850_b.field_72995_K) {
            if (this.tick % 400 == 0 && this.isRanchOwnerInGame() && !this.entities.isEmpty()) {
                try {
                    this.entities.forEach(Entity10CanBreed::updateBreeding);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
            if (this.tick % 100 == 0 && this.isRanchOwnerInGame()) {
                for (int i = 0; i < this.ids.size(); ++i) {
                    EntityPixelmon p;
                    RanchPokemon poke = this.ids.get(i);
                    if (this.entityExists(poke) || !this.ownerInGame(poke) || (p = this.createEntity(poke)) == null) continue;
                    this.entities.add(p);
                }
                Iterator<EntityPixelmon> i = this.entities.iterator();
                while (i.hasNext()) {
                    EntityPixelmon pixelmon = i.next();
                    if (pixelmon == null) {
                        i.remove();
                        continue;
                    }
                    if (!pixelmon.isInRanchBlock) {
                        pixelmon.unloadEntity();
                        i.remove();
                        this.removePokemon(new RanchPokemon(pixelmon.func_184753_b(), pixelmon.getPokemonId()));
                        continue;
                    }
                    if (pixelmon.isLoaded(false) || !this.setLocationForEntity(pixelmon)) continue;
                    pixelmon.releaseFromPokeball();
                }
            }
        } else {
            this.checkAboveGround();
        }
    }

    public abstract boolean isRanchOwnerInGame();

    public abstract void onActivate(EntityPlayer var1);

    @Override
    public void updateStatus() {
    }

    public abstract boolean hasBreedingPartner(EntityPixelmon var1);

    public EntityPixelmon getFirstBreedingPartner(EntityPixelmon pixelmon) {
        ArrayList possiblePartners = (ArrayList)this.entities.stream().filter(p -> p != pixelmon).filter(p -> Entity10CanBreed.canBreed(pixelmon, p)).collect(Collectors.toList());
        if (possiblePartners.size() == 1) {
            return (EntityPixelmon)((Object)possiblePartners.get(0));
        }
        if (possiblePartners.size() > 1) {
            EntityPixelmon highestPartner = (EntityPixelmon)((Object)possiblePartners.get(0));
            for (int i = 1; i < possiblePartners.size(); ++i) {
                if (((EntityPixelmon)((Object)possiblePartners.get(i))).getNumBreedingLevels() <= highestPartner.getNumBreedingLevels()) continue;
                highestPartner = (EntityPixelmon)((Object)possiblePartners.get(i));
            }
            return highestPartner;
        }
        return null;
    }

    public abstract void claimEgg(EntityPlayerMP var1);

    public void removePokemon(EntityPlayerMP player, int[] id) {
        try {
            PlayerComputerStorage storage = PixelmonStorage.computerManager.getPlayerStorage(player);
            NBTTagCompound pokemonNBT = storage.getPokemonNBT(id);
            pokemonNBT.func_74757_a("isInRanch", false);
            pokemonNBT.func_74777_a("BreedingInteractions", (short)-1);
            storage.setChanged(id);
            Iterator<EntityPixelmon> i = this.entities.iterator();
            while (i.hasNext()) {
                EntityPixelmon pixelmon = i.next();
                if (pixelmon == null || !PixelmonMethods.isIDSame(pixelmon, id)) continue;
                pixelmon.unloadEntity();
                i.remove();
                break;
            }
            this.ids.removeIf(p -> PixelmonMethods.isIDSame(p.pokemonID, id));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateStatus();
    }

    private void removePokemon(RanchPokemon poke) {
        try {
            NBTTagCompound pokemonNBT;
            PlayerComputerStorage storage = PixelmonStorage.computerManager.getPlayerStorageFromUUID(this.field_145850_b, poke.ownerUUID);
            if (storage != null && (pokemonNBT = storage.getPokemonNBT(poke.pokemonID)) != null) {
                pokemonNBT.func_74757_a("isInRanch", false);
                pokemonNBT.func_74777_a("BreedingInteractions", (short)-1);
                storage.setChanged(poke.pokemonID);
                if (storage.isOffline()) {
                    PixelmonStorage.computerManager.savePlayer(storage);
                }
            }
            Iterator<EntityPixelmon> i = this.entities.iterator();
            while (i.hasNext()) {
                EntityPixelmon pixelmon = i.next();
                if (!PixelmonMethods.isIDSame(pixelmon, poke.pokemonID)) continue;
                pixelmon.unloadEntity();
                i.remove();
                break;
            }
            this.ids.removeIf(p -> PixelmonMethods.isIDSame(p.pokemonID, poke.pokemonID));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateStatus();
    }

    public void addPokemon(EntityPlayerMP player, int[] id) {
        try {
            PlayerComputerStorage storage = PixelmonStorage.computerManager.getPlayerStorage(player);
            RanchPokemon poke = new RanchPokemon(player.func_110124_au(), id);
            this.ids.add(poke);
            NBTTagCompound pokemonTag = storage.getPokemonNBT(id);
            pokemonTag.func_74757_a("isInRanch", true);
            pokemonTag.func_74772_a("lastBreedingTime", this.field_145850_b.func_82737_E());
            pokemonTag.func_74777_a("BreedingInteractions", (short)0);
            storage.setChanged(id);
            EntityPixelmon pixelmon = this.createEntity(poke);
            if (pixelmon != null) {
                this.entities.add(pixelmon);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateStatus();
    }

    public ArrayList<PixelmonData> getPokemonData() {
        ArrayList<PixelmonData> pokemonData = new ArrayList<PixelmonData>();
        try {
            for (RanchPokemon poke : this.ids) {
                try {
                    PlayerComputerStorage s = PixelmonStorage.computerManager.getPlayerStorageFromUUID(this.field_145850_b, poke.ownerUUID);
                    pokemonData.add(new PixelmonData(s.getPokemonNBT(poke.pokemonID)));
                }
                catch (Exception e) {
                    System.out.println("Player has a Pok\u00e9mon in a ranch block which isn't in his/her PC.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pokemonData;
    }

    @Override
    public int getEntityCount() {
        return this.entities.size();
    }

    public void onDestroy() {
        if (!this.field_145850_b.field_72995_K) {
            try {
                while (this.ids.size() != 0) {
                    RanchPokemon poke = this.ids.get(0);
                    this.removePokemon(poke);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private EntityPixelmon createEntity(RanchPokemon poke) {
        EntityPixelmon pixelmon = null;
        try {
            PlayerComputerStorage s = PixelmonStorage.computerManager.getPlayerStorageFromUUID(this.field_145850_b, poke.ownerUUID);
            pixelmon = s.getPokemonEntity(poke.pokemonID, this.field_145850_b);
            if (pixelmon == null || !pixelmon.isInRanchBlock) {
                for (int i = 0; i < this.ids.size(); ++i) {
                    if (!PixelmonMethods.isIDSame(this.ids.get((int)i).pokemonID, poke.pokemonID)) continue;
                    this.ids.remove(i);
                    --i;
                }
                return null;
            }
            pixelmon.aggression = EnumAggression.passive;
            pixelmon.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(4.0);
            pixelmon.setSpawnLocation(SpawnLocation.Land);
            pixelmon.resetAI();
            if (this.setLocationForEntity(pixelmon)) {
                pixelmon.field_70170_p.func_72838_d((Entity)pixelmon);
            }
            pixelmon.setRanchBlockOwner(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pixelmon;
    }

    private boolean setLocationForEntity(EntityPixelmon pixelmon) {
        for (int i = 0; i < 5; ++i) {
            int[] xz = this.ranchBounds.getRandomLocation(this.field_145850_b.field_73012_v);
            BlockPos pos = new BlockPos(xz[0], this.field_174879_c.func_177956_o() + RandomHelper.getRandomNumberBetween(0, 3), xz[1]);
            pos = pos.func_177984_a();
            pixelmon.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0f, 0.0f);
            if (!pixelmon.func_70601_bi()) continue;
            return true;
        }
        return false;
    }

    private boolean ownerInGame(RanchPokemon poke) {
        if (this.field_145850_b == null || poke == null) {
            return false;
        }
        return this.field_145850_b.func_152378_a(poke.ownerUUID) != null;
    }

    protected abstract void checkAboveGround();

    private boolean entityExists(RanchPokemon poke) {
        for (EntityPixelmon p : this.entities) {
            if (!PixelmonMethods.isIDSame(p, poke.pokemonID)) continue;
            return true;
        }
        return false;
    }

    public void setInitBounds() {
        this.ranchBounds = new RanchBounds(this, this.field_174879_c.func_177952_p() + this.ranchWidth, this.field_174879_c.func_177958_n() - this.ranchLength, this.field_174879_c.func_177952_p() - this.ranchWidth, this.field_174879_c.func_177958_n() + this.ranchLength, this.field_174879_c.func_177956_o());
    }

    @Override
    public Bounds getBounds() {
        return this.ranchBounds;
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.ranchBounds.setWorldObj(world);
    }

    public boolean applyHourglass() {
        boolean hourglassused = false;
        for (EntityPixelmon e : this.entities) {
            if (e.breedingStrength == EnumBreedingStrength.NONE || e.getNumBreedingLevels() >= PixelmonConfig.numBreedingLevels) continue;
            hourglassused = true;
            BreedEvent.BreedingLevelChanged levelChangedEvent = new BreedEvent.BreedingLevelChanged(e.func_184753_b(), this, e, e.getNumBreedingLevels(), e.getNumBreedingLevels() + 1);
            Pixelmon.EVENT_BUS.post((Event)levelChangedEvent);
            e.setNumBreedingLevels(levelChangedEvent.getNewLevel());
        }
        return hourglassused;
    }

    public class RanchPokemon {
        UUID ownerUUID;
        int[] pokemonID;

        public RanchPokemon(UUID ownerUUID, int[] pokemonID) {
            this.ownerUUID = ownerUUID;
            this.pokemonID = pokemonID;
        }
    }
}

