/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawnData;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleStartTypes;
import com.pixelmonmod.pixelmon.spawning.spawners.EnumWorldState;
import java.util.HashMap;
import net.minecraft.world.World;

public class BlockSpawnArea {
    public String name;
    public EnumBattleStartTypes type;
    public HashMap<String, BlockSpawnData> blockSpawns = new HashMap();

    public BlockSpawnArea(String name, EnumBattleStartTypes type, HashMap<String, BlockSpawnData> blockSpawns) {
        this.name = name;
        this.type = type;
        this.blockSpawns = blockSpawns;
    }

    public String getRandomPokemon(World world) {
        return this.getPokemonFromList(world);
    }

    public String getPokemonFromList(World world) {
        EnumWorldState state = this.getWorldState(world);
        int totalRarity = 0;
        for (BlockSpawnData spawnList : this.blockSpawns.values()) {
            totalRarity += spawnList.getRarity(state);
        }
        if (totalRarity > 0) {
            int num = RandomHelper.getRandomNumberBetween(0, totalRarity - 1);
            int sum = 0;
            for (BlockSpawnData spawnList : this.blockSpawns.values()) {
                int rarity = 0;
                if (num < sum + (rarity += spawnList.getRarity(state))) {
                    return spawnList.name;
                }
                sum += rarity;
            }
        }
        return null;
    }

    public EnumWorldState getWorldState(World world) {
        long time = world.func_72820_D() % 24000L;
        EnumWorldState state = time >= 22500L || time < 1000L ? EnumWorldState.dawn : (time >= 1000L && time < 11000L ? EnumWorldState.day : (time >= 11000L && time < 13500L ? EnumWorldState.dusk : EnumWorldState.night));
        return state;
    }
}

