/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.google.common.base.Predicate;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.achievement.PixelmonAchievements;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileEntities.EnumPokegiftType;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityPokegift;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemHelper;
import com.pixelmonmod.pixelmon.sounds.PixelSounds;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockPokegift
extends BlockContainer
implements IBlockHasOwner {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.29f, 0.0, (double)0.29f, (double)0.72f, (double)0.44f, (double)0.72f);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected Class<? extends TileEntityPokegift> pokeChestTileEntityClass;
    protected String itemName = I18n.func_74838_a((String)"item.pokeGift.name");
    protected double xVel = 0.1;
    protected double yVel = 0.2;
    protected double zVel = 0.1;
    protected EnumPokegiftType TYPE = EnumPokegiftType.GIFT;

    public BlockPokegift(Class<? extends TileEntityPokegift> tileEntityClass) {
        super(Material.field_151592_s);
        this.pokeChestTileEntityClass = tileEntityClass;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K || hand == EnumHand.OFF_HAND) {
            return true;
        }
        TileEntityPokegift tile = BlockHelper.getTileEntity(TileEntityPokegift.class, (IBlockAccess)worldIn, pos);
        if (tile != null) {
            UUID blockOwner = tile.getOwner();
            UUID playerID = playerIn.func_110124_au();
            if (playerID != blockOwner) {
                state.func_177230_c().func_176201_c(state);
                if (tile.canClaim(playerID)) {
                    if (tile.shouldBreakBlock()) {
                        worldIn.func_175698_g(pos);
                    }
                    if (tile.getPixelmon() == null) {
                        ChatHandler.sendChat((Entity)playerIn, "pixelutilities.blocks.emptygift", this.itemName);
                        worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 0.8f, 1.0f);
                        return true;
                    }
                    ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.chestfound", this.itemName);
                    playerIn.func_71064_a(PixelmonAchievements.pokeGift, 1);
                    Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)playerIn);
                    if (optstorage.isPresent()) {
                        if (tile.getPixelmon().func_70902_q() == null) {
                            ChatHandler.sendChat((Entity)playerIn, "pixelmon.block.error", this.itemName);
                            return false;
                        }
                    } else {
                        return false;
                    }
                    Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent((EntityPlayerMP)playerIn, ReceiveType.PokeBall, tile.getPixelmon()));
                    optstorage.get().addToParty(tile.getPixelmon());
                    tile.addClaimer(playerID);
                    worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, PixelSounds.pokelootObtained, SoundCategory.BLOCKS, 0.2f, 1.0f);
                } else {
                    ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.claimedloot", new Object[0]);
                }
            } else {
                boolean shiftClick = playerIn.func_70093_af();
                if (shiftClick) {
                    if (tile.getPixelmon() != null) {
                        tile.setOwner(null);
                        ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.ownerchanged", new Object[0]);
                        playerIn.func_71064_a(PixelmonAchievements.givenPokeGift, 1);
                        return true;
                    }
                    ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.fillmefirst", new Object[0]);
                    return false;
                }
                EntityPlayerMP playerMP = (EntityPlayerMP)playerIn;
                Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(playerMP);
                if (optstorage.isPresent()) {
                    PlayerStorage ownerStorage = optstorage.get();
                    if (ownerStorage.count() == 1) {
                        ChatHandler.sendChat((Entity)playerMP, "pixelmon.blocks.lastpoke", new Object[0]);
                        return false;
                    }
                    int[] firstPokeID = null;
                    for (int i = 0; i < 6; ++i) {
                        int[] pixelmonID = ownerStorage.getIDFromPosition(i);
                        if (!ownerStorage.hasSentOut(pixelmonID)) continue;
                        firstPokeID = pixelmonID;
                        i = 6;
                    }
                    EntityPixelmon currentPixelmon = tile.getPixelmon();
                    if (firstPokeID == null) {
                        if (currentPixelmon == null || !playerIn.func_184812_l_()) {
                            ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.nothingtoadd", new Object[0]);
                        } else {
                            String mode = "";
                            if (tile.getChestMode() && tile.getDropMode()) {
                                tile.setChestOneTime(false);
                                tile.setDropOneTime(true);
                                mode = I18n.func_74838_a((String)"pixelmon.blocks.chestmodePL1D");
                            } else {
                                tile.setDropOneTime(true);
                                tile.setChestOneTime(true);
                                mode = I18n.func_74838_a((String)"pixelmon.blocks.chestmodeFCFS");
                            }
                            ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.chestmode", mode);
                        }
                        return false;
                    }
                    ownerStorage.recallAllPokemon();
                    NBTTagCompound nbt = ownerStorage.getNBT(firstPokeID);
                    int position = ownerStorage.getPosition(firstPokeID);
                    EntityPixelmon toGive = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(nbt, worldIn);
                    if (currentPixelmon != null) {
                        tile.setPixelmon(toGive);
                        NBTTagCompound currentNBT = new NBTTagCompound();
                        currentPixelmon.func_70014_b(currentNBT);
                        ownerStorage.changePokemonAndAssignID(position, currentNBT);
                    } else {
                        tile.setPixelmon(toGive);
                        ownerStorage.changePokemonAndAssignID(position, null);
                    }
                    ownerStorage.sendUpdatedList();
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase player) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)i);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntityPokegift tile;
        UUID playerID;
        if (!world.field_72995_K && (playerID = player.func_110124_au()) == (tile = BlockHelper.getTileEntity(TileEntityPokegift.class, (IBlockAccess)world, pos)).getOwner()) {
            Optional<PlayerStorage> optStorage;
            world.func_175698_g(pos);
            DropItemHelper.giveItemStackToPlayer(player, new ItemStack(PixelmonBlocks.pokegiftBlock));
            EntityPixelmon pokemon = tile.getPixelmon();
            if (pokemon != null && (optStorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)player)).isPresent()) {
                optStorage.get().addToParty(pokemon);
            }
        }
    }

    public TileEntity func_149915_a(World par1World, int var1) {
        try {
            TileEntityPokegift tileP = this.pokeChestTileEntityClass.newInstance();
            return tileP;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random random) {
        TileEntityPokegift tile = BlockHelper.getTileEntity(TileEntityPokegift.class, (IBlockAccess)world, pos);
        if (tile.getVisibility() == EnumPokechestVisibility.Hidden) {
            float rand = random.nextFloat() * 0.5f + 1.0f;
            world.func_175688_a(EnumParticleTypes.SPELL_INSTANT, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.xVel * (double)rand, this.yVel * (double)rand, this.zVel * (double)rand, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess access, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return AABB;
    }

    @Override
    public void setOwner(BlockPos pos, EntityPlayer playerIn) {
        UUID playerID = playerIn.func_110124_au();
        TileEntityPokegift tile = BlockHelper.getTileEntity(TileEntityPokegift.class, (IBlockAccess)playerIn.field_70170_p, pos);
        tile.setOwner(playerID);
        if (PixelmonConfig.pokegiftMany) {
            tile.setChestOneTime(false);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }
}

