/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.google.common.base.Predicate;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.achievement.PixelmonAchievements;
import com.pixelmonmod.pixelmon.api.events.PokeLootClaimedEvent;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokeChestType;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityPokeChest;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemHelper;
import com.pixelmonmod.pixelmon.sounds.PixelSounds;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPokeChest
extends BlockContainer
implements IBlockHasOwner {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.29f, 0.0, (double)0.29f, (double)0.72f, (double)0.44f, (double)0.72f);
    private Class<? extends TileEntityPokeChest> pokeChestTileEntityClass;
    protected EnumPokeChestType TYPE = EnumPokeChestType.POKEBALL;
    ItemStack[] drops = null;

    public BlockPokeChest(Class<? extends TileEntityPokeChest> tileEntityClass) {
        super(Material.field_151592_s);
        this.func_149752_b(6000000.0f);
        this.pokeChestTileEntityClass = tileEntityClass;
        this.func_149663_c("pokechest");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected ItemStack ChestDrop() {
        if (this.TYPE == EnumPokeChestType.POKEBALL) {
            return DropItemRegistry.getTier1Drop();
        }
        if (this.TYPE == EnumPokeChestType.ULTRABALL) {
            return DropItemRegistry.getTier2Drop();
        }
        if (this.TYPE == EnumPokeChestType.MASTERBALL) {
            return DropItemRegistry.getTier3Drop();
        }
        return null;
    }

    private ItemStack HiddenDrop() {
        int num = RandomHelper.rand.nextInt(100);
        if (num <= 50) {
            return DropItemRegistry.getTier1Drop();
        }
        if (num < 85) {
            return DropItemRegistry.getTier2Drop();
        }
        return DropItemRegistry.getTier3Drop();
    }

    private ItemStack[] getRandomDrops(EnumPokechestVisibility visibility) {
        if (visibility == EnumPokechestVisibility.Visible) {
            return new ItemStack[]{this.ChestDrop()};
        }
        return new ItemStack[]{this.HiddenDrop()};
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || hand == EnumHand.OFF_HAND) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityPokeChest)) {
            return true;
        }
        TileEntityPokeChest tile = BlockHelper.getTileEntity(TileEntityPokeChest.class, (IBlockAccess)world, pos);
        UUID blockOwner = tile.getOwner();
        UUID playerID = player.func_110124_au();
        if (!playerID.equals(blockOwner)) {
            EnumPokechestVisibility visibility = tile.getVisibility();
            if (tile.canClaim(playerID) && !Pixelmon.EVENT_BUS.post((Event)new PokeLootClaimedEvent((EntityPlayerMP)player, tile))) {
                if (tile.shouldBreakBlock()) {
                    if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player))) {
                        return true;
                    }
                    world.func_175698_g(pos);
                }
                this.drops = tile.isCustomDrop() ? tile.getCustomDrops() : this.getRandomDrops(visibility);
                if (tile.isGrotto()) {
                    player.func_71064_a(PixelmonAchievements.grottoChieve, 1);
                }
                for (ItemStack drop : this.drops) {
                    if (drop == null) continue;
                    Item dropItem = drop.func_77973_b();
                    if (dropItem == PixelmonItemsPokeballs.masterBall) {
                        player.func_71064_a(PixelmonAchievements.masterBallChieve, 1);
                    }
                    ItemStack newDrop = new ItemStack(dropItem, 1, drop.func_77952_i());
                    DropItemHelper.giveItemStackToPlayer(player, newDrop);
                }
                String itemName = this.drops.length == 0 || this.drops[0] == null ? I18n.func_74838_a((String)"tile.poke_chest.name") : this.drops[0].func_77973_b().func_77653_i(this.drops[0]);
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestfound", itemName);
                tile.removeClaimer(playerID);
                tile.addClaimer(playerID);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PixelSounds.pokelootObtained, SoundCategory.BLOCKS, 0.2f, 1.0f);
                if (visibility == EnumPokechestVisibility.Hidden) {
                    player.func_71064_a(PixelmonAchievements.hiddenLootChieve, 1);
                } else {
                    player.func_71064_a(PixelmonAchievements.normalLootChieve, 1);
                }
            } else if (tile.isTimeEnabled()) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timedclaim", new Object[0]);
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.claimedloot", new Object[0]);
            }
        } else {
            boolean shiftClick = player.func_70093_af();
            if (shiftClick) {
                tile.setOwner(null);
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.ownerchanged", new Object[0]);
            } else {
                ItemStack itemStack = player.func_184614_ca();
                if (!itemStack.func_190926_b()) {
                    tile.setCustomDrops(itemStack);
                    tile.setOwner(null);
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestset", I18n.func_74838_a((String)(itemStack.func_77977_a() + ".name")));
                } else {
                    EnumPokechestVisibility visibility = tile.getVisibility();
                    String metaMode = "";
                    if (visibility == EnumPokechestVisibility.Hidden) {
                        tile.setVisibility(EnumPokechestVisibility.Visible);
                        metaMode = "Normal";
                    } else {
                        tile.setVisibility(EnumPokechestVisibility.Hidden);
                        metaMode = "Hidden";
                    }
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.visible", metaMode);
                    return false;
                }
            }
        }
        return true;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int i = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)i);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntityPokeChest tile;
        UUID playerID;
        if (!world.field_72995_K && (playerID = player.func_110124_au()).equals((tile = BlockHelper.getTileEntity(TileEntityPokeChest.class, (IBlockAccess)world, pos)).getOwner())) {
            String mode = "pixelmon.blocks.chestmode";
            boolean chestMode = tile.getChestMode();
            boolean dropMode = tile.getDropMode();
            boolean timeEnabled = tile.isTimeEnabled();
            if (!(chestMode || dropMode || timeEnabled)) {
                tile.setChestOneTime(false);
                tile.setDropOneTime(true);
                tile.setTimeEnabled(false);
                mode = mode + "PL1D";
            } else if (!chestMode && dropMode && !timeEnabled) {
                tile.setDropOneTime(true);
                tile.setChestOneTime(false);
                tile.setTimeEnabled(true);
                mode = mode + "TD";
            } else if (timeEnabled) {
                tile.setTimeEnabled(false);
                tile.setDropOneTime(true);
                tile.setChestOneTime(true);
                mode = mode + "FCFS";
            } else if (chestMode && dropMode && !timeEnabled) {
                tile.setChestOneTime(false);
                tile.setDropOneTime(false);
                tile.setTimeEnabled(false);
                mode = mode + "PUD";
            }
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestmode", I18n.func_74838_a((String)mode));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.TYPE == EnumPokeChestType.POKEBALL) {
            return new ItemStack(PixelmonBlocks.pokeChest);
        }
        if (this.TYPE == EnumPokeChestType.MASTERBALL) {
            return new ItemStack(PixelmonBlocks.masterChest);
        }
        if (this.TYPE == EnumPokeChestType.ULTRABALL) {
            return new ItemStack(PixelmonBlocks.ultraChest);
        }
        return null;
    }

    public TileEntity func_149915_a(World par1World, int var1) {
        try {
            return this.pokeChestTileEntityClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random random) {
        TileEntityPokeChest tile = BlockHelper.getTileEntity(TileEntityPokeChest.class, (IBlockAccess)world, pos);
        if (tile.getVisibility() == EnumPokechestVisibility.Hidden) {
            float rand = random.nextFloat() * 0.5f + 1.0f;
            double xVel = 0.1;
            double yVel = 0.2;
            double zVel = 0.1;
            world.func_175688_a(EnumParticleTypes.SPELL_INSTANT, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, xVel * (double)rand, yVel * (double)rand, zVel * (double)rand, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess access, BlockPos pos) {
        return AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return AABB;
    }

    @Override
    public void setOwner(BlockPos pos, EntityPlayer playerIn) {
        UUID playerID = playerIn.func_110124_au();
        TileEntityPokeChest tile = BlockHelper.getTileEntity(TileEntityPokeChest.class, (IBlockAccess)playerIn.field_70170_p, pos);
        tile.setOwner(playerID);
    }
}

