/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Protect;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;

public class SpikyShield
extends Protect {
    public SpikyShield() {
        super(StatusType.SpikyShield);
    }

    @Override
    protected boolean addStatus(PixelmonWrapper user) {
        return user.addStatus(new SpikyShield(), user);
    }

    @Override
    public void stopsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user) {
        super.stopsIncomingAttackMessage(pokemon, user);
        if (user.attack.baseAttack.getMakesContact()) {
            user.bc.sendToAll("pixelmon.effect.hurt", user.getNickname());
            user.doBattleDamage(pokemon, user.getPercentMaxHealth(12.5f), DamageTypeEnum.STATUS);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        super.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
        if (userChoice.weight != -1.0f) {
            block0: for (ArrayList<MoveChoice> choices : MoveChoice.splitChoices(pw.getOpponentPokemon(), bestOpponentChoices)) {
                for (MoveChoice choice : choices) {
                    if (!choice.isAttack() || !choice.attack.baseAttack.getMakesContact()) continue;
                    userChoice.raiseWeight(12.5f);
                    continue block0;
                }
            }
        }
    }
}

