/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MagicGuard;
import java.util.ArrayList;

public class Nightmare
extends StatusBase {
    public Nightmare() {
        super(StatusType.Nightmare);
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(StatusType.Sleep) && target.addStatus(new Nightmare(), user)) {
            target.bc.sendToAll("pixelmon.status.nightmareadd", target.getNickname());
        } else {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (pw.hasStatus(StatusType.Sleep)) {
            if (!(pw.getBattleAbility() instanceof MagicGuard)) {
                pw.bc.sendToAll("pixelmon.status.nightmare", pw.getNickname());
                pw.doBattleDamage(pw, pw.getPercentMaxHealth(25.0f), DamageTypeEnum.STATUS);
            }
        } else {
            pw.removeStatus(this);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            if (target.getBattleAbility() instanceof MagicGuard) continue;
            userChoice.raiseWeight(25.0f);
        }
    }
}

