/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.FlareBoost;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Guts;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Heatproof;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MarvelScale;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.QuickFeet;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Synchronize;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;

public class Burn
extends StatusPersist {
    private static final float AI_WEIGHT = 25.0f;

    public Burn() {
        super(StatusType.Burn);
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance()) {
            Burn.burn(user, target, user.attack, true);
        }
    }

    public static boolean burn(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage) {
        boolean result;
        boolean isStatusMove;
        boolean bl = isStatusMove = attack != null && attack.baseAttack.attackCategory == 2;
        if (target.hasType(EnumType.Fire)) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
                user.setAttackFailed();
            }
            return false;
        }
        if (target.hasPrimaryStatus()) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                user.setAttackFailed();
            }
            return false;
        }
        TextComponentTranslation message = null;
        if (showMessage) {
            message = ChatHandler.getMessage("pixelmon.effect.burnt", target.getNickname());
        }
        if (!(result = target.addStatus(new Burn(), user, message)) && isStatusMove) {
            user.setAttackFailed();
        }
        return result;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        AbilityBase userAbility = pw.getBattleAbility();
        if (!(userAbility instanceof MagicGuard)) {
            pw.bc.sendToAll("pixelmon.status.burnhurt", pw.getNickname());
            int fraction = userAbility instanceof Heatproof ? 32 : 16;
            pw.doBattleDamage(pw, pw.getPercentMaxHealth(100.0f / (float)fraction), DamageTypeEnum.STATUS);
        }
    }

    @Override
    public StatusPersist restoreFromNBT(NBTTagCompound nbt) {
        return new Burn();
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (!(user.getBattleAbility() instanceof Guts)) {
            int var10001;
            int n = var10001 = StatsType.Attack.getStatIndex();
            stats[n] = stats[n] / 2;
        }
        return stats;
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        return pokemon.hasType(EnumType.Fire);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.burncure";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.burncureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        boolean offensive = userChoice.isOffensiveMove();
        float weight = this.getWeightWithChance(25.0f);
        if (!offensive || userChoice.isMiddleTier()) {
            boolean hitsAlly = userChoice.hitsAlly();
            if (!offensive || !hitsAlly) {
                ArrayList<PixelmonWrapper> opponents = pw.getOpponentPokemon();
                Iterator<PixelmonWrapper> var11 = userChoice.targets.iterator();
                while (true) {
                    boolean beneficial;
                    if (!var11.hasNext()) {
                        return;
                    }
                    PixelmonWrapper target = var11.next();
                    if (offensive && !Burn.burn(pw, target, userChoice.attack, false)) continue;
                    AbilityBase ability = target.getBattleAbility();
                    boolean bl = beneficial = ability instanceof FlareBoost || ability instanceof Guts || ability instanceof MarvelScale || ability instanceof QuickFeet;
                    if (!beneficial || !hitsAlly) {
                        if (beneficial ^ hitsAlly) {
                            userChoice.raiseWeight(-weight);
                            continue;
                        }
                        if (ability instanceof Synchronize) continue;
                        pw.getBattleAI().weightStatusOpponentOptions(pw, userChoice, target, new Burn(), opponents, bestOpponentChoices);
                        if (ability instanceof MagicGuard) continue;
                        userChoice.raiseWeight(weight);
                        continue;
                    }
                    if (!(ability instanceof Guts) && target.getMoveset().hasAttackCategory(0)) continue;
                    userChoice.raiseWeight(weight);
                }
            }
        }
    }
}

