/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.clauses;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SkyBattle
extends BattleClause {
    private static final Set<EnumPokemon> ALLOWED_POKEMON = new HashSet<EnumPokemon>();
    private static final Set<String> PROHIBITED_MOVES = new HashSet<String>();

    SkyBattle() {
        super("sky");
    }

    @Override
    public boolean validateSingle(PokemonLink pokemon) {
        return ALLOWED_POKEMON.contains((Object)pokemon.getBaseStats().pokemon);
    }

    public static boolean isMoveAllowed(Attack move) {
        return !PROHIBITED_MOVES.contains(move.baseAttack.getUnLocalizedName());
    }

    static {
        ALLOWED_POKEMON.addAll(Arrays.asList(EnumPokemon.Charizard, EnumPokemon.Butterfree, EnumPokemon.Pidgeotto, EnumPokemon.Pidgeot, EnumPokemon.Fearow, EnumPokemon.Zubat, EnumPokemon.Golbat, EnumPokemon.Gastly, EnumPokemon.Haunter, EnumPokemon.Koffing, EnumPokemon.Weezing, EnumPokemon.Scyther, EnumPokemon.Gyarados, EnumPokemon.Aerodactyl, EnumPokemon.Articuno, EnumPokemon.Zapdos, EnumPokemon.Moltres, EnumPokemon.Dragonite, EnumPokemon.Noctowl, EnumPokemon.Ledyba, EnumPokemon.Ledian, EnumPokemon.Crobat, EnumPokemon.Togetic, EnumPokemon.Xatu, EnumPokemon.Hoppip, EnumPokemon.Skiploom, EnumPokemon.Jumpluff, EnumPokemon.Yanma, EnumPokemon.Misdreavus, EnumPokemon.Unown, EnumPokemon.Gligar, EnumPokemon.Mantine, EnumPokemon.Skarmory, EnumPokemon.Lugia, EnumPokemon.Hooh, EnumPokemon.Beautifly, EnumPokemon.Swellow, EnumPokemon.Wingull, EnumPokemon.Pelipper, EnumPokemon.Masquerain, EnumPokemon.Ninjask, EnumPokemon.Vibrava, EnumPokemon.Flygon, EnumPokemon.Swablu, EnumPokemon.Altaria, EnumPokemon.Lunatone, EnumPokemon.Solrock, EnumPokemon.Baltoy, EnumPokemon.Claydol, EnumPokemon.Duskull, EnumPokemon.Tropius, EnumPokemon.Chimecho, EnumPokemon.Salamence, EnumPokemon.Latias, EnumPokemon.Latios, EnumPokemon.Rayquaza, EnumPokemon.Staravia, EnumPokemon.Staraptor, EnumPokemon.Mothim, EnumPokemon.Combee, EnumPokemon.Vespiquen, EnumPokemon.Drifloon, EnumPokemon.Drifblim, EnumPokemon.Mismagius, EnumPokemon.Honchkrow, EnumPokemon.Chingling, EnumPokemon.Mantyke, EnumPokemon.Togekiss, EnumPokemon.Yanmega, EnumPokemon.Gliscor, EnumPokemon.Uxie, EnumPokemon.Mesprit, EnumPokemon.Azelf, EnumPokemon.Sigilyph, EnumPokemon.Archeops, EnumPokemon.Emolga, EnumPokemon.Cryogonal, EnumPokemon.Braviary));
        PROHIBITED_MOVES.addAll(Arrays.asList("Body Slam", "Bulldoze", "Dig", "Dive", "Earth Power", "Earthquake", "Electric Terrain", "Fissure", "Fire Pledge", "Flying Press", "Frenzy Plant", "Geomancy", "Grass Knot", "Grass Pledge", "Grassy Terrain", "Gravity", "Heat Crash", "Heavy Slam", "Ingrain", "Land's Wrath", "Magnitude", "Mat Block", "Misty Terrain", "Mud Sport", "Muddy Water", "Rototiller", "Seismic Toss", "Slam", "Smack Down", "Spikes", "Stomp", "Substitute", "Surf", "Toxic Spikes", "Thousand Arrows", "Thousand Waves", "Water Pledge", "Water Sport"));
    }
}

