/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TerrainExamine;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.ai.RandomAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BackToMainMenu;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnforcedSwitch;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ExitBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetBattlingPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonTeamData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui.HPPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.Add;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCClear;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import com.pixelmonmod.pixelmon.enums.forms.EnumBurmy;
import com.pixelmonmod.pixelmon.items.ItemShrineOrb;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.AirSaver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerParticipant
extends BattleParticipant {
    public EntityPlayerMP player;
    public PlayerStorage storage;
    long guiCheck = 0L;
    private static int idcounter = 0;
    public boolean hasAmuletCoin = false;
    public boolean hasHappyHour = false;
    public int payDay = 0;
    private AirSaver airSaver;
    private PlayerStorage cachedStorage = null;

    public PlayerParticipant(EntityPlayerMP p, EntityPixelmon ... startingPixelmon) {
        super(startingPixelmon.length);
        this.player = p;
        this.loadParty(this.getStorage());
        this.initialize(p, startingPixelmon);
    }

    public PlayerParticipant(EntityPlayerMP p, List<PokemonLink> teamSelection, int numControlledPokemon) {
        super(numControlledPokemon);
        this.loadParty(teamSelection);
        EntityPixelmon[] startingPixelmon = new EntityPixelmon[numControlledPokemon];
        for (int i = 0; i < numControlledPokemon; ++i) {
            if (teamSelection.size() <= i) continue;
            startingPixelmon[i] = teamSelection.get(i).getEntity();
        }
        this.initialize(p, startingPixelmon);
    }

    private void initialize(EntityPlayerMP p, EntityPixelmon ... startingPixelmon) {
        this.player = p;
        this.storage = this.getStorage();
        int positionIndex = 0;
        for (EntityPixelmon pokemon : startingPixelmon) {
            PixelmonWrapper pw;
            if (pokemon == null || (pw = this.getPokemonFromParty(pokemon)) == null) continue;
            this.controlledPokemon.add(pw);
            pw.battlePosition = positionIndex++;
        }
        this.airSaver = new AirSaver(p);
        p.func_70637_d(false);
        p.field_191988_bg = 0.0f;
        p.field_70702_br = 0.0f;
        p.func_70095_a(false);
    }

    private void enableReturnHeldItems() {
        for (PixelmonWrapper pw : this.allPokemon) {
            pw.enableReturnHeldItem();
        }
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.Player;
    }

    @Override
    public boolean canGainXP() {
        return true;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        return this.countAblePokemon() > this.getActiveUnfaintedPokemon().size() + this.switchingOut.size();
    }

    @Override
    public void startBattle(BattleControllerBase bc) {
        super.startBattle(bc);
        this.setBattleAI(new RandomAI(this));
        this.player.field_71075_bZ.field_75102_a = true;
        Pixelmon.network.sendTo((IMessage)new PCClear(), this.player);
        boolean useTurnTime = false;
        int activateTime = 0;
        int turnTime = 0;
        if (bc.rules.turnTime > 0) {
            useTurnTime = true;
            activateTime = bc.rules.turnTime;
            turnTime = bc.rules.turnTime;
        } else if (PixelmonServerConfig.afkHandlerOn) {
            useTurnTime = true;
            activateTime = PixelmonServerConfig.afkTimerActivateSeconds;
            turnTime = PixelmonConfig.afkTimerTurnSeconds;
        }
        ParticipantType[][] battleType = bc.getBattleType(this);
        StartBattle startPacket = useTurnTime ? new StartBattle(bc.battleIndex, battleType, activateTime, turnTime, bc.rules) : new StartBattle(bc.battleIndex, battleType, bc.rules);
        Pixelmon.network.sendTo((IMessage)startPacket, this.player);
        this.storage.pokedex.sendToPlayer(this.player);
        if (bc.rules.fullHeal || PixelmonConfig.returnHeldItems && bc.isPvP()) {
            this.enableReturnHeldItems();
        }
        int i = 0;
        while (i < this.allPokemon.length) {
            PixelmonWrapper pw = this.allPokemon[i];
            PixelmonData data = new PixelmonData(new WrapperLink(pw));
            data.inBattle = true;
            data.order = i++;
            Pixelmon.network.sendTo((IMessage)new Add(data), this.player);
        }
        Pixelmon.network.sendTo((IMessage)new SetBattlingPokemon(this.getTeamPokemonList()), this.player);
        PixelmonMethods.getAllActivePokemon((EntityPlayer)this.player).forEach(EntityPixelmon::unloadEntity);
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!PixelmonConfig.useBattleDimension) {
                if (!this.storage.isInWorld(pw.getPokemonID())) {
                    pw.pokemon.func_70012_b(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, this.player.field_70177_z, 0.0f);
                    pw.pokemon.releaseFromPokeball();
                }
                pw.pokemon.field_70128_L = false;
            }
            if (PixelmonConfig.useBattleDimension) continue;
            pw.pokemon.battleController = bc;
        }
    }

    public ArrayList<PixelmonWrapper> getTeamPokemonList() {
        ArrayList<BattleParticipant> team = this.bc.getTeam(this);
        ArrayList<PixelmonWrapper> teamPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : team) {
            teamPokemon.addAll(p.controlledPokemon);
        }
        return teamPokemon;
    }

    @Override
    public void endBattle() {
        MinecraftServer server;
        if (!this.player.field_71075_bZ.field_75098_d) {
            this.player.field_71075_bZ.field_75102_a = false;
        }
        int burmyForm = -1;
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            NBTTagCompound nbt;
            if (!pixelmonWrapper.changeBurmy || this.controlledPokemon.isEmpty()) continue;
            if (burmyForm == -1) {
                burmyForm = EnumBurmy.getFromType(TerrainExamine.getTerrain((PixelmonWrapper)this.controlledPokemon.get(0))).ordinal();
            }
            if ((nbt = this.storage.getNBT(pixelmonWrapper.getPokemonID())) == null) continue;
            nbt.func_74768_a("Variant", burmyForm);
            this.storage.updateClient(nbt, EnumUpdateType.Stats);
        }
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.resetOnSwitch();
            if (pw.pokemon == null) continue;
            if (pw.pokemon.isMega) {
                pw.pokemon.setForm(-1);
                pw.pokemon.isMega = false;
            }
            pw.pokemon.endBattle();
            pw.pokemon.catchInPokeball();
        }
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            if (pixelmonWrapper.nbt == null) continue;
            pixelmonWrapper.resetBattleEvolution();
            pixelmonWrapper.writeToNBT();
            this.storage.updateClient(pixelmonWrapper.nbt, EnumUpdateType.HP, EnumUpdateType.Ability, EnumUpdateType.HeldItem, EnumUpdateType.Stats, EnumUpdateType.Status, EnumUpdateType.Moveset);
        }
        if (this.payDay > 0 && this.hasMorePokemon()) {
            this.payDay *= this.getPrizeMoneyMultiplier();
            this.storage.addCurrency(this.payDay);
            ChatHandler.sendBattleMessage((Entity)this.getEntity(), "pixelmon.effect.paydayend", this.getName(), this.payDay);
        }
        Pixelmon.network.sendTo((IMessage)new ExitBattle(), this.player);
        Pixelmon.network.sendTo((IMessage)new PCClear(), this.player);
        if (this.bc != null && this.bc.participants.size() == 2 && this.bc.otherParticipant(this) instanceof PlayerParticipant) {
            if (!this.hasMorePokemon()) {
                this.storage.stats.addLoss();
            } else {
                this.storage.stats.addWin();
            }
        }
        if ((server = this.player.field_70170_p.func_73046_m()) != null && server.field_71305_c.length > 0) {
            PixelmonStorage.save(this.player);
        }
    }

    @Override
    public void getNextPokemon(int position) {
        if (position >= this.controlledPokemon.size()) {
            this.wait = false;
            return;
        }
        boolean switching = false;
        PixelmonWrapper switchingPokemon = (PixelmonWrapper)this.controlledPokemon.get(position);
        switchingPokemon.isSwitching = true;
        switching = true;
        switchingPokemon.wait = true;
        if (switchingPokemon.newPokemonID == null) {
            Pixelmon.network.sendTo((IMessage)new EnforcedSwitch(position), this.player);
        }
        if (!switching) {
            this.wait = false;
        }
    }

    public int getPrizeMoneyMultiplier() {
        int multiplier = 1;
        if (this.hasAmuletCoin) {
            multiplier *= 2;
        }
        if (this.hasHappyHour) {
            multiplier *= 2;
        }
        return multiplier;
    }

    @Override
    public int[] getNextPokemonID() {
        return this.storage.getFirstAblePokemon(this.getEntity().field_70170_p).getPokemonId();
    }

    @Override
    public TextComponentBase getName() {
        return new TextComponentString(this.player.func_145748_c_().func_150260_c());
    }

    @Override
    public void selectAction() {
        this.getMove(null);
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper pokemon) {
        if (this.bc == null) {
            return null;
        }
        boolean canSwitch = true;
        boolean canFlee = true;
        ArrayList<PixelmonWrapper> pokemonToChoose = new ArrayList<PixelmonWrapper>();
        for (PixelmonWrapper p : this.controlledPokemon) {
            if (p.getMoveset().isEmpty()) {
                this.bc.endBattleWithoutXP();
                return null;
            }
            boolean[] canExit = PlayerParticipant.canSwitch(p);
            canSwitch = canExit[0];
            canFlee = canExit[1];
            if (p.attack == null || !p.attack.doesPersist(p)) {
                pokemonToChoose.add(p);
                p.wait = true;
                continue;
            }
            p.wait = false;
        }
        if (!pokemonToChoose.isEmpty()) {
            Pixelmon.network.sendTo((IMessage)new BackToMainMenu(canSwitch, canFlee, pokemonToChoose), this.player);
            ArrayList<Spectator> playerSpectators = this.bc.getPlayerSpectators(this);
            playerSpectators.forEach(spectator -> spectator.sendMessage(new BackToMainMenu(true, true, pokemonToChoose)));
        }
        return null;
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper pw, int[] newPixelmonId) {
        double x = this.player.field_70165_t;
        double y = this.player.field_70163_u;
        double z = this.player.field_70161_v;
        String beforeName = pw.getNickname();
        pw.beforeSwitch();
        if (!pw.isFainted() && !pw.nextSwitchIsMove) {
            ChatHandler.sendBattleMessage((Entity)this.player, "playerparticipant.enough", pw.getNickname());
            this.bc.sendToOthers("playerparticipant.withdrew", this, this.player.func_145748_c_().func_150260_c(), beforeName);
        }
        PixelmonWrapper newWrapper = this.getPokemonFromParty(newPixelmonId);
        if (!this.bc.simulateMode) {
            pw.pokemon.catchInPokeball();
            pw.pokemon = null;
            Optional<EntityPixelmon> newPokemonOptional = this.storage.getAlreadyExists(newPixelmonId, this.player.field_70170_p);
            EntityPixelmon newPixelmon = null;
            if (newPokemonOptional.isPresent()) {
                newPixelmon = newPokemonOptional.get();
                newPixelmon.field_70179_y = 0.0;
                newPixelmon.field_70181_x = 0.0;
                newPixelmon.field_70159_w = 0.0;
                newPixelmon.func_70012_b(x, y, z, this.player.field_70177_z, 0.0f);
            } else {
                newPixelmon = this.storage.sendOut(newPixelmonId, pw.getWorld());
                if (newPixelmon == null) {
                    this.bc.sendToAll("Problem sending out Pok\u00e9mon, cancelling battle. Please report this.", new Object[0]);
                    this.bc.endBattle(EnumBattleEndCause.FORCE);
                    return null;
                }
                newPixelmon.field_70179_y = 0.0;
                newPixelmon.field_70181_x = 0.0;
                newPixelmon.field_70159_w = 0.0;
                newPixelmon.func_70012_b(x, y, z, this.player.field_70177_z, 0.0f);
                newPixelmon.releaseFromPokeball();
            }
            newWrapper.pokemon = newPixelmon;
        }
        newWrapper.battlePosition = pw.battlePosition;
        newWrapper.getBattleAbility().beforeSwitch(newWrapper);
        String newNickname = newWrapper.getNickname();
        ChatHandler.sendBattleMessage((Entity)this.player, "playerparticipant.go", newNickname);
        this.bc.sendToOthers("battlecontroller.sendout", this, this.player.func_145748_c_().func_150260_c(), newNickname);
        int index = this.controlledPokemon.indexOf(pw);
        this.controlledPokemon.set(index, newWrapper);
        this.bc.participants.forEach(BattleParticipant::updateOtherPokemon);
        newWrapper.afterSwitch();
        return newWrapper;
    }

    @Override
    public boolean checkPokemon() {
        for (NBTTagCompound n : this.storage.getList()) {
            if (n == null || n.func_74762_e("PixelmonNumberMoves") != 0) continue;
            ChatHandler.sendChat((Entity)this.player, "playerparticipant.load", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
        pw.update(EnumUpdateType.HP);
    }

    @Override
    public EntityLivingBase getEntity() {
        return this.player;
    }

    @Override
    public void updateOtherPokemon() {
        ArrayList<Spectator> playerSpectators;
        if (this.bc == null) {
            this.endBattle();
            return;
        }
        if (this.bc.simulateMode) {
            return;
        }
        ArrayList<PixelmonWrapper> opponents = this.bc.getOpponentPokemon(this);
        for (int i = 0; i < opponents.size(); ++i) {
            if (opponents.get(i) != null) continue;
            opponents.remove(i);
            --i;
        }
        if (this.bc.battleTurn == -1) {
            this.updateOpponentPokemon();
            if (this.bc.getTeam(this).size() > 1) {
                ArrayList<PixelmonWrapper> otherTeamPokemon = this.getAllyData();
                Pixelmon.network.sendTo((IMessage)new SetPokemonTeamData(otherTeamPokemon), this.player);
                playerSpectators = this.bc.getPlayerSpectators(this);
                playerSpectators.forEach(spectator -> spectator.sendMessage(new SetPokemonTeamData(otherTeamPokemon)));
            }
        }
        if (!this.bc.battleEnded) {
            ArrayList<PixelmonWrapper> teamPokemon = this.getTeamPokemonList();
            Pixelmon.network.sendTo((IMessage)new SetBattlingPokemon(teamPokemon), this.player);
            playerSpectators = this.bc.getPlayerSpectators(this);
            playerSpectators.forEach(spectator -> spectator.sendMessage(new SetBattlingPokemon(teamPokemon)));
        }
    }

    public ArrayList<PixelmonWrapper> getAllyData() {
        ArrayList<BattleParticipant> team = this.bc.getTeam(this);
        ArrayList<PixelmonWrapper> otherTeamPokemon = new ArrayList<PixelmonWrapper>(6);
        team.stream().filter(p -> p != this).forEach(p -> otherTeamPokemon.addAll(p.controlledPokemon));
        otherTeamPokemon.stream().filter(wrapper -> PixelmonMethods.isIDSame(new int[]{-1, -1}, wrapper.getPokemonID())).forEach(wrapper -> wrapper.pokemon.setPokemonId(new int[]{-1, idcounter++}));
        return otherTeamPokemon;
    }

    public PixelmonInGui[] getOpponentData() {
        ArrayList<PixelmonWrapper> opponents = this.bc.getOpponentPokemon(this);
        return PixelmonInGui.convertToGUI(opponents);
    }

    public void updateOpponentPokemon() {
        PixelmonInGui[] data = this.getOpponentData();
        Pixelmon.network.sendTo((IMessage)new SetPokemonBattleData(data), this.player);
        ArrayList<Spectator> playerSpectators = this.bc.getPlayerSpectators(this);
        playerSpectators.forEach(spectator -> spectator.sendMessage(new SetPokemonBattleData(data)));
    }

    public void updatePokemonHealth(EntityPixelmon pixelmon) {
        this.updateOtherPokemon();
    }

    public void checkPlayerItems() {
        for (int i = 0; i < this.player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack item;
            int dmg;
            if (this.player.field_71071_by.field_70462_a.get(i) == null || !(((ItemStack)this.player.field_71071_by.field_70462_a.get(i)).func_77973_b() instanceof ItemShrineOrb) || (dmg = (item = (ItemStack)this.player.field_71071_by.field_70462_a.get(i)).func_77952_i()) >= ItemShrineOrb.full) continue;
            item.func_77964_b(dmg + 1);
            break;
        }
    }

    public int getHighestLevel() {
        int lvl = -1;
        for (PixelmonWrapper pw : this.allPokemon) {
            lvl = Math.max(lvl, pw.getLevelNum());
        }
        return lvl;
    }

    @Override
    public void tick() {
        this.airSaver.tick();
        if (this.storage != null && !this.storage.guiOpened) {
            this.openGui();
        }
        if (this.player.func_110143_aJ() <= 0.0f) {
            this.bc.endBattleWithoutXP();
            BattleRegistry.deRegisterBattle(this.bc);
        }
    }

    public void givePlayerExp(PixelmonWrapper pixelmon) {
        int opponentPixelmonLevel = pixelmon.getLevelNum();
        int expAmount = 0;
        int divisor = 5;
        if (opponentPixelmonLevel >= 75) {
            expAmount = opponentPixelmonLevel / (divisor * 5);
            this.player.func_71023_q(expAmount);
        } else if (opponentPixelmonLevel >= 50) {
            expAmount = opponentPixelmonLevel / (divisor * 4);
            this.player.func_71023_q(expAmount);
        } else if (opponentPixelmonLevel >= 35) {
            expAmount = opponentPixelmonLevel / (divisor * 2);
            this.player.func_71023_q(expAmount);
        } else if (opponentPixelmonLevel > divisor) {
            expAmount = opponentPixelmonLevel / divisor;
            this.player.func_71023_q(expAmount);
        } else {
            this.player.func_71023_q(1);
        }
    }

    public void openGui() {
        if (this.guiCheck == 0L || System.currentTimeMillis() - this.guiCheck > 1000L) {
            this.player.openGui((Object)Pixelmon.instance, EnumGui.Battle.getIndex().intValue(), this.player.field_70170_p, this.bc.battleIndex, 0, 0);
            this.guiCheck = System.currentTimeMillis();
        }
    }

    @Override
    public void setPosition(double[] ds) {
        this.player.field_71135_a.func_147364_a(ds[0], ds[1], ds[2], this.player.field_70177_z, this.player.field_70125_A);
    }

    @Override
    public void sendDamagePacket(EntityPixelmon user, int damage) {
        Pixelmon.network.sendTo((IMessage)new HPPacket(user, -damage), this.player);
    }

    @Override
    public void sendHealPacket(EntityPixelmon target, int amount) {
        Pixelmon.network.sendTo((IMessage)new HPPacket(target, amount), this.player);
    }

    @Override
    public String getDisplayName() {
        return this.player.getDisplayNameString();
    }

    @Override
    public PlayerStorage getStorage() {
        if (this.cachedStorage == null) {
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(this.player);
            optstorage.ifPresent(playerStorage -> {
                this.cachedStorage = playerStorage;
            });
        }
        return this.cachedStorage;
    }

    @Override
    public boolean canMegaEvolve() {
        return this.getStorage().megaData.canEquipMegaItem();
    }
}

