/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.worldgen.structures.stargate.nether;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.worldgen.structures.JSGStructure;
import tauri.dev.jsg.worldgen.structures.stargate.nether.StargateGenerationHelper;
import tauri.dev.jsg.worldgen.util.EnumGenerationHeight;
import tauri.dev.jsg.worldgen.util.GeneratedStargate;

public class JSGNetherStructure
extends JSGStructure {
    private final List<StargateGenerationHelper.Direction> DIRECTIONS;
    private final List<BlockMatcher> ALLOWED_BLOCKS_BELOW;
    private static final int MINIMAL_FRONT_SPACE = 16;
    private static final int MINIMAL_SIDE_SPACE = 5;

    public JSGNetherStructure(String structureName, int yNegativeOffset, boolean isStargateStructure, boolean isRingsStructure, SymbolTypeEnum symbolType, int structureSizeX, int structureSizeZ, int airUp, int dimensionToSpawn, boolean findOptimalRotation, @Nullable ITemplateProcessor templateProcessor, Rotation rotationToNorth, double terrainFlatPercents, double topBlockMatchPercent, @Nonnull EnumGenerationHeight genHeight) {
        super(structureName, yNegativeOffset, isStargateStructure, isRingsStructure, symbolType, structureSizeX, structureSizeZ, airUp, dimensionToSpawn, findOptimalRotation, templateProcessor, rotationToNorth, terrainFlatPercents, topBlockMatchPercent, genHeight);
        this.DIRECTIONS = Arrays.asList(new StargateGenerationHelper.Direction(EnumFacing.UP, false, 0).setRequiredMinimum(this.airUp).setIgnoreInMaximum(), new StargateGenerationHelper.Direction(EnumFacing.NORTH, true, 2), new StargateGenerationHelper.Direction(EnumFacing.SOUTH, true, 2), new StargateGenerationHelper.Direction(EnumFacing.WEST, true, 2), new StargateGenerationHelper.Direction(EnumFacing.EAST, true, 2));
        this.ALLOWED_BLOCKS_BELOW = Arrays.asList(BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL), BlockMatcher.func_177642_a((Block)Blocks.field_150449_bY), BlockMatcher.func_177642_a((Block)Blocks.field_150425_aM));
    }

    @Override
    public GeneratedStargate generateStructure(World executedInWorld, BlockPos posIn, Random random, @Nullable WorldServer worldToSpawn) {
        Rotation rotation;
        BlockPos start;
        MinecraftServer mcServer = executedInWorld.func_73046_m();
        JSG.info("Nether Structure " + this.structureName + " generation started!");
        if (mcServer == null) {
            return null;
        }
        worldToSpawn = worldToSpawn == null ? mcServer.func_71218_a(this.dimensionToSpawn) : worldToSpawn;
        BlockPos current = start = posIn;
        int count = 0;
        int pass = 1;
        BlockPos found = null;
        Map.Entry<EnumFacing, StargateGenerationHelper.DirectionResult> frontResult = null;
        while (found == null) {
            for (BlockPos.MutableBlockPos pos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)current, (BlockPos)current.func_177982_a(16, 16, 16))) {
                StargateGenerationHelper.FreeSpace freeSpace;
                if (worldToSpawn.func_175623_d(pos.func_177977_b()) || (freeSpace = StargateGenerationHelper.getFreeSpaceInDirections((IBlockAccess)worldToSpawn, (BlockPos)pos, this.DIRECTIONS, 16, this.ALLOWED_BLOCKS_BELOW)) == null || freeSpace.getMaxDistance().getValue().distance < 16) continue;
                int left = freeSpace.getDistance((EnumFacing)freeSpace.getMaxDistance().getKey().func_176735_f()).distance;
                int right = freeSpace.getDistance((EnumFacing)freeSpace.getMaxDistance().getKey().func_176746_e()).distance;
                if (left < 5 || right < 5) continue;
                found = pos.func_185334_h();
                frontResult = freeSpace.getMaxDistance();
                break;
            }
            if (count == 0) {
                current = start.func_177982_a(16, 0, 0);
            } else if (count == 1) {
                current = start.func_177982_a(0, 0, 16);
            } else if (count == 2) {
                current = start.func_177982_a(16, 0, 16);
            } else if (count == 3) {
                if (start.func_177956_o() > 100) {
                    start = posIn.func_177982_a(32 * pass, 0, 32 * pass);
                    ++pass;
                } else {
                    start = start.func_177982_a(0, 16, 0);
                }
                current = start;
            }
            if (++count <= 3) continue;
            count = 0;
        }
        switch ((EnumFacing)frontResult.getKey()) {
            case SOUTH: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case WEST: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case EAST: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            default: {
                rotation = Rotation.NONE;
            }
        }
        int y = Math.min(((StargateGenerationHelper.DirectionResult)frontResult.getValue()).ydiff, 0);
        BlockPos translate = new BlockPos(-7, y -= 2, -16).func_190942_a(rotation);
        found = found.func_177971_a((Vec3i)translate);
        return super.generateStructure(executedInWorld, found, random, worldToSpawn, rotation);
    }
}

