/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.worldgen.structures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.structures.StructureConfig;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.worldgen.structures.JSGStructure;
import tauri.dev.jsg.worldgen.structures.processor.NetherProcessor;
import tauri.dev.jsg.worldgen.structures.processor.OverworldProcessor;
import tauri.dev.jsg.worldgen.structures.stargate.nether.JSGNetherStructure;
import tauri.dev.jsg.worldgen.util.EnumGenerationHeight;

public enum EnumStructures {
    PLAINS_MW("sg_plains_milkyway", 0, true, false, SymbolTypeEnum.MILKYWAY, 13, 13, 0, true, JSGConfig.WorldGen.structures.stargateRandomGeneratorEnabled, JSGConfig.WorldGen.structures.stargateRGChanceOverworld, new OverworldProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150349_c);
            this.add(Blocks.field_150346_d);
            this.add(Blocks.field_150348_b);
        }
    }, null, 35, Rotation.CLOCKWISE_90, 0.7, 0.8, EnumGenerationHeight.MIDDLE),
    DESERT_MW("sg_desert_milkyway", 0, true, false, SymbolTypeEnum.MILKYWAY, 13, 13, 0, true, JSGConfig.WorldGen.structures.stargateRandomGeneratorEnabled, JSGConfig.WorldGen.structures.stargateRGChanceOverworld, new OverworldProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150354_m);
            this.add(Blocks.field_150322_A);
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("desert");
            this.add("mesa");
        }
    }, 35, Rotation.CLOCKWISE_90, 0.7, 0.8, EnumGenerationHeight.MIDDLE),
    MOSSY_MW("sg_mossy_milkyway", 0, true, false, SymbolTypeEnum.MILKYWAY, 13, 13, 0, true, JSGConfig.WorldGen.structures.stargateRandomGeneratorEnabled, JSGConfig.WorldGen.structures.stargateRGChanceOverworld, new OverworldProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150349_c);
            this.add(Blocks.field_150346_d);
            this.add(Blocks.field_150348_b);
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("taiga");
            this.add("jungle");
            this.add("swamp");
            this.add("mushroom");
        }
    }, 35, Rotation.CLOCKWISE_90, 0.7, 0.8, EnumGenerationHeight.MIDDLE),
    FROST_MW("sg_frosty_milkyway", 0, true, false, SymbolTypeEnum.MILKYWAY, 13, 13, 0, true, JSGConfig.WorldGen.structures.stargateRandomGeneratorEnabled, JSGConfig.WorldGen.structures.stargateRGChanceOverworld, new OverworldProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150433_aE);
            this.add(Blocks.field_150431_aC);
            this.add(Blocks.field_150432_aD);
            this.add(Blocks.field_185778_de);
            this.add(Blocks.field_150403_cj);
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("ice");
            this.add("frozen");
            this.add("cold");
        }
    }, 35, Rotation.CLOCKWISE_90, 0.7, 0.8, EnumGenerationHeight.MIDDLE),
    PLAINS_PG("sg_plains_pegasus", 0, true, false, SymbolTypeEnum.PEGASUS, 13, 13, 0, true, JSGConfig.WorldGen.structures.stargateRandomGeneratorEnabled, JSGConfig.WorldGen.structures.stargateRGChanceOverworld, new OverworldProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150349_c);
            this.add(Blocks.field_150346_d);
            this.add(Blocks.field_150348_b);
        }
    }, null, 35, Rotation.CLOCKWISE_90, 0.8, 0.8, EnumGenerationHeight.MIDDLE),
    DESERT_PG("sg_desert_pegasus", 0, true, false, SymbolTypeEnum.PEGASUS, 13, 13, 0, true, JSGConfig.WorldGen.structures.stargateRandomGeneratorEnabled, JSGConfig.WorldGen.structures.stargateRGChanceOverworld, new OverworldProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150354_m);
            this.add(Blocks.field_150322_A);
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("desert");
            this.add("mesa");
        }
    }, 35, Rotation.CLOCKWISE_90, 0.7, 0.8, EnumGenerationHeight.MIDDLE),
    MOSSY_PG("sg_mossy_pegasus", 0, true, false, SymbolTypeEnum.PEGASUS, 13, 13, 0, true, JSGConfig.WorldGen.structures.stargateRandomGeneratorEnabled, JSGConfig.WorldGen.structures.stargateRGChanceOverworld, new OverworldProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150349_c);
            this.add(Blocks.field_150346_d);
            this.add(Blocks.field_150348_b);
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("taiga");
        }
    }, 35, Rotation.CLOCKWISE_90, 0.7, 0.8, EnumGenerationHeight.MIDDLE),
    FROST_PG("sg_frosty_pegasus", 0, true, false, SymbolTypeEnum.PEGASUS, 13, 13, 0, true, JSGConfig.WorldGen.structures.stargateRandomGeneratorEnabled, JSGConfig.WorldGen.structures.stargateRGChanceOverworld, new OverworldProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150433_aE);
            this.add(Blocks.field_150431_aC);
            this.add(Blocks.field_150432_aD);
            this.add(Blocks.field_185778_de);
            this.add(Blocks.field_150403_cj);
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("ice");
            this.add("frozen");
            this.add("cold");
        }
    }, 35, Rotation.CLOCKWISE_90, 0.7, 0.8, EnumGenerationHeight.MIDDLE),
    END_UNI("sg_end_universe", 0, true, false, SymbolTypeEnum.UNIVERSE, 10, 10, 1, true, JSGConfig.WorldGen.structures.stargateRandomGeneratorEnabled, JSGConfig.WorldGen.structures.stargateRGChanceTheEnd, new OverworldProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150377_bs);
        }
    }, null, 15, Rotation.CLOCKWISE_90, 0.7, 0.8, EnumGenerationHeight.LOW),
    NETHER_MW("sg_nether_milkyway", 0, true, false, SymbolTypeEnum.MILKYWAY, 16, 16, -1, false, false, 0.0f, new NetherProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150424_aL);
            this.add(Blocks.field_150449_bY);
            this.add(Blocks.field_150385_bj);
            this.add(Blocks.field_150425_aM);
        }
    }, null, 12, Rotation.NONE, 0.3, 0.8, EnumGenerationHeight.HEIGHT),
    NAQUADAH_MINE("naquadah_mine", 10, false, false, null, 15, 15, 0, false, JSGConfig.WorldGen.structures.structuresRandomGeneratorEnabled, 5.0E-4f, null, (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150349_c);
        }
    }, null, 35, Rotation.NONE, 0.5, 0.5, EnumGenerationHeight.LOW),
    TOKRA_TUNNEL("tr_tokra", 21, false, true, null, 7, 7, 0, false, JSGConfig.WorldGen.structures.structuresRandomGeneratorEnabled, 5.0E-4f, null, (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150354_m);
            this.add(Blocks.field_150349_c);
        }
    }, null, 35, Rotation.NONE, 0.88, 0.8, EnumGenerationHeight.LOW),
    ANCIENT_TOTEM("ancient_totem", 0, false, false, null, 3, 3, 0, false, JSGConfig.WorldGen.structures.structuresRandomGeneratorEnabled, 8.0E-6f, new OverworldProcessor(), (List<Block>)new ArrayList<Block>(){
        {
            this.add(Blocks.field_150349_c);
            this.add(Blocks.field_150354_m);
            this.add(Blocks.field_150348_b);
            this.add(Blocks.field_150346_d);
            this.add(Blocks.field_150351_n);
        }
    }, null, 5, Rotation.NONE, 0.9, 0.3, EnumGenerationHeight.LOW);

    public final String name;
    private final JSGStructure structure;
    private final JSGNetherStructure netherStructure;
    public final boolean randomGenEnableDefault;
    public final float chance;
    public final List<String> allowedInBiomes;
    public final List<Block> allowedOnBlocks;

    private EnumStructures(String structureName, int yNegativeOffset, boolean isStargateStructure, boolean isRingsStructure, SymbolTypeEnum symbolType, int structureSizeX, int structureSizeZ, int dimensionToSpawn, boolean findOptimalRotation, boolean randomGenEnable, @Nullable float chanceToGenerateRandom, @Nullable ITemplateProcessor templateProcessor, List<Block> allowedOnBlocks, List<String> allowedInBiomes, int airCountUp, Rotation rotationToNorth, @Nonnull double terrainFlatPercents, double topBlockMatchPercent, EnumGenerationHeight genHeight) {
        this.name = structureName;
        this.netherStructure = new JSGNetherStructure(structureName, yNegativeOffset, isStargateStructure, isRingsStructure, symbolType, structureSizeX, structureSizeZ, airCountUp, dimensionToSpawn, findOptimalRotation, templateProcessor, rotationToNorth, terrainFlatPercents, topBlockMatchPercent, genHeight);
        this.structure = new JSGStructure(structureName, yNegativeOffset, isStargateStructure, isRingsStructure, symbolType, structureSizeX, structureSizeZ, airCountUp, dimensionToSpawn, findOptimalRotation, templateProcessor, rotationToNorth, terrainFlatPercents, topBlockMatchPercent, genHeight);
        this.randomGenEnableDefault = randomGenEnable;
        this.chance = chanceToGenerateRandom;
        this.allowedInBiomes = allowedInBiomes;
        this.allowedOnBlocks = allowedOnBlocks;
    }

    public JSGStructure getActualStructure(int dimId) {
        if (dimId == -1) {
            return this.netherStructure;
        }
        return this.structure;
    }

    public static void initConfig() {
        StructureConfig configStargates = new StructureConfig("stargateStructures");
        StructureConfig configRings = new StructureConfig("ringsStructures");
        StructureConfig configOther = new StructureConfig("otherStructures");
        for (EnumStructures s : EnumStructures.values()) {
            if (s.name.startsWith("sg_")) {
                configStargates.addKey(s.name, s.randomGenEnableDefault, s.chance);
                continue;
            }
            if (s.name.startsWith("tr_")) {
                configRings.addKey(s.name, s.randomGenEnableDefault, s.chance);
                continue;
            }
            configOther.addKey(s.name, s.randomGenEnableDefault, s.chance);
        }
        StructureConfig.addConfig(configStargates);
        StructureConfig.addConfig(configRings);
        StructureConfig.addConfig(configOther);
    }

    public boolean randomGeneratorEnabled() {
        if (this.name.startsWith("sg_")) {
            return StructureConfig.isEnabled("stargateStructures", this.name);
        }
        if (this.name.startsWith("tr_")) {
            return StructureConfig.isEnabled("ringsStructures", this.name);
        }
        return StructureConfig.isEnabled("otherStructures", this.name);
    }

    public float getChance() {
        if (this.name.startsWith("sg_")) {
            return StructureConfig.getChance("stargateStructures", this.name);
        }
        if (this.name.startsWith("tr_")) {
            return StructureConfig.getChance("ringsStructures", this.name);
        }
        return StructureConfig.getChance("otherStructures", this.name);
    }

    @Nullable
    public static EnumStructures getStargateStructureByBiome(String biomeName, SymbolTypeEnum symbolType, int dimensionToSpawn) {
        ArrayList<EnumStructures> biomeNull = new ArrayList<EnumStructures>();
        for (EnumStructures structure : EnumStructures.values()) {
            if (!structure.getActualStructure((int)dimensionToSpawn).isStargateStructure || structure.getActualStructure((int)dimensionToSpawn).symbolType != symbolType || structure.getActualStructure((int)dimensionToSpawn).dimensionToSpawn != dimensionToSpawn) continue;
            if (structure.allowedInBiomes != null) {
                for (String s : structure.allowedInBiomes) {
                    if (!biomeName.toLowerCase().contains(s.toLowerCase())) continue;
                    return structure;
                }
                continue;
            }
            biomeNull.add(structure);
        }
        if (biomeNull.size() > 0) {
            return (EnumStructures)((Object)biomeNull.get(0));
        }
        return null;
    }

    @Nullable
    public static EnumStructures getStructureByName(String name) {
        for (EnumStructures s : EnumStructures.values()) {
            if (!s.name.equalsIgnoreCase(name)) continue;
            return s;
        }
        return null;
    }

    public static Collection<String> getAllStructureNames() {
        ArrayList<String> col = new ArrayList<String>();
        for (EnumStructures s : EnumStructures.values()) {
            col.add(s.name);
        }
        return col;
    }
}

