/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.util.updater;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;

public class GetUpdate {
    public static final String ERROR_STRING = "Error was occurred while updating JSG!";
    public static final String URL_BASE = "https://api.justsgmod.eu/?api=curseforge&version=1.12.2";
    public static final String GET_NAME_URL = "https://api.justsgmod.eu/?api=curseforge&version=1.12.2&t=name";
    public static final String GET_DOWNLOAD_URL = "https://api.justsgmod.eu/?api=curseforge&version=1.12.2&t=url";
    public static final String DOWNLOAD_URL_USER = GetUpdate.getSiteContent("https://api.justsgmod.eu/?api=curseforge&version=1.12.2&t=url");

    public static UpdateResult checkForUpdate() {
        String currentVersion = "1.12.2-4.11.0.8".replace("1.12.2-", "");
        if (!JSGConfig.General.enableAutoUpdater) {
            return new UpdateResult(EnumUpdateResult.DISABLED, currentVersion);
        }
        String webData = GetUpdate.getSiteContent(GET_NAME_URL);
        if (webData.equalsIgnoreCase(ERROR_STRING)) {
            return new UpdateResult(EnumUpdateResult.ERROR, "Exit code: 1");
        }
        String[] got = webData.split("-");
        if (got.length < 3) {
            return new UpdateResult(EnumUpdateResult.ERROR, "Exit code: 2");
        }
        String gotVersion = got[2];
        String[] currentVersionSplit = currentVersion.split("\\.");
        String[] gotVersionSplit = gotVersion.split("\\.");
        try {
            for (int i = 0; i < 4; ++i) {
                if (gotVersionSplit.length < i + 1 || currentVersionSplit.length < i + 1) continue;
                if (Integer.parseInt(currentVersionSplit[i]) < Integer.parseInt(gotVersionSplit[i])) {
                    return new UpdateResult(EnumUpdateResult.NEWER_AVAILABLE, gotVersion);
                }
                if (Integer.parseInt(currentVersionSplit[i]) <= Integer.parseInt(gotVersionSplit[i])) continue;
                return new UpdateResult(EnumUpdateResult.UP_TO_DATE, gotVersion);
            }
        }
        catch (Exception e) {
            JSG.warn("Error while checking for update!", e);
            return new UpdateResult(EnumUpdateResult.ERROR, "Exit code: 3");
        }
        return new UpdateResult(EnumUpdateResult.UP_TO_DATE, gotVersion);
    }

    public static void openWebsiteToClient(String url) {
        try {
            Class<?> ocClass = Class.forName("java.awt.Desktop");
            Object object = ocClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            ocClass.getMethod("browse", URI.class).invoke(object, new URI(url));
        }
        catch (Exception e) {
            JSG.error("Couldn't open link", e);
        }
    }

    public static String getSiteContent(String link) {
        String Response;
        InputStream Stream2;
        HttpURLConnection Http;
        URL Url;
        try {
            Url = new URL(link);
        }
        catch (MalformedURLException e1) {
            return ERROR_STRING;
        }
        try {
            Http = (HttpURLConnection)Url.openConnection();
        }
        catch (IOException e1) {
            return ERROR_STRING;
        }
        if (Http == null) {
            return ERROR_STRING;
        }
        Map<String, List<String>> Header = Http.getHeaderFields();
        try {
            for (String header : Header.get(null)) {
                if (!header.contains(" 302 ") && !header.contains(" 301 ")) continue;
                link = Header.get("Location").get(0);
                try {
                    Url = new URL(link);
                }
                catch (MalformedURLException e) {
                    return ERROR_STRING;
                }
                try {
                    Http = (HttpURLConnection)Url.openConnection();
                }
                catch (IOException e) {
                    return ERROR_STRING;
                }
                Header = Http.getHeaderFields();
            }
        }
        catch (Exception ignored) {
            return ERROR_STRING;
        }
        try {
            Stream2 = Http.getInputStream();
        }
        catch (IOException e) {
            return ERROR_STRING;
        }
        try {
            Response = GetUpdate.GetStringFromStream(Stream2);
        }
        catch (IOException e) {
            return ERROR_STRING;
        }
        return Response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String GetStringFromStream(InputStream Stream2) throws IOException {
        if (Stream2 != null) {
            StringWriter Writer2 = new StringWriter();
            char[] Buffer2 = new char[2048];
            try {
                int counter;
                BufferedReader Reader2 = new BufferedReader(new InputStreamReader(Stream2, StandardCharsets.UTF_8));
                while ((counter = Reader2.read(Buffer2)) != -1) {
                    ((Writer)Writer2).write(Buffer2, 0, counter);
                }
            }
            finally {
                Stream2.close();
            }
            return ((Object)Writer2).toString();
        }
        return ERROR_STRING;
    }

    public static class UpdateResult {
        public EnumUpdateResult result;
        public final String response;

        public UpdateResult(EnumUpdateResult result, String newestVersion) {
            this.result = result;
            this.response = newestVersion;
        }
    }

    public static enum EnumUpdateResult {
        UP_TO_DATE,
        NEWER_AVAILABLE,
        ERROR,
        DISABLED;

    }
}

