/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.util.main.loader;

import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.advancements.JSGAdvancements;
import tauri.dev.jsg.capability.endpoint.ItemEndpointCapability;
import tauri.dev.jsg.chunkloader.ChunkLoadingCallback;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.craftings.CraftingConfig;
import tauri.dev.jsg.config.stargate.StargateSizeEnum;
import tauri.dev.jsg.config.structures.StructureConfig;
import tauri.dev.jsg.datafixer.TileNamesFixer;
import tauri.dev.jsg.gui.JSGGuiHandler;
import tauri.dev.jsg.integration.OCWrapperInterface;
import tauri.dev.jsg.integration.ThermalIntegration;
import tauri.dev.jsg.machine.assembler.AssemblerRecipes;
import tauri.dev.jsg.machine.chamber.CrystalChamberRecipes;
import tauri.dev.jsg.machine.orewashing.OreWashingRecipes;
import tauri.dev.jsg.machine.pcbfabricator.PCBFabricatorRecipes;
import tauri.dev.jsg.util.main.loader.JSGOreDictionary;
import tauri.dev.jsg.waterlog.FluidLoggedAPIHandler;
import tauri.dev.jsg.worldgen.JSGOresGenerator;
import tauri.dev.jsg.worldgen.structures.EnumStructures;
import tauri.dev.jsg.worldgen.structures.JSGStructuresGenerator;

public class JSGInit {
    private static final String OC_WRAPPER_LOADED = "tauri.dev.jsg.integration.OCWrapperLoaded";
    private static final String OC_WRAPPER_NOT_LOADED = "tauri.dev.jsg.integration.OCWrapperNotLoaded";

    public static void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new JSGOresGenerator(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new JSGStructuresGenerator(), (int)0);
        JSG.info("Successfully registered World Generation!");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)JSG.instance, (IGuiHandler)new JSGGuiHandler());
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)JSG.instance, (ForgeChunkManager.LoadingCallback)ChunkLoadingCallback.INSTANCE);
        JSGOreDictionary.registerOreDictionary();
        JSG.info("Successfully registered OreDictionary!");
        ItemEndpointCapability.register();
        JSG.info("Successfully registered Capabilities (phase 2)!");
        JSGAdvancements.register();
        JSGInit.registerThermal();
        JSGInit.registerOC();
        JSGInit.registerFluidLogger();
        JSGInit.fixData();
        AssemblerRecipes.addToConfig();
        CrystalChamberRecipes.addToConfig();
        PCBFabricatorRecipes.addToConfig();
        OreWashingRecipes.addToConfig();
        CraftingConfig.load(JSG.modConfigDir);
        JSG.info("Successfully loaded CraftingConfig!");
        EnumStructures.initConfig();
        StructureConfig.load(JSG.modConfigDir);
        JSG.info("Successfully loaded StructureConfig!");
        StargateSizeEnum.init();
        JSG.info("Successfully registered Stargate sizes!");
        ConfigManager.sync((String)"jsg", (Config.Type)Config.Type.INSTANCE);
    }

    public static void fixData() {
        ModFixs modFixs = FMLCommonHandler.instance().getDataFixer().init("jsg", 25);
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileNamesFixer());
    }

    public static void registerThermal() {
        if (Loader.isModLoaded((String)"thermalexpansion") && JSGConfig.General.integration.tExpansionIntegration) {
            JSG.info("Thermal Expansion found and connection is enabled... Connecting...");
            ThermalIntegration.registerRecipes();
            JSG.info("Successfully connected into Thermal Expansion!");
        }
    }

    public static void registerOC() {
        try {
            if (Loader.isModLoaded((String)"opencomputers") && JSGConfig.General.integration.ocIntegration) {
                JSG.info("OpenComputers found and connection is enabled... Connecting...");
                JSG.ocWrapper = (OCWrapperInterface)Class.forName(OC_WRAPPER_LOADED).newInstance();
                JSG.info("Successfully connected into OpenComputers!");
            } else {
                JSG.ocWrapper = (OCWrapperInterface)Class.forName(OC_WRAPPER_NOT_LOADED).newInstance();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            JSG.error("Exception loading OpenComputers wrapper");
            e.printStackTrace();
        }
    }

    public static void registerFluidLogger() {
        if (Loader.isModLoaded((String)"fluidlogged_api") && JSGConfig.General.integration.flapiIntegration) {
            JSG.info("FluidLogged-API found and connection is enabled... Connecting...");
            MinecraftForge.EVENT_BUS.register((Object)new FluidLoggedAPIHandler());
            JSG.info("Successfully connected into FluidLogged-API!");
        }
    }
}

