/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.util;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.tileentity.dialhomedevice.DHDAbstractTile;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.util.ILinkable;

public class LinkingHelper {
    private static int nextLinkId = 0;

    @Nullable
    public static BlockPos findClosestUnlinked(World world, BlockPos startPos, BlockPos radius, Block targetBlock, int linkId) {
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos target : BlockPos.func_177975_b((BlockPos)startPos.func_177973_b((Vec3i)radius), (BlockPos)startPos.func_177971_a((Vec3i)radius))) {
            double distanceSq;
            ILinkable linkedTile;
            if (world.func_180495_p(target).func_177230_c() != targetBlock || (linkedTile = (ILinkable)world.func_175625_s(target)) == null || !linkedTile.canLinkTo() && linkId != linkedTile.getLinkId() || linkedTile instanceof StargateClassicBaseTile && !((StargateClassicBaseTile)((Object)linkedTile)).isMerged() || !((distanceSq = startPos.func_177951_i((Vec3i)target)) < closestDistance)) continue;
            closestDistance = distanceSq;
            closest = target.func_185334_h();
        }
        return closest;
    }

    @Nullable
    public static BlockPos findClosestUnlinked(World world, BlockPos startPos, BlockPos radius, Block[] targetBlocks, int linkId) {
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos target : BlockPos.func_177975_b((BlockPos)startPos.func_177973_b((Vec3i)radius), (BlockPos)startPos.func_177971_a((Vec3i)radius))) {
            for (Block targetBlock : targetBlocks) {
                double distanceSq;
                ILinkable linkedTile;
                if (world.func_180495_p(target).func_177230_c() != targetBlock || !(linkedTile = (ILinkable)world.func_175625_s(target)).canLinkTo() && linkId != linkedTile.getLinkId() || !((distanceSq = startPos.func_177951_i((Vec3i)target)) < closestDistance)) continue;
                closestDistance = distanceSq;
                closest = target.func_185334_h();
            }
        }
        return closest;
    }

    @Nullable
    public static BlockPos findClosestPos(World world, BlockPos startPos, BlockPos radius, Block[] targetBlocks, ArrayList<BlockPos> blacklist) {
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos target : BlockPos.func_177975_b((BlockPos)startPos.func_177973_b((Vec3i)radius), (BlockPos)startPos.func_177971_a((Vec3i)radius))) {
            for (Block targetBlock : targetBlocks) {
                double distanceSq;
                if (world.func_180495_p(target).func_177230_c() != targetBlock || blacklist.contains(target) || !((distanceSq = startPos.func_177951_i((Vec3i)target)) < closestDistance)) continue;
                closestDistance = distanceSq;
                closest = target.func_185334_h();
            }
        }
        return closest;
    }

    public static BlockPos getDhdRange() {
        int xz = JSGConfig.DialHomeDevice.mechanics.rangeFlat;
        int y = JSGConfig.DialHomeDevice.mechanics.rangeVertical;
        return new BlockPos(xz, y, xz);
    }

    public static void updateLinkedGate(World world, BlockPos gatePos, BlockPos dhdPos) {
        StargateAbstractBaseTile gateTile = (StargateAbstractBaseTile)world.func_175625_s(gatePos);
        DHDAbstractTile dhdTile = (DHDAbstractTile)world.func_175625_s(dhdPos);
        if (dhdTile != null) {
            int linkId = LinkingHelper.getLinkId();
            dhdTile.setLinkedGate(gatePos, linkId);
            gateTile.setLinkedDHD(dhdPos, linkId);
        }
    }

    public static int getLinkId() {
        return ++nextLinkId;
    }
}

