/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.util;

import java.util.ArrayList;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import tauri.dev.jsg.config.JSGConfig;

public class JSGTextureLightningHelper {
    public static void lightUpTexture(World world, final BlockPos pos, float lightIntensity) {
        JSGTextureLightningHelper.lightUpTexture(world, new ArrayList<BlockPos>(){
            {
                this.add(pos);
            }
        }, lightIntensity);
    }

    public static void lightUpTexture(World world, ArrayList<BlockPos> poses, float lightIntensity) {
        if (!JSGConfig.General.visual.renderEmissive) {
            return;
        }
        int count = poses.size();
        int skyLight = 0;
        int blockLight = 0;
        for (BlockPos pos : poses) {
            skyLight += world.func_175642_b(EnumSkyBlock.SKY, pos);
            blockLight += world.func_175642_b(EnumSkyBlock.BLOCK, pos);
        }
        float i = lightIntensity * 15.0f;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)Math.max((float)((blockLight /= count) * 16), i), (float)Math.max((float)((skyLight /= count) * 16), i));
    }

    public static void lightUpTexture(float lightIntensity) {
        int i;
        if (!JSGConfig.General.visual.renderEmissive) {
            return;
        }
        RenderHelper.func_74519_b();
        if (lightIntensity > 1.0f) {
            lightIntensity = 1.0f;
        }
        if (lightIntensity < 0.0f) {
            lightIntensity = 0.0f;
        }
        if ((i = Math.round(lightIntensity * 15.0f)) < 1) {
            return;
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(i * 16), (float)(i * 16));
    }

    public static void resetLight(World world, final BlockPos pos) {
        JSGTextureLightningHelper.resetLight(world, new ArrayList<BlockPos>(){
            {
                this.add(pos);
            }
        });
    }

    public static void resetLight(World world, ArrayList<BlockPos> poses) {
        int count = poses.size();
        int skyLight = 0;
        int blockLight = 0;
        for (BlockPos pos : poses) {
            skyLight += world.func_175642_b(EnumSkyBlock.SKY, pos);
            blockLight += world.func_175642_b(EnumSkyBlock.BLOCK, pos);
        }
        RenderHelper.func_74519_b();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((blockLight /= count) * 16), (float)((skyLight /= count) * 16));
    }
}

