/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.util;

import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tauri.dev.jsg.advancements.JSGAdvancements;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateMilkyWayBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateOrlinBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargatePegasusBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateUniverseBaseTile;
import tauri.dev.jsg.util.JSGAxisAlignedBB;

public class JSGAdvancementsUtil {
    public static void tryTriggerRangedAdvancement(TileEntity tile, EnumAdvancementType advancementType) {
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        int radius = JSGConfig.General.advancementsConfig.radius;
        List players = world.func_72872_a(EntityPlayerMP.class, (AxisAlignedBB)new JSGAxisAlignedBB(pos.func_177982_a(-radius, -radius, -radius), pos.func_177982_a(radius, radius, radius)));
        for (EntityPlayerMP player : players) {
            switch (advancementType) {
                case GATE_OPEN: {
                    if (!(tile instanceof StargateClassicBaseTile)) break;
                    int dialedSize = ((StargateAbstractBaseTile)tile).getDialedAddress().size();
                    JSGAdvancements.CHEVRON_SEVEN_LOCKED.trigger(player);
                    if (dialedSize >= 8) {
                        JSGAdvancements.CHEVRON_EIGHT_LOCKED.trigger(player);
                    }
                    if (dialedSize < 9) break;
                    JSGAdvancements.CHEVRON_NINE_LOCKED.trigger(player);
                    break;
                }
                case GATE_MERGE: {
                    if (!(tile instanceof StargateAbstractBaseTile)) break;
                    if (tile instanceof StargateOrlinBaseTile) {
                        JSGAdvancements.MERGED_ORLIN.trigger(player);
                    }
                    if (tile instanceof StargateMilkyWayBaseTile) {
                        JSGAdvancements.MERGED_MILKYWAY.trigger(player);
                    }
                    if (tile instanceof StargatePegasusBaseTile) {
                        JSGAdvancements.MERGED_PEGASUS.trigger(player);
                    }
                    if (!(tile instanceof StargateUniverseBaseTile)) break;
                    JSGAdvancements.MERGED_UNIVERSE.trigger(player);
                    break;
                }
                case IRIS_IMPACT: {
                    JSGAdvancements.IRIS_IMPACT.trigger(player);
                    break;
                }
                case ZPM_HUB: {
                    JSGAdvancements.THREE_ZPMS.trigger(player);
                    break;
                }
                case ZPM_SLOT: {
                    JSGAdvancements.ZPM_SLOT.trigger(player);
                    break;
                }
            }
        }
    }

    public static enum EnumAdvancementType {
        GATE_OPEN,
        GATE_MERGE,
        GATE_FLICKER,
        IRIS_IMPACT,
        ZPM_HUB,
        ZPM_SLOT;

    }
}

