/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.transportrings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.transportrings.SymbolTypeTransportRingsEnum;
import tauri.dev.jsg.transportrings.TransportRingsAddress;

public class TransportRings {
    private Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addressMap = new HashMap<SymbolTypeTransportRingsEnum, TransportRingsAddress>();
    private String name;
    private BlockPos pos;
    private double distance;
    private int ringsDistance = 2;
    private boolean isClone;

    public TransportRings(Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addressMap, BlockPos pos) {
        this(addressMap, "", pos, false);
    }

    public TransportRings(Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addressMap, String name) {
        this(addressMap, name, new BlockPos(0, 0, 0), false);
    }

    public TransportRings(NBTTagCompound compound) {
        this.deserializeNBT(compound);
    }

    private TransportRings(Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addressMap, String name, BlockPos pos, boolean isClone) {
        this.addressMap = addressMap;
        this.name = name;
        this.pos = pos;
        this.isClone = isClone;
    }

    public TransportRingsAddress getAddress(SymbolTypeTransportRingsEnum symbolType) {
        return this.addressMap.get(symbolType);
    }

    public Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> getAddresses() {
        return this.addressMap;
    }

    public void setAddress(SymbolTypeTransportRingsEnum symbolType, TransportRingsAddress address) {
        this.addressMap.put(symbolType, address);
    }

    public void setAddress(Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addresses) {
        this.addressMap = addresses;
    }

    public String getName() {
        if (this.name == null) {
            return "[empty]";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public double getDistance() {
        return this.distance;
    }

    public int getRingsDistance() {
        return this.ringsDistance;
    }

    public void setRingsDistance(int dist) {
        this.ringsDistance = dist;
    }

    public TransportRings cloneWithNewDistance(BlockPos callerPos) {
        return new TransportRings(this.addressMap, this.name, this.pos, true).setDistanceTo(callerPos);
    }

    public boolean isInGrid() {
        return true;
    }

    private TransportRings setDistanceTo(BlockPos pos) {
        this.distance = this.pos.func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return this;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.addressMap != null) {
            for (SymbolTypeTransportRingsEnum symbolType : SymbolTypeTransportRingsEnum.values()) {
                compound.func_74782_a("address_" + symbolType.id, (NBTBase)this.addressMap.get(symbolType).serializeNBT());
            }
        }
        if (this.name != null) {
            compound.func_74778_a("name", this.name);
        }
        compound.func_74772_a("pos", this.pos.func_177986_g());
        if (this.isClone) {
            compound.func_74780_a("distance", this.distance);
        }
        compound.func_74768_a("ringsDistance", this.ringsDistance);
        return compound;
    }

    public TransportRings deserializeNBT(NBTTagCompound compound) {
        this.addressMap = new HashMap<SymbolTypeTransportRingsEnum, TransportRingsAddress>();
        for (SymbolTypeTransportRingsEnum symbolType : SymbolTypeTransportRingsEnum.values()) {
            if (compound.func_74764_b("address_" + symbolType.id)) {
                this.addressMap.put(symbolType, new TransportRingsAddress(compound.func_74775_l("address_" + symbolType.id)));
                continue;
            }
            this.addressMap.put(symbolType, new TransportRingsAddress(symbolType));
        }
        if (compound.func_74764_b("name")) {
            this.name = compound.func_74779_i("name");
        }
        this.pos = BlockPos.func_177969_a((long)compound.func_74763_f("pos"));
        if (compound.func_74764_b("distance")) {
            this.isClone = true;
            this.distance = compound.func_74769_h("distance");
        }
        this.ringsDistance = compound.func_74762_e("ringsDistance");
        return this;
    }

    public Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> newAddressMap() {
        HashMap<SymbolTypeTransportRingsEnum, TransportRingsAddress> map = new HashMap<SymbolTypeTransportRingsEnum, TransportRingsAddress>();
        for (SymbolTypeTransportRingsEnum symbolType : SymbolTypeTransportRingsEnum.values()) {
            map.put(symbolType, new TransportRingsAddress(symbolType));
        }
        return map;
    }

    public String toString() {
        return "[pos=" + this.pos.toString() + ", address=" + this.addressMap.toString() + ", name=" + this.name + "]";
    }

    public List<String> getAddressNameList(SymbolTypeTransportRingsEnum symbolType) {
        ArrayList<String> names = new ArrayList<String>();
        for (SymbolInterface symbol : this.addressMap.get((Object)symbolType).address) {
            names.add(symbol.getEnglishName());
        }
        return names;
    }
}

