/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.transportrings;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.transportrings.TransportRingsAddress;

public enum SymbolGoauldEnum implements SymbolInterface
{
    AMUN(0, 0, "Amun"),
    SERKET(1, 1, "Serket"),
    KHEPRI(2, 3, "Khepri"),
    RA(3, 2, "Ra"),
    FELLUCA(4, 4, "Felluca"),
    COBRA(5, 5, "Cobra"),
    LIGHT(6, 6, "Light");

    public final int id;
    public final int angleIndex;
    public final String englishName;
    public final String translationKey;
    public final ResourceLocation iconResource;
    public final ResourceLocation modelResource;
    private static final Map<Integer, SymbolGoauldEnum> ID_MAP;
    private static final Map<Integer, SymbolGoauldEnum> ANGLE_INDEX_MAP;
    private static final Map<String, SymbolGoauldEnum> ENGLISH_NAME_MAP;

    private SymbolGoauldEnum(int id, int angleIndex, String englishName) {
        this.id = id;
        this.angleIndex = angleIndex;
        this.englishName = englishName;
        this.translationKey = "glyph.jsg.transportrings.goauld." + englishName.toLowerCase().replace(" ", "_");
        this.iconResource = new ResourceLocation("jsg", "textures/gui/symbol/transportrings/goauld/" + englishName.toLowerCase() + ".png");
        this.modelResource = new ResourceLocation("jsg", "models/tesr/transportrings/controller/goauld/goauld_button_" + (id + 1) + ".obj");
    }

    public static SymbolGoauldEnum getOrigin() {
        return COBRA;
    }

    @Override
    public boolean origin() {
        return this == SymbolGoauldEnum.getOrigin();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public float getAngle() {
        return this.angleIndex;
    }

    @Override
    public int getAngleIndex() {
        return this.angleIndex;
    }

    @Override
    public String getEnglishName() {
        return this.englishName;
    }

    public String toString() {
        return this.getEnglishName();
    }

    @Override
    public ResourceLocation getIconResource(BiomeOverlayEnum overlay, int dimId, int configOrigin) {
        return this.iconResource;
    }

    @Override
    public String localize() {
        return JSG.proxy.localize(this.translationKey, new Object[0]);
    }

    @Override
    public SymbolTypeEnum getSymbolType() {
        return null;
    }

    public static SymbolGoauldEnum getRandomSymbol(Random random) {
        int id;
        while ((id = random.nextInt(5)) == SymbolGoauldEnum.getOrigin().id || id == SymbolGoauldEnum.LIGHT.id) {
        }
        return SymbolGoauldEnum.valueOf(id);
    }

    public static boolean validateDialedAddress(TransportRingsAddress address) {
        if (address.size() < 5) {
            return false;
        }
        return address.get(address.size() - 1).origin();
    }

    public static List<SymbolInterface> stripOrigin(List<SymbolInterface> dialedAddress) {
        return dialedAddress.subList(0, dialedAddress.size() - 1);
    }

    public static SymbolGoauldEnum valueOf(int id) {
        return ID_MAP.get(id);
    }

    public static SymbolGoauldEnum fromEnglishName(String englishName) {
        return ENGLISH_NAME_MAP.get(englishName.toLowerCase().replace("\u0102\u00b6", "o"));
    }

    public static SymbolGoauldEnum getSymbolByAngleIndex(int index) {
        return ANGLE_INDEX_MAP.get(index);
    }

    static {
        ID_MAP = new HashMap<Integer, SymbolGoauldEnum>();
        ANGLE_INDEX_MAP = new HashMap<Integer, SymbolGoauldEnum>();
        ENGLISH_NAME_MAP = new HashMap<String, SymbolGoauldEnum>();
        for (SymbolGoauldEnum symbol : SymbolGoauldEnum.values()) {
            ID_MAP.put(symbol.id, symbol);
            ANGLE_INDEX_MAP.put(symbol.angleIndex, symbol);
            ENGLISH_NAME_MAP.put(symbol.englishName.toLowerCase(), symbol);
        }
    }
}

