/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.util;

import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import tauri.dev.jsg.stargate.EnumScheduledTask;
import tauri.dev.jsg.tileentity.util.ScheduledTaskExecutorInterface;

public class ScheduledTask
implements INBTSerializable<NBTTagCompound> {
    private ScheduledTaskExecutorInterface executor;
    private long taskCreated;
    private EnumScheduledTask scheduledTask;
    private boolean active;
    private boolean customWaitTime;
    private int waitTime;
    private NBTTagCompound customData = null;

    public ScheduledTask(EnumScheduledTask scheduledTask) {
        this.scheduledTask = scheduledTask;
        this.active = true;
        this.customWaitTime = false;
    }

    public ScheduledTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        this(scheduledTask);
        this.customData = customData;
    }

    public ScheduledTask(EnumScheduledTask scheduledTask, int waitTime) {
        this(scheduledTask);
        this.customWaitTime = true;
        this.waitTime = waitTime;
    }

    public ScheduledTask(EnumScheduledTask scheduledTask, int waitTime, NBTTagCompound customData) {
        this(scheduledTask, waitTime);
        this.customData = customData;
    }

    public ScheduledTask(NBTTagCompound compound) {
        this.deserializeNBT(compound);
    }

    public ScheduledTask setExecutor(ScheduledTaskExecutorInterface executor) {
        this.executor = executor;
        return this;
    }

    public void setTaskCreated(long taskCreated) {
        this.taskCreated = taskCreated;
    }

    public ScheduledTask inactive() {
        this.active = false;
        return this;
    }

    public ScheduledTask active() {
        this.active = true;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean update(long worldTicks) {
        boolean call;
        int waitTime = this.customWaitTime ? this.waitTime : this.scheduledTask.waitTicks;
        long effTick = worldTicks - this.taskCreated;
        boolean bl = call = effTick == (long)waitTime;
        if (this.scheduledTask.overtime) {
            boolean bl2 = call = effTick >= (long)waitTime;
        }
        if (call) {
            try {
                this.executor.executeTask(this.scheduledTask, this.customData);
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74772_a("taskCreated", this.taskCreated);
        compound.func_74768_a("scheduledTask", this.scheduledTask.id);
        compound.func_74757_a("active", this.active);
        compound.func_74757_a("customWaitTime", this.customWaitTime);
        compound.func_74768_a("waitTime", this.waitTime);
        if (this.customData != null) {
            compound.func_74782_a("customData", (NBTBase)this.customData);
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.taskCreated = compound.func_74763_f("taskCreated");
        this.scheduledTask = EnumScheduledTask.valueOf(compound.func_74762_e("scheduledTask"));
        this.active = compound.func_74767_n("active");
        this.customWaitTime = compound.func_74767_n("customWaitTime");
        this.waitTime = compound.func_74762_e("waitTime");
        if (compound.func_74764_b("customData")) {
            this.customData = compound.func_74775_l("customData");
        }
    }

    public String toString() {
        return this.scheduledTask.toString() + (this.customWaitTime ? ", custom time=" + this.waitTime : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scheduledTask == null ? 0 : this.scheduledTask.hashCode());
        result = 31 * result + (int)(this.taskCreated ^ this.taskCreated >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduledTask other = (ScheduledTask)obj;
        if (this.scheduledTask != other.scheduledTask) {
            return false;
        }
        return this.taskCreated == other.taskCreated;
    }

    public static void iterate(List<ScheduledTask> scheduledTasks, long worldTicks) {
        int i = 0;
        while (i < scheduledTasks.size()) {
            ScheduledTask scheduledTask = scheduledTasks.get(i);
            if (scheduledTask.isActive()) {
                if (scheduledTask.update(worldTicks)) {
                    scheduledTasks.remove(scheduledTask);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    public static NBTTagCompound serializeList(List<ScheduledTask> scheduledTasks) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("size", scheduledTasks.size());
        for (int i = 0; i < scheduledTasks.size(); ++i) {
            compound.func_74782_a("scheduledTask" + i, (NBTBase)scheduledTasks.get(i).serializeNBT());
        }
        return compound;
    }

    public static void deserializeList(NBTTagCompound compound, List<ScheduledTask> scheduledTasks, ScheduledTaskExecutorInterface executor) {
        int size = compound.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            scheduledTasks.add(new ScheduledTask(compound.func_74775_l("scheduledTask" + i)).setExecutor(executor));
        }
    }
}

