/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.util;

import java.util.Iterator;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.util.EnumKeyInterface;

public interface IUpgradable {
    public <T> T getCapability(Capability<T> var1, EnumFacing var2);

    default public IItemHandler getItemHandler() {
        return (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    default public boolean hasUpgrade(EnumKeyInterface<Item> upgrade) {
        return this.hasUpgrade(upgrade.getKey());
    }

    default public boolean hasUpgrade(Item item) {
        IItemHandler itemHandler = this.getItemHandler();
        Iterator<Integer> iter = this.getUpgradeSlotsIterator();
        while (iter.hasNext()) {
            int slot = iter.next();
            if (itemHandler.getStackInSlot(slot).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    default public Iterator<Integer> getUpgradeSlotsIterator() {
        return IntStream.range(0, this.getItemHandler().getSlots()).iterator();
    }

    default public boolean tryInsertUpgrade(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b().equals(JSGItems.PAGE_NOTEBOOK_ITEM)) {
            return false;
        }
        IItemHandler itemHandler = this.getItemHandler();
        Iterator<Integer> iterator = this.getUpgradeSlotsIterator();
        while (iterator.hasNext()) {
            int slot = iterator.next();
            if (!itemHandler.getStackInSlot(slot).func_190926_b() || !itemHandler.isItemValid(slot, stack)) continue;
            player.func_184611_a(hand, itemHandler.insertItem(slot, stack, false));
            return true;
        }
        return false;
    }
}

