/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.transportrings.controller;

import java.util.EnumSet;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.block.transportrings.TransportRingsAbstractBlock;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.transportrings.controller.TRControllerAbstractRendererState;
import tauri.dev.jsg.renderer.transportrings.controller.TRControllerGoauldRendererState;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.dialhomedevice.DHDActivateButtonState;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.tileentity.transportrings.controller.TRControllerAbstractTile;
import tauri.dev.jsg.transportrings.SymbolGoauldEnum;
import tauri.dev.jsg.transportrings.SymbolTypeTransportRingsEnum;
import tauri.dev.jsg.transportrings.TransportRingsAddress;

public class TRControllerGoauldTile
extends TRControllerAbstractTile {
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST);

    @Override
    public void playPressSound(boolean isFinal) {
        if (!isFinal) {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.func_174877_v(), SoundEventEnum.TR_CONTROLLER_GOAULD_BUTTON);
        } else {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.func_174877_v(), SoundEventEnum.TR_CONTROLLER_GOAULD_BUTTON_FINAL);
        }
    }

    @Override
    public void onLoad() {
        this.rendererState = new TRControllerGoauldRendererState(new TransportRingsAddress(SymbolTypeTransportRingsEnum.GOAULD), BiomeOverlayEnum.NORMAL, false);
        if (this.field_145850_b.field_72995_K) {
            this.setBiomeOverlay(BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.field_174879_c, this.getSupportedOverlays()));
        }
        super.onLoad();
    }

    @Override
    public TransportRingsAbstractBlock getTRBlock() {
        return JSGBlocks.TRANSPORT_RINGS_GOAULD_BLOCK;
    }

    @Override
    protected EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    public SymbolTypeTransportRingsEnum getSymbolType() {
        return SymbolTypeTransportRingsEnum.GOAULD;
    }

    @Override
    public TRControllerAbstractRendererState getRendererState() {
        return this.rendererState;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_STATE) {
            return new TRControllerGoauldRendererState();
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_STATE: {
                this.rendererState = ((TRControllerGoauldRendererState)state).initClient(this.field_174879_c, BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.field_174879_c, SUPPORTED_OVERLAYS), this.linkedRingsTile);
                break;
            }
            case DHD_ACTIVATE_BUTTON: {
                boolean connected = false;
                if (this.isLinked() && this.linkedRingsTile != null) {
                    connected = this.linkedRingsTile.isBusy();
                }
                if (state == null) break;
                DHDActivateButtonState activateState = (DHDActivateButtonState)state;
                this.rendererState.setIsConnected(connected);
                int symbol = activateState.symbol;
                if (activateState.deactivate) {
                    ((TRControllerGoauldRendererState)this.rendererState).deactivateSymbol(this.field_145850_b.func_82737_E(), SymbolGoauldEnum.valueOf(symbol));
                    break;
                }
                if (activateState.clearAll) {
                    ((TRControllerGoauldRendererState)this.rendererState).clearSymbols(this.field_145850_b.func_82737_E());
                    break;
                }
                ((TRControllerGoauldRendererState)this.rendererState).activateSymbol(this.field_145850_b.func_82737_E(), SymbolGoauldEnum.valueOf(symbol));
                break;
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_STATE) {
            TransportRingsAddress address = new TransportRingsAddress(SymbolTypeTransportRingsEnum.GOAULD);
            if (this.isLinked()) {
                TransportRingsAbstractTile trTile = this.getLinkedRingsTile();
                if (trTile == null) {
                    return this.rendererState;
                }
                address.addAll(trTile.dialedAddress);
                boolean ringsAreConnected = trTile.isBusy();
                return new TRControllerGoauldRendererState(address, this.getBiomeOverlay(), ringsAreConnected);
            }
            return new TRControllerGoauldRendererState(address, this.getBiomeOverlay(), false);
        }
        return super.getState(stateType);
    }
}

