/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.transportrings.controller;

import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.transportrings.TransportRingsAbstractBlock;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.packet.StateUpdateRequestToServer;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.transportrings.controller.TRControllerAbstractRendererState;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.dialhomedevice.DHDActivateButtonState;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.transportrings.SymbolTypeTransportRingsEnum;
import tauri.dev.jsg.util.ILinkable;
import tauri.dev.jsg.util.LinkingHelper;

public abstract class TRControllerAbstractTile
extends TileEntity
implements ITickable,
ILinkable,
StateProviderInterface {
    protected BiomeOverlayEnum biomeOverlay = BiomeOverlayEnum.NORMAL;
    protected TransportRingsAbstractTile linkedRingsTile;
    protected NetworkRegistry.TargetPoint targetPoint;
    TRControllerAbstractRendererState rendererState;
    private BlockPos lastPos = BlockPos.field_177992_a;
    private BlockPos linkedRings;
    private int linkId = -1;

    public BiomeOverlayEnum getBiomeOverlay() {
        return this.biomeOverlay;
    }

    public void setBiomeOverlay(BiomeOverlayEnum biomeOverlay) {
        this.biomeOverlay = biomeOverlay;
    }

    public abstract SymbolTypeTransportRingsEnum getSymbolType();

    public abstract void playPressSound(boolean var1);

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        } else {
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_STATE));
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 40L == 0L && this.rendererState != null) {
                this.biomeOverlay = BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.field_174879_c, this.getSupportedOverlays());
                this.rendererState.setBiomeOverlay(BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.field_174879_c, this.getSupportedOverlays()));
            }
            if (!this.lastPos.equals((Object)this.field_174879_c)) {
                this.lastPos = this.field_174879_c;
                this.updateLinkStatus();
                this.func_70296_d();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isLinked() && this.getLinkedRings() == null) {
                this.linkedRingsTile = (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(this.getLinkedRings());
            }
            if (!this.isLinked() && this.getLinkedRings() != null) {
                this.linkedRingsTile = null;
            }
            this.func_70296_d();
        }
    }

    protected abstract EnumSet<BiomeOverlayEnum> getSupportedOverlays();

    public abstract TRControllerAbstractRendererState getRendererState();

    public void setLinkedRings(BlockPos pos, int linkId) {
        this.linkedRings = pos;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public BlockPos getLinkedRings() {
        return this.linkedRings;
    }

    public TransportRingsAbstractTile getLinkedRingsTile() {
        return (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(this.linkedRings);
    }

    public boolean isLinked() {
        return this.linkedRings != null;
    }

    public TransportRingsAbstractTile getLinkedRingsTile(World world) {
        return this.linkedRings != null ? (TransportRingsAbstractTile)world.func_175625_s(this.linkedRings) : null;
    }

    @Override
    public boolean canLinkTo() {
        return !this.isLinked();
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }

    public abstract TransportRingsAbstractBlock getTRBlock();

    public void updateLinkStatus() {
        int linkId;
        BlockPos closestRings = LinkingHelper.findClosestUnlinked(this.field_145850_b, this.field_174879_c, new BlockPos(10, 40, 10), this.getTRBlock(), this.linkId);
        int n = linkId = closestRings == null ? -1 : LinkingHelper.getLinkId();
        if (closestRings != null) {
            TransportRingsAbstractTile ringsTile = (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(closestRings);
            Objects.requireNonNull(ringsTile).setLinkedController(this.field_174879_c, linkId);
        }
        this.setLinkedRings(closestRings, linkId);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        if (this.linkedRings != null) {
            compound.func_74772_a("linkedRings", this.linkedRings.func_177986_g());
            compound.func_74768_a("linkId", this.linkId);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("linkedRings")) {
            this.linkedRings = BlockPos.func_177969_a((long)compound.func_74763_f("linkedRings"));
            this.linkId = compound.func_74762_e("linkId");
        }
        super.func_145839_a(compound);
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.DHD_ACTIVATE_BUTTON) {
            return new DHDActivateButtonState();
        }
        throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
    }

    public void sendState(StateTypeEnum type, State state) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetPoint != null) {
            JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, type, state), this.targetPoint);
        } else {
            JSG.debug("targetPoint was null trying to send " + (Object)((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }
}

