/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.transportrings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlock;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.block.props.TRPlatformBlock;
import tauri.dev.jsg.block.transportrings.controller.TRControllerAbstractBlock;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.ingame.ITileConfig;
import tauri.dev.jsg.config.ingame.ITileConfigEntry;
import tauri.dev.jsg.config.ingame.JSGConfigEnumEntry;
import tauri.dev.jsg.config.ingame.JSGConfigOption;
import tauri.dev.jsg.config.ingame.JSGConfigOptionTypeEnum;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.entity.friendly.TokraEntity;
import tauri.dev.jsg.gui.container.transportrings.TRGuiState;
import tauri.dev.jsg.gui.container.transportrings.TRGuiUpdate;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.energy.CapacitorItemBlock;
import tauri.dev.jsg.item.notebook.PageNotebookItem;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.packet.StateUpdateRequestToServer;
import tauri.dev.jsg.packet.transportrings.StartPlayerFadeOutToClient;
import tauri.dev.jsg.power.stargate.StargateClassicEnergyStorage;
import tauri.dev.jsg.power.stargate.StargateEnergyRequired;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.stargate.EnumScheduledTask;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.dialhomedevice.DHDActivateButtonState;
import tauri.dev.jsg.state.transportrings.TransportRingsRendererState;
import tauri.dev.jsg.state.transportrings.TransportRingsStartAnimationRequest;
import tauri.dev.jsg.tileentity.transportrings.controller.TRControllerAbstractTile;
import tauri.dev.jsg.tileentity.util.IUpgradable;
import tauri.dev.jsg.tileentity.util.PreparableInterface;
import tauri.dev.jsg.tileentity.util.ScheduledTask;
import tauri.dev.jsg.tileentity.util.ScheduledTaskExecutorInterface;
import tauri.dev.jsg.transportrings.ParamsSetResult;
import tauri.dev.jsg.transportrings.RingsPlatform;
import tauri.dev.jsg.transportrings.SymbolGoauldEnum;
import tauri.dev.jsg.transportrings.SymbolTypeTransportRingsEnum;
import tauri.dev.jsg.transportrings.TransportResult;
import tauri.dev.jsg.transportrings.TransportRings;
import tauri.dev.jsg.transportrings.TransportRingsAddress;
import tauri.dev.jsg.util.EnumKeyInterface;
import tauri.dev.jsg.util.EnumKeyMap;
import tauri.dev.jsg.util.ILinkable;
import tauri.dev.jsg.util.JSGAxisAlignedBB;
import tauri.dev.jsg.util.JSGItemStackHandler;
import tauri.dev.jsg.util.LinkingHelper;
import tauri.dev.jsg.util.main.JSGProps;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.WirelessEndpoint", modid="opencomputers")})
public abstract class TransportRingsAbstractTile
extends TileEntity
implements ITickable,
StateProviderInterface,
ScheduledTaskExecutorInterface,
ILinkable,
Environment,
IUpgradable,
ITileConfig,
PreparableInterface {
    public static final int FADE_OUT_TOTAL_TIME = 40;
    public static final int TIMEOUT_TELEPORT = 20;
    public static final int TIMEOUT_FADE_OUT = 63;
    public static final int RINGS_CLEAR_OUT = 48;
    private final StargateClassicEnergyStorage energyStorage = new StargateClassicEnergyStorage(){

        @Override
        protected void onEnergyChanged() {
            TransportRingsAbstractTile.this.func_70296_d();
        }
    };
    public Map<Map<SymbolTypeTransportRingsEnum, TransportRingsAddress>, TransportRings> ringsMap = new HashMap<Map<SymbolTypeTransportRingsEnum, TransportRingsAddress>, TransportRings>();
    public JSGAxisAlignedBB LOCAL_TELEPORT_BOX = new JSGAxisAlignedBB(-1.0, 2.0, -1.0, 2.0, 4.5, 2.0);
    protected JSGAxisAlignedBB globalTeleportBox;
    protected List<Entity> teleportList = new ArrayList<Entity>();
    protected BlockPos lastPos = BlockPos.field_177992_a;
    private boolean addedToNetwork;
    protected BlockPos targetRingsPos = new BlockPos(0, 0, 0);
    protected List<Entity> excludedEntities = new ArrayList<Entity>();
    protected Object ocContext;
    protected boolean initiating;
    protected TransportRings rings;
    protected int energyTransferedLastTick = 0;
    List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
    protected int ringsDistance = 2;
    protected String ringsName = "";
    TransportRingsRendererState rendererState = new TransportRingsRendererState();
    private List<BlockPos> invisibleBlocksTemplate = Arrays.asList(new BlockPos(0, 2, 2), new BlockPos(1, 2, 2), new BlockPos(2, 2, 1));
    private boolean busy = false;
    private BlockPos linkedController;
    public TransportRingsAddress dialedAddress = new TransportRingsAddress(this.getSymbolType());
    private int linkId = -1;
    private final Node node = JSG.ocWrapper.createNode(this, "transportrings");
    private int currentPowerTier = 1;
    public int itemStackHandlerSlotsCount = 10;
    private final JSGItemStackHandler itemStackHandler = new JSGItemStackHandler(10){

        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.func_77973_b();
            boolean isItemCapacitor = item instanceof CapacitorItemBlock;
            switch (slot) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return TransportRingsUpgradeEnum.contains(item) && !TransportRingsAbstractTile.this.hasUpgrade(item) && TransportRingsUpgradeEnum.valueOf((Item)item).slotId == slot;
                }
                case 4: {
                    return isItemCapacitor && TransportRingsAbstractTile.this.getSupportedCapacitors() >= 1;
                }
                case 5: {
                    return isItemCapacitor && TransportRingsAbstractTile.this.getSupportedCapacitors() >= 2;
                }
                case 6: {
                    return isItemCapacitor && TransportRingsAbstractTile.this.getSupportedCapacitors() >= 3;
                }
                case 7: 
                case 8: 
                case 9: {
                    return item == JSGItems.PAGE_NOTEBOOK_ITEM;
                }
            }
            return true;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            switch (slot) {
                case 4: 
                case 5: 
                case 6: {
                    TransportRingsAbstractTile.this.updatePowerTier();
                    break;
                }
            }
            TransportRingsAbstractTile.this.func_70296_d();
        }
    };
    private short pageProgress = 0;
    private int pageSlotId;
    private boolean doPageProgress;
    private ScheduledTask givePageTask;
    private boolean lockPage;
    private int keepAliveEnergyPerTick = 0;
    private int energyStoredLastTick = 0;
    public boolean isPlatformBuild = false;
    public IBlockState platformOverlayBlockState = Blocks.field_192443_dR.func_176203_a(10);
    protected JSGTileEntityConfig config = new JSGTileEntityConfig();

    public short getPageProgress() {
        return this.pageProgress;
    }

    public void setPageProgress(int pageProgress) {
        this.pageProgress = (short)pageProgress;
    }

    public IBlockState getPlatformOverlayBlockState() {
        return this.platformOverlayBlockState;
    }

    public boolean isTherePlatform() {
        return this.getPlatform() != null;
    }

    public void updatePlatformStatus() {
        this.updatePlatformStatus(false);
    }

    public void updatePlatformStatus(boolean forceDeletion) {
        boolean tempState;
        if (this.field_145850_b.func_175625_s(this.field_174879_c) == null || !(this.field_145850_b.func_175625_s(this.field_174879_c) instanceof TransportRingsAbstractTile)) {
            forceDeletion = true;
        }
        boolean bl = tempState = this.isTherePlatform() && (this.isPlatformBuild || this.hasPlatformSpace());
        if (this.isPlatformBuild != tempState || forceDeletion) {
            this.tryBuildPlatformPattern(!tempState || forceDeletion);
        }
        this.isPlatformBuild = tempState;
    }

    public boolean isTherePlace(BlockPos pos) {
        IBlockState newState = this.field_145850_b.func_180495_p(pos);
        Block newBlock = newState.func_177230_c();
        return newBlock.isAir(newState, (IBlockAccess)this.field_145850_b, pos) || newBlock.func_176200_f((IBlockAccess)this.field_145850_b, pos) || !(newBlock instanceof JSGBlock);
    }

    public boolean hasPlatformSpace() {
        return this.hasPlatformSpace(false, false);
    }

    public boolean hasPlatformSpace(boolean tryBuild, boolean removeBlocks) {
        if (this.getPlatform() == null) {
            return false;
        }
        BlockPos[] pattern = this.getPlatform().platformBlock.getPattern();
        boolean fromToPattern = this.getPlatform().platformBlock.getPlatform().fromToPattern;
        if (!fromToPattern) {
            for (BlockPos offset : pattern) {
                BlockPos o = new BlockPos((Vec3i)offset);
                if (this.ringsDistance > 0) {
                    o.func_177981_b(this.ringsDistance);
                }
                if (this.ringsDistance < 0) {
                    o.func_177979_c(-this.ringsDistance);
                }
                BlockPos actualPos = new BlockPos((Vec3i)this.field_174879_c).func_177971_a((Vec3i)o);
                if (tryBuild) {
                    if (!this.isTherePlace(actualPos)) continue;
                    this.field_145850_b.func_175656_a(actualPos, removeBlocks ? Blocks.field_150350_a.func_176223_P() : JSGBlocks.NAQUADAH_BLOCK_RAW.func_176223_P());
                    continue;
                }
                if (this.isTherePlace(actualPos)) continue;
                return false;
            }
            return true;
        }
        for (int x = pattern[0].func_177958_n(); x <= pattern[1].func_177958_n(); ++x) {
            for (int z = pattern[0].func_177952_p(); z <= pattern[1].func_177952_p(); ++z) {
                BlockPos o = new BlockPos(x, 0, z);
                if (this.ringsDistance > 0) {
                    o.func_177981_b(this.ringsDistance);
                }
                if (this.ringsDistance < 0) {
                    o.func_177979_c(-this.ringsDistance);
                }
                BlockPos actualPos = new BlockPos((Vec3i)this.field_174879_c).func_177971_a((Vec3i)o);
                if (tryBuild) {
                    if (!this.isTherePlace(actualPos)) continue;
                    this.field_145850_b.func_175656_a(actualPos, removeBlocks ? Blocks.field_150350_a.func_176223_P() : JSGBlocks.NAQUADAH_BLOCK_RAW.func_176223_P());
                    continue;
                }
                if (this.isTherePlace(actualPos)) continue;
                return false;
            }
        }
        return true;
    }

    public void tryBuildPlatformPattern(boolean removeBlocks) {
        this.hasPlatformSpace(true, removeBlocks);
    }

    public RingsPlatform getPlatform() {
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos pos = this.field_174879_c.func_177967_a(facing, 1);
            Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
            if (!(block instanceof TRPlatformBlock)) continue;
            return new RingsPlatform(pos, (TRPlatformBlock)block);
        }
        return null;
    }

    public void playPlatformSound(boolean closing) {
        if (this.ringsDistance < 0 || !this.isTherePlatform() || !this.getConfig().getOption(ConfigOptions.RENDER_PLATFORM_MOVING.id).getBooleanValue()) {
            return;
        }
        JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getPosWithDistance(this.ringsDistance), this.getPlatform().platformBlock.getPlatformSound(closing));
    }

    public void func_73660_a() {
        block15: {
            block16: {
                if (this.field_145850_b.field_72995_K) break block15;
                if (!this.addedToNetwork) {
                    this.addedToNetwork = true;
                    JSG.ocWrapper.joinOrCreateNetwork(this);
                }
                this.initConfig();
                ScheduledTask.iterate(this.scheduledTasks, this.field_145850_b.func_82737_E());
                if (this.getRings().getAddresses() == null || this.getRings().getAddresses().size() < SymbolTypeTransportRingsEnum.values().length || this.getRings().getAddress(SymbolTypeTransportRingsEnum.valueOf(0)).get(0).equals(SymbolGoauldEnum.getOrigin()) || this.getRings().getAddress(SymbolTypeTransportRingsEnum.valueOf(0)).get(0).equals(this.getRings().getAddress(SymbolTypeTransportRingsEnum.valueOf(0)).get(1))) {
                    if (this.getRings().getAddresses() != null) {
                        JSG.debug("TransportRings at " + this.field_174879_c.toString() + " are generating new addresses!");
                    }
                    this.generateAddress(true);
                }
                if (!this.lastPos.equals((Object)this.field_174879_c)) {
                    this.lastPos = this.field_174879_c;
                    this.getRings().setPos(this.field_174879_c);
                    this.updateRingsDistance();
                    this.setRingsParams(null, null, this.getRings().getName());
                    this.updateLinkStatus();
                    this.func_70296_d();
                }
                this.updatePlatformStatus();
                if (this.field_145850_b.func_82737_E() % 80L == 0L) {
                    this.updateRingsDistance();
                }
                this.energyTransferedLastTick = 0;
                if (this.keepAliveEnergyPerTick > 0) {
                    if (this.targetRingsPos == null) {
                        return;
                    }
                    if (this.field_145850_b.func_175625_s(this.targetRingsPos) == null) {
                        return;
                    }
                    if (this.getEnergyStorage().getEnergyStored() >= this.keepAliveEnergyPerTick) {
                        this.getEnergyStorage().extractEnergy(this.keepAliveEnergyPerTick, false);
                        this.func_70296_d();
                    }
                    this.energyTransferedLastTick = this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick;
                    this.energyStoredLastTick = this.getEnergyStorage().getEnergyStored();
                    this.func_70296_d();
                }
                if (this.givePageTask != null && this.givePageTask.update(this.field_145850_b.func_82737_E())) {
                    this.givePageTask = null;
                }
                if (!this.doPageProgress) break block16;
                if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                    this.pageProgress = (short)(this.pageProgress + 1);
                    if (this.pageProgress > 18) {
                        this.pageProgress = 0;
                        this.doPageProgress = false;
                    }
                }
                if (!this.itemStackHandler.getStackInSlot(this.pageSlotId).func_190926_b()) break block15;
                this.lockPage = false;
                this.doPageProgress = false;
                this.pageProgress = 0;
                this.givePageTask = null;
                break block15;
            }
            if (this.lockPage && this.itemStackHandler.getStackInSlot(this.pageSlotId).func_190926_b()) {
                this.lockPage = false;
            }
            if (!this.lockPage) {
                for (int i = 7; i < this.itemStackHandlerSlotsCount; ++i) {
                    if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
                    this.doPageProgress = true;
                    this.lockPage = true;
                    this.pageSlotId = i;
                    this.givePageTask = new ScheduledTask(EnumScheduledTask.STARGATE_GIVE_PAGE, 36);
                    this.givePageTask.setTaskCreated(this.field_145850_b.func_82737_E());
                    this.givePageTask.setExecutor(this);
                    break;
                }
            }
        }
    }

    public int getSlotsCount() {
        return this.itemStackHandlerSlotsCount;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.rendererState.ringsDistance = this.ringsDistance;
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_STATE));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.setBarrierBlocks(false, false);
            this.generateAddress(false);
            this.globalTeleportBox = this.LOCAL_TELEPORT_BOX.offset(this.field_174879_c);
            this.updatePowerTier();
        }
    }

    public void onBreak() {
        this.setBarrierBlocks(false, false);
        this.updatePlatformStatus(true);
    }

    public Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> generateAndPostAddress(boolean reset) {
        Random random = new Random((long)this.field_174879_c.hashCode() * 31L + (long)this.field_145850_b.field_73011_w.getDimension());
        if (reset) {
            HashMap<SymbolTypeTransportRingsEnum, TransportRingsAddress> map = new HashMap<SymbolTypeTransportRingsEnum, TransportRingsAddress>();
            for (SymbolTypeTransportRingsEnum symbolType : SymbolTypeTransportRingsEnum.values()) {
                TransportRingsAddress address = new TransportRingsAddress(symbolType);
                address.generate(random);
                map.put(symbolType, address);
            }
            return map;
        }
        return this.getRings().getAddresses();
    }

    public void generateAddress(boolean reset) {
        this.setRingsParams(this.generateAndPostAddress(reset));
    }

    public void setNewRingsDistance(int newRingsDistance) {
        this.getRings().setRingsDistance(newRingsDistance);
        this.updateRingsDistance();
    }

    public void updateRingsDistance() {
        this.ringsDistance = this.getRings().getRingsDistance();
        this.LOCAL_TELEPORT_BOX = new JSGAxisAlignedBB(-1.0, this.ringsDistance, -1.0, 2.0, (double)this.ringsDistance + 2.5, 2.0);
        this.invisibleBlocksTemplate = Arrays.asList(new BlockPos(0, this.ringsDistance, 2), new BlockPos(1, this.ringsDistance, 2), new BlockPos(2, this.ringsDistance, 1));
        this.globalTeleportBox = this.LOCAL_TELEPORT_BOX.offset(this.field_174879_c);
        this.rendererState.ringsDistance = this.ringsDistance;
        this.rendererState.ringsConfig = this.config;
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.RINGS_DISTANCE_UPDATE, new TransportRingsStartAnimationRequest(this.rendererState.animationStart, this.rendererState.ringsDistance, this.rendererState.ringsConfig)), point);
        this.func_70296_d();
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(this.field_145850_b.func_82737_E());
        this.scheduledTasks.add(scheduledTask);
        this.func_70296_d();
    }

    protected StargateEnergyRequired getEnergyRequiredToDial(TransportRings targetRings) {
        BlockPos sPos = this.field_174879_c;
        BlockPos tPos = targetRings.getPos();
        double distance = (int)sPos.func_185332_f(tPos.func_177958_n(), tPos.func_177956_o(), tPos.func_177952_p());
        distance = distance < 200.0 ? (distance *= 0.8) : 200.0 * Math.log10(distance) / Math.log10(200.0);
        int energyBase = JSGConfig.Rings.power.ringsKeepAliveBlockToEnergyRatioPerTick;
        StargateEnergyRequired energyRequired = new StargateEnergyRequired(energyBase, energyBase);
        energyRequired = energyRequired.mul(distance);
        return energyRequired;
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        switch (scheduledTask) {
            case RINGS_START_ANIMATION: {
                this.animationStart();
                this.setBarrierBlocks(true, true);
                this.sendStateToController(StateTypeEnum.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(this.getSymbolType().getLight()));
                this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_FADE_OUT));
                this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_SOLID_BLOCKS, 35));
                this.playPlatformSound(false);
                JSG.debug("Rings at " + this.field_174879_c.toString() + " started transport!");
                break;
            }
            case RINGS_SOLID_BLOCKS: {
                this.setBarrierBlocks(true, false);
                break;
            }
            case RINGS_FADE_OUT: {
                this.teleportList = this.field_145850_b.func_72872_a(Entity.class, (AxisAlignedBB)this.globalTeleportBox);
                for (Entity entity : this.teleportList) {
                    if (!(entity instanceof EntityPlayerMP)) continue;
                    JSGPacketHandler.INSTANCE.sendTo((IMessage)new StartPlayerFadeOutToClient(StartPlayerFadeOutToClient.EnumFadeOutEffectType.RINGS), (EntityPlayerMP)entity);
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_TELEPORT));
                break;
            }
            case RINGS_TELEPORT: {
                BlockPos teleportVector = this.targetRingsPos.func_177973_b((Vec3i)this.field_174879_c);
                TransportRingsAbstractTile targetTile = (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(this.targetRingsPos);
                if (targetTile == null) break;
                int targetRingsHeight = targetTile.getRings().getRingsDistance();
                for (Entity entity : this.teleportList) {
                    int extracted = this.getEnergyStorage().extractEnergy(JSGConfig.Rings.power.ringsTeleportPowerDraw, true);
                    if (this.initiating && extracted < JSGConfig.Rings.power.ringsTeleportPowerDraw && entity instanceof EntityLivingBase) continue;
                    if (entity instanceof EntityLivingBase && this.initiating) {
                        this.getEnergyStorage().extractEnergy(extracted, false);
                    }
                    if (this.excludedEntities.contains(entity)) continue;
                    BlockPos ePos = entity.func_180425_c().func_177971_a((Vec3i)teleportVector);
                    double y = this.targetRingsPos.func_177956_o() + targetRingsHeight;
                    entity.func_70634_a((double)ePos.func_177958_n(), y, (double)ePos.func_177952_p());
                    if (entity instanceof TokraEntity) {
                        ((TokraEntity)entity).moveFromRingsPlatform();
                    }
                    if (!(entity instanceof EntityPlayerMP)) continue;
                    this.triggerTeleportAdvancement((EntityPlayerMP)entity);
                }
                this.func_70296_d();
                this.teleportList.clear();
                this.excludedEntities.clear();
                this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_CLEAR_OUT));
                JSG.debug("Rings at " + this.field_174879_c.toString() + " transported entities!");
                break;
            }
            case RINGS_CLEAR_OUT: {
                this.setBarrierBlocks(false, false);
                this.setBusy(false);
                this.clearButtonsController();
                TransportRingsAbstractTile targetRingsTile = (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(this.targetRingsPos);
                if (targetRingsTile != null) {
                    targetRingsTile.setBusy(false);
                }
                this.sendSignal(this.ocContext, "transportrings_teleport_finished", this.initiating);
                this.keepAliveEnergyPerTick = 0;
                this.playPlatformSound(true);
                this.func_70296_d();
                JSG.debug("Rings at " + this.field_174879_c.toString() + " deactivated!");
                break;
            }
            case STARGATE_GIVE_PAGE: {
                SymbolTypeTransportRingsEnum symbolType = SymbolTypeTransportRingsEnum.valueOf(this.pageSlotId - 7);
                ItemStack stack = this.itemStackHandler.getStackInSlot(this.pageSlotId);
                if (stack.func_190926_b()) break;
                JSG.debug("Giving Notebook page of address " + symbolType);
                NBTTagCompound compound = PageNotebookItem.getCompoundFromAddress(this.getRings().getAddresses().get(symbolType), PageNotebookItem.getRegistryPathFromWorld(this.field_145850_b, this.field_174879_c));
                stack = new ItemStack((Item)JSGItems.PAGE_NOTEBOOK_ITEM, 1, 1);
                stack.func_77982_d(compound);
                this.itemStackHandler.setStackInSlot(this.pageSlotId, stack);
                break;
            }
            case RINGS_SYMBOL_DEACTIVATE: {
                if (customData != null && customData.func_74764_b("symbol")) {
                    int symbolId = customData.func_74762_e("symbol");
                    this.sendStateToController(StateTypeEnum.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(symbolId, true));
                    break;
                }
                this.sendStateToController(StateTypeEnum.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(true));
                break;
            }
            default: {
                throw new UnsupportedOperationException("EnumScheduledTask." + scheduledTask.name() + " not implemented on " + this.getClass().getName());
            }
        }
    }

    public abstract void triggerTeleportAdvancement(EntityPlayerMP var1);

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public int getRingsDistance() {
        return this.ringsDistance;
    }

    public String getRingsName() {
        return this.ringsName;
    }

    public List<Entity> startAnimationAndTeleport(BlockPos targetRingsPos, List<Entity> excludedEntities, int waitTime, boolean initiating) {
        this.targetRingsPos = targetRingsPos;
        this.excludedEntities = excludedEntities;
        this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_START_ANIMATION, waitTime));
        this.sendSignal(this.ocContext, "transportrings_teleport_start", initiating);
        this.initiating = initiating;
        this.func_70296_d();
        return this.field_145850_b.func_72872_a(Entity.class, (AxisAlignedBB)this.globalTeleportBox);
    }

    public void animationStart() {
        this.rendererState.animationStart = this.field_145850_b.func_82737_E();
        this.rendererState.ringsUprising = true;
        this.rendererState.isAnimationActive = true;
        this.rendererState.ringsDistance = this.getRings().getRingsDistance();
        this.rendererState.ringsConfig = this.config;
        this.func_70296_d();
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.START_ANIMATION, new TransportRingsStartAnimationRequest(this.rendererState.animationStart, this.rendererState.ringsDistance, this.rendererState.ringsConfig)), point);
    }

    public TransportRingsRendererState getRendererState() {
        return this.rendererState;
    }

    public TransportResult dialNearestRings(boolean dial) {
        Iterator<TransportRings> iterator = this.ringsMap.values().iterator();
        if (iterator.hasNext()) {
            TransportRings rings = iterator.next();
            if (!rings.isInGrid()) {
                return TransportResult.NO_SUCH_ADDRESS;
            }
            BlockPos targetRingsPos = rings.getPos();
            TransportRingsAbstractTile targetRingsTile = (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(targetRingsPos);
            if (targetRingsTile == null || targetRingsTile.checkIfObstructed()) {
                return TransportResult.OBSTRUCTED_TARGET;
            }
            if (targetRingsTile.isBusy()) {
                return TransportResult.BUSY_TARGET;
            }
            StargateEnergyRequired energyRequired = this.getEnergyRequiredToDial(rings);
            int extracted = this.getEnergyStorage().extractEnergy(energyRequired.keepAlive * 20, true);
            if (extracted < energyRequired.keepAlive * 20) {
                return TransportResult.NOT_ENOUGH_POWER;
            }
            if (dial) {
                this.keepAliveEnergyPerTick = energyRequired.keepAlive;
                this.setBusy(true);
                targetRingsTile.setBusy(true);
                List excludedFromReceivingSite = this.field_145850_b.func_72872_a(Entity.class, (AxisAlignedBB)this.globalTeleportBox);
                List<Entity> excludedEntities = targetRingsTile.startAnimationAndTeleport(this.field_174879_c, excludedFromReceivingSite, EnumScheduledTask.RINGS_START_ANIMATION.waitTicks, false);
                this.startAnimationAndTeleport(targetRingsPos, excludedEntities, EnumScheduledTask.RINGS_START_ANIMATION.waitTicks, true);
            }
            return TransportResult.OK;
        }
        return TransportResult.NO_SUCH_ADDRESS;
    }

    public TransportResult addSymbolToAddressInternal(SymbolInterface symbol, boolean computer) {
        if (this.isBusy()) {
            return TransportResult.BUSY;
        }
        if (this.canAddSymbol(symbol)) {
            TransportResult result;
            this.dialedAddress.setSymbolType(this.getSymbolType());
            this.dialedAddress.add(symbol);
            this.func_70296_d();
            this.activateSymbolController(symbol);
            this.playPressSoundController(computer, false);
            if (this.symbolWillLock() && !(result = this.attemptTransportTo(this.dialedAddress, EnumScheduledTask.RINGS_START_ANIMATION.waitTicks)).ok()) {
                this.clearButtonsController(7);
                this.func_70296_d();
                this.sendSignal(this.ocContext, "transportrings_symbol_engage_failed", result.toString());
                return result;
            }
            this.sendSignal(this.ocContext, "transportrings_symbol_engage", TransportResult.OK.toString());
            return TransportResult.ACTIVATED;
        }
        if (symbol.origin()) {
            this.activateSymbolController(symbol);
            this.clearButtonsController(7);
            this.playPressSoundController(computer, true);
            this.sendSignal(this.ocContext, "transportrings_symbol_engage_failed", TransportResult.NO_SUCH_ADDRESS.toString());
            return TransportResult.NO_SUCH_ADDRESS;
        }
        return TransportResult.ALREADY_ACTIVATED;
    }

    public void playPressSoundController(boolean computer, boolean isFinal) {
        TRControllerAbstractTile controller = this.getLinkedControllerTile(this.field_145850_b);
        if ((!computer || this.config.getOption(ConfigOptions.ENABLE_OC_PRESS_SOUND.id).getBooleanValue()) && this.isLinked() && controller != null) {
            controller.playPressSound(isFinal);
        }
    }

    public void activateSymbolController(SymbolInterface symbol) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("symbol", symbol.getId());
        this.sendStateToController(StateTypeEnum.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(symbol));
        this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_SYMBOL_DEACTIVATE, compound));
    }

    public void clearButtonsController() {
        this.clearButtonsController(-1);
    }

    public void clearButtonsController(int waitTicks) {
        if (waitTicks > -1) {
            this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_SYMBOL_DEACTIVATE, waitTicks));
        } else {
            this.sendStateToController(StateTypeEnum.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(true));
        }
        this.dialedAddress.clear();
        this.func_70296_d();
    }

    public boolean canAddSymbol(SymbolInterface symbol) {
        if (this.dialedAddress.contains(symbol)) {
            return false;
        }
        if (this.dialedAddress.size() > 4) {
            this.dialedAddress.clear();
            return false;
        }
        return !this.isBusy();
    }

    public void sendStateToController(StateTypeEnum stateType, State state) {
        if (this.getLinkedControllerTile(this.field_145850_b) != null) {
            this.getLinkedControllerTile(this.field_145850_b).sendState(stateType, state);
        }
    }

    public boolean symbolWillLock() {
        return this.dialedAddress.size() > 4 || this.dialedAddress.getLast().origin();
    }

    public TransportResult attemptTransportTo(TransportRingsAddress address, int waitTime) {
        TransportRingsAddress strippedAddress;
        if (!this.getRings().isInGrid()) {
            return TransportResult.NOT_IN_GRID;
        }
        if (this.checkIfObstructed()) {
            return TransportResult.OBSTRUCTED;
        }
        if (this.isBusy()) {
            return TransportResult.BUSY;
        }
        TransportRingsAddress transportRingsAddress = strippedAddress = address.getLast().origin() ? address.stripOrigin() : address;
        if (address.size() < 4) {
            return TransportResult.NO_SUCH_ADDRESS;
        }
        boolean found = false;
        for (TransportRings rings : this.ringsMap.values()) {
            if (!rings.getAddress(address.getSymbolType()).equalsV2(strippedAddress, 4)) continue;
            if (!rings.isInGrid()) {
                return TransportResult.NO_SUCH_ADDRESS;
            }
            BlockPos targetRingsPos = rings.getPos();
            TransportRingsAbstractTile targetRingsTile = (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(targetRingsPos);
            if (targetRingsTile == null || targetRingsTile.checkIfObstructed()) {
                return TransportResult.OBSTRUCTED_TARGET;
            }
            if (targetRingsTile.isBusy()) {
                return TransportResult.BUSY_TARGET;
            }
            StargateEnergyRequired energyRequired = this.getEnergyRequiredToDial(rings);
            int extracted = this.getEnergyStorage().extractEnergy(energyRequired.keepAlive * 20, true);
            if (extracted < energyRequired.keepAlive * 20) {
                return TransportResult.NOT_ENOUGH_POWER;
            }
            this.keepAliveEnergyPerTick = energyRequired.keepAlive;
            this.setBusy(true);
            targetRingsTile.setBusy(true);
            List excludedFromReceivingSite = this.field_145850_b.func_72872_a(Entity.class, (AxisAlignedBB)this.globalTeleportBox);
            List<Entity> excludedEntities = targetRingsTile.startAnimationAndTeleport(this.field_174879_c, excludedFromReceivingSite, waitTime, false);
            this.startAnimationAndTeleport(targetRingsPos, excludedEntities, waitTime, true);
            found = true;
            break;
        }
        if (!found) {
            return TransportResult.NO_SUCH_ADDRESS;
        }
        return TransportResult.OK;
    }

    private boolean checkIfObstructed() {
        if (JSGConfig.Rings.mechanics.ignoreObstructionCheck) {
            return false;
        }
        for (int y = 0; y < 3; ++y) {
            for (Rotation rotation : Rotation.values()) {
                for (BlockPos invPos : this.invisibleBlocksTemplate) {
                    BlockPos newPos = new BlockPos((Vec3i)this.field_174879_c).func_177971_a((Vec3i)invPos.func_190942_a(rotation)).func_177982_a(0, y, 0);
                    IBlockState newState = this.field_145850_b.func_180495_p(newPos);
                    Block newBlock = newState.func_177230_c();
                    if (newBlock.isAir(newState, (IBlockAccess)this.field_145850_b, newPos) || newBlock.func_176200_f((IBlockAccess)this.field_145850_b, newPos)) continue;
                    return true;
                }
            }
        }
        return this.field_174879_c.func_177956_o() + this.ringsDistance < 0;
    }

    public void setBarrierBlocks(boolean set, boolean passable) {
        this.setBarrierBlocks(set, passable, false);
    }

    public void setBarrierBlocks(boolean set, boolean passable, boolean force) {
        IBlockState invBlockState = JSGBlocks.INVISIBLE_BLOCK.func_176223_P();
        if (passable) {
            invBlockState = invBlockState.func_177226_a((IProperty)JSGProps.HAS_COLLISIONS, (Comparable)Boolean.valueOf(false));
        }
        for (int y = 1; y < 3; ++y) {
            for (Rotation rotation : Rotation.values()) {
                for (BlockPos invPos : this.invisibleBlocksTemplate) {
                    BlockPos newPos = this.field_174879_c.func_177971_a((Vec3i)invPos.func_190942_a(rotation)).func_177982_a(0, y, 0);
                    if (set) {
                        this.field_145850_b.func_180501_a(newPos, invBlockState, 3);
                        continue;
                    }
                    if (!force && this.field_145850_b.func_180495_p(newPos).func_177230_c() != JSGBlocks.INVISIBLE_BLOCK) continue;
                    this.field_145850_b.func_175698_g(newPos);
                }
            }
        }
    }

    public void setLinkedController(BlockPos pos, int linkId) {
        this.linkedController = pos;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public boolean isLinked() {
        return this.linkedController != null && this.field_145850_b.func_175625_s(this.linkedController) instanceof TRControllerAbstractTile;
    }

    public TRControllerAbstractTile getLinkedControllerTile(World world) {
        return this.linkedController != null ? (TRControllerAbstractTile)world.func_175625_s(this.linkedController) : null;
    }

    public SymbolTypeTransportRingsEnum getSymbolType() {
        if (this.getLinkedControllerTile(this.field_145850_b) != null) {
            return this.getLinkedControllerTile(this.field_145850_b).getSymbolType();
        }
        return this.getSymbolTypeByThis();
    }

    protected abstract SymbolTypeTransportRingsEnum getSymbolTypeByThis();

    @Override
    public boolean canLinkTo() {
        return !this.isLinked();
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }

    public TransportRings getRings() {
        if (this.rings == null) {
            this.rings = new TransportRings(this.generateAndPostAddress(true), this.field_174879_c);
        }
        return this.rings;
    }

    public TransportRings getClonedRings(BlockPos callerPos) {
        return this.getRings().cloneWithNewDistance(callerPos);
    }

    public void addRings(TransportRingsAbstractTile caller) {
        TransportRings clonedRings = caller.getClonedRings(this.field_174879_c);
        if (clonedRings.isInGrid()) {
            this.ringsMap.put(clonedRings.getAddresses(), clonedRings);
            this.func_70296_d();
        }
    }

    public void removeRingsFromMap(Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addressMap) {
        if (this.ringsMap.remove(addressMap) != null) {
            this.func_70296_d();
        }
    }

    public void removeRings(Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addressMap) {
        TileEntity tile;
        TransportRings rings = this.ringsMap.get(addressMap);
        if (rings != null && (tile = this.field_145850_b.func_175625_s(rings.getPos())) instanceof TransportRingsAbstractTile) {
            ((TransportRingsAbstractTile)tile).removeRingsFromMap(this.getRings().getAddresses());
        }
        this.removeRingsFromMap(addressMap);
    }

    public void removeAllRings() {
        for (Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addressMap : new ArrayList<Map<SymbolTypeTransportRingsEnum, TransportRingsAddress>>(this.ringsMap.keySet())) {
            this.removeRings(addressMap);
        }
    }

    public ParamsSetResult setRingsParams(String name, int distance) {
        this.setNewRingsDistance(distance);
        this.setRingsName(name);
        return this.setRingsParams(null, null, null, name);
    }

    public void setRingsParams(Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addressMap) {
        this.setRingsParams(null, addressMap, null, this.getRings().getName());
    }

    public void setRingsParams(TransportRingsAddress address, SymbolTypeTransportRingsEnum symbolType, String name) {
        this.setRingsName(name);
        this.setRingsParams(address, null, symbolType, name);
    }

    public ParamsSetResult setRingsParams(TransportRingsAddress address, Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addressMap, SymbolTypeTransportRingsEnum symbolType, String name) {
        int x = this.field_174879_c.func_177958_n();
        int z = this.field_174879_c.func_177952_p();
        int radius = JSGConfig.Rings.mechanics.rangeFlat;
        int y = this.field_174879_c.func_177956_o();
        int vertical = JSGConfig.Rings.mechanics.rangeVertical;
        ArrayList<TransportRingsAbstractTile> ringsTilesInRange = new ArrayList<TransportRingsAbstractTile>();
        for (BlockPos newRingsPos : BlockPos.func_177975_b((BlockPos)new BlockPos(x - radius, y - vertical, z - radius), (BlockPos)new BlockPos(x + radius, y + vertical, z + radius))) {
            TileEntity tile;
            if (!JSGBlocks.isInBlocksArray(this.field_145850_b.func_180495_p(newRingsPos).func_177230_c(), JSGBlocks.RINGS_BLOCKS) || this.field_174879_c.equals((Object)newRingsPos) || !((tile = this.field_145850_b.func_175625_s(newRingsPos)) instanceof TransportRingsAbstractTile)) continue;
            TransportRingsAbstractTile newRingsTile = (TransportRingsAbstractTile)tile;
            ringsTilesInRange.add(newRingsTile);
        }
        Map<SymbolTypeTransportRingsEnum, TransportRingsAddress> addressOld = this.getRings().getAddresses();
        this.removeAllRings();
        if (symbolType != null && addressMap == null) {
            this.getRings().setAddress(symbolType, address);
        } else if (addressMap != null) {
            this.getRings().setAddress(addressMap);
        } else {
            this.getRings().setAddress(addressOld);
        }
        this.getRings().setName(name);
        this.getRings().setRingsDistance(this.ringsDistance);
        for (TransportRingsAbstractTile newRingsTile : ringsTilesInRange) {
            this.addRings(newRingsTile);
            newRingsTile.addRings(this);
        }
        this.func_70296_d();
        return ParamsSetResult.OK;
    }

    public void setRingsName(String name) {
        this.getRings().setName(name);
        this.ringsName = name;
        this.func_70296_d();
    }

    protected void func_190201_b(@Nonnull World worldIn) {
        this.func_145834_a(worldIn);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        int j;
        compound.func_74782_a("rendererState", (NBTBase)this.rendererState.serializeNBT());
        compound.func_74782_a("ringsData", (NBTBase)this.getRings().serializeNBT());
        if (this.linkedController != null) {
            compound.func_74772_a("linkedController", this.linkedController.func_177986_g());
            compound.func_74768_a("linkId", this.linkId);
        }
        compound.func_74768_a("ringsMapLength", this.ringsMap.size());
        int i = 0;
        for (TransportRings rings : this.ringsMap.values()) {
            compound.func_74782_a("ringsMap" + i, (NBTBase)rings.serializeNBT());
            ++i;
        }
        compound.func_74782_a("scheduledTasks", (NBTBase)ScheduledTask.serializeList(this.scheduledTasks));
        compound.func_74768_a("teleportListSize", this.teleportList.size());
        for (j = 0; j < this.teleportList.size(); ++j) {
            compound.func_74768_a("teleportList" + j, this.teleportList.get(j).func_145782_y());
        }
        compound.func_74768_a("excludedSize", this.excludedEntities.size());
        for (j = 0; j < this.excludedEntities.size(); ++j) {
            compound.func_74768_a("excluded" + j, this.excludedEntities.get(j).func_145782_y());
        }
        compound.func_74772_a("targetRingsPos", this.targetRingsPos.func_177986_g());
        compound.func_74757_a("busy", this.isBusy());
        if (this.node != null) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            this.node.save(nodeCompound);
            compound.func_74782_a("node", (NBTBase)nodeCompound);
        }
        compound.func_74757_a("initiating", this.initiating);
        compound.func_74782_a("itemHandler", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74782_a("energyStorage", (NBTBase)this.energyStorage.serializeNBT());
        compound.func_74782_a("config", (NBTBase)this.config.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        try {
            int j;
            this.rendererState.deserializeNBT(compound.func_74775_l("rendererState"));
            ScheduledTask.deserializeList(compound.func_74775_l("scheduledTasks"), this.scheduledTasks, this);
            this.teleportList = new ArrayList<Entity>();
            int size = compound.func_74762_e("teleportListSize");
            for (j = 0; j < size; ++j) {
                this.teleportList.add(this.field_145850_b.func_73045_a(compound.func_74762_e("teleportList" + j)));
            }
            this.excludedEntities = new ArrayList<Entity>();
            size = compound.func_74762_e("excludedSize");
            for (j = 0; j < size; ++j) {
                this.excludedEntities.add(this.field_145850_b.func_73045_a(compound.func_74762_e("excluded" + j)));
            }
            this.targetRingsPos = BlockPos.func_177969_a((long)compound.func_74763_f("targetRingsPos"));
            if (compound.func_74764_b("ringsData")) {
                this.getRings().deserializeNBT(compound.func_74775_l("ringsData"));
            }
            if (compound.func_74764_b("linkedController")) {
                this.linkedController = BlockPos.func_177969_a((long)compound.func_74763_f("linkedController"));
                this.linkId = compound.func_74762_e("linkId");
            }
            if (compound.func_74764_b("ringsMapLength")) {
                int len = compound.func_74762_e("ringsMapLength");
                this.ringsMap.clear();
                for (int i = 0; i < len; ++i) {
                    TransportRings rings = new TransportRings(compound.func_74775_l("ringsMap" + i));
                    this.ringsMap.put(rings.getAddresses(), rings);
                }
            }
            if (this.node != null && compound.func_74764_b("node")) {
                this.node.load(compound.func_74775_l("node"));
            }
            this.setBusy(compound.func_74767_n("busy"));
            this.initiating = compound.func_74767_n("initiating");
            this.itemStackHandler.deserializeNBT(compound.func_74775_l("itemHandler"));
            this.ringsDistance = this.getRings().getRingsDistance();
            this.ringsName = this.getRings().getName();
            this.energyStorage.deserializeNBT(compound.func_74775_l("energyStorage"));
            this.config.deserializeNBT(compound.func_74775_l("config"));
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e) {
            JSG.warn("Exception at reading NBT");
            JSG.warn("If loading world used with previous version and nothing game-breaking doesn't happen, please ignore it");
            e.printStackTrace();
        }
        super.func_145839_a(compound);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: {
                return this.rendererState;
            }
            case GUI_STATE: {
                return new TRGuiState(this.getRings().getAddresses(), this.getConfig());
            }
            case GUI_UPDATE: {
                return new TRGuiUpdate(this.energyStorage.getEnergyStoredInternally(), this.energyTransferedLastTick, this.ringsName, this.ringsDistance);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: {
                return new TransportRingsRendererState();
            }
            case START_ANIMATION: 
            case RINGS_DISTANCE_UPDATE: {
                return new TransportRingsStartAnimationRequest();
            }
            case GUI_STATE: {
                return new TRGuiState();
            }
            case GUI_UPDATE: {
                return new TRGuiUpdate();
            }
        }
        return null;
    }

    public BlockPos getPosWithDistance(int distance) {
        return distance > 0 ? this.field_174879_c.func_177981_b(distance + 2) : this.field_174879_c.func_177979_c(distance * -1 - (distance < -2 ? 2 : 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_STATE: {
                this.rendererState = (TransportRingsRendererState)state;
                break;
            }
            case START_ANIMATION: {
                int distance = ((TransportRingsStartAnimationRequest)state).ringsDistance;
                long animationStart = ((TransportRingsStartAnimationRequest)state).animationStart;
                JSGSoundHelper.playSoundEventClientSide(this.field_145850_b, this.getPosWithDistance(distance), SoundEventEnum.RINGS_TRANSPORT);
                this.rendererState.ringsDistance = distance;
                this.rendererState.animationStart = animationStart;
                this.rendererState.isAnimationActive = true;
                this.rendererState.ringsUprising = true;
                break;
            }
            case RINGS_DISTANCE_UPDATE: {
                TransportRingsStartAnimationRequest s = (TransportRingsStartAnimationRequest)state;
                this.rendererState.ringsDistance = s.ringsDistance;
                this.rendererState.ringsConfig = s.ringsConfig;
                break;
            }
            case GUI_STATE: {
                TRGuiState guiState = (TRGuiState)state;
                this.setRingsParams(guiState.trAdddressMap);
                this.config = guiState.config;
                break;
            }
            case GUI_UPDATE: {
                TRGuiUpdate guiUpdate = (TRGuiUpdate)state;
                this.energyStorage.setEnergyStoredInternally(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.transferedLastTick;
                if (this.getRings().getName().equals(guiUpdate.ringsName) && this.getRings().getRingsDistance() == guiUpdate.distance) break;
                this.setRingsParams(guiUpdate.ringsName, guiUpdate.distance);
                break;
            }
        }
    }

    @Override
    public JSGTileEntityConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(JSGTileEntityConfig config) {
        for (JSGConfigOption o : config.getOptions()) {
            this.config.getOption(o.id).setValue(o.getStringValue());
        }
        this.func_70296_d();
    }

    @Override
    public void initConfig() {
        JSGConfigOption o = this.getConfig().getOption(ConfigOptions.CAPACITORS_COUNT.id, true);
        int caps = o == null ? this.getDefaultCapacitors() : o.getIntValue();
        JSGTileEntityConfig.initConfig(this.getConfig(), ConfigOptions.values());
        this.getConfig().getOption(ConfigOptions.CAPACITORS_COUNT.id).setDefaultValue(this.getDefaultCapacitors() + "").setValue(caps + "");
        this.func_70296_d();
        JSGTileEntityConfig.initConfig(this.getConfig(), ConfigOptions.values());
    }

    public abstract TRControllerAbstractBlock getControllerBlock();

    public void updateLinkStatus() {
        TRControllerAbstractTile controllerTile;
        int linkId;
        BlockPos closestController = LinkingHelper.findClosestUnlinked(this.field_145850_b, this.field_174879_c, new BlockPos(10, 5, 10), this.getControllerBlock(), this.linkId);
        int n = linkId = closestController == null ? -1 : LinkingHelper.getLinkId();
        if (closestController != null && (controllerTile = (TRControllerAbstractTile)this.field_145850_b.func_175625_s(closestController)) != null) {
            controllerTile.setLinkedRings(this.field_174879_c, linkId);
        }
        this.setLinkedController(closestController, linkId);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new JSGAxisAlignedBB(this.field_174879_c.func_177971_a((Vec3i)new BlockPos(-5, -30, -5)), this.field_174879_c.func_177971_a((Vec3i)new BlockPos(5, 30, 5)));
    }

    public boolean shouldRenderInPass(int flag) {
        return true;
    }

    public void onChunkUnload() {
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        if (this.node != null) {
            this.node.remove();
        }
        super.func_145843_s();
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    public void sendSignal(Object context, String name, Object ... params) {
        JSG.ocWrapper.sendSignalToReachable(this.node, (Context)context, name, params);
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getJSGVersion(Context context, Arguments args) {
        return new Object[]{"1.12.2-4.11.0.8"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getAddress(Context context, Arguments args) {
        HashMap<SymbolTypeTransportRingsEnum, List<String>> map = new HashMap<SymbolTypeTransportRingsEnum, List<String>>();
        for (SymbolTypeTransportRingsEnum symbolType : SymbolTypeTransportRingsEnum.values()) {
            map.put(symbolType, this.getRings().getAddressNameList(symbolType));
        }
        return new Object[]{map};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getAvailableRingsAddresses(Context context, Arguments args) {
        return new Object[]{this.ringsMap.keySet()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] isInGrid(Context context, Arguments args) {
        return new Object[]{this.getRings().isInGrid()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getName(Context context, Arguments args) {
        return new Object[]{this.getRings().getName()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] setName(Context context, Arguments args) {
        String name = args.checkString(0);
        this.setRingsName(name);
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getAvailableRings(Context context, Arguments args) {
        HashMap<String, String> values = new HashMap<String, String>(this.ringsMap.size());
        for (TransportRings rings : this.ringsMap.values()) {
            for (SymbolTypeTransportRingsEnum symbolType : SymbolTypeTransportRingsEnum.values()) {
                values.put(rings.getAddress(symbolType).toString(), rings.getName());
            }
        }
        return new Object[]{values};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] addSymbolToAddress(Context context, Arguments args) {
        String symbolName = "";
        int symbolId = -1;
        if (!args.isInteger(1)) {
            symbolName = args.checkString(1);
        } else {
            symbolId = args.checkInteger(1);
        }
        int symbolType = args.checkInteger(0);
        int maxSymbolType = SymbolTypeTransportRingsEnum.values().length;
        if (symbolType < 0 || symbolType >= maxSymbolType) {
            throw new IllegalArgumentException("bad argument #1 (symbolType must be in a range (0 - " + maxSymbolType + "))");
        }
        SymbolTypeTransportRingsEnum symbolTypeConverted = SymbolTypeTransportRingsEnum.valueOf(symbolType);
        int maxSymbols = symbolTypeConverted.getSymbolsCount();
        if (symbolName.equals("") && (symbolId < 0 || symbolId >= maxSymbols)) {
            throw new IllegalArgumentException("bad argument #2 (address out of range, must be higher than -1 and lower than " + maxSymbols + ")");
        }
        this.ocContext = context;
        if (symbolName.equals("")) {
            return new Object[]{this.addSymbolToAddressInternal(symbolTypeConverted.getSymbol(symbolId), true)};
        }
        return new Object[]{this.addSymbolToAddressInternal(symbolTypeConverted.fromEnglishName(symbolName), true)};
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getEnergyStorage());
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getEnergyTransferedLastTick() {
        return this.energyTransferedLastTick;
    }

    public int getSupportedCapacitors() {
        return Math.min(this.getConfig().getOption(ConfigOptions.CAPACITORS_COUNT.id).getIntValue() + (this.hasUpgrade(TransportRingsUpgradeEnum.CAPACITY_UPGRADE) ? 1 : 0), 3);
    }

    public abstract int getDefaultCapacitors();

    protected StargateClassicEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getPowerTier() {
        return this.currentPowerTier;
    }

    private void updatePowerTier() {
        int i;
        int powerTier = 1;
        for (i = 4; i < 7; ++i) {
            if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
            ++powerTier;
        }
        if (powerTier != this.currentPowerTier) {
            this.currentPowerTier = powerTier;
            this.energyStorage.clearStorages();
            for (i = 4; i < 7; ++i) {
                ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                this.energyStorage.addStorage((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null));
            }
            JSG.debug("Updated to power tier: " + powerTier);
        }
    }

    @Override
    public boolean prepare(ICommandSender sender, ICommand command) {
        if (this.isBusy()) {
            CommandBase.func_152373_a((ICommandSender)sender, (ICommand)command, (String)"Stop any rings activity before preparation.", (Object[])new Object[0]);
            return false;
        }
        this.dialedAddress.clear();
        this.scheduledTasks.clear();
        this.getRings().getAddresses().clear();
        return true;
    }

    public static enum TransportRingsUpgradeEnum implements EnumKeyInterface<Item>
    {
        GOAULD_UPGRADE(JSGItems.CRYSTAL_GLYPH_GOAULD, 0),
        ORI_UPGRADE(JSGItems.CRYSTAL_GLYPH_ORI, 1),
        ANCIENT_UPGRADE(JSGItems.CRYSTAL_GLYPH_ANCIENT, 2),
        CAPACITY_UPGRADE(JSGItems.CRYSTAL_UPGRADE_CAPACITY, 3);

        private static final EnumKeyMap<Item, TransportRingsUpgradeEnum> idMap;
        public final Item item;
        public final int slotId;

        private TransportRingsUpgradeEnum(Item item, int slotId) {
            this.item = item;
            this.slotId = slotId;
        }

        public static TransportRingsUpgradeEnum valueOf(Item item) {
            return idMap.valueOf(item);
        }

        public static boolean contains(Item item) {
            return idMap.contains(item);
        }

        @Override
        public Item getKey() {
            return this.item;
        }

        static {
            idMap = new EnumKeyMap((EnumKeyInterface[])TransportRingsUpgradeEnum.values());
        }
    }

    public static enum ConfigOptions implements ITileConfigEntry
    {
        RENDER_PLATFORM_MOVING(0, "platformMoving", JSGConfigOptionTypeEnum.BOOLEAN, "true", "Render platform moving part"),
        RENDER_PLATFORM_BASE(1, "platformBase", JSGConfigOptionTypeEnum.BOOLEAN, "true", "Render platform base part"),
        ENABLE_OC_PRESS_SOUND(2, "ocPressSound", JSGConfigOptionTypeEnum.BOOLEAN, "false", "Play press sound when dialing with OC"),
        CAPACITORS_COUNT(3, "maxCapacitors", JSGConfigOptionTypeEnum.NUMBER, "2", 0, 3, "Specifies how many", "capacitors can be installed", "into rings"),
        ENABLE_NONACTIVE_RENDER(4, "nonactiveRender", JSGConfigOptionTypeEnum.BOOLEAN, "false", "Render ring under ground if rings are not active");

        public final int id;
        public final String label;
        public final String[] comment;
        public final JSGConfigOptionTypeEnum type;
        public final String defaultValue;
        public List<JSGConfigEnumEntry> possibleValues;
        public final int minInt;
        public final int maxInt;

        private ConfigOptions(int optionId, String label, JSGConfigOptionTypeEnum type, String defaultValue, String ... comment) {
            this(optionId, label, type, defaultValue, -1, -1, comment);
        }

        private ConfigOptions(int optionId, String label, JSGConfigOptionTypeEnum type, String defaultValue, int minInt, int maxInt, String ... comment) {
            this.id = optionId;
            this.label = label;
            this.type = type;
            this.defaultValue = defaultValue;
            this.minInt = minInt;
            this.maxInt = maxInt;
            this.comment = comment;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String[] getComment() {
            return this.comment;
        }

        @Override
        public JSGConfigOptionTypeEnum getType() {
            return this.type;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public List<JSGConfigEnumEntry> getPossibleValues() {
            return this.possibleValues;
        }

        @Override
        public int getMin() {
            return this.minInt;
        }

        @Override
        public int getMax() {
            return this.maxInt;
        }
    }
}

