/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.stargate;

import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.stargate.StargateDimensionConfig;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.power.stargate.StargateEnergyRequired;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.stargate.StargateClassicRendererState;
import tauri.dev.jsg.renderer.stargate.StargateUniverseRendererState;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.SoundPositionedEnum;
import tauri.dev.jsg.sound.StargateSoundEventEnum;
import tauri.dev.jsg.sound.StargateSoundPositionedEnum;
import tauri.dev.jsg.stargate.EnumIrisMode;
import tauri.dev.jsg.stargate.EnumScheduledTask;
import tauri.dev.jsg.stargate.EnumSpinDirection;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.stargate.NearbyGate;
import tauri.dev.jsg.stargate.StargateOpenResult;
import tauri.dev.jsg.stargate.merging.StargateAbstractMergeHelper;
import tauri.dev.jsg.stargate.merging.StargateUniverseMergeHelper;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.StargateAddressDynamic;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.stargate.network.SymbolUniverseEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.stargate.StargateRendererActionState;
import tauri.dev.jsg.state.stargate.StargateSpinState;
import tauri.dev.jsg.state.stargate.StargateUniverseSymbolState;
import tauri.dev.jsg.tileentity.props.DestinyCountDownTile;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.tileentity.util.ScheduledTask;
import tauri.dev.jsg.util.ILinkable;
import tauri.dev.jsg.util.LinkingHelper;

public class StargateUniverseBaseTile
extends StargateClassicBaseTile
implements ILinkable {
    protected World fakeWorld;
    protected BlockPos fakePos;
    private static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED);
    private StargateAddress addressToDial;
    private int symbolsToDialCount;
    private int addressPosition;
    private boolean abortingDialing = false;
    private static final int fastDialingPeriod = 30;
    private int coolDown = 0;
    private static final int COOL_DOWN_DELAY = 60;
    private BlockPos lastPos = BlockPos.field_177992_a;
    private BlockPos countDownPos;
    private int linkId = -1;

    @Override
    public World getFakeWorld() {
        if (this.fakeWorld == null) {
            return this.field_145850_b;
        }
        return this.fakeWorld;
    }

    @Override
    public void setFakeWorld(World world) {
        this.fakeWorld = world;
        this.func_70296_d();
    }

    @Override
    public BlockPos getFakePos() {
        if (this.fakePos == null) {
            return this.field_174879_c;
        }
        return this.fakePos;
    }

    @Override
    public void setFakePos(BlockPos pos) {
        this.fakePos = pos;
        this.func_70296_d();
    }

    public boolean canContinue() {
        return this.coolDown <= 0;
    }

    public void updateCoolDown() {
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        if (this.coolDown < 0) {
            this.coolDown = 0;
        }
        this.func_70296_d();
    }

    public void setCoolDown() {
        this.coolDown = 60;
        this.func_70296_d();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateCoolDown();
        if (!this.field_145850_b.field_72995_K && !this.lastPos.equals((Object)this.field_174879_c)) {
            this.lastPos = this.field_174879_c;
            this.func_70296_d();
        }
    }

    @Override
    protected void onGateMerged() {
        super.onGateMerged();
        this.updateLinkStatus();
    }

    public StargateAddress getAddressToDial() {
        return this.addressToDial;
    }

    @Override
    public void addSymbolToAddressDHD(SymbolInterface symbol) {
    }

    public boolean dialAddress(StargateAddress address, int symbolCount) {
        if (!this.canContinue()) {
            return false;
        }
        if (!this.stargateState.idle()) {
            return false;
        }
        this.addressToDial = address;
        this.symbolsToDialCount = symbolCount;
        this.addressPosition = -1;
        this.targetRingSymbol = SymbolUniverseEnum.G1;
        this.stargateState = EnumStargateState.DIALING;
        JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.GATE_UNIVERSE_DIAL_START);
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 35, null));
        this.ringSpinContext = null;
        this.spinDirection = EnumSpinDirection.CLOCKWISE;
        this.setCoolDown();
        this.func_70296_d();
        return true;
    }

    public SymbolInterface getNextSymbol(boolean addOne) {
        ++this.addressPosition;
        int pos = this.addressPosition--;
        if (!addOne) {
            // empty if block
        }
        this.func_70296_d();
        if (this.addressToDial == null) {
            return null;
        }
        if (pos >= this.addressToDial.getSize() + 1) {
            return this.getSymbolType().getTopSymbol();
        }
        if (pos >= this.symbolsToDialCount && addOne) {
            return this.getSymbolType().getOrigin();
        }
        if (pos >= this.symbolsToDialCount) {
            return null;
        }
        return this.addressToDial.get(pos);
    }

    @Override
    public boolean abortDialingSequence() {
        if (this.stargateState.incoming()) {
            return false;
        }
        if (this.isIncoming) {
            return false;
        }
        if (this.canContinue() && (this.stargateState.dialingComputer() || this.stargateState.idle() || this.stargateState.dialing())) {
            this.abortingDialing = true;
            this.currentRingSymbol = this.targetRingSymbol;
            this.func_70296_d();
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_RESET, 60, null));
            this.spinStartTime = -1L;
            this.isSpinning = false;
            this.sendState(StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, true, 0));
            this.addFailedTaskAndPlaySound();
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
            if (this.lastSpinFinished != null && this.scheduledTasks.contains(this.lastSpinFinished)) {
                this.removeTask(this.lastSpinFinished);
            }
            if (!this.isIncoming) {
                this.disconnectGate();
            }
            this.stargateState = EnumStargateState.FAILING;
            this.setCoolDown();
            this.func_70296_d();
            this.resetTargetIncomingAnimation();
            return true;
        }
        return false;
    }

    @Override
    public void failGate() {
        if (this.stargateState.incoming()) {
            return;
        }
        this.isIncoming = false;
        this.func_70296_d();
        if (this.abortingDialing) {
            this.isFinalActive = false;
            this.func_70296_d();
            return;
        }
        super.failGate();
        this.addressToDial = null;
        if (!this.abortingDialing && this.targetRingSymbol != SymbolUniverseEnum.TOP_CHEVRON) {
            this.addSymbolToAddressManual(SymbolUniverseEnum.TOP_CHEVRON, null);
        }
    }

    @Override
    public void dialingFailed(StargateOpenResult reason) {
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        super.dialingFailed(reason);
    }

    @Override
    protected void disconnectGate() {
        this.isIncoming = false;
        this.func_70296_d();
        super.disconnectGate();
        this.addressToDial = null;
        if (!this.abortingDialing) {
            this.addSymbolToAddressManual(SymbolUniverseEnum.TOP_CHEVRON, null);
        }
    }

    @Override
    public void addSymbolToAddressManual(SymbolInterface targetSymbol, Object context) {
        if (this.stargateState.incoming()) {
            return;
        }
        if (targetSymbol != this.getSymbolType().getTopSymbol()) {
            this.stargateState = context != null ? EnumStargateState.DIALING_COMPUTER : EnumStargateState.DIALING;
        }
        if (this.dialedAddress.size() == 0 && targetSymbol != SymbolUniverseEnum.TOP_CHEVRON && this.stargateState.dialingComputer()) {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.GATE_UNIVERSE_DIAL_START);
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
            this.targetRingSymbol = targetSymbol;
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 35, null));
            this.ringSpinContext = context;
            this.spinDirection = EnumSpinDirection.CLOCKWISE;
        } else {
            super.addSymbolToAddressManual(targetSymbol, context);
        }
        if (targetSymbol == this.getSymbolType().getTopSymbol()) {
            this.stargateState = EnumStargateState.FAILING;
        }
        this.func_70296_d();
    }

    @Override
    protected StargateEnergyRequired getEnergyRequiredToDial(StargatePos targetGatePos) {
        BlockPos sPos = this.getFakePos();
        BlockPos tPos = targetGatePos.gatePos;
        DimensionType sourceDim = this.getFakeWorld().field_73011_w.func_186058_p();
        DimensionType targetDim = targetGatePos.getWorld().field_73011_w.func_186058_p();
        StargateAbstractBaseTile targetTile = targetGatePos.getTileEntity();
        if (targetTile instanceof StargateUniverseBaseTile) {
            tPos = ((StargateUniverseBaseTile)targetTile).getFakePos();
            targetDim = ((StargateUniverseBaseTile)targetTile).getFakeWorld().field_73011_w.func_186058_p();
        }
        if (sourceDim == DimensionType.OVERWORLD && targetDim == DimensionType.NETHER) {
            tPos = new BlockPos(tPos.func_177958_n() * 8, tPos.func_177956_o(), tPos.func_177952_p() * 8);
        } else if (sourceDim == DimensionType.NETHER && targetDim == DimensionType.OVERWORLD) {
            sPos = new BlockPos(sPos.func_177958_n() * 8, sPos.func_177956_o(), sPos.func_177952_p() * 8);
        }
        double distance = (int)sPos.func_185332_f(tPos.func_177958_n(), tPos.func_177956_o(), tPos.func_177952_p());
        distance = distance < 5000.0 ? (distance *= 0.8) : 5000.0 * Math.log10(distance) / Math.log10(5000.0);
        StargateEnergyRequired energyRequired = new StargateEnergyRequired(JSGConfig.Stargate.power.openingBlockToEnergyRatio, JSGConfig.Stargate.power.keepAliveBlockToEnergyRatioPerTick);
        energyRequired = energyRequired.mul(distance).add(StargateDimensionConfig.getCost(sourceDim, targetDim));
        if (this.dialedAddress.size() == 9) {
            energyRequired.mul(JSGConfig.Stargate.power.nineSymbolAddressMul);
        }
        if (this.dialedAddress.size() == 8) {
            energyRequired.mul(JSGConfig.Stargate.power.eightSymbolAddressMul);
        }
        return energyRequired.mul(JSGConfig.Stargate.power.stargateUniverseEnergyMul);
    }

    @Override
    public SymbolTypeEnum getSymbolType() {
        return SymbolTypeEnum.UNIVERSE;
    }

    @Override
    protected int getMaxChevrons() {
        return 9;
    }

    @Override
    protected int getOpenSoundDelay() {
        return super.getOpenSoundDelay() + 10;
    }

    private void activateSymbolServer(SymbolInterface symbol) {
        if (!(symbol instanceof SymbolUniverseEnum)) {
            JSG.error("Error while engaging symbol " + symbol.getEnglishName() + " for clients.", new ClassCastException());
            return;
        }
        JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.STARGATE_UNIVERSE_ACTIVATE_SYMBOL, new StargateUniverseSymbolState((SymbolUniverseEnum)symbol, false)), this.targetPoint);
    }

    @Override
    protected void addSymbolToAddress(SymbolInterface symbol) {
        this.activateSymbolServer(symbol);
        super.addSymbolToAddress(symbol);
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        boolean onlySpin = false;
        if (customData != null && customData.func_74764_b("onlySpin")) {
            onlySpin = customData.func_74767_n("onlySpin");
        }
        switch (scheduledTask) {
            case LIGHT_UP_CHEVRONS: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
                break;
            }
            case STARGATE_DIAL_NEXT: {
                if (this.stargateState.incoming() || this.abortingDialing || this.stargateState.failing()) break;
                if (this.isFastDialing && this.stargateState.dialingDHD()) {
                    SymbolInterface tempSymbol;
                    if (this.dialedAddress.size() == 0) {
                        this.spinRing(1, false, true, 30 * this.symbolsToDialCount + 100);
                    }
                    if (!this.canAddSymbol(tempSymbol = this.getNextSymbol(true)) || tempSymbol == SymbolUniverseEnum.TOP_CHEVRON) break;
                    this.addSymbolToAddress(tempSymbol);
                    this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                    this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), this.targetRingSymbol.getEnglishName());
                    this.doIncomingAnimation(60, true, this.getNextSymbol(false));
                    if (this.stargateWillLock(tempSymbol)) break;
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 30));
                    break;
                }
                if (this.stargateState.dialingComputer() && this.targetRingSymbol != this.getSymbolType().getTopSymbol()) {
                    super.addSymbolToAddressManual(this.targetRingSymbol, this.ringSpinContext);
                    break;
                }
                if (this.targetRingSymbol == this.getSymbolType().getTopSymbol()) break;
                this.targetRingSymbol = this.getNextSymbol(true);
                this.func_70296_d();
                if (this.targetRingSymbol == SymbolUniverseEnum.TOP_CHEVRON) {
                    this.abortDialingSequence();
                    break;
                }
                this.addSymbolToAddressManual(this.targetRingSymbol, null);
                break;
            }
            case STARGATE_RESET: {
                if (this.stargateState.incoming()) break;
                this.addSymbolToAddressManual(this.getSymbolType().getTopSymbol(), null);
                this.abortingDialing = false;
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                if (onlySpin && this.stargateState.dialingComputer()) {
                    this.stargateState = EnumStargateState.IDLE;
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 9, true);
                    this.func_70296_d();
                    break;
                }
                if (onlySpin && this.stargateState.dialing() && this.isFastDialing) {
                    this.attemptOpenAndFail();
                    break;
                }
                if (onlySpin || this.stargateState.incoming()) break;
                if (this.targetRingSymbol != SymbolUniverseEnum.TOP_CHEVRON) {
                    this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_FINISHED, 10));
                } else {
                    this.dialingFailed(StargateOpenResult.ABORTED);
                    this.stargateState = EnumStargateState.IDLE;
                    this.abortingDialing = false;
                }
                this.func_70296_d();
                break;
            }
            case BEGIN_SPIN: {
                if (customData == null || !customData.func_74764_b("period")) break;
                int period = customData.func_74762_e("period");
                this.spinRing(1, false, true, period);
                break;
            }
            case STARGATE_FAILED_SOUND: {
                this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
                this.func_70296_d();
                break;
            }
            case STARGATE_DIAL_FINISHED: {
                if (this.abortingDialing) {
                    return;
                }
                if (this.canAddSymbol(this.targetRingSymbol)) {
                    this.addSymbolToAddress(this.targetRingSymbol);
                    if (this.stargateState.dialingComputer()) {
                        if (!this.abortingDialing) {
                            this.stargateState = EnumStargateState.IDLE;
                        }
                    } else if (!this.stargateWillLock(this.targetRingSymbol)) {
                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 24));
                    } else {
                        this.attemptOpenAndFail();
                    }
                } else if (!this.stargateState.incoming()) {
                    this.dialingFailed(StargateOpenResult.ADDRESS_MALFORMED);
                    this.stargateState = EnumStargateState.IDLE;
                }
                this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), this.targetRingSymbol.getEnglishName());
                break;
            }
        }
        this.func_70296_d();
        super.executeTask(scheduledTask, customData);
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.STARGATE_UNIVERSE_ACTIVATE_SYMBOL) {
            return new StargateUniverseSymbolState();
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        if (this.getRendererStateClient() != null) {
            switch (stateType) {
                case STARGATE_UNIVERSE_ACTIVATE_SYMBOL: {
                    StargateUniverseSymbolState symbolState = (StargateUniverseSymbolState)state;
                    if (symbolState.dimAll) {
                        this.getRendererStateClient().clearSymbols(this.field_145850_b.func_82737_E());
                        break;
                    }
                    this.getRendererStateClient().activateSymbol(this.field_145850_b.func_82737_E(), symbolState.symbol);
                    break;
                }
                case RENDERER_UPDATE: {
                    StargateRendererActionState gateActionState = (StargateRendererActionState)state;
                    if (gateActionState.action != StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS) break;
                    this.getRendererStateClient().clearSymbols(this.field_145850_b.func_82737_E());
                    break;
                }
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        this.startIncomingAnimation(dialedAddressSize, 10);
        super.incomingWormhole(9);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize, int time) {
        int period = (time *= dialedAddressSize) - 2000;
        if (period < 0) {
            period = 0;
        }
        this.startIncomingAnimation(dialedAddressSize, period);
        super.incomingWormhole(9, false);
    }

    @Override
    public void startIncomingAnimation(int addressSize, int period) {
        double ticks = (double)(period * 20) / 1000.0;
        this.incomingPeriod = (int)Math.round(ticks);
        this.incomingAddressSize = addressSize;
        this.incomingLastChevronLightUp = 0;
        this.stargateState = EnumStargateState.INCOMING;
        this.isIncoming = true;
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 9, true);
        if (this.stargateState.dialing()) {
            this.abortDialingSequence();
        }
        this.func_70296_d();
        this.lightUpChevronByIncoming(!this.config.getOption(StargateClassicBaseTile.ConfigOptions.ALLOW_INCOMING.id).getBooleanValue());
    }

    @Override
    protected void lightUpChevronByIncoming(boolean disableAnimation) {
        super.lightUpChevronByIncoming(disableAnimation);
        if (this.incomingPeriod == -1) {
            return;
        }
        boolean spin = this.config.getOption(StargateClassicBaseTile.ConfigOptions.SPIN_GATE_INCOMING.id).getBooleanValue();
        if (!disableAnimation && this.incomingLastChevronLightUp == 1) {
            this.stargateState = EnumStargateState.INCOMING;
            NBTTagCompound compound = new NBTTagCompound();
            int time = this.incomingPeriod - 15;
            compound.func_74768_a("period", time);
            if (spin) {
                this.addTask(new ScheduledTask(EnumScheduledTask.BEGIN_SPIN, 15, compound));
            }
            this.addTask(new ScheduledTask(EnumScheduledTask.LIGHT_UP_CHEVRONS, 8));
            this.sendSignal(null, "stargate_incoming_wormhole", this.incomingAddressSize);
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            super.resetIncomingAnimation();
            this.isIncoming = false;
            if (this.irisMode == EnumIrisMode.AUTO && this.isIrisOpened()) {
                this.toggleIris();
            }
        } else if (this.incomingLastChevronLightUp == 2 && disableAnimation) {
            this.stargateState = EnumStargateState.INCOMING;
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
            this.sendSignal(null, "stargate_incoming_wormhole", this.incomingAddressSize);
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            super.resetIncomingAnimation();
            this.isIncoming = false;
            if (this.irisMode == EnumIrisMode.AUTO && this.isIrisOpened()) {
                this.toggleIris();
            }
        } else if (this.isIncoming && !this.stargateState.engaged()) {
            this.stargateState = EnumStargateState.INCOMING;
        }
        this.func_70296_d();
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    @Nullable
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        switch (soundEnum) {
            case GATE_RING_ROLL: {
                return SoundPositionedEnum.UNIVERSE_RING_ROLL;
            }
            case GATE_RING_ROLL_START: {
                return SoundPositionedEnum.UNIVERSE_RING_ROLL_START;
            }
        }
        return null;
    }

    @Override
    @Nullable
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        switch (soundEnum) {
            case OPEN: {
                return SoundEventEnum.GATE_UNIVERSE_OPEN;
            }
            case CLOSE: {
                return SoundEventEnum.GATE_UNIVERSE_CLOSE;
            }
            case DIAL_FAILED: {
                return SoundEventEnum.GATE_UNIVERSE_DIAL_FAILED;
            }
            case INCOMING: {
                return SoundEventEnum.GATE_UNIVERSE_DIAL_START;
            }
            case CHEVRON_SHUT: {
                return this.targetRingSymbol == SymbolUniverseEnum.TOP_CHEVRON ? SoundEventEnum.GATE_UNIVERSE_CHEVRON_TOP_LOCK : SoundEventEnum.GATE_UNIVERSE_CHEVRON_LOCK;
            }
        }
        return null;
    }

    @Override
    public StargateAbstractMergeHelper getMergeHelper() {
        return StargateUniverseMergeHelper.INSTANCE;
    }

    @Override
    protected boolean onGateMergeRequested() {
        if (this.stargateSize != JSGConfig.Stargate.stargateSize) {
            StargateUniverseMergeHelper.INSTANCE.convertToPattern(this.field_145850_b, this.field_174879_c, this.facing, this.facingVertical, this.stargateSize, JSGConfig.Stargate.stargateSize);
            this.stargateSize = JSGConfig.Stargate.stargateSize;
        }
        return StargateUniverseMergeHelper.INSTANCE.checkBlocks((IBlockAccess)this.field_145850_b, this.field_174879_c, this.facing, this.facingVertical);
    }

    @Override
    public void setLinkedDHD(BlockPos dhdPos, int linkId) {
    }

    @Override
    protected StargateClassicRendererState.StargateClassicRendererStateBuilder getRendererStateServer() {
        return new StargateUniverseRendererState.StargateUniverseRendererStateBuilder(super.getRendererStateServer()).setDialedAddress(this.stargateState.initiating() || this.stargateState.dialing() ? this.dialedAddress : new StargateAddressDynamic(this.getSymbolType())).setActiveChevrons(this.stargateState.idle() ? 0 : 9).setStargateSize(this.stargateSize);
    }

    @Override
    protected StargateUniverseRendererState createRendererStateClient() {
        return new StargateUniverseRendererState();
    }

    @Override
    public StargateUniverseRendererState getRendererStateClient() {
        return (StargateUniverseRendererState)super.getRendererStateClient();
    }

    @Override
    public int getDefaultCapacitors() {
        return JSGConfig.Stargate.power.universeCapacitors;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.addressToDial != null) {
            compound.func_74782_a("addressToDial", (NBTBase)this.addressToDial.serializeNBT());
        }
        compound.func_74768_a("symbolsToDialCount", this.symbolsToDialCount);
        compound.func_74768_a("addressPosition", this.addressPosition);
        compound.func_74768_a("coolDown", this.coolDown);
        compound.func_74757_a("abortingDialing", this.abortingDialing);
        if (this.isLinked()) {
            compound.func_74772_a("countDownPos", this.countDownPos.func_177986_g());
            compound.func_74768_a("linkId", this.linkId);
        }
        if (this.fakePos != null) {
            compound.func_74768_a("fakeX", this.fakePos.func_177958_n());
            compound.func_74768_a("fakeY", this.fakePos.func_177956_o());
            compound.func_74768_a("fakeZ", this.fakePos.func_177956_o());
        }
        if (this.fakeWorld != null) {
            compound.func_74768_a("fakeWorld", this.fakeWorld.field_73011_w.getDimension());
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.addressToDial = new StargateAddress(compound.func_74775_l("addressToDial"));
        this.addressPosition = compound.func_74762_e("addressPosition");
        this.symbolsToDialCount = compound.func_74762_e("symbolsToDialCount");
        this.coolDown = compound.func_74762_e("coolDown");
        this.abortingDialing = compound.func_74767_n("abortingDialing");
        if (compound.func_74764_b("countDownPos")) {
            this.countDownPos = BlockPos.func_177969_a((long)compound.func_74763_f("countDownPos"));
        }
        if (compound.func_74764_b("linkId")) {
            this.linkId = compound.func_74762_e("linkId");
        }
        if (compound.func_74764_b("fakeX")) {
            this.fakePos = new BlockPos(compound.func_74762_e("fakeX"), compound.func_74762_e("fakeY"), compound.func_74762_e("fakeZ"));
        }
        if (compound.func_74764_b("fakeWorld") && this.field_145850_b.func_73046_m() != null) {
            this.fakeWorld = this.field_145850_b.func_73046_m().func_71218_a(compound.func_74762_e("fakeWorld"));
        }
    }

    @Override
    public boolean canLinkTo() {
        return this.isMerged() && !this.isLinked();
    }

    public boolean isLinked() {
        return this.countDownPos != null && this.field_145850_b.func_175625_s(this.countDownPos) instanceof DestinyCountDownTile;
    }

    public void setLinkedCountdown(BlockPos dhdPos, int linkId) {
        this.countDownPos = dhdPos;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public void updateLinkStatus() {
        DestinyCountDownTile destinyCountDownTile;
        if (!this.isMerged()) {
            return;
        }
        BlockPos closestUnlinked = LinkingHelper.findClosestUnlinked(this.field_145850_b, this.field_174879_c, LinkingHelper.getDhdRange(), JSGBlocks.DESTINY_COUNTDOWN_BLOCK, this.getLinkId());
        int linkId = LinkingHelper.getLinkId();
        if (closestUnlinked != null && (destinyCountDownTile = (DestinyCountDownTile)this.field_145850_b.func_175625_s(closestUnlinked)) != null) {
            destinyCountDownTile.setLinkedGate(this.field_174879_c, linkId);
            this.setLinkedCountdown(closestUnlinked, linkId);
            this.func_70296_d();
        }
    }

    public NearbyGate getRandomNearbyGate() {
        ArrayList<NearbyGate> addresses = this.getNearbyGates();
        if (addresses.size() == 0) {
            return null;
        }
        int i = (int)Math.min(Math.floor(Math.random() * (double)addresses.size()), (double)(addresses.size() - 1));
        if (i < 0) {
            i = 0;
        }
        return addresses.get(i);
    }

    @Override
    public boolean prepare(ICommandSender sender, ICommand command) {
        this.setLinkedDHD(null, -1);
        this.setLinkedCountdown(null, -1);
        return super.prepare(sender, command);
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }
}

