/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.stargate;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.gui.container.stargate.StargateContainerGuiUpdate;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.dialhomedevice.DHDAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.ChevronEnum;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargatePegasusRendererState;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.SoundPositionedEnum;
import tauri.dev.jsg.sound.StargateSoundEventEnum;
import tauri.dev.jsg.sound.StargateSoundPositionedEnum;
import tauri.dev.jsg.stargate.EnumScheduledTask;
import tauri.dev.jsg.stargate.EnumSpinDirection;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.stargate.StargateOpenResult;
import tauri.dev.jsg.stargate.StargatePegasusSpinHelper;
import tauri.dev.jsg.stargate.merging.StargateAbstractMergeHelper;
import tauri.dev.jsg.stargate.merging.StargatePegasusMergeHelper;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolPegasusEnum;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.dialhomedevice.DHDActivateButtonState;
import tauri.dev.jsg.state.stargate.StargateBiomeOverrideState;
import tauri.dev.jsg.state.stargate.StargateRendererActionState;
import tauri.dev.jsg.state.stargate.StargateSpinState;
import tauri.dev.jsg.tileentity.dialhomedevice.DHDAbstractTile;
import tauri.dev.jsg.tileentity.dialhomedevice.DHDPegasusTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.tileentity.util.ScheduledTask;
import tauri.dev.jsg.util.ILinkable;
import tauri.dev.jsg.util.LinkingHelper;

public class StargatePegasusBaseTile
extends StargateClassicBaseTile
implements ILinkable {
    private BlockPos linkedDHD = null;
    private int linkId = -1;
    private BlockPos lastPos = BlockPos.field_177992_a;
    protected List<SymbolPegasusEnum> toDialSymbols = new ArrayList<SymbolPegasusEnum>();
    protected EntityPlayer lastSender;
    protected boolean continueDialing = false;
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED, BiomeOverlayEnum.SOOTY);

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        this.resetToDialSymbols();
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
    }

    @Override
    protected void failGate() {
        super.failGate();
        this.resetToDialSymbols();
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDHD(this.field_145850_b)).clearSymbols();
        }
    }

    @Override
    protected void dialingFailed(StargateOpenResult reason) {
        this.resetToDialSymbols();
        super.dialingFailed(reason);
    }

    @Override
    protected void addFailedTaskAndPlaySound() {
        this.continueDialing = false;
        this.func_70296_d();
        if (this.stargateState == EnumStargateState.DIALING || this.stargateState == EnumStargateState.DIALING_COMPUTER || this.stargateState == EnumStargateState.IDLE) {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAIL, this.stargateState.dialingComputer() ? 83 : 53));
            this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
        }
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating) {
        super.openGate(targetGatePos, isInitiating);
        this.resetToDialSymbols();
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol(SymbolPegasusEnum.BBB);
        }
    }

    @Override
    public void activateDHDSymbolBRB() {
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol(SymbolPegasusEnum.BBB);
        }
    }

    @Override
    public void clearDHDSymbols() {
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
    }

    @Override
    public void setConfig(JSGTileEntityConfig config) {
        DHDPegasusTile dhd;
        super.setConfig(config);
        if (this.isLinked() && (dhd = this.getLinkedDHD(this.field_145850_b)) != null) {
            DHDAbstractRendererState state = (DHDAbstractRendererState)dhd.getState(StateTypeEnum.RENDERER_STATE);
            state.gateConfig = this.getConfig();
            dhd.sendState(StateTypeEnum.RENDERER_STATE, state);
        }
    }

    @Override
    public SymbolTypeEnum getSymbolType() {
        return SymbolTypeEnum.PEGASUS;
    }

    @Override
    protected int getMaxChevrons() {
        return this.isLinkedAndDHDOperational() && this.stargateState != EnumStargateState.DIALING_COMPUTER && !this.getLinkedDHD(this.field_145850_b).hasUpgrade(DHDAbstractTile.DHDUpgradeEnum.CHEVRON_UPGRADE) ? 7 : 9;
    }

    @Override
    public void addSymbolToAddress(SymbolInterface symbol) {
        this.addSymbolToAddress(symbol, true);
    }

    public void addSymbolToAddress(SymbolInterface symbol, boolean activateSymbol) {
        if (this.isLinkedAndDHDOperational() && activateSymbol) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol((SymbolPegasusEnum)symbol);
        }
        super.addSymbolToAddress(symbol);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        super.incomingWormhole(dialedAddressSize);
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
        this.startIncomingAnimation(dialedAddressSize, 300);
        this.func_70296_d();
    }

    @Override
    public void incomingWormhole(int dialedAddressSize, int time) {
        super.incomingWormhole(dialedAddressSize);
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
        this.startIncomingAnimation(dialedAddressSize, time);
        this.func_70296_d();
    }

    @Override
    public void startIncomingAnimation(int addressSize, int period) {
        super.startIncomingAnimation(addressSize, period);
        this.incomingPeriod = (int)Math.round((double)(this.incomingPeriod * addressSize) / 36.0);
        this.func_70296_d();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void lightUpChevronByIncoming(boolean disableAnimation) {
        block12: {
            block11: {
                super.lightUpChevronByIncoming(disableAnimation);
                if (this.incomingPeriod == -1) {
                    return;
                }
                if (disableAnimation) break block11;
                boolean spin = this.config.getOption(StargateClassicBaseTile.ConfigOptions.SPIN_GATE_INCOMING.id).getBooleanValue();
                int z = this.incomingLastChevronLightUp;
                if (z == 1 && spin) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.GATE_RING_ROLL, 15));
                    this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, true);
                }
                if (z % 4 == 0 && z > 0) {
                    int chevron = z / 4;
                    int[] pattern = new int[]{1, 2, 3, 7, 8, 4, 5, 6, 9};
                    if (!this.stargateState.idle() && this.isIncoming) {
                        if (chevron >= 9) {
                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, true);
                            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                            this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                            this.resetIncomingAnimation();
                            this.func_70296_d();
                            return;
                        }
                        if (pattern[chevron - 1] < this.incomingAddressSize) {
                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, pattern[chevron - 1] + 9, false);
                            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
                        }
                    } else {
                        this.isIncoming = false;
                        this.stargateState = EnumStargateState.IDLE;
                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CLEAR_CHEVRONS, 10));
                        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                        this.resetIncomingAnimation();
                        this.func_70296_d();
                        return;
                    }
                }
                if (spin) {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.ACTIVATE_GLYPH, z, false);
                    break block12;
                } else if (z == 1) {
                    for (int i = 0; i < 36; ++i) {
                        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.ACTIVATE_GLYPH, i, false);
                    }
                }
                break block12;
            }
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, this.incomingAddressSize, false);
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            this.isIncoming = false;
            this.resetIncomingAnimation();
            this.func_70296_d();
        }
        this.func_70296_d();
    }

    @Override
    public void onGateBroken() {
        super.onGateBroken();
        if (this.isLinked()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
            this.getLinkedDHD(this.field_145850_b).setLinkedGate(null, -1);
            this.setLinkedDHD(null, -1);
        }
    }

    @Override
    protected void onGateMerged() {
        super.onGateMerged();
        this.updateLinkStatus();
    }

    @Override
    public StargateAbstractMergeHelper getMergeHelper() {
        return StargatePegasusMergeHelper.INSTANCE;
    }

    @Override
    public boolean canLinkTo() {
        return this.isMerged() && !this.isLinked();
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }

    @Nullable
    public DHDPegasusTile getLinkedDHD(World world) {
        if (this.linkedDHD == null) {
            return null;
        }
        return (DHDPegasusTile)world.func_175625_s(this.linkedDHD);
    }

    public boolean isLinked() {
        return this.linkedDHD != null && this.field_145850_b.func_175625_s(this.linkedDHD) instanceof DHDPegasusTile;
    }

    public boolean isLinkedAndDHDOperational() {
        if (!this.isLinked()) {
            return false;
        }
        DHDPegasusTile dhdTile = this.getLinkedDHD(this.field_145850_b);
        if (dhdTile == null) {
            return false;
        }
        return dhdTile.hasControlCrystal();
    }

    @Override
    public void setLinkedDHD(BlockPos dhdPos, int linkId) {
        this.linkedDHD = dhdPos;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public void updateLinkStatus() {
        BlockPos closestDhd = LinkingHelper.findClosestUnlinked(this.field_145850_b, this.field_174879_c, LinkingHelper.getDhdRange(), JSGBlocks.DHD_PEGASUS_BLOCK, this.getLinkId());
        int linkId = LinkingHelper.getLinkId();
        if (closestDhd != null) {
            DHDPegasusTile dhdTile = (DHDPegasusTile)this.field_145850_b.func_175625_s(closestDhd);
            dhdTile.setLinkedGate(this.field_174879_c, linkId);
            this.setLinkedDHD(closestDhd, linkId);
            this.func_70296_d();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.isLinked()) {
            compound.func_74772_a("linkedDHD", this.linkedDHD.func_177986_g());
            compound.func_74768_a("linkId", this.linkId);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("linkedDHD")) {
            this.linkedDHD = BlockPos.func_177969_a((long)compound.func_74763_f("linkedDHD"));
        }
        if (compound.func_74764_b("linkId")) {
            this.linkId = compound.func_74762_e("linkId");
        }
        super.func_145839_a(compound);
        if (this.stargateState.engaged() || this.stargateState.incoming() || this.stargateState.unstable()) {
            for (int i = 0; i < 36; ++i) {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.ACTIVATE_GLYPH, i, false);
            }
        }
    }

    @Override
    public boolean prepare(ICommandSender sender, ICommand command) {
        this.setLinkedDHD(null, -1);
        return super.prepare(sender, command);
    }

    @Override
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        switch (soundEnum) {
            case GATE_RING_ROLL: {
                return SoundPositionedEnum.PEGASUS_RING_ROLL;
            }
            case GATE_RING_ROLL_START: {
                return SoundPositionedEnum.PEGASUS_RING_ROLL_START;
            }
        }
        return null;
    }

    @Override
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        switch (soundEnum) {
            case OPEN: {
                return SoundEventEnum.GATE_PEGASUS_OPEN;
            }
            case CLOSE: {
                return SoundEventEnum.GATE_MILKYWAY_CLOSE;
            }
            case DIAL_FAILED: {
                return SoundEventEnum.GATE_PEGASUS_DIAL_FAILED;
            }
            case INCOMING: {
                return SoundEventEnum.GATE_PEGASUS_INCOMING;
            }
            case CHEVRON_OPEN: 
            case CHEVRON_SHUT: {
                return SoundEventEnum.GATE_PEGASUS_CHEVRON_OPEN;
            }
        }
        return null;
    }

    @Override
    protected boolean onGateMergeRequested() {
        if (this.stargateSize != JSGConfig.Stargate.stargateSize) {
            StargatePegasusMergeHelper.INSTANCE.convertToPattern(this.field_145850_b, this.field_174879_c, this.facing, this.facingVertical, this.stargateSize, JSGConfig.Stargate.stargateSize);
            this.stargateSize = JSGConfig.Stargate.stargateSize;
        }
        return StargatePegasusMergeHelper.INSTANCE.checkBlocks((IBlockAccess)this.field_145850_b, this.field_174879_c, this.facing, this.facingVertical);
    }

    public void resetToDialSymbols() {
        this.toDialSymbols.clear();
    }

    @Override
    protected boolean canAddSymbolInternal(SymbolInterface symbol) {
        if (this.dialedAddress.contains(symbol)) {
            return false;
        }
        return this.dialedAddress.size() < this.getMaxChevrons();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.toDialSymbols.size() > 0 && this.field_145850_b.func_82737_E() - this.lastSpinFinishedIn > (long)(this.continueDialing ? 2 : 10) && this.stargateState.idle()) {
            if (this.toDialSymbols.get(0) == SymbolPegasusEnum.BBB || this.canAddSymbolInternal(this.toDialSymbols.get(0))) {
                this.addSymbolToAddressByList(this.toDialSymbols.get(0));
            }
            if (this.toDialSymbols.size() > 0) {
                this.toDialSymbols.remove(0);
            }
            this.func_70296_d();
        }
        if (!this.lastPos.equals((Object)this.field_174879_c)) {
            this.lastPos = this.field_174879_c;
            this.updateLinkStatus();
            this.func_70296_d();
        }
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    protected StargatePegasusRendererState.StargatePegasusRendererStateBuilder getRendererStateServer() {
        return (StargatePegasusRendererState.StargatePegasusRendererStateBuilder)new StargatePegasusRendererState.StargatePegasusRendererStateBuilder(super.getRendererStateServer()).setStargateSize(this.stargateSize);
    }

    @Override
    protected StargateAbstractRendererState createRendererStateClient() {
        return new StargatePegasusRendererState();
    }

    @Override
    public StargatePegasusRendererState getRendererStateClient() {
        return (StargatePegasusRendererState)super.getRendererStateClient();
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: {
                return new StargatePegasusRendererState();
            }
            case DHD_ACTIVATE_BUTTON: {
                return new DHDActivateButtonState();
            }
            case GUI_UPDATE: {
                return new StargateContainerGuiUpdate();
            }
            case BIOME_OVERRIDE_STATE: {
                return new StargateBiomeOverrideState();
            }
        }
        return super.createState(stateType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        if (this.getRendererStateClient() != null) {
            switch (stateType) {
                case RENDERER_UPDATE: {
                    StargateRendererActionState gateActionState = (StargateRendererActionState)state;
                    switch (gateActionState.action) {
                        case CHEVRON_OPEN: {
                            this.getRendererStateClient().openChevron(this.field_145850_b.func_82737_E());
                            break;
                        }
                        case CHEVRON_CLOSE: {
                            this.getRendererStateClient().closeChevron(this.field_145850_b.func_82737_E());
                            break;
                        }
                        case CLEAR_CHEVRONS: {
                            this.getRendererStateClient().clearChevrons(this.field_145850_b.func_82737_E());
                            return;
                        }
                        case ACTIVATE_GLYPH: {
                            int slot = ((StargateRendererActionState)state).chevronCount;
                            slot = 36 - (slot - 9);
                            if (slot > 36) {
                                slot -= 36;
                            }
                            if (slot < 0) {
                                slot += 36;
                            }
                            if (this.getRendererStateClient() == null) break;
                            this.getRendererStateClient().setGlyphAtSlot(slot, slot);
                            break;
                        }
                        case CHEVRON_ACTIVATE: {
                            this.getRendererStateClient().spinHelper.setIsSpinning(false);
                            if (((StargateRendererActionState)state).chevronCount > 9) break;
                            ChevronEnum chevron = gateActionState.modifyFinal ? ChevronEnum.getFinal() : this.getRendererStateClient().chevronTextureList.getNextChevron();
                            this.getRendererStateClient().lockChevron(this.getRendererStateClient().spinHelper.getTargetSymbol().getId(), chevron);
                            break;
                        }
                    }
                    break;
                }
                case SPIN_STATE: {
                    StargateSpinState spinState = (StargateSpinState)state;
                    if (spinState.setOnly) {
                        this.getRendererStateClient().spinHelper.setIsSpinning(false);
                        ((StargatePegasusSpinHelper)this.getRendererStateClient().spinHelper).setTargetSymbol(spinState.targetSymbol);
                    }
                    if (this.getRendererStateClient().chevronTextureList.getNextChevron().rotationIndex != 1) break;
                    this.getRendererStateClient().slotToGlyphMap.clear();
                    break;
                }
            }
        }
        super.setState(stateType, state);
    }

    @Override
    protected long getSpinStartOffset() {
        return this.slotFromChevron(this.getRendererStateClient().chevronTextureList.getCurrentChevron());
    }

    public int slotFromChevron(ChevronEnum chevron) {
        return (new int[]{9, 5, 1, 33, 29, 25, 21, 17, 13})[chevron.rotationIndex];
    }

    @Override
    public StargateOpenResult attemptOpenAndFail() {
        if (this.stargateState != EnumStargateState.INCOMING) {
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        }
        this.continueDialing = false;
        this.func_70296_d();
        return super.attemptOpenAndFail();
    }

    @Override
    public boolean canAddSymbol(SymbolInterface symbol) {
        if (this.dialedAddress.size() >= this.getMaxChevrons()) {
            return false;
        }
        return super.canAddSymbol(symbol);
    }

    public boolean canAddSymbolToList(SymbolInterface symbol) {
        int size = this.toDialSymbols.size();
        for (SymbolPegasusEnum s : this.toDialSymbols) {
            if (!s.brb()) continue;
            --size;
        }
        if (this.dialedAddress.size() + size + (this.stargateState.dialing() ? 1 : 0) >= this.getMaxChevrons()) {
            return false;
        }
        if (this.toDialSymbols.contains((SymbolPegasusEnum)symbol)) {
            return false;
        }
        return super.canAddSymbol(symbol);
    }

    public void addSymbolToAddressDHD(SymbolInterface targetSymbol, EntityPlayer sender) {
        this.lastSender = sender;
        this.addSymbolToAddressDHD(targetSymbol);
        this.func_70296_d();
    }

    @Override
    public void addSymbolToAddressDHD(SymbolInterface targetSymbol) {
        DHDPegasusTile dhd;
        if (targetSymbol != SymbolPegasusEnum.BBB && !this.canAddSymbolToList(targetSymbol)) {
            return;
        }
        if (!(targetSymbol instanceof SymbolPegasusEnum)) {
            return;
        }
        if (this.toDialSymbols.contains(targetSymbol)) {
            return;
        }
        if (this.isLinkedAndDHDOperational() && (targetSymbol != SymbolPegasusEnum.BBB || this.toDialSymbols.size() > 0) && (dhd = this.getLinkedDHD(this.field_145850_b)) != null) {
            ((DHDAbstractTile)dhd).activateSymbol(targetSymbol);
        }
        this.toDialSymbols.add((SymbolPegasusEnum)targetSymbol);
    }

    public void addSymbolToAddressByList(SymbolInterface targetSymbol) {
        float distance;
        int indexDiff;
        EnumSpinDirection counterDirection;
        ChevronEnum currentChevron;
        this.lastSpinFinishedIn = 0L;
        if (((SymbolPegasusEnum)targetSymbol).brb()) {
            StargateOpenResult openResult = this.attemptOpenAndFail();
            if (openResult == StargateOpenResult.NOT_ENOUGH_POWER && this.lastSender != null) {
                this.lastSender.func_146105_b((ITextComponent)new TextComponentTranslation("tile.jsg.dhd_block.not_enough_power", new Object[0]), true);
            }
            this.continueDialing = false;
            this.func_70296_d();
            return;
        }
        boolean fastDial = this.getConfig().getOption(StargateClassicBaseTile.ConfigOptions.PEG_DIAL_ANIMATION.id).getEnumValue().getIntValue() == 1;
        boolean canContinueByConfig = this.getConfig().getOption(StargateClassicBaseTile.ConfigOptions.PEG_DIAL_ANIMATION.id).getEnumValue().getIntValue() == 0;
        this.stargateState = EnumStargateState.DIALING;
        this.targetRingSymbol = targetSymbol;
        this.spinDirection = this.spinDirection.opposite();
        if (fastDial) {
            this.continueDialing = false;
            this.func_70296_d();
            JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, EnumSpinDirection.CLOCKWISE, true, 0)), this.targetPoint);
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, 5 + new Random().nextInt(5)));
            this.doIncomingAnimation(10, true);
            this.sendSignal(null, "stargate_dhd_chevron_engaged", this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), targetSymbol.getEnglishName());
            return;
        }
        ChevronEnum targetChevron = this.stargateWillLock(targetSymbol, true) ? ChevronEnum.getFinal() : ChevronEnum.valueOf(this.dialedAddress.size());
        ChevronEnum chevronEnum = currentChevron = this.dialedAddress.size() == 0 ? ChevronEnum.C1 : ChevronEnum.valueOf(targetChevron.index - 1);
        if (this.stargateWillLock(targetSymbol, true) && this.dialedAddress.size() == 6) {
            currentChevron = ChevronEnum.C6;
        }
        EnumSpinDirection enumSpinDirection = counterDirection = (indexDiff = this.slotFromChevron(currentChevron) - this.slotFromChevron(targetChevron)) < 0 ? EnumSpinDirection.COUNTER_CLOCKWISE : EnumSpinDirection.CLOCKWISE;
        if (this.spinDirection == counterDirection) {
            indexDiff = 36 - Math.abs(indexDiff);
        }
        if ((distance = (float)Math.abs(indexDiff)) <= 20.0f) {
            distance += 36.0f;
        }
        int duration = (int)distance;
        this.doIncomingAnimation(duration, true, targetSymbol);
        JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, 0)), this.targetPoint);
        this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 1);
        this.addTask(this.lastSpinFinished);
        if (!this.continueDialing) {
            this.addTask(new ScheduledTask(EnumScheduledTask.GATE_RING_ROLL, 15));
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, true);
        }
        int toDialSize = this.toDialSymbols.size();
        if (this.toDialSymbols.contains(SymbolPegasusEnum.BBB)) {
            --toDialSize;
        }
        this.continueDialing = canContinueByConfig && toDialSize >= 2 && targetChevron != ChevronEnum.getFinal();
        this.func_70296_d();
        this.isSpinning = true;
        this.spinStartTime = this.field_145850_b.func_82737_E();
        this.ringSpinContext = null;
        this.sendSignal(null, "stargate_dhd_chevron_engaged", this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), targetSymbol.getEnglishName());
        this.func_70296_d();
    }

    @Override
    public void addSymbolToAddressManual(SymbolInterface targetSymbol, @Nullable Object context) {
        boolean moveOnly;
        this.stargateState = EnumStargateState.DIALING_COMPUTER;
        this.targetRingSymbol = targetSymbol;
        boolean bl = moveOnly = this.targetRingSymbol == this.currentRingSymbol;
        if (moveOnly) {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, 0));
            this.doIncomingAnimation(10, true);
        } else {
            float distance;
            int indexDiff;
            EnumSpinDirection counterDirection;
            ChevronEnum currentChevron;
            this.spinDirection = this.spinDirection.opposite();
            ChevronEnum targetChevron = targetSymbol.origin() ? ChevronEnum.getFinal() : ChevronEnum.valueOf(this.dialedAddress.size());
            ChevronEnum chevronEnum = currentChevron = this.dialedAddress.size() == 0 ? ChevronEnum.C1 : ChevronEnum.valueOf(targetChevron.index - 1);
            if (targetSymbol.origin() && this.dialedAddress.size() == 6) {
                currentChevron = ChevronEnum.C6;
            }
            EnumSpinDirection enumSpinDirection = counterDirection = (indexDiff = this.slotFromChevron(currentChevron) - this.slotFromChevron(targetChevron)) < 0 ? EnumSpinDirection.COUNTER_CLOCKWISE : EnumSpinDirection.CLOCKWISE;
            if (this.spinDirection == counterDirection) {
                indexDiff = 36 - Math.abs(indexDiff);
            }
            if ((distance = (float)Math.abs(indexDiff)) <= 20.0f) {
                distance += 36.0f;
            }
            int duration = (int)distance;
            this.doIncomingAnimation(duration, true, this.targetRingSymbol);
            JSG.debug("addSymbolToAddressManual: current:" + this.currentRingSymbol + ", target:" + targetSymbol + ", direction:" + (Object)((Object)this.spinDirection) + ", distance:" + distance + ", duration:" + duration + ", moveOnly:" + moveOnly);
            JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, 0)), this.targetPoint);
            this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 1);
            this.addTask(this.lastSpinFinished);
            this.addTask(new ScheduledTask(EnumScheduledTask.GATE_RING_ROLL, 15));
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, true);
            this.isSpinning = true;
            this.spinStartTime = this.field_145850_b.func_82737_E();
            this.ringSpinContext = context;
            if (context != null) {
                this.sendSignal(context, "stargate_spin_start", this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), targetSymbol.getEnglishName());
            }
        }
        this.func_70296_d();
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        boolean onlySpin = false;
        if (customData != null && customData.func_74764_b("onlySpin")) {
            onlySpin = customData.func_74767_n("onlySpin");
        }
        switch (scheduledTask) {
            case STARGATE_ACTIVATE_CHEVRON: {
                this.stargateState = EnumStargateState.IDLE;
                this.func_70296_d();
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, -1, this.isFinalActive);
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                if (!onlySpin) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 0));
                } else {
                    this.stargateState = EnumStargateState.IDLE;
                }
                this.func_70296_d();
                break;
            }
            case STARGATE_CHEVRON_OPEN: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                if (!this.continueDialing) {
                    this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                }
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_OPEN, 0, false);
                if (this.canAddSymbol(this.targetRingSymbol)) {
                    this.addSymbolToAddress(this.targetRingSymbol, this.stargateState == EnumStargateState.DIALING_COMPUTER);
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 0));
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 60));
                break;
            }
            case STARGATE_CHEVRON_OPEN_SECOND: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_LIGHT_UP, 0));
                break;
            }
            case STARGATE_CHEVRON_LIGHT_UP: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, this.stargateWillLock(this.targetRingSymbol));
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 1));
                break;
            }
            case STARGATE_CHEVRON_CLOSE: {
                if (this.stargateWillLock(this.targetRingSymbol)) {
                    this.stargateState = EnumStargateState.IDLE;
                    this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), true, this.targetRingSymbol.getEnglishName());
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_DIM, 1));
                break;
            }
            case STARGATE_CHEVRON_DIM: {
                this.stargateState = EnumStargateState.IDLE;
                this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), false, this.targetRingSymbol.getEnglishName());
                break;
            }
            case STARGATE_CHEVRON_FAIL: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                this.dialingFailed(this.checkAddressAndEnergy(this.dialedAddress));
                break;
            }
            case STARGATE_CLEAR_CHEVRONS: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
            }
        }
        super.executeTask(scheduledTask, customData);
    }

    @Override
    public int getDefaultCapacitors() {
        return 3;
    }
}

