/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.stargate;

import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.packet.StateUpdateRequestToServer;
import tauri.dev.jsg.stargate.EnumMemberVariant;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.stargate.StargateCamoState;
import tauri.dev.jsg.state.stargate.StargateLightState;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractMemberTile;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.main.JSGProps;

public abstract class StargateClassicMemberTile
extends StargateAbstractMemberTile
implements StateProviderInterface,
ITickable {
    private NetworkRegistry.TargetPoint targetPoint;
    protected EnumFacing facingVertical;
    private boolean isLitUp;
    private IBlockState camoBlockState;

    public EnumFacing getFacingVertical() {
        return this.facingVertical == null ? EnumFacing.SOUTH : this.facingVertical;
    }

    public void setVerticalFacing(EnumFacing f) {
        this.facingVertical = f;
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.FACING_VERTICAL) != this.getFacingVertical()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)JSGProps.FACING_VERTICAL, (Comparable)this.getFacingVertical()));
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        } else {
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.CAMO_STATE));
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.LIGHT_STATE));
        }
    }

    public void func_189667_a(Rotation rotation) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)rotation.func_185831_a(facing)));
    }

    public void setLitUp(boolean isLitUp) {
        boolean sync = isLitUp != this.isLitUp;
        this.isLitUp = isLitUp;
        this.func_70296_d();
        if (sync) {
            this.sendState(StateTypeEnum.LIGHT_STATE, this.getState(StateTypeEnum.LIGHT_STATE));
        }
    }

    public boolean isLitUp(IBlockState state) {
        return state.func_177229_b((IProperty)JSGProps.MEMBER_VARIANT) == EnumMemberVariant.CHEVRON && this.isLitUp;
    }

    public void setCamoState(IBlockState camoBlockState) {
        this.camoBlockState = camoBlockState;
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.sendState(StateTypeEnum.CAMO_STATE, this.getState(StateTypeEnum.CAMO_STATE));
        } else {
            JSG.warn("Tried to set camoBlockState from client. This won't work!");
        }
    }

    public IBlockState getCamoState() {
        return this.camoBlockState;
    }

    public ItemStack getCamoItemStack() {
        if (this.camoBlockState != null) {
            int meta;
            Block block = this.camoBlockState.func_177230_c();
            if (block == Blocks.field_150431_aC) {
                return null;
            }
            int quantity = 1;
            if (block instanceof BlockSlab && ((BlockSlab)block).func_176552_j()) {
                quantity = 2;
                meta = block.func_176201_c(this.camoBlockState);
                if (block == Blocks.field_150334_T) {
                    block = Blocks.field_150333_U;
                } else if (block == Blocks.field_180388_cO) {
                    block = Blocks.field_180389_cP;
                } else if (block == Blocks.field_150373_bw) {
                    block = Blocks.field_150376_bx;
                } else if (block == Blocks.field_185770_cW) {
                    block = Blocks.field_185771_cX;
                }
            } else {
                meta = block.func_176201_c(this.camoBlockState);
            }
            return new ItemStack(block, quantity, meta);
        }
        return null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("isLitUp", this.isLitUp);
        if (this.camoBlockState != null) {
            compound.func_74778_a("doubleSlabBlock", Objects.requireNonNull(this.camoBlockState.func_177230_c().getRegistryName()).toString());
            compound.func_74768_a("doubleSlabMeta", this.camoBlockState.func_177230_c().func_176201_c(this.camoBlockState));
        }
        compound.func_74768_a("facingVertical", FacingHelper.toInt(this.facingVertical));
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        Block dblSlabBlock;
        this.isLitUp = compound.func_74767_n("isLitUp");
        if (compound.func_74764_b("doubleSlabBlock") && (dblSlabBlock = Block.func_149684_b((String)compound.func_74779_i("doubleSlabBlock"))) != null) {
            this.camoBlockState = dblSlabBlock.func_176203_a(compound.func_74762_e("doubleSlabMeta"));
        }
        this.facingVertical = FacingHelper.fromInt(compound.func_74762_e("facingVertical"));
        super.func_145839_a(compound);
    }

    protected void sendState(StateTypeEnum type, State state) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetPoint != null) {
            JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, type, state), this.targetPoint);
        } else {
            JSG.debug("targetPoint was null trying to send " + (Object)((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case CAMO_STATE: {
                return new StargateCamoState(this.camoBlockState);
            }
            case LIGHT_STATE: {
                return new StargateLightState(this.isLitUp);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case CAMO_STATE: {
                return new StargateCamoState();
            }
            case LIGHT_STATE: {
                return new StargateLightState();
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case CAMO_STATE: {
                StargateCamoState memberState = (StargateCamoState)state;
                this.camoBlockState = memberState.getState();
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                break;
            }
            case LIGHT_STATE: {
                this.isLitUp = ((StargateLightState)state).isLitUp();
                this.field_145850_b.func_175679_n(this.field_174879_c);
                this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
                break;
            }
        }
    }
}

