/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.stargate;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.beamer.BeamerLinkingHelper;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.chunkloader.ChunkManager;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.JSGConfigUtil;
import tauri.dev.jsg.config.ingame.ITileConfig;
import tauri.dev.jsg.config.ingame.ITileConfigEntry;
import tauri.dev.jsg.config.ingame.JSGConfigEnumEntry;
import tauri.dev.jsg.config.ingame.JSGConfigOption;
import tauri.dev.jsg.config.ingame.JSGConfigOptionTypeEnum;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.config.stargate.StargateDimensionConfig;
import tauri.dev.jsg.config.stargate.StargateSizeEnum;
import tauri.dev.jsg.config.stargate.StargateTimeLimitModeEnum;
import tauri.dev.jsg.gui.container.stargate.StargateContainerGuiState;
import tauri.dev.jsg.gui.container.stargate.StargateContainerGuiUpdate;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.energy.CapacitorItemBlock;
import tauri.dev.jsg.item.linkable.gdo.GDOMessages;
import tauri.dev.jsg.item.notebook.PageNotebookItem;
import tauri.dev.jsg.item.stargate.IrisItem;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdateRequestToServer;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.power.stargate.StargateClassicEnergyStorage;
import tauri.dev.jsg.power.stargate.StargateEnergyRequired;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.stargate.StargateClassicRendererState;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.StargateSoundEventEnum;
import tauri.dev.jsg.sound.StargateSoundPositionedEnum;
import tauri.dev.jsg.stargate.EnumIrisMode;
import tauri.dev.jsg.stargate.EnumIrisState;
import tauri.dev.jsg.stargate.EnumIrisType;
import tauri.dev.jsg.stargate.EnumScheduledTask;
import tauri.dev.jsg.stargate.EnumSpinDirection;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.stargate.NearbyGate;
import tauri.dev.jsg.stargate.StargateClassicSpinHelper;
import tauri.dev.jsg.stargate.StargateClosedReasonEnum;
import tauri.dev.jsg.stargate.StargateOpenResult;
import tauri.dev.jsg.stargate.codesender.CodeSender;
import tauri.dev.jsg.stargate.codesender.CodeSenderType;
import tauri.dev.jsg.stargate.codesender.ComputerCodeSender;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.StargateAddressDynamic;
import tauri.dev.jsg.stargate.network.StargateNetwork;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolPegasusEnum;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.stargate.StargateBiomeOverrideState;
import tauri.dev.jsg.state.stargate.StargateRendererActionState;
import tauri.dev.jsg.state.stargate.StargateSpinState;
import tauri.dev.jsg.tileentity.BeamerTile;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicMemberTile;
import tauri.dev.jsg.tileentity.stargate.StargateMilkyWayBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargatePegasusBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateUniverseBaseTile;
import tauri.dev.jsg.tileentity.util.IUpgradable;
import tauri.dev.jsg.tileentity.util.ScheduledTask;
import tauri.dev.jsg.util.BlockHelpers;
import tauri.dev.jsg.util.EnumKeyInterface;
import tauri.dev.jsg.util.EnumKeyMap;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.ItemHandlerHelper;
import tauri.dev.jsg.util.ItemMetaPair;
import tauri.dev.jsg.util.JSGAdvancementsUtil;
import tauri.dev.jsg.util.JSGAxisAlignedBB;
import tauri.dev.jsg.util.JSGItemStackHandler;
import tauri.dev.jsg.util.math.TemperatureHelper;

public abstract class StargateClassicBaseTile
extends StargateAbstractBaseTile
implements IUpgradable,
ITileConfig {
    private EnumIrisState irisState = EnumIrisState.OPENED;
    private EnumIrisType irisType = EnumIrisType.NULL;
    private int irisCode = -1;
    protected EnumIrisMode irisMode = EnumIrisMode.OPENED;
    private long irisAnimation = 0L;
    public int shieldKeepAlive = 0;
    private int irisDurability = 0;
    private int irisMaxDurability = 0;
    protected boolean isFinalActive;
    public boolean isFastDialing;
    protected double lastIrisHeat = -2.0;
    protected double lastGateHeat = -2.0;
    public double irisHeat;
    public double gateHeat;
    public static final double IRIS_MAX_HEAT_TITANIUM = JSGConfig.Stargate.iris.irisTitaniumMaxHeat;
    public static final double IRIS_MAX_HEAT_TRINIUM = JSGConfig.Stargate.iris.irisTriniumMaxHeat;
    public static final double GATE_MAX_HEAT = JSGConfig.Stargate.mechanics.gateMaxHeat;
    protected StargateSizeEnum stargateSize = JSGConfig.Stargate.stargateSize;
    private BlockPos lastPos = BlockPos.field_177992_a;
    protected int incomingAddressSize = -1;
    protected int incomingPeriod = -1;
    protected int incomingLastChevronLightUp = -1;
    protected JSGTileEntityConfig config = new JSGTileEntityConfig();
    public static final JSGAxisAlignedBB RENDER_BOX = new JSGAxisAlignedBB(-5.5, 0.0, -0.5, 5.5, 10.5, 0.5);
    public static final JSGAxisAlignedBB RENDER_BOX_LARGE = new JSGAxisAlignedBB(-7.5, 0.0, -0.5, 7.5, 12.5, 0.5);
    protected long lastSpinFinishedIn = 0L;
    protected boolean isSpinning;
    protected long spinStartTime;
    protected SymbolInterface currentRingSymbol = this.getSymbolType().getTopSymbol();
    protected SymbolInterface targetRingSymbol = this.getSymbolType().getTopSymbol();
    protected EnumSpinDirection spinDirection = EnumSpinDirection.COUNTER_CLOCKWISE;
    protected Object ringSpinContext;
    private short pageProgress = 0;
    private int pageSlotId;
    private boolean doPageProgress;
    private ScheduledTask givePageTask;
    private boolean lockPage;
    public static final int BIOME_OVERRIDE_SLOT = 10;
    private final JSGItemStackHandler itemStackHandler = new JSGItemStackHandler(12){

        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.func_77973_b();
            boolean isItemCapacitor = item instanceof CapacitorItemBlock;
            switch (slot) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return StargateUpgradeEnum.contains(item) && !StargateClassicBaseTile.this.hasUpgrade(item);
                }
                case 4: {
                    return isItemCapacitor && StargateClassicBaseTile.this.getSupportedCapacitors() >= 1;
                }
                case 5: {
                    return isItemCapacitor && StargateClassicBaseTile.this.getSupportedCapacitors() >= 2;
                }
                case 6: {
                    return isItemCapacitor && StargateClassicBaseTile.this.getSupportedCapacitors() >= 3;
                }
                case 7: 
                case 8: {
                    return item == JSGItems.PAGE_NOTEBOOK_ITEM;
                }
                case 9: {
                    return item == JSGItems.PAGE_NOTEBOOK_ITEM || item == JSGItems.UNIVERSE_DIALER;
                }
                case 10: {
                    BiomeOverlayEnum override = JSGConfigUtil.getBiomeOverrideItemMetaPairs().get(new ItemMetaPair(stack));
                    if (override == null) {
                        return false;
                    }
                    return StargateClassicBaseTile.this.getSupportedOverlays().contains((Object)override);
                }
                case 11: {
                    return StargateClassicBaseTile.this.canInsertItemAsIris(item);
                }
            }
            return true;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            switch (slot) {
                case 4: 
                case 5: 
                case 6: {
                    StargateClassicBaseTile.this.updatePowerTier();
                    break;
                }
                case 10: {
                    StargateClassicBaseTile.this.sendState(StateTypeEnum.BIOME_OVERRIDE_STATE, new StargateBiomeOverrideState(StargateClassicBaseTile.this.determineBiomeOverride()));
                    break;
                }
                case 11: {
                    StargateClassicBaseTile.this.updateIrisType();
                    break;
                }
            }
            StargateClassicBaseTile.this.func_70296_d();
        }
    };
    protected CodeSender codeSender;
    private Runnable afterIrisDone = null;
    private static final List<Integer> UPGRADE_SLOTS_IDS = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 11));
    private final StargateClassicEnergyStorage energyStorage = new StargateClassicEnergyStorage(){

        @Override
        protected void onEnergyChanged() {
            StargateClassicBaseTile.this.func_70296_d();
        }
    };
    private int currentPowerTier = 1;
    private final List<BlockPos> linkedBeamers = new ArrayList<BlockPos>();

    public boolean getFastDialState() {
        return this.isFastDialing;
    }

    public void setFastDial(boolean state) {
        if (this.stargateState.idle()) {
            this.isFastDialing = state;
        }
        this.func_70296_d();
    }

    public void tryHeatUp(boolean byIrisHit, double irisHeatUpCoefficient) {
        this.tryHeatUp(byIrisHit, false, 1.0, irisHeatUpCoefficient, 1.0, -1.0, -1.0);
    }

    public void tryHeatUp(double gateHeatUpCoefficient) {
        this.tryHeatUp(false, true, gateHeatUpCoefficient, 1.0, 1.0, -1.0, -1.0);
    }

    public double getMaxIrisHeat() {
        if (this.isShieldIris()) {
            return Double.MAX_VALUE;
        }
        return this.getIrisType() == EnumIrisType.IRIS_TRINIUM ? IRIS_MAX_HEAT_TRINIUM : IRIS_MAX_HEAT_TITANIUM;
    }

    public void tryHeatUp(boolean heatUpIris, boolean heatUpGate, double gateHeatUpCoefficient, double irisHeatUpCoefficient, double coolDownCoefficient, double maxHeatByAround, double minHeatByAround) {
        double heatUpCoefficientConst = 0.7;
        double coolDownCoefficientConst = 0.3;
        if ((heatUpGate || Math.abs(this.gateHeat - this.irisHeat) >= 50.0) && (maxHeatByAround == -1.0 || this.gateHeat + 0.7 * gateHeatUpCoefficient <= maxHeatByAround)) {
            this.gateHeat += 0.7 * gateHeatUpCoefficient;
        }
        if (minHeatByAround == -1.0 || this.gateHeat - 0.3 * coolDownCoefficient > minHeatByAround) {
            this.gateHeat -= 0.3 * coolDownCoefficient;
        }
        if ((heatUpIris || Math.abs(this.gateHeat - this.irisHeat) >= 25.0) && (maxHeatByAround == -1.0 || this.irisHeat + 0.7 * irisHeatUpCoefficient <= maxHeatByAround)) {
            this.irisHeat += 0.7 * irisHeatUpCoefficient;
        }
        if (minHeatByAround == -1.0 || this.irisHeat - 0.3 * coolDownCoefficient > minHeatByAround) {
            this.irisHeat -= 0.3 * coolDownCoefficient;
        }
        ItemStack irisItem = this.getItemHandler().getStackInSlot(11);
        double maxHeat = this.getMaxIrisHeat();
        if (this.irisHeat >= maxHeat) {
            int heatCoefficient = (int)Math.round(Math.abs(this.irisHeat - maxHeat));
            if (JSGConfig.Stargate.iris.enableIrisOverHeatCollapse && this.field_145850_b.func_82737_E() % (long)((int)(Math.random() * 70.0) + 1) == 0L && this.isPhysicalIris() && irisItem.func_77984_f()) {
                irisItem.func_77973_b().setDamage(irisItem, irisItem.func_77973_b().getDamage(irisItem) + (new Random().nextInt(heatCoefficient) + 1));
                if (irisItem.func_190916_E() == 0) {
                    this.updateIrisType();
                }
                JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.IRIS_HIT);
            }
        }
        if (this.gateHeat >= GATE_MAX_HEAT && JSGConfig.Stargate.mechanics.enableGateOverHeatExplosion) {
            this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 60.0f, false, true);
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L && (this.lastIrisHeat != this.irisHeat || this.lastGateHeat != this.gateHeat)) {
            this.lastIrisHeat = this.irisHeat;
            this.lastGateHeat = this.gateHeat;
            this.func_70296_d();
            this.sendState(StateTypeEnum.RENDERER_UPDATE, new StargateRendererActionState(this.irisHeat, this.gateHeat));
        }
        this.func_70296_d();
    }

    protected StargateSizeEnum getStargateSizeConfig(boolean server) {
        return server ? JSGConfig.Stargate.stargateSize : this.getRendererStateClient().stargateSize;
    }

    @Override
    public BlockPos getGateCenterPos() {
        if (this.stargateSize == StargateSizeEnum.EXTRA_LARGE) {
            return this.field_174879_c.func_177967_a(EnumFacing.UP, 5);
        }
        return this.field_174879_c.func_177967_a(EnumFacing.UP, 4);
    }

    @Nonnull
    protected StargateSizeEnum getStargateSize() {
        return this.stargateSize;
    }

    @Override
    protected JSGAxisAlignedBB getHorizonKillingBox(boolean server) {
        return this.getStargateSizeConfig((boolean)server).killingBox;
    }

    @Override
    protected int getHorizonSegmentCount(boolean server) {
        return this.getStargateSizeConfig((boolean)server).horizonSegmentCount;
    }

    @Override
    protected List<JSGAxisAlignedBB> getGateVaporizingBoxes(boolean server) {
        return this.getStargateSizeConfig((boolean)server).gateVaporizingBoxes;
    }

    @Override
    protected JSGAxisAlignedBB getHorizonTeleportBox(boolean server) {
        return this.getStargateSizeConfig((boolean)server).teleportBox;
    }

    @Override
    protected void engageGate() {
        super.engageGate();
        for (BlockPos beamerPos : this.linkedBeamers) {
            if (this.field_145850_b.func_175625_s(beamerPos) == null) continue;
            ((BeamerTile)Objects.requireNonNull(this.field_145850_b.func_175625_s(beamerPos))).gateEngaged(this.targetGatePos);
        }
    }

    @Override
    public void closeGate(StargateClosedReasonEnum reason) {
        super.closeGate(reason);
        for (BlockPos beamerPos : this.linkedBeamers) {
            if (this.field_145850_b.func_175625_s(beamerPos) == null) continue;
            ((BeamerTile)Objects.requireNonNull(this.field_145850_b.func_175625_s(beamerPos))).gateClosed();
        }
    }

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        if (this.irisMode == EnumIrisMode.AUTO && this.isIrisClosed()) {
            this.toggleIris();
        }
        this.isFinalActive = false;
        if (this.codeSender != null) {
            this.codeSender = null;
        }
        this.updateChevronLight(0, false);
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, this.dialedAddress.size(), this.isFinalActive);
    }

    public boolean isGateBurried() {
        if (!this.getConfig().getOption(ConfigOptions.ENABLE_BURY_STATE.id).getBooleanValue()) {
            return false;
        }
        for (BlockPos targetPos : Objects.requireNonNull(StargateSizeEnum.getIrisBlocksPattern(this.getStargateSize()))) {
            BlockPos newPos = this.field_174879_c.func_177971_a((Vec3i)FacingHelper.rotateBlock(targetPos, this.facing, this.facingVertical));
            IBlockState state = this.field_145850_b.func_180495_p(newPos);
            if (StargateClassicBaseTile.isLiquidBlock(false, state) || StargateClassicBaseTile.isLiquidBlock(true, state)) {
                return false;
            }
            if (state.func_185904_a() != Material.field_151579_a && state.func_177230_c() != JSGBlocks.IRIS_BLOCK && state.func_177230_c() != JSGBlocks.INVISIBLE_BLOCK) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void failGate() {
        super.failGate();
        this.resetTargetIncomingAnimation();
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        this.isFinalActive = false;
        if (this.stargateState != EnumStargateState.INCOMING && !this.isIncoming) {
            this.updateChevronLight(0, false);
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, this.dialedAddress.size(), this.isFinalActive);
        }
    }

    @Override
    protected StargateAbstractBaseTile.ResultTargetValid attemptOpenDialed() {
        StargateOpenResult result = this.checkAddressAndEnergy(this.dialedAddress);
        boolean targetValid = result.ok();
        if (this.connectedToGatePos == null) {
            return new StargateAbstractBaseTile.ResultTargetValid(StargateOpenResult.CALLER_HUNG_UP, targetValid);
        }
        if (!this.connectedToGatePos.getTileEntity().stargateState.incoming()) {
            return new StargateAbstractBaseTile.ResultTargetValid(StargateOpenResult.CALLER_HUNG_UP, targetValid);
        }
        if (this.isGateBurried()) {
            return new StargateAbstractBaseTile.ResultTargetValid(StargateOpenResult.GATE_BURRIED, targetValid);
        }
        return super.attemptOpenDialed();
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating) {
        super.openGate(targetGatePos, isInitiating);
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        this.tryHeatUp(8.0);
        this.isFinalActive = true;
    }

    public boolean abortDialingSequence() {
        if (this.stargateState.incoming()) {
            return false;
        }
        if (this.isIncoming) {
            return false;
        }
        if (this.stargateState.dialingComputer() || this.stargateState.idle() || this.stargateState.dialing()) {
            this.spinStartTime = this.field_145850_b.func_82737_E() + 3000L;
            this.isSpinning = false;
            this.currentRingSymbol = this.targetRingSymbol;
            this.sendState(StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, true, 0));
            this.addFailedTaskAndPlaySound();
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
            if (this.lastSpinFinished != null && this.scheduledTasks.contains(this.lastSpinFinished)) {
                this.removeTask(this.lastSpinFinished);
            }
            this.failGate();
            if (!this.isIncoming) {
                this.disconnectGate();
            }
            this.func_70296_d();
            this.resetTargetIncomingAnimation();
            return true;
        }
        return false;
    }

    @Override
    public void generateIncoming(int entities, int addressSize, int delay) {
        if (this.isGateBurried()) {
            return;
        }
        super.generateIncoming(entities, addressSize, delay);
    }

    public abstract void addSymbolToAddressDHD(SymbolInterface var1);

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        this.incomingWormhole(dialedAddressSize, true);
    }

    public void incomingWormhole(int dialedAddressSize, boolean toggleIris) {
        if (this.irisMode == EnumIrisMode.AUTO && this.isIrisOpened() && toggleIris) {
            this.toggleIris();
        }
        super.incomingWormhole(dialedAddressSize);
        this.isFinalActive = true;
        this.updateChevronLight(dialedAddressSize, true);
    }

    @Override
    public void onGateBroken() {
        super.onGateBroken();
        this.updateChevronLight(0, false);
        if (this.irisType != EnumIrisType.NULL && this.irisState == EnumIrisState.CLOSED) {
            this.setIrisBlocks(false);
        }
        this.isSpinning = false;
        this.irisState = EnumIrisState.OPENED;
        this.irisType = EnumIrisType.NULL;
        this.currentRingSymbol = this.getSymbolType().getTopSymbol();
        this.sendState(StateTypeEnum.SPIN_STATE, new StargateSpinState(this.currentRingSymbol, this.spinDirection, true, 0));
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        ItemHandlerHelper.dropInventoryItems(this.field_145850_b, this.field_174879_c, (IItemHandler)this.itemStackHandler);
        for (BlockPos beamerPos : this.linkedBeamers) {
            if (this.field_145850_b.func_175625_s(beamerPos) == null) continue;
            BeamerTile beamerTile = (BeamerTile)this.field_145850_b.func_175625_s(beamerPos);
            Objects.requireNonNull(beamerTile).setLinkedGate(null, null);
        }
        this.linkedBeamers.clear();
    }

    @Override
    protected void onGateMerged() {
        double heat;
        super.onGateMerged();
        BeamerLinkingHelper.findBeamersInFront(this.field_145850_b, this.field_174879_c, this.facing);
        this.updateBeamers();
        this.updateIrisType();
        this.gateHeat = heat = TemperatureHelper.asKelvins(this.getTemperatureAroundGate()).toCelsius();
        this.irisHeat = heat;
        this.func_70296_d();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.lastPos = this.field_174879_c;
        if (!this.field_145850_b.field_72995_K) {
            boolean set;
            this.updateBeamers();
            this.updatePowerTier();
            this.updateIrisType();
            boolean bl = set = this.irisType != EnumIrisType.NULL;
            if (this.isMerged()) {
                this.setIrisBlocks(set && this.irisState == EnumIrisState.CLOSED);
            }
        }
    }

    protected abstract boolean onGateMergeRequested();

    public void startIncomingAnimation(int addressSize, int period) {
        double ticks = (double)(period * 20) / 1000.0;
        this.incomingPeriod = (int)Math.round(ticks);
        this.incomingAddressSize = addressSize;
        this.incomingLastChevronLightUp = 0;
        this.stargateState = EnumStargateState.INCOMING;
        this.isIncoming = true;
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 9, true);
        if (this.stargateState == EnumStargateState.DIALING_COMPUTER) {
            this.abortDialingSequence();
        }
        this.func_70296_d();
    }

    public void resetIncomingAnimation() {
        this.incomingAddressSize = -1;
        this.incomingPeriod = -1;
        this.incomingLastChevronLightUp = -1;
        this.func_70296_d();
    }

    protected void lightUpChevronByIncoming(boolean disableAnimation) {
        if (!this.isIncoming) {
            if (this.incomingPeriod != -1) {
                this.stargateState = EnumStargateState.IDLE;
            }
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 9, true);
            this.resetIncomingAnimation();
            this.func_70296_d();
            return;
        }
        if (this.stargateState.idle()) {
            this.stargateState = EnumStargateState.IDLE;
            this.func_70296_d();
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
            this.resetIncomingAnimation();
            return;
        }
        ++this.incomingLastChevronLightUp;
    }

    public void tryRunIncoming(long ticks) {
        if (this.incomingPeriod == 0) {
            this.incomingPeriod = 1;
        }
        if (this.incomingPeriod != -1 && ticks % (long)this.incomingPeriod == 0L) {
            this.lightUpChevronByIncoming(!this.getConfig().getOption(ConfigOptions.ALLOW_INCOMING.id).getBooleanValue());
        }
    }

    private static boolean isLiquidBlock(boolean lava, IBlockState state) {
        return StargateClassicBaseTile.getLiquidBlockTemp(lava, state) > -1.0;
    }

    private static double getLiquidBlockTemp(boolean lava, IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockLiquid) {
            if (lava && block.func_149739_a().equalsIgnoreCase("tile.lava")) {
                return TemperatureHelper.asCelsius(1200.0).toKelvins();
            }
            if (!lava && block.func_149739_a().equalsIgnoreCase("tile.water")) {
                return TemperatureHelper.asCelsius(3.0).toKelvins();
            }
        }
        if (block instanceof BlockFluidBase) {
            boolean isHot;
            BlockFluidBase liquid = (BlockFluidBase)block;
            boolean bl = isHot = (double)liquid.getFluid().getTemperature() >= TemperatureHelper.asCelsius(1200.0).toKelvins();
            if (isHot && lava || !isHot && !lava) {
                return liquid.getFluid().getTemperature();
            }
        }
        return -1.0;
    }

    public double getAroundGateLiquid(boolean lava, boolean getTemperature) {
        return this.getTemperatureAroundGate(lava ? 1 : -1, getTemperature);
    }

    public double getTemperatureAroundGate(int type, boolean getTemperature) {
        Block block;
        IBlockState state;
        BlockPos newPos;
        boolean lava = type == 1;
        boolean air = type == 0;
        double suma = 0.0;
        for (BlockPos chevron : this.getMergeHelper().getChevronBlocks()) {
            chevron = FacingHelper.rotateBlock(chevron, this.facing, this.facingVertical).func_177971_a((Vec3i)this.field_174879_c);
            for (EnumFacing facing : EnumFacing.values()) {
                newPos = chevron.func_177971_a(facing.func_176730_m());
                state = this.field_145850_b.func_180495_p(newPos);
                block = state.func_177230_c();
                if (air) {
                    if (!this.field_145850_b.func_175623_d(newPos)) continue;
                    if (getTemperature) {
                        suma += TemperatureHelper.asCelsius(this.field_145850_b.func_180494_b(this.field_174879_c).func_180626_a(this.field_174879_c) * 30.0f).toKelvins();
                        continue;
                    }
                    suma += 1.0;
                    continue;
                }
                if (StargateClassicBaseTile.isLiquidBlock(lava, state)) {
                    if (getTemperature) {
                        suma += StargateClassicBaseTile.getLiquidBlockTemp(lava, state);
                        continue;
                    }
                    suma += 1.0;
                    continue;
                }
                if (lava || block != Blocks.field_150432_aD && block != Blocks.field_150433_aE && block != Blocks.field_150403_cj) continue;
                if (getTemperature) {
                    suma += block == Blocks.field_150433_aE ? TemperatureHelper.asCelsius(3.0).toKelvins() : TemperatureHelper.asCelsius(-3.0).toKelvins();
                    continue;
                }
                suma += 1.0;
            }
        }
        for (BlockPos ring : this.getMergeHelper().getRingBlocks()) {
            ring = FacingHelper.rotateBlock(ring, this.facing, this.facingVertical).func_177971_a((Vec3i)this.field_174879_c);
            for (EnumFacing facing : EnumFacing.values()) {
                newPos = ring.func_177971_a(facing.func_176730_m());
                state = this.field_145850_b.func_180495_p(newPos);
                block = state.func_177230_c();
                if (air) {
                    if (!this.field_145850_b.func_175623_d(newPos)) continue;
                    if (getTemperature) {
                        suma += TemperatureHelper.asCelsius(this.field_145850_b.func_180494_b(this.field_174879_c).func_180626_a(this.field_174879_c) * 30.0f).toKelvins();
                        continue;
                    }
                    suma += 1.0;
                    continue;
                }
                if (StargateClassicBaseTile.isLiquidBlock(lava, state)) {
                    if (getTemperature) {
                        suma += StargateClassicBaseTile.getLiquidBlockTemp(lava, state);
                        continue;
                    }
                    suma += 1.0;
                    continue;
                }
                if (lava || block != Blocks.field_150432_aD && block != Blocks.field_150433_aE && block != Blocks.field_150403_cj) continue;
                if (getTemperature) {
                    suma += block == Blocks.field_150433_aE ? TemperatureHelper.asCelsius(3.0).toKelvins() : TemperatureHelper.asCelsius(-3.0).toKelvins();
                    continue;
                }
                suma += 1.0;
            }
        }
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos newPos2 = this.field_174879_c.func_177971_a(facing.func_176730_m());
            IBlockState state2 = this.field_145850_b.func_180495_p(newPos2);
            Block block2 = state2.func_177230_c();
            if (air) {
                if (!this.field_145850_b.func_175623_d(newPos2)) continue;
                if (getTemperature) {
                    suma += TemperatureHelper.asCelsius(this.field_145850_b.func_180494_b(this.field_174879_c).func_180626_a(this.field_174879_c) * 30.0f).toKelvins();
                    continue;
                }
                suma += 1.0;
                continue;
            }
            if (StargateClassicBaseTile.isLiquidBlock(lava, state2)) {
                if (getTemperature) {
                    suma += StargateClassicBaseTile.getLiquidBlockTemp(lava, state2);
                    continue;
                }
                suma += 1.0;
                continue;
            }
            if (lava || block2 != Blocks.field_150432_aD && block2 != Blocks.field_150433_aE && block2 != Blocks.field_150403_cj) continue;
            if (getTemperature) {
                suma += block2 == Blocks.field_150433_aE ? TemperatureHelper.asCelsius(3.0).toKelvins() : TemperatureHelper.asCelsius(-3.0).toKelvins();
                continue;
            }
            suma += 1.0;
        }
        return suma;
    }

    public double getTemperatureAroundGate() {
        double lavaCount = this.getAroundGateLiquid(true, false);
        double waterCount = this.getAroundGateLiquid(false, false);
        double airCount = this.getTemperatureAroundGate(0, false);
        double total = lavaCount + waterCount + airCount;
        double maxTemperature = this.getAroundGateLiquid(true, true);
        double minTemperature = this.getAroundGateLiquid(false, true);
        double airTemp = this.getTemperatureAroundGate(0, true);
        double totalTemp = maxTemperature + minTemperature + airTemp;
        return TemperatureHelper.asCelsius(total > 0.0 ? TemperatureHelper.asKelvins(totalTemp / total).toCelsius() : 25.0).toKelvins();
    }

    @Override
    public void func_73660_a() {
        block76: {
            block73: {
                block75: {
                    block74: {
                        Random rand;
                        boolean shouldBeFast;
                        if (this.field_145850_b.field_72995_K && this.getConfig().getOptions().size() < 1) {
                            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.GUI_STATE));
                        }
                        if (!this.field_145850_b.field_72995_K && this.isFastDialing != (shouldBeFast = this.getConfig().getOption(ConfigOptions.ENABLE_FAST_DIAL.id).getBooleanValue()) && this.getStargateState().idle()) {
                            this.setFastDial(shouldBeFast);
                        }
                        if (!this.field_145850_b.field_72995_K && this.isMerged()) {
                            float chance;
                            BlockPos topBlockPos = this.getMergeHelper().getTopBlock().func_177971_a((Vec3i)this.field_174879_c);
                            if (this.field_145850_b.func_72912_H().func_76061_m() && BlockHelpers.isBlockDirectlyUnderSky((IBlockAccess)this.field_145850_b, topBlockPos) && (chance = (rand = new Random()).nextFloat()) < JSGConfig.Stargate.mechanics.lightingBoldChance) {
                                int max = JSGConfig.Stargate.power.stargateEnergyStorage / 17;
                                int min = max / 6;
                                int energy = (int)(rand.nextFloat() * (float)(max - min) + (float)min);
                                this.getEnergyStorage().receiveEnergy(energy, false);
                                this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)topBlockPos.func_177958_n(), (double)topBlockPos.func_177956_o(), (double)topBlockPos.func_177952_p(), false));
                            }
                        }
                        if (!this.field_145850_b.field_72995_K && this.isMerged()) {
                            double middleTemperature = TemperatureHelper.asKelvins(this.getTemperatureAroundGate()).toCelsius();
                            double cc = Math.min(Math.abs(this.gateHeat / (middleTemperature * 2.0)), 0.5);
                            double c = Math.sin(cc) * 0.7 + 0.05;
                            this.tryHeatUp(false, true, c, c, c, middleTemperature, middleTemperature);
                            if (!this.hasIris()) {
                                this.irisHeat = -1.0;
                                this.func_70296_d();
                            }
                        }
                        String RIG_PREFIX = "[RIG] at " + this.field_174879_c.toString() + ":: ";
                        if (!this.field_145850_b.field_72995_K) {
                            this.tryRunIncoming(this.field_145850_b.func_82737_E());
                        }
                        if (!this.field_145850_b.field_72995_K) {
                            int chanceToRandom;
                            this.initConfig();
                            rand = new Random();
                            if (this.config.getOption(ConfigOptions.ALLOW_RIG.id).getBooleanValue() && this.field_145850_b.func_175697_a(this.field_174879_c, 10) && this.field_145850_b.func_82737_E() % 200L == 0L && (chanceToRandom = rand.nextInt(1000)) <= JSGConfig.Stargate.rig.chance) {
                                int entities = rand.nextInt(25);
                                int delay = rand.nextInt(200);
                                if (this instanceof StargateUniverseBaseTile && (delay = rand.nextInt(300)) < 120) {
                                    delay = 120;
                                }
                                if (delay < 80) {
                                    delay = 80;
                                }
                                if (entities < 3) {
                                    entities = 3;
                                }
                                this.generateIncoming(entities, 7, delay);
                                JSG.debug(RIG_PREFIX + "Stargate at " + this.field_174879_c.toString() + " generated RIG!");
                            }
                            if (this.randomIncomingIsActive) {
                                int wait = 80;
                                int waitOpen = this.randomIncomingOpenDelay + 20;
                                if (waitOpen < 80) {
                                    waitOpen = 80;
                                }
                                if (this.isMerged()) {
                                    if (this.randomIncomingState == 0.0f) {
                                        if (this.canAcceptConnectionFrom(null)) {
                                            this.randomIncomingState += 1.0f;
                                            int period = waitOpen / 20 * 1000 / this.randomIncomingAddrSize;
                                            this.stargateState = EnumStargateState.INCOMING;
                                            this.isIncoming = true;
                                            if (this.connectedToGate) {
                                                StargateAbstractBaseTile tGate;
                                                if (!this.dialedAddress.contains(this.getSymbolType().getOrigin())) {
                                                    this.dialedAddress.addOrigin();
                                                }
                                                if ((tGate = Objects.requireNonNull(this.network.getStargate(this.dialedAddress)).getTileEntity()) != null) {
                                                    tGate.stargateState = EnumStargateState.IDLE;
                                                    tGate.func_70296_d();
                                                }
                                                this.connectedToGate = false;
                                                this.connectingToGate = false;
                                            }
                                            this.func_70296_d();
                                            if (this.getConfig().getOption(ConfigOptions.ALLOW_INCOMING.id).getBooleanValue()) {
                                                this.incomingWormhole(this.randomIncomingAddrSize, period);
                                            } else {
                                                this.incomingWormhole(this.randomIncomingAddrSize);
                                            }
                                            this.sendSignal(null, "stargate_incoming_wormhole", this.randomIncomingAddrSize);
                                            this.failGate();
                                            JSG.debug(RIG_PREFIX + "Incoming!");
                                        } else {
                                            this.resetRandomIncoming();
                                        }
                                    } else if (this.randomIncomingState < (float)waitOpen) {
                                        if (!this.stargateState.engaged() && !this.stargateState.unstable()) {
                                            this.stargateState = EnumStargateState.INCOMING;
                                            this.randomIncomingState += 1.0f;
                                        } else {
                                            this.resetRandomIncoming();
                                        }
                                    } else if (this.randomIncomingState == (float)waitOpen) {
                                        if (!this.stargateState.engaged() && !this.stargateState.unstable() && this.stargateState.incoming()) {
                                            this.randomIncomingState += 1.0f;
                                            this.targetGatePos = null;
                                            this.setOpenedSince();
                                            ChunkManager.forceChunk(this.field_145850_b, new ChunkPos(this.field_174879_c));
                                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.OPEN_GATE, 0, false);
                                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_OPEN_SOUND, this.getOpenSoundDelay()));
                                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks + 19 + this.getTicksPerHorizonSegment(true)));
                                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_WIDEN, EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks + 23 + this.getTicksPerHorizonSegment(true)));
                                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ENGAGE));
                                            this.sendSignal(null, "stargate_open", false);
                                            this.activateDHDSymbolBRB();
                                            this.func_70296_d();
                                            JSG.debug(RIG_PREFIX + "Opening!");
                                            this.isFinalActive = true;
                                        } else {
                                            this.resetRandomIncoming();
                                        }
                                    } else if (this.randomIncomingState < (float)(waitOpen + wait)) {
                                        this.randomIncomingState += 1.0f;
                                    } else if (this.randomIncomingState >= (float)(waitOpen + wait) && this.randomIncomingEntities > 0 && (this.stargateState == EnumStargateState.ENGAGED || this.stargateState == EnumStargateState.INCOMING)) {
                                        this.randomIncomingState += 1.0f;
                                        String[] entityListString = JSGConfig.Stargate.rig.entitiesToSpawn;
                                        ArrayList<Entity> entityList = new ArrayList<Entity>();
                                        for (String entityString : entityListString) {
                                            String[] entityTemporallyList = entityString.split(":");
                                            if (entityTemporallyList.length < 2) continue;
                                            String entityStringNew = entityTemporallyList[0].equals("minecraft") ? entityTemporallyList[1] : entityTemporallyList[0] + ":" + entityTemporallyList[1];
                                            ResourceLocation rlString = new ResourceLocation(entityStringNew);
                                            entityList.add(EntityList.func_188429_b((ResourceLocation)rlString, (World)this.field_145850_b));
                                        }
                                        int randomDelay = new Random().nextInt(16);
                                        if (randomDelay <= 0) {
                                            randomDelay = 1;
                                        }
                                        if (this.randomIncomingState % (float)(5 * randomDelay) == 0.0f) {
                                            int randomEntity;
                                            --this.randomIncomingEntities;
                                            int posX = this.getGateCenterPos().func_177958_n();
                                            int posY = this.getGateCenterPos().func_177956_o();
                                            int posZ = this.getGateCenterPos().func_177952_p();
                                            EntityZombie mobEntity = new EntityZombie(this.field_145850_b);
                                            int entitiesLength = entityList.size();
                                            if (entitiesLength > 0 && entityList.get(randomEntity = rand.nextInt(entitiesLength)) != null) {
                                                mobEntity = (Entity)entityList.get(randomEntity);
                                            }
                                            mobEntity.func_70012_b((double)posX, (double)posY, (double)posZ, 0.0f, 0.0f);
                                            if (this.isIrisOpened() || this.irisType.equals((Object)EnumIrisType.NULL)) {
                                                this.field_145850_b.func_72838_d((Entity)mobEntity);
                                                JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.WORMHOLE_GO);
                                                JSG.debug(RIG_PREFIX + "Spawned " + mobEntity.func_70005_c_());
                                            } else {
                                                if (this.isPhysicalIris()) {
                                                    JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.IRIS_HIT);
                                                } else if (this.isShieldIris()) {
                                                    JSGSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.SHIELD_HIT);
                                                }
                                                JSGAdvancementsUtil.tryTriggerRangedAdvancement(this, JSGAdvancementsUtil.EnumAdvancementType.IRIS_IMPACT);
                                                ItemStack irisItem = this.getItemHandler().getStackInSlot(11);
                                                if (irisItem.func_77973_b() instanceof IrisItem) {
                                                    int chance = EnchantmentHelper.func_82781_a((ItemStack)irisItem).containsKey(Enchantments.field_185307_s) ? JSGConfig.Stargate.iris.unbreakingChance * EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)irisItem) : 0;
                                                    int random = rand.nextInt(100);
                                                    if (random > chance) {
                                                        JSGItems.UPGRADE_IRIS.setDamage(irisItem, JSGItems.UPGRADE_IRIS.getDamage(irisItem) + 1);
                                                    }
                                                    if (irisItem.func_190916_E() == 0) {
                                                        this.updateIrisType();
                                                    }
                                                } else {
                                                    IEnergyStorage energyStorage = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null);
                                                    if (energyStorage != null) {
                                                        energyStorage.extractEnergy(500, false);
                                                    }
                                                }
                                                JSG.debug(RIG_PREFIX + mobEntity.func_70005_c_() + " hit iris!");
                                                this.sendSignal(null, "stargate_event_iris_hit", "Something just hit the IRIS!");
                                            }
                                        }
                                    } else if (this.randomIncomingEntities <= 0 && this.randomIncomingState >= (float)(waitOpen + wait) || this.stargateState != EnumStargateState.ENGAGED) {
                                        this.resetRandomIncoming();
                                        this.attemptClose(StargateClosedReasonEnum.AUTOCLOSE);
                                        JSG.debug(RIG_PREFIX + "Closed!!!");
                                        this.clearDHDSymbols();
                                    }
                                    this.func_70296_d();
                                } else {
                                    this.resetRandomIncoming();
                                }
                            }
                        }
                        this.extractEnergyByShield(0);
                        if (!this.field_145850_b.field_72995_K && this.isShieldIris()) {
                            this.shieldKeepAlive = JSGConfig.Stargate.iris.shieldPowerDraw;
                            this.shieldKeepAlive = (int)((double)this.shieldKeepAlive + this.irisHeat * (this.irisHeat / IRIS_MAX_HEAT_TRINIUM));
                            if (this.isIrisClosed()) {
                                this.extractEnergyByShield(this.shieldKeepAlive);
                            }
                            if (this.getEnergyStorage().getEnergyStored() < this.shieldKeepAlive) {
                                this.toggleIris();
                                this.sendSignal(null, "stargate_iris_out_of_power", "Shield runs out of power! Opening shield...");
                            } else if (this.irisMode == EnumIrisMode.CLOSED && this.isIrisOpened()) {
                                this.toggleIris();
                            }
                        }
                        super.func_73660_a();
                        if (this.field_145850_b.field_72995_K) break block73;
                        if (!this.lastPos.equals((Object)this.field_174879_c)) {
                            this.lastPos = this.field_174879_c;
                            this.generateAddresses(!this.hasUpgrade(StargateUpgradeEnum.CHEVRON_UPGRADE));
                            if (this.isMerged()) {
                                this.updateMergeState(this.onGateMergeRequested(), this.facing, this.facingVertical);
                            }
                        }
                        if (this.givePageTask != null && this.givePageTask.update(this.field_145850_b.func_82737_E())) {
                            this.givePageTask = null;
                        }
                        if (!this.doPageProgress) break block74;
                        if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                            this.pageProgress = (short)(this.pageProgress + 1);
                            if (this.pageProgress > 18) {
                                this.pageProgress = 0;
                                this.doPageProgress = false;
                            }
                        }
                        if (!this.itemStackHandler.getStackInSlot(this.pageSlotId).func_190926_b()) break block75;
                        this.lockPage = false;
                        this.doPageProgress = false;
                        this.pageProgress = 0;
                        this.givePageTask = null;
                        break block75;
                    }
                    if (this.lockPage && this.itemStackHandler.getStackInSlot(this.pageSlotId).func_190926_b()) {
                        this.lockPage = false;
                    }
                    if (!this.lockPage) {
                        for (int i = 7; i < 10; ++i) {
                            if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
                            this.doPageProgress = true;
                            this.lockPage = true;
                            this.pageSlotId = i;
                            this.givePageTask = new ScheduledTask(EnumScheduledTask.STARGATE_GIVE_PAGE, 36);
                            this.givePageTask.setTaskCreated(this.field_145850_b.func_82737_E());
                            this.givePageTask.setExecutor(this);
                            break;
                        }
                    }
                }
                if (!this.isIrisClosed() && !this.isIrisOpened() && this.field_145850_b.func_82737_E() - this.irisAnimation > (long)(this.isPhysicalIris() ? 60 : 10)) {
                    switch (this.irisState) {
                        case OPENING: {
                            this.irisState = EnumIrisState.OPENED;
                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.irisType, this.irisState, this.irisAnimation);
                            if (this.afterIrisDone != null) {
                                this.afterIrisDone.run();
                            }
                            this.afterIrisDone = null;
                            this.sendSignal(null, "stargate_iris_opened", "Iris is opened");
                            break;
                        }
                        case CLOSING: {
                            this.irisState = EnumIrisState.CLOSED;
                            this.setIrisBlocks(true);
                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.irisType, this.irisState, this.irisAnimation);
                            if (this.afterIrisDone != null) {
                                this.afterIrisDone.run();
                            }
                            this.afterIrisDone = null;
                            this.sendSignal(null, "stargate_iris_closed", "Iris is closed");
                            break;
                        }
                    }
                    this.func_70296_d();
                }
                break block76;
            }
            if (this.field_145850_b.func_82737_E() % 40L == 0L && this.rendererStateClient != null && this.getRendererStateClient().biomeOverride == null) {
                this.rendererStateClient.setBiomeOverlay(this.getBiomeOverlayWithOverride(false));
            }
        }
    }

    @Override
    protected void kawooshDestruction() {
        if (!this.isIrisClosed() || this.irisType == EnumIrisType.NULL) {
            super.kawooshDestruction();
        }
    }

    private BiomeOverlayEnum determineBiomeOverride() {
        ItemStack stack = this.itemStackHandler.getStackInSlot(10);
        if (stack.func_190926_b()) {
            return null;
        }
        BiomeOverlayEnum biomeOverlay = JSGConfigUtil.getBiomeOverrideItemMetaPairs().get(new ItemMetaPair(stack));
        if (this.getSupportedOverlays().contains((Object)biomeOverlay)) {
            return biomeOverlay;
        }
        return null;
    }

    @Override
    public BiomeOverlayEnum getBiomeOverlayWithOverride(boolean override) {
        BiomeOverlayEnum overlay = null;
        if (override) {
            overlay = this.determineBiomeOverride();
        }
        if (overlay == null) {
            return super.getBiomeOverlayWithOverride(override);
        }
        return overlay;
    }

    @Override
    protected boolean shouldAutoclose() {
        boolean beamerActive = false;
        for (BlockPos beamerPos : this.linkedBeamers) {
            if (this.field_145850_b.func_175625_s(beamerPos) != null) {
                BeamerTile beamerTile = (BeamerTile)this.field_145850_b.func_175625_s(beamerPos);
                beamerActive = beamerTile.isActive();
            }
            if (!beamerActive) continue;
            break;
        }
        return !beamerActive && super.shouldAutoclose();
    }

    @Override
    protected boolean canAddSymbolInternal(SymbolInterface symbol) {
        if (this.isFinalActive) {
            return false;
        }
        return super.canAddSymbolInternal(symbol);
    }

    protected void func_190201_b(World world) {
        this.func_145834_a(world);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("stargateSize", this.stargateSize.id);
        compound.func_74782_a("itemHandler", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74757_a("isFinalActive", this.isFinalActive);
        compound.func_74757_a("isSpinning", this.isSpinning);
        compound.func_74772_a("spinStartTime", this.spinStartTime);
        compound.func_74768_a("currentRingSymbol", this.currentRingSymbol.getId());
        compound.func_74768_a("targetRingSymbol", this.targetRingSymbol.getId());
        compound.func_74768_a("spinDirection", this.spinDirection.id);
        NBTTagList linkedBeamersTagList = new NBTTagList();
        for (BlockPos vect : this.linkedBeamers) {
            linkedBeamersTagList.func_74742_a((NBTBase)new NBTTagLong(vect.func_177986_g()));
        }
        compound.func_74782_a("linkedBeamers", (NBTBase)linkedBeamersTagList);
        if (this.irisState == null) {
            if (this.codeSender != null) {
                this.codeSender.sendMessage((TextComponentBase)GDOMessages.OPENED.textComponent);
                this.codeSender = null;
            }
            this.irisState = EnumIrisState.OPENED;
        }
        compound.func_74774_a("irisState", this.irisState.id);
        compound.func_74768_a("irisCode", this.irisCode);
        compound.func_74774_a("irisMode", this.irisMode.id);
        if (this.codeSender != null && !this.field_145850_b.field_72995_K) {
            compound.func_74782_a("codeSender", (NBTBase)this.codeSender.serializeNBT());
        }
        compound.func_74768_a("incomingLastChevronLightUp", this.incomingLastChevronLightUp);
        compound.func_74768_a("incomingPeriod", this.incomingPeriod);
        compound.func_74768_a("incomingAddressSize", this.incomingAddressSize);
        compound.func_74782_a("config", (NBTBase)this.getConfig().serializeNBT());
        compound.func_74780_a("irisHeat", this.irisHeat);
        compound.func_74780_a("lastIrisHeat", this.lastIrisHeat);
        compound.func_74780_a("gateHeat", this.gateHeat);
        compound.func_74780_a("lastGateHeat", this.lastGateHeat);
        compound.func_74757_a("fastDialing", this.isFastDialing);
        compound.func_74768_a("facingVertical", FacingHelper.toInt(this.facingVertical));
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.stargateSize = compound.func_74764_b("patternVersion") ? StargateSizeEnum.SMALL : (compound.func_74764_b("stargateSize") ? StargateSizeEnum.fromId(compound.func_74762_e("stargateSize")) : JSGConfig.Stargate.stargateSize);
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("itemHandler"));
        this.isFinalActive = compound.func_74767_n("isFinalActive");
        this.isSpinning = compound.func_74767_n("isSpinning");
        this.spinStartTime = compound.func_74763_f("spinStartTime");
        this.currentRingSymbol = this.getSymbolType().valueOfSymbol(compound.func_74762_e("currentRingSymbol"));
        this.targetRingSymbol = this.getSymbolType().valueOfSymbol(compound.func_74762_e("targetRingSymbol"));
        this.spinDirection = EnumSpinDirection.valueOf(compound.func_74762_e("spinDirection"));
        for (NBTBase tag : compound.func_150295_c("linkedBeamers", 4)) {
            this.linkedBeamers.add(BlockPos.func_177969_a((long)((NBTTagLong)tag).func_150291_c()));
        }
        this.irisState = EnumIrisState.getValue(compound.func_74771_c("irisState"));
        this.irisCode = compound.func_74762_e("irisCode") != 0 ? compound.func_74762_e("irisCode") : -1;
        this.irisMode = EnumIrisMode.getValue(compound.func_74771_c("irisMode"));
        if (compound.func_74764_b("codeSender") && !this.field_145850_b.field_72995_K) {
            NBTTagCompound nbt = compound.func_74775_l("codeSender");
            this.codeSender = this.codeSenderFromNBT(nbt);
        }
        this.incomingPeriod = compound.func_74762_e("incomingPeriod");
        this.incomingLastChevronLightUp = compound.func_74762_e("incomingLastChevronLightUp");
        this.incomingAddressSize = compound.func_74762_e("incomingAddressSize");
        this.getConfig().deserializeNBT(compound.func_74775_l("config"));
        this.irisHeat = compound.func_74769_h("irisHeat");
        this.lastIrisHeat = compound.func_74769_h("lastIrisHeat");
        this.gateHeat = compound.func_74769_h("gateHeat");
        this.lastGateHeat = compound.func_74769_h("lastGateHeat");
        this.isFastDialing = compound.func_74767_n("fastDialing");
        this.facingVertical = FacingHelper.fromInt(compound.func_74762_e("facingVertical"));
        super.func_145839_a(compound);
    }

    private CodeSender codeSenderFromNBT(NBTTagCompound compound) {
        this.codeSender = CodeSenderType.fromId((int)compound.func_74762_e((String)"type")).constructor.get();
        switch (this.codeSender.getType()) {
            case PLAYER: {
                this.codeSender.prepareToLoad(new Object[]{this.field_145850_b});
                break;
            }
            case COMPUTER: {
                this.codeSender.prepareToLoad(null);
            }
        }
        this.codeSender.deserializeNBT((NBTBase)compound);
        return this.codeSender;
    }

    @Override
    public JSGTileEntityConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(JSGTileEntityConfig config) {
        for (JSGConfigOption o : config.getOptions()) {
            this.config.getOption(o.id).setValue(o.getStringValue());
        }
        this.func_70296_d();
    }

    @Override
    public void setConfigAndUpdate(JSGTileEntityConfig config) {
        this.setConfig(config);
        this.sendState(StateTypeEnum.GUI_STATE, this.getState(StateTypeEnum.GUI_STATE));
    }

    @Override
    public void initConfig() {
        JSGConfigOption o = this.getConfig().getOption(ConfigOptions.CAPACITORS_COUNT.id, true);
        int caps = o == null || o.defaultValue.equals(o.getStringValue()) ? this.getDefaultCapacitors() : o.getIntValue();
        JSGTileEntityConfig.initConfig(this.getConfig(), ConfigOptions.values());
        this.getConfig().getOption(ConfigOptions.CAPACITORS_COUNT.id).setDefaultValue(this.getDefaultCapacitors() + "").setValue(caps + "");
        this.func_70296_d();
    }

    protected void updateChevronLight(int lightUp, boolean isFinalActive) {
        if (isFinalActive) {
            --lightUp;
        }
        for (int i = 0; i < 9; ++i) {
            StargateClassicMemberTile memberTile;
            BlockPos chevPos = FacingHelper.rotateBlock(this.getMergeHelper().getChevronBlocks().get(i), this.facing, this.facingVertical).func_177971_a((Vec3i)this.field_174879_c);
            if (!this.getMergeHelper().matchMember(this.field_145850_b.func_180495_p(chevPos)) || (memberTile = (StargateClassicMemberTile)this.field_145850_b.func_175625_s(chevPos)) == null) continue;
            memberTile.setLitUp(i == 8 ? isFinalActive : lightUp > i);
        }
    }

    @Override
    protected StargateClassicRendererState.StargateClassicRendererStateBuilder getRendererStateServer() {
        return new StargateClassicRendererState.StargateClassicRendererStateBuilder(super.getRendererStateServer()).setSymbolType(this.getSymbolType()).setActiveChevrons(this.dialedAddress.size()).setFinalActive(this.isFinalActive).setCurrentRingSymbol(this.currentRingSymbol).setSpinDirection(this.spinDirection).setSpinning(this.isSpinning).setTargetRingSymbol(this.targetRingSymbol).setSpinStartTime(this.spinStartTime).setBiomeOverride(this.determineBiomeOverride()).setIrisState(this.irisState).setIrisType(this.irisType).setIrisMode(this.irisMode).setIrisCode(this.irisCode).setIrisAnimation(this.irisAnimation);
    }

    @Override
    public StargateClassicRendererState getRendererStateClient() {
        return (StargateClassicRendererState)super.getRendererStateClient();
    }

    @Override
    protected JSGAxisAlignedBB getRenderBoundingBoxRaw() {
        if (this.getStargateSize() == StargateSizeEnum.EXTRA_LARGE) {
            return RENDER_BOX_LARGE;
        }
        return RENDER_BOX;
    }

    protected long getSpinStartOffset() {
        return 0L;
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_STATE: {
                return new StargateContainerGuiState(this.gateAddressMap, this.getConfig());
            }
            case GUI_UPDATE: {
                return new StargateContainerGuiUpdate(this.energyStorage.getEnergyStoredInternally(), this.energyTransferedLastTick, this.energySecondsToClose, this.irisMode, this.irisCode, this.openedSince, this.gateHeat, this.irisHeat);
            }
        }
        return super.getState(stateType);
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_STATE: {
                return new StargateContainerGuiState();
            }
            case GUI_UPDATE: {
                return new StargateContainerGuiUpdate();
            }
            case SPIN_STATE: {
                return new StargateSpinState();
            }
            case BIOME_OVERRIDE_STATE: {
                return new StargateBiomeOverrideState();
            }
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        block0 : switch (stateType) {
            case RENDERER_UPDATE: {
                if (this.getRendererStateClient() == null) break;
                StargateRendererActionState gateActionState = (StargateRendererActionState)state;
                switch (gateActionState.action) {
                    case CHEVRON_ACTIVATE: {
                        if (gateActionState.modifyFinal) {
                            this.getRendererStateClient().chevronTextureList.activateFinalChevron(this.field_145850_b.func_82737_E());
                            break block0;
                        }
                        this.getRendererStateClient().chevronTextureList.activateNextChevron(this.field_145850_b.func_82737_E(), gateActionState.chevronCount);
                        break block0;
                    }
                    case CLEAR_CHEVRONS: {
                        this.getRendererStateClient().clearChevrons(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                    case LIGHT_UP_CHEVRONS: {
                        this.getRendererStateClient().chevronTextureList.lightUpChevrons(this.field_145850_b.func_82737_E(), gateActionState.chevronCount);
                        break block0;
                    }
                    case CHEVRON_ACTIVATE_BOTH: {
                        this.getRendererStateClient().chevronTextureList.activateNextChevron(this.field_145850_b.func_82737_E());
                        this.getRendererStateClient().chevronTextureList.activateFinalChevron(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                    case CHEVRON_DIM: {
                        this.getRendererStateClient().chevronTextureList.deactivateFinalChevron(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                    case IRIS_UPDATE: {
                        this.getRendererStateClient().irisState = gateActionState.irisState;
                        this.getRendererStateClient().irisType = gateActionState.irisType;
                        if (gateActionState.irisState != EnumIrisState.CLOSING && gateActionState.irisState != EnumIrisState.OPENING) break block0;
                        this.getRendererStateClient().irisAnimation = this.field_145850_b.func_82737_E();
                        break block0;
                    }
                    case HEAT_UPDATE: {
                        this.getRendererStateClient().irisHeat = gateActionState.irisHeat;
                        this.getRendererStateClient().gateHeat = gateActionState.gateHeat;
                        this.irisHeat = gateActionState.irisHeat;
                        this.gateHeat = gateActionState.gateHeat;
                        this.func_70296_d();
                        break block0;
                    }
                }
                break;
            }
            case GUI_STATE: {
                StargateContainerGuiState guiState = (StargateContainerGuiState)state;
                this.gateAddressMap = guiState.gateAdddressMap;
                this.config = guiState.config;
                this.func_70296_d();
                break;
            }
            case GUI_UPDATE: {
                StargateContainerGuiUpdate guiUpdate = (StargateContainerGuiUpdate)state;
                this.energyStorage.setEnergyStoredInternally(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.transferedLastTick;
                this.energySecondsToClose = guiUpdate.secondsToClose;
                this.irisMode = guiUpdate.irisMode;
                this.irisCode = guiUpdate.irisCode;
                this.openedSince = guiUpdate.openedSince;
                this.gateHeat = guiUpdate.gateTemp;
                this.irisHeat = guiUpdate.irisTemp;
                this.func_70296_d();
                break;
            }
            case SPIN_STATE: {
                if (this.getRendererStateClient() == null) break;
                StargateSpinState spinState = (StargateSpinState)state;
                if (spinState.setOnly) {
                    this.getRendererStateClient().spinHelper.setIsSpinning(false);
                    this.getRendererStateClient().spinHelper.setCurrentSymbol(spinState.targetSymbol);
                    break;
                }
                int speed = this.getConfig().getOption(ConfigOptions.STARGATE_SPIN_SPEED.id).getIntValue();
                this.getRendererStateClient().spinHelper.initRotation((float)speed / 100.0f, this.field_145850_b.func_82737_E(), spinState.targetSymbol, spinState.direction, this.getSpinStartOffset(), spinState.plusRounds);
                break;
            }
            case BIOME_OVERRIDE_STATE: {
                StargateBiomeOverrideState overrideState = (StargateBiomeOverrideState)state;
                if (this.rendererStateClient == null) break;
                this.getRendererStateClient().biomeOverride = overrideState.biomeOverride;
                break;
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        boolean fastDial = false;
        boolean onlySpin = false;
        if (customData != null) {
            if (customData.func_74764_b("fastDial")) {
                fastDial = customData.func_74767_n("fastDial");
            }
            if (customData.func_74764_b("onlySpin")) {
                onlySpin = customData.func_74767_n("onlySpin");
            }
        }
        switch (scheduledTask) {
            case STARGATE_HORIZON_LIGHT_BLOCK: {
                if (this.irisType == EnumIrisType.NULL || this.irisType == EnumIrisType.SHIELD || !this.isIrisClosed()) {
                    super.executeTask(scheduledTask, customData);
                    break;
                }
                if (!this.isIrisClosed()) break;
                this.field_145850_b.func_180495_p(this.getGateCenterPos()).func_177230_c().func_149715_a(0.7f);
                break;
            }
            case STARGATE_CLOSE: {
                if (this.irisType == EnumIrisType.NULL || !this.isIrisClosed()) {
                    super.executeTask(scheduledTask, customData);
                    break;
                }
                if (!this.isIrisClosed()) break;
                this.field_145850_b.func_180495_p(this.getGateCenterPos()).func_177230_c().func_149715_a(0.0f);
                this.disconnectGate();
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                this.lastSpinFinishedIn = this.field_145850_b.func_82737_E();
                if (fastDial) break;
                this.isSpinning = false;
                this.currentRingSymbol = this.targetRingSymbol;
                if (!(this instanceof StargatePegasusBaseTile) || !((StargatePegasusBaseTile)this).continueDialing) {
                    this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                }
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, false);
                this.func_70296_d();
                break;
            }
            case STARGATE_GIVE_PAGE: {
                SymbolTypeEnum symbolType = SymbolTypeEnum.valueOf(this.pageSlotId - 7);
                ItemStack stack = this.itemStackHandler.getStackInSlot(this.pageSlotId);
                if (stack.func_77973_b() == JSGItems.UNIVERSE_DIALER) {
                    NBTTagList saved = stack.func_77978_p().func_150295_c("saved", 10);
                    NBTTagCompound compound = ((StargateAddress)this.gateAddressMap.get(symbolType)).serializeNBT();
                    compound.func_74757_a("hasUpgrade", this.hasUpgrade(StargateUpgradeEnum.CHEVRON_UPGRADE));
                    this.setOriginId(compound);
                    saved.func_74742_a((NBTBase)compound);
                    break;
                }
                JSG.debug("Giving Notebook page of address " + symbolType);
                NBTTagCompound compound = PageNotebookItem.getCompoundFromAddress((StargateAddress)this.gateAddressMap.get(symbolType), this.hasUpgrade(StargateUpgradeEnum.CHEVRON_UPGRADE), PageNotebookItem.getRegistryPathFromWorld(this.field_145850_b, this.field_174879_c), this.getOriginId());
                stack = new ItemStack((Item)JSGItems.PAGE_NOTEBOOK_ITEM, 1, 1);
                stack.func_77982_d(compound);
                this.itemStackHandler.setStackInSlot(this.pageSlotId, stack);
                break;
            }
            case GATE_RING_ROLL: {
                if (this.stargateState.idle() && !onlySpin) break;
                this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, true);
                break;
            }
            default: {
                super.executeTask(scheduledTask, customData);
            }
        }
    }

    public static int getOriginId(BiomeOverlayEnum overlay, int dimId, int configOrigin) {
        int override;
        if (configOrigin >= 0) {
            return configOrigin;
        }
        if (overlay == null) {
            overlay = BiomeOverlayEnum.NORMAL;
        }
        if ((override = StargateDimensionConfig.getOrigin(DimensionManager.getProviderType((int)dimId), overlay)) >= 0) {
            return override;
        }
        switch (overlay) {
            case FROST: {
                return 3;
            }
            case AGED: {
                return 4;
            }
            case SOOTY: {
                return 2;
            }
            case NORMAL: {
                if (dimId == 0) {
                    return 5;
                }
                return 0;
            }
        }
        return 0;
    }

    public int getOriginId() {
        return StargateClassicBaseTile.getOriginId(this.getBiomeOverlayWithOverride(true), this.getFakeWorld().field_73011_w.getDimension(), this.getConfig().getOption(ConfigOptions.ORIGIN_MODEL.id).getEnumValue().getIntValue());
    }

    public void setOriginId(NBTTagCompound compound) {
        compound.func_74768_a("originId", this.getOriginId());
    }

    public void addSymbolToAddressManual(SymbolInterface targetSymbol, @Nullable Object context) {
        int soundSpinWait = 5;
        if (this instanceof StargateUniverseBaseTile) {
            soundSpinWait = 10;
        }
        this.targetRingSymbol = targetSymbol;
        boolean moveOnly = this.targetRingSymbol == this.currentRingSymbol;
        int plusRounds = 0;
        this.spinDirection = this.spinDirection.opposite();
        float distance = this.spinDirection.getDistance(this.currentRingSymbol, this.targetRingSymbol);
        if (moveOnly) {
            ++plusRounds;
        }
        if (!JSGConfig.Stargate.visual.fasterMWGateDial) {
            if (distance < 90.0f && plusRounds == 0) {
                ++plusRounds;
            }
            if (distance < 270.0f && plusRounds == 0 && this.getConfig().getOption(ConfigOptions.ALLOW_INCOMING.id).getBooleanValue() && this.targetRingSymbol == this.targetRingSymbol.getSymbolType().getOrigin()) {
                ++plusRounds;
            }
        } else if (distance > 180.0f) {
            this.spinDirection = this.spinDirection.opposite();
            distance = this.spinDirection.getDistance(this.currentRingSymbol, this.targetRingSymbol);
            plusRounds = 0;
        }
        float speedFactor = (float)this.getConfig().getOption(ConfigOptions.STARGATE_SPIN_SPEED.id).getIntValue() / 100.0f;
        int duration = StargateClassicSpinHelper.getAnimationDuration(speedFactor, distance += (float)(plusRounds * 360));
        this.doIncomingAnimation(duration, true, this.targetRingSymbol);
        this.sendState(StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, plusRounds));
        this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 5);
        this.addTask(this.lastSpinFinished);
        this.addTask(new ScheduledTask(EnumScheduledTask.GATE_RING_ROLL, soundSpinWait));
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, true);
        this.isSpinning = true;
        this.spinStartTime = this.field_145850_b.func_82737_E();
        this.ringSpinContext = context;
        if (context != null) {
            this.sendSignal(context, "stargate_spin_start", this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), targetSymbol.getEnglishName());
        }
        this.func_70296_d();
    }

    public void spinRing(int rounds, boolean changeState, boolean findNearest, int time) {
        if (time < 0) {
            time *= -1;
        }
        time -= 20;
        this.targetRingSymbol = this.currentRingSymbol;
        this.spinDirection = EnumSpinDirection.CLOCKWISE;
        if (changeState) {
            this.stargateState = EnumStargateState.DIALING_COMPUTER;
        }
        if (rounds == 0) {
            rounds = 1;
        }
        if (rounds < 0) {
            this.spinDirection = EnumSpinDirection.COUNTER_CLOCKWISE;
            rounds *= -1;
        }
        float speedFactor = (float)this.getConfig().getOption(ConfigOptions.STARGATE_SPIN_SPEED.id).getIntValue() / 100.0f;
        float distance = 360 * rounds;
        if (findNearest) {
            rounds = 0;
            float currentAngle = this.currentRingSymbol.getAngle();
            float angle = StargateClassicSpinHelper.getAnimationDistance(speedFactor, time);
            if (angle > 360.0f) {
                rounds = (int)Math.floor(angle / 360.0f);
                angle -= (float)(rounds * 360);
            }
            float finalAngle = currentAngle - angle;
            if (this.spinDirection == EnumSpinDirection.CLOCKWISE) {
                finalAngle = angle + currentAngle;
            }
            if (finalAngle > 360.0f) {
                finalAngle -= 360.0f;
            } else if (finalAngle < 0.0f) {
                finalAngle += 360.0f;
            }
            if (finalAngle < 15.0f && rounds == 0) {
                finalAngle += 15.0f;
            }
            float nearestAngle = this.getSymbolType().getAngleOfNearest(finalAngle);
            this.targetRingSymbol = this.getSymbolType().getSymbolByAngle(nearestAngle);
            distance = this.spinDirection.getDistance(this.currentRingSymbol, this.targetRingSymbol);
            distance += (float)(360 * rounds);
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("onlySpin", true);
        int duration = StargateClassicSpinHelper.getAnimationDuration(speedFactor, distance);
        if (this.targetPoint != null) {
            this.sendState(StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, rounds));
        }
        if (this.stargateState.incoming()) {
            this.stargateState = EnumStargateState.INCOMING;
            this.func_70296_d();
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 5, compound));
        } else {
            this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 5, compound);
            this.addTask(this.lastSpinFinished);
        }
        this.addTask(new ScheduledTask(EnumScheduledTask.GATE_RING_ROLL, 5));
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, true);
        this.isSpinning = true;
        this.spinStartTime = this.field_145850_b.func_82737_E();
        this.ringSpinContext = null;
        this.sendSignal(null, "stargate_spin_start", this.dialedAddress.size(), false, this.targetRingSymbol.getEnglishName());
        this.func_70296_d();
    }

    public short getPageProgress() {
        return this.pageProgress;
    }

    public void setPageProgress(int pageProgress) {
        this.pageProgress = (short)pageProgress;
    }

    public int getSupportedCapacitors() {
        return this.getConfig().getOption(ConfigOptions.CAPACITORS_COUNT.id).getIntValue();
    }

    public abstract int getDefaultCapacitors();

    public boolean canInsertItemAsIris(Item item) {
        return StargateIrisUpgradeEnum.contains(item);
    }

    public void updateIrisType() {
        this.updateIrisType(true);
    }

    public void updateIrisType(boolean markDirty) {
        this.irisType = EnumIrisType.byItem(this.itemStackHandler.getStackInSlot(11).func_77973_b());
        this.irisAnimation = this.func_145831_w().func_82737_E();
        if (this.irisType == EnumIrisType.NULL) {
            this.irisState = EnumIrisState.OPENED;
        }
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.irisType, this.irisState, this.irisAnimation);
        this.updateIrisDurability();
        if (markDirty) {
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K && this.isIrisOpened()) {
            this.setIrisBlocks(false);
        }
    }

    public void updateIrisDurability() {
        this.irisDurability = 0;
        this.irisMaxDurability = 0;
        if (this.isPhysicalIris()) {
            this.irisMaxDurability = this.irisType == EnumIrisType.IRIS_TITANIUM ? JSGConfig.Stargate.iris.titaniumIrisDurability : JSGConfig.Stargate.iris.triniumIrisDurability;
            this.irisDurability = this.irisMaxDurability - this.itemStackHandler.getStackInSlot(11).func_77973_b().getDamage(this.itemStackHandler.getStackInSlot(11));
        }
    }

    public EnumIrisType getIrisType() {
        return this.irisType;
    }

    public EnumIrisState getIrisState() {
        return this.irisState;
    }

    public boolean isIrisClosed() {
        return this.irisState == EnumIrisState.CLOSED;
    }

    public boolean isIrisOpened() {
        return this.irisState == EnumIrisState.OPENED;
    }

    public boolean isPhysicalIris() {
        switch (this.irisType) {
            case IRIS_TITANIUM: 
            case IRIS_TRINIUM: {
                return true;
            }
        }
        return false;
    }

    public boolean hasIris() {
        return this.irisType != EnumIrisType.NULL;
    }

    public boolean isShieldIris() {
        return this.irisType == EnumIrisType.SHIELD;
    }

    public boolean toggleIris() {
        SoundEventEnum closeSound;
        SoundEventEnum openSound;
        if (this.irisType == EnumIrisType.NULL) {
            return false;
        }
        if (this.isIrisClosed() || this.isIrisOpened()) {
            this.irisAnimation = this.func_145831_w().func_82737_E();
        }
        if (this.isPhysicalIris()) {
            openSound = SoundEventEnum.IRIS_OPENING;
            closeSound = SoundEventEnum.IRIS_CLOSING;
        } else {
            openSound = SoundEventEnum.SHIELD_OPENING;
            closeSound = SoundEventEnum.SHIELD_CLOSING;
        }
        switch (this.irisState) {
            case OPENED: {
                if (this.isShieldIris() && this.getEnergyStorage().getEnergyStored() < this.shieldKeepAlive * 3) {
                    return false;
                }
                this.irisState = EnumIrisState.CLOSING;
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, true, this.irisType, this.irisState, this.irisAnimation);
                this.sendSignal(null, "stargate_iris_closing", "Iris is closing");
                this.func_70296_d();
                this.playSoundEvent(closeSound);
                if (this.targetGatePos == null) break;
                this.executeTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, null);
                break;
            }
            case CLOSED: {
                this.irisState = EnumIrisState.OPENING;
                this.setIrisBlocks(false);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, true, this.irisType, this.irisState, this.irisAnimation);
                this.sendSignal(null, "stargate_iris_opening", "Iris is opening");
                this.func_70296_d();
                this.playSoundEvent(openSound);
                if (this.targetGatePos == null) break;
                this.executeTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, null);
                break;
            }
            default: {
                return false;
            }
        }
        this.func_70296_d();
        return true;
    }

    public boolean receiveIrisCode(CodeSender sender, int code) {
        this.sendSignal(null, "received_code", code);
        if (this.irisMode != EnumIrisMode.AUTO) {
            sender.sendMessage((TextComponentBase)GDOMessages.SEND_TO_COMPUTER.textComponent);
            this.codeSender = sender;
            return false;
        }
        if (code == this.irisCode) {
            switch (this.irisState) {
                case OPENED: {
                    sender.sendMessage((TextComponentBase)GDOMessages.OPENED.textComponent);
                    break;
                }
                case CLOSED: {
                    sender.sendMessage((TextComponentBase)GDOMessages.CODE_ACCEPTED.textComponent);
                    this.codeSender = sender;
                    this.toggleIris();
                    break;
                }
                case OPENING: 
                case CLOSING: {
                    sender.sendMessage((TextComponentBase)GDOMessages.BUSY.textComponent);
                    break;
                }
            }
        } else {
            sender.sendMessage((TextComponentBase)GDOMessages.CODE_REJECTED.textComponent);
            return false;
        }
        this.func_70296_d();
        return true;
    }

    public void setIrisCode(int code) {
        this.irisCode = code;
        this.func_70296_d();
    }

    public void setIrisMode(EnumIrisMode irisMode) {
        if (this.irisMode != irisMode && this.hasIris()) {
            switch (irisMode) {
                case OPENED: 
                case CLOSED: {
                    this.irisModeAction(irisMode);
                    break;
                }
                case AUTO: {
                    if (this.getStargateState().engaged()) {
                        if (this.irisState != EnumIrisState.OPENED) break;
                        this.toggleIris();
                        break;
                    }
                    if (!this.isIrisClosed()) break;
                    this.toggleIris();
                    break;
                }
            }
        }
        this.irisMode = irisMode;
        this.func_70296_d();
    }

    private void irisModeAction(EnumIrisMode mode) {
        EnumIrisState p2;
        EnumIrisState p;
        if (mode == EnumIrisMode.OPENED) {
            p = EnumIrisState.CLOSED;
            p2 = EnumIrisState.CLOSING;
        } else if (mode == EnumIrisMode.CLOSED) {
            p = EnumIrisState.OPENED;
            p2 = EnumIrisState.OPENING;
        } else {
            return;
        }
        if (this.irisState == p) {
            this.toggleIris();
        } else if (this.irisState == p2) {
            this.afterIrisDone = this::toggleIris;
        }
    }

    public int getIrisCode() {
        return this.irisCode;
    }

    public EnumIrisMode getIrisMode() {
        return this.irisMode;
    }

    private void setIrisBlocks(boolean set) {
        IBlockState invBlockState = JSGBlocks.IRIS_BLOCK.func_176223_P();
        if (set) {
            invBlockState = JSGBlocks.IRIS_BLOCK.func_176203_a(this.getFacing().func_176736_b());
        }
        BlockPos startPos = this.field_174879_c;
        for (BlockPos invPos : Objects.requireNonNull(StargateSizeEnum.getIrisBlocksPattern(this.getStargateSize()))) {
            BlockPos newPos = startPos.func_177971_a((Vec3i)FacingHelper.rotateBlock(invPos, this.facing, this.facingVertical));
            if (set) {
                if (this.field_145850_b.func_180495_p(newPos).func_185904_a() != Material.field_151579_a) {
                    if (!JSGConfig.Stargate.iris.irisDestroysBlocks) continue;
                    this.field_145850_b.func_175655_b(newPos, true);
                }
                this.field_145850_b.func_180501_a(newPos, invBlockState, 3);
                if (newPos != this.getGateCenterPos() || this.targetGatePos == null) continue;
                this.field_145850_b.func_180495_p(newPos).func_177230_c().func_149715_a(1.0f);
                continue;
            }
            if (newPos == this.getGateCenterPos() && this.targetGatePos != null) {
                this.executeTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, null);
            }
            if (this.field_145850_b.func_180495_p(newPos).func_177230_c() != JSGBlocks.IRIS_BLOCK) continue;
            this.field_145850_b.func_175698_g(newPos);
        }
    }

    @Override
    public Iterator<Integer> getUpgradeSlotsIterator() {
        return UPGRADE_SLOTS_IDS.iterator();
    }

    @Override
    protected StargateAbstractEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getPowerTier() {
        return this.currentPowerTier;
    }

    private void updatePowerTier() {
        int i;
        int powerTier = 1;
        for (i = 4; i < 7; ++i) {
            if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
            ++powerTier;
        }
        if (powerTier != this.currentPowerTier) {
            this.currentPowerTier = powerTier;
            this.energyStorage.clearStorages();
            for (i = 4; i < 7; ++i) {
                ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                this.energyStorage.addStorage((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null));
            }
            JSG.debug("Updated to power tier: " + powerTier);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        return super.getCapability(capability, facing);
    }

    public void addLinkedBeamer(BlockPos pos) {
        if (this.stargateState.engaged()) {
            ((BeamerTile)Objects.requireNonNull(this.field_145850_b.func_175625_s(pos))).gateEngaged(this.targetGatePos);
        }
        this.linkedBeamers.add(pos.func_185334_h());
        this.func_70296_d();
    }

    public void removeLinkedBeamer(BlockPos pos) {
        this.linkedBeamers.remove(pos);
        this.func_70296_d();
    }

    private void updateBeamers() {
        if (this.stargateState.engaged()) {
            for (BlockPos beamerPos : this.linkedBeamers) {
                if (this.field_145850_b.func_175625_s(beamerPos) == null) continue;
                ((BeamerTile)Objects.requireNonNull(this.field_145850_b.func_175625_s(beamerPos))).gateEngaged(this.targetGatePos);
            }
        }
    }

    public World getFakeWorld() {
        return this.field_145850_b;
    }

    public void setFakeWorld(World world) {
    }

    public BlockPos getFakePos() {
        return this.field_174879_c;
    }

    public void setFakePos(BlockPos pos) {
    }

    public ArrayList<NearbyGate> getNearbyGates() {
        return this.getNearbyGates(null, false, true);
    }

    public ArrayList<NearbyGate> getNearbyGates(@Nullable SymbolTypeEnum gateType, boolean ignoreIfInstance, boolean checkAddressAndEnergy) {
        Class tileClass;
        if (gateType == null) {
            gateType = this.getSymbolType();
        }
        double squaredGate = (double)JSGConfig.Stargate.mechanics.universeGateNearbyReach * (double)JSGConfig.Stargate.mechanics.universeGateNearbyReach;
        ArrayList<NearbyGate> addresses = new ArrayList<NearbyGate>();
        switch (gateType) {
            case MILKYWAY: {
                tileClass = StargateMilkyWayBaseTile.class;
                break;
            }
            case UNIVERSE: {
                tileClass = StargateUniverseBaseTile.class;
                break;
            }
            case PEGASUS: {
                tileClass = StargatePegasusBaseTile.class;
                break;
            }
            default: {
                return addresses;
            }
        }
        for (Map.Entry<StargateAddress, StargatePos> entry : StargateNetwork.get(this.getFakeWorld()).getMap().get(gateType).entrySet()) {
            StargateClassicBaseTile classicTile;
            StargatePos stargatePos = entry.getValue();
            StargateAbstractBaseTile targetGateTile = stargatePos.getTileEntity();
            if (!(targetGateTile instanceof StargateClassicBaseTile) || !(classicTile = (StargateClassicBaseTile)targetGateTile).isMerged() || !ignoreIfInstance && !tileClass.isInstance(classicTile)) continue;
            int targetDim = classicTile.getFakeWorld().field_73011_w.getDimension();
            BlockPos targetFoundPos = classicTile.getFakePos();
            if (targetDim != this.getFakeWorld().field_73011_w.getDimension() || targetFoundPos.func_177951_i((Vec3i)this.getFakePos()) > squaredGate || stargatePos.gatePos.equals((Object)this.field_174879_c) && stargatePos.dimensionID == this.field_145850_b.field_73011_w.getDimension()) continue;
            int symbolsNeeded = this.getSymbolType().getMinimalSymbolCountTo(gateType, StargateDimensionConfig.isGroupEqual(DimensionManager.getProviderType((int)stargatePos.dimensionID), this.field_145850_b.field_73011_w.func_186058_p()));
            if (checkAddressAndEnergy) {
                StargateAddressDynamic addr3 = new StargateAddressDynamic(gateType);
                addr3.addAll(entry.getKey().subList(0, symbolsNeeded - 1));
                addr3.addSymbol(targetGateTile.getSymbolType().getOrigin());
                if (!this.checkAddressAndEnergy(addr3).ok()) continue;
                addresses.add(new NearbyGate(entry.getKey(), symbolsNeeded, targetGateTile.getSymbolType()));
                continue;
            }
            addresses.add(new NearbyGate(entry.getKey(), symbolsNeeded, targetGateTile.getSymbolType()));
        }
        return addresses;
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getOpenedTime(Context context, Arguments args) {
        if (this.stargateState.engaged()) {
            String secondsString;
            int minutes;
            float openedSeconds = this.getOpenedSeconds();
            int seconds = (int)(openedSeconds - (float)(60 * (minutes = (int)Math.floor(openedSeconds / 60.0f))));
            String string = secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
            if (openedSeconds > 0.0f) {
                return new Object[]{true, "stargate_time", "" + minutes, "" + secondsString};
            }
            return new Object[]{false, "stargate_not_connected"};
        }
        return new Object[]{false, "stargate_not_connected"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- close/open the iris/shield")
    public Object[] toggleIris(Context context, Arguments args) {
        if (this.irisType == EnumIrisType.NULL) {
            return new Object[]{false, "stargate_iris_missing", "Iris is not installed!"};
        }
        if (this.irisMode != EnumIrisMode.OC) {
            return new Object[]{false, "stargate_iris_error_mode", "Iris mode must be set to OC"};
        }
        boolean result = this.toggleIris();
        this.func_70296_d();
        if (!result && this.isShieldIris() && this.isIrisOpened() && this.getEnergyStorage().getEnergyStored() < this.shieldKeepAlive * 3) {
            return new Object[]{false, "stargate_iris_not_power", "Not enough power to close shield"};
        }
        if (!result) {
            return new Object[]{false, "stargate_iris_busy", "Iris is busy"};
        }
        return new Object[]{true};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- get info about iris")
    public Object[] getIrisState(Context context, Arguments args) {
        return new Object[]{this.irisState.toString()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- get info about iris")
    public Object[] getIrisType(Context context, Arguments args) {
        return new Object[]{this.irisType.toString()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- get info about iris")
    public Object[] getIrisDurability(Context context, Arguments args) {
        this.updateIrisDurability();
        return new Object[]{this.irisDurability + "/" + this.irisMaxDurability, this.irisDurability, this.irisMaxDurability};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(message:string) -- Sends message to last person, who sent code for iris")
    public Object[] sendMessageToIncoming(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!this.stargateState.engaged()) {
            return new Object[]{null, "stargate_failure_not_engaged", "Stargate is not engaged"};
        }
        if (!args.isString(0)) {
            return new Object[]{false, "wrong_argument_type"};
        }
        if (this.codeSender != null && this.codeSender.canReceiveMessage()) {
            this.codeSender.sendMessage((TextComponentBase)new TextComponentString(args.checkString(0)));
            return new Object[]{true, "success"};
        }
        return new Object[]{false, "no_listener_available"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(code:integer) -- send code like GDO")
    public Object[] sendIrisCode(Context context, Arguments args) {
        StargatePos destinationPos = StargateNetwork.get(this.field_145850_b).getStargate(this.dialedAddress);
        if (!args.isInteger(0)) {
            throw new IllegalArgumentException("code must be integer!");
        }
        if (destinationPos == null) {
            return new Object[]{false, "stargate_not_engaged"};
        }
        StargateAbstractBaseTile te = destinationPos.getTileEntity();
        if (!(te instanceof StargateClassicBaseTile)) {
            return new Object[]{false, "invalid_target_gate"};
        }
        ((StargateClassicBaseTile)te).receiveIrisCode(new ComputerCodeSender(StargateNetwork.get(this.field_145850_b).getStargate(this.getStargateAddress(SymbolTypeEnum.MILKYWAY))), args.checkInteger(0));
        return new Object[]{true, "success"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(symbolName:string) -- Spins the ring to the given symbol and engages/locks it")
    public Object[] engageSymbol(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!this.stargateState.idle()) {
            return new Object[]{null, "stargate_failure_busy", "Stargate is busy, state: " + (Object)((Object)this.stargateState)};
        }
        if (this.dialedAddress.size() == 9) {
            return new Object[]{null, "stargate_failure_full", "Already dialed 9 chevrons"};
        }
        SymbolInterface targetSymbol = this.getSymbolFromNameIndex(args.checkAny(0));
        if (targetSymbol == SymbolPegasusEnum.UNKNOW1 || targetSymbol == SymbolPegasusEnum.UNKNOW2) {
            throw new IllegalArgumentException("bad argument (symbol name/index invalid)");
        }
        this.addSymbolToAddressManual(targetSymbol, context);
        this.func_70296_d();
        return new Object[]{"stargate_spin"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() - aborts dialing")
    public Object[] abortDialing(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (this.stargateState.dialingComputer() || this.stargateState.idle()) {
            this.abortDialingSequence();
            this.func_70296_d();
            return new Object[]{null, "stargate_aborting", "Aborting dialing"};
        }
        return new Object[]{null, "stargate_aborting_failed", "Aborting dialing failed"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Tries to open the gate")
    public Object[] engageGate(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (this.stargateState.idle()) {
            StargateOpenResult gateState = this.attemptOpenAndFail();
            if (gateState.ok()) {
                return new Object[]{"stargate_engage"};
            }
            this.sendSignal(null, "stargate_failed", "");
            return new Object[]{null, "stargate_failure_opening", "Stargate failed to open", gateState.toString()};
        }
        return new Object[]{null, "stargate_failure_busy", "Stargate is busy", this.stargateState.toString()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Tries to close the gate")
    public Object[] disengageGate(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (this.stargateState.engaged()) {
            if (this.getStargateState().initiating()) {
                this.attemptClose(StargateClosedReasonEnum.REQUESTED);
                return new Object[]{"stargate_disengage"};
            }
            return new Object[]{null, "stargate_failure_wrong_end", "Unable to close the gate on this end"};
        }
        return new Object[]{null, "stargate_failure_not_open", "The gate is closed"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Tries to spin mw gate")
    public Object[] spinGate(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (this instanceof StargatePegasusBaseTile) {
            return new Object[]{null, "stargate_not_supported", "Stargate type is not supported"};
        }
        if (this.stargateState.idle()) {
            if (args.isInteger(0)) {
                int time = args.checkInteger(0);
                boolean changeState = true;
                if (args.isBoolean(1)) {
                    changeState = args.checkBoolean(1);
                }
                if (time != 0) {
                    this.spinRing(1, changeState, true, time);
                    return new Object[]{null, "stargate_spin"};
                }
                return new Object[]{null, "stargate_failure_wrong_usage", "Time is 0"};
            }
            return new Object[]{null, "stargate_failure_wrong_usage", "Missing first argument (time in ticks)"};
        }
        return new Object[]{null, "stargate_failure_not_idle", "The gate is not idle"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Returns capacitors count")
    public Object[] getCapacitorsInstalled(Context context, Arguments args) {
        return new Object[]{this.isMerged() ? Integer.valueOf(this.currentPowerTier - 1) : null};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Returns gate type")
    public Object[] getGateType(Context context, Arguments args) {
        return new Object[]{this.isMerged() ? this.getSymbolType() : null};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Returns gate status")
    public Object[] getGateStatus(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{"not_merged"};
        }
        if (this.stargateState.engaged()) {
            return new Object[]{"open", this.stargateState.initiating()};
        }
        return new Object[]{this.stargateState.toString().toLowerCase()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(address:table|address:string...) -- Returns energy needed to dial an address")
    public Object[] getEnergyRequiredToDial(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{"not_merged"};
        }
        StargateAddressDynamic stargateAddress = new StargateAddressDynamic(this.getSymbolType());
        Iterator iterator = args.isTable(0) ? args.checkTable(0).values().iterator() : args.iterator();
        while (iterator.hasNext()) {
            Object symbolObj = iterator.next();
            if (stargateAddress.size() == 9) {
                throw new IllegalArgumentException("Too much glyphs");
            }
            SymbolInterface symbol = this.getSymbolFromNameIndex(symbolObj);
            if (stargateAddress.contains(symbol)) {
                throw new IllegalArgumentException("Duplicate glyph");
            }
            stargateAddress.addSymbol(symbol);
        }
        if (!stargateAddress.getLast().origin() && stargateAddress.size() < 9) {
            stargateAddress.addOrigin();
        }
        if (!stargateAddress.validate()) {
            return new Object[]{"address_malformed"};
        }
        if (!this.canDialAddress(stargateAddress)) {
            return new Object[]{"address_malformed"};
        }
        StargateEnergyRequired energyRequired = this.getEnergyRequiredToDial(Objects.requireNonNull(this.network.getStargate(stargateAddress)));
        HashMap<String, Constable> energyMap = new HashMap<String, Constable>(2);
        energyMap.put("open", Integer.valueOf(energyRequired.energyToOpen));
        energyMap.put("keepAlive", Integer.valueOf(energyRequired.keepAlive));
        energyMap.put("canOpen", Boolean.valueOf(this.getEnergyStorage().getEnergyStored() >= energyRequired.energyToOpen));
        return new Object[]{energyMap};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(gateType:string|gateType:int, checkGateType:boolean, checkAddressAndEnergy:boolean) -- Returns nearby gates")
    public Object[] getNearbyGates(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, false, "gate_not_merged", new HashMap()};
        }
        HashMap<String, Map> map = new HashMap<String, Map>();
        SymbolTypeEnum symbolType = args.isInteger(0) ? SymbolTypeEnum.valueOf(args.checkInteger(0)) : (args.isString(0) ? SymbolTypeEnum.valueOf(args.checkString(0)) : this.getSymbolType());
        boolean checkType = args.isBoolean(1) && args.checkBoolean(1);
        boolean checkAddEne = args.isBoolean(2) && args.checkBoolean(2);
        for (NearbyGate g : this.getNearbyGates(symbolType, checkType, checkAddEne)) {
            Map map2 = map.computeIfAbsent(g.address.getSymbolType().toString(), k -> new HashMap());
            map2.put(g.address.getNameList(), g.symbolsNeeded);
            map.put(g.gateType.toString(), map2);
        }
        return new Object[]{null, true, "success", map};
    }

    public static enum StargateIrisUpgradeEnum implements EnumKeyInterface<Item>
    {
        IRIS_UPGRADE_CLASSIC(JSGItems.UPGRADE_IRIS),
        IRIS_UPGRADE_TRINIUM(JSGItems.UPGRADE_IRIS_TRINIUM),
        IRIS_UPGRADE_SHIELD(JSGItems.UPGRADE_SHIELD);

        public final Item item;
        private static final EnumKeyMap<Item, StargateIrisUpgradeEnum> idMap;

        private StargateIrisUpgradeEnum(Item item) {
            this.item = item;
        }

        @Override
        public Item getKey() {
            return this.item;
        }

        public static StargateIrisUpgradeEnum valueOf(Item item) {
            return idMap.valueOf(item);
        }

        public static boolean contains(Item item) {
            return idMap.contains(item);
        }

        static {
            idMap = new EnumKeyMap((EnumKeyInterface[])StargateIrisUpgradeEnum.values());
        }
    }

    public static enum StargateUpgradeEnum implements EnumKeyInterface<Item>
    {
        MILKYWAY_GLYPHS(JSGItems.CRYSTAL_GLYPH_MILKYWAY),
        PEGASUS_GLYPHS(JSGItems.CRYSTAL_GLYPH_PEGASUS),
        UNIVERSE_GLYPHS(JSGItems.CRYSTAL_GLYPH_UNIVERSE),
        CHEVRON_UPGRADE(JSGItems.CRYSTAL_GLYPH_STARGATE);

        public final Item item;
        private static final EnumKeyMap<Item, StargateUpgradeEnum> idMap;

        private StargateUpgradeEnum(Item item) {
            this.item = item;
        }

        @Override
        public Item getKey() {
            return this.item;
        }

        public static StargateUpgradeEnum valueOf(Item item) {
            return idMap.valueOf(item);
        }

        public static boolean contains(Item item) {
            return idMap.contains(item);
        }

        static {
            idMap = new EnumKeyMap((EnumKeyInterface[])StargateUpgradeEnum.values());
        }
    }

    public static enum ConfigOptions implements ITileConfigEntry
    {
        ALLOW_INCOMING(0, "allowIncomingAnim", JSGConfigOptionTypeEnum.BOOLEAN, JSGConfig.Stargate.visual.allowIncomingAnimations + "", "Enable incoming animation", "on this gate"),
        DHD_TOP_LOCK(1, "dhdLockPoO", JSGConfigOptionTypeEnum.BOOLEAN, JSGConfig.DialHomeDevice.visual.dhdLastOpen + "", "Enable opening last chevron", "while dialing milkyway gate with dhd", " - ONLY FOR MW GATES - "),
        ENABLE_FAST_DIAL(2, "enableFastDial", JSGConfigOptionTypeEnum.BOOLEAN, JSGConfig.Stargate.visual.enableFastDialing + "", "Enable fast dialing", " - ONLY FOR UNI GATES NOW - "),
        ALLOW_RIG(3, "enableRIG", JSGConfigOptionTypeEnum.BOOLEAN, JSGConfig.Stargate.rig.enableRandomIncoming + "", "Enable random incoming", "generator on this gate"),
        ENABLE_DHD_PRESS_SOUND(4, "dhdPressSound", JSGConfigOptionTypeEnum.BOOLEAN, JSGConfig.DialHomeDevice.audio.computerDialSound + "", "Enable DHD press sound", "when dialing with OC"),
        CAPACITORS_COUNT(5, "maxCapacitors", JSGConfigOptionTypeEnum.NUMBER, "3", 0, 3, "Specifies how many", "capacitors can be installed", "into this gate"),
        PEG_DIAL_ANIMATION(6, "pegDialAnim", "1", (List<JSGConfigEnumEntry>)new ArrayList<JSGConfigEnumEntry>(){
            {
                this.add(new JSGConfigEnumEntry("Slow", "-1"));
                this.add(new JSGConfigEnumEntry("Normal", "0"));
                this.add(new JSGConfigEnumEntry("Fast", "1"));
            }
        }, "Speed of pegasus gate dialing with DHD"),
        SPIN_GATE_INCOMING(7, "incomingSpin", JSGConfigOptionTypeEnum.BOOLEAN, "true", "Enable ring spin", "animation while incoming animation", "occurs"),
        ORIGIN_MODEL(8, "originModel", "0", (List<JSGConfigEnumEntry>)new ArrayList<JSGConfigEnumEntry>(){
            {
                this.add(new JSGConfigEnumEntry("[by overlay]", "-1"));
                this.add(new JSGConfigEnumEntry("Default", "0"));
                this.add(new JSGConfigEnumEntry("P7J-989", "1"));
                this.add(new JSGConfigEnumEntry("Nether", "2"));
                this.add(new JSGConfigEnumEntry("Antarctica", "3"));
                this.add(new JSGConfigEnumEntry("Abydos", "4"));
                this.add(new JSGConfigEnumEntry("Tauri", "5"));
                for (String poo : JSGConfig.Stargate.pointOfOrigins.additionalOrigins) {
                    String name = poo.split(":")[1];
                    String value = poo.split(":")[0];
                    this.add(new JSGConfigEnumEntry(name, value));
                }
            }
        }, "Override point of origin model", " - ONLY FOR MW ADDRESS/GATE - "),
        ENABLE_BURY_STATE(9, "enableBuryState", JSGConfigOptionTypeEnum.BOOLEAN, JSGConfig.Stargate.mechanics.enableBurriedState + "", "Enable bury state for the gate?"),
        TIME_LIMIT_MODE(10, "timeLimitMode", JSGConfig.Stargate.openLimit.maxOpenedWhat.id + "", (List<JSGConfigEnumEntry>)new ArrayList<JSGConfigEnumEntry>(){
            {
                this.add(new JSGConfigEnumEntry(StargateTimeLimitModeEnum.DISABLED.name, StargateTimeLimitModeEnum.DISABLED.id + ""));
                this.add(new JSGConfigEnumEntry(StargateTimeLimitModeEnum.CLOSE_GATE.name, StargateTimeLimitModeEnum.CLOSE_GATE.id + ""));
                this.add(new JSGConfigEnumEntry(StargateTimeLimitModeEnum.DRAW_MORE_POWER.name, StargateTimeLimitModeEnum.DRAW_MORE_POWER.id + ""));
            }
        }, "Gate open time limit mode"),
        TIME_LIMIT_TIME(11, "timeLimitTime", JSGConfigOptionTypeEnum.NUMBER, JSGConfig.Stargate.openLimit.maxOpenedSeconds + "", 0, -1, "Seconds of gate's open time limit."),
        TIME_LIMIT_POWER(12, "timeLimitPower", JSGConfigOptionTypeEnum.NUMBER, JSGConfig.Stargate.openLimit.maxOpenedPowerDrawAfterLimit + "", 0, -1, "Power draw when gate runs", "out of open time limit.", " - TIME LIMIT MODE MUST BE SET TO \"DRAW_POWER\" - "),
        STARGATE_SPIN_SPEED(13, "spinSpeed", JSGConfigOptionTypeEnum.NUMBER, "100", 1, 300, "Speed factor of the gate", " - ONLY FOR MW AND UNI GATES - ");

        public final int id;
        public final String label;
        public final String[] comment;
        public final JSGConfigOptionTypeEnum type;
        public final String defaultValue;
        public List<JSGConfigEnumEntry> possibleValues;
        public final int minInt;
        public final int maxInt;

        private ConfigOptions(int optionId, String label, String defaultValue, List<JSGConfigEnumEntry> possibleValues, String ... comment) {
            this(optionId, label, JSGConfigOptionTypeEnum.SWITCH, defaultValue, comment);
            this.possibleValues = possibleValues;
        }

        private ConfigOptions(int optionId, String label, JSGConfigOptionTypeEnum type, String defaultValue, String ... comment) {
            this(optionId, label, type, defaultValue, -1, -1, comment);
        }

        private ConfigOptions(int optionId, String label, JSGConfigOptionTypeEnum type, String defaultValue, int minInt, int maxInt, String ... comment) {
            this.id = optionId;
            this.label = label;
            this.type = type;
            this.defaultValue = defaultValue;
            this.minInt = minInt;
            this.maxInt = maxInt;
            this.comment = comment;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String[] getComment() {
            return this.comment;
        }

        @Override
        public JSGConfigOptionTypeEnum getType() {
            return this.type;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public List<JSGConfigEnumEntry> getPossibleValues() {
            return this.possibleValues;
        }

        @Override
        public int getMin() {
            return this.minInt;
        }

        @Override
        public int getMax() {
            return this.maxInt;
        }
    }
}

