/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.machine;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.machine.AbstractMachineRecipe;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.renderer.machine.AbstractMachineRendererState;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.util.IUpgradable;
import tauri.dev.jsg.util.JSGItemStackHandler;

public abstract class AbstractMachineTile
extends TileEntity
implements IUpgradable,
StateProviderInterface,
ITickable {
    protected NetworkRegistry.TargetPoint targetPoint;
    protected int energyStoredLastTick = 0;
    protected int energyTransferedLastTick = 0;
    protected int machineProgress = 0;
    protected int machineProgressLast = -1;
    protected long machineStart = -1L;
    protected long machineEnd = -1L;
    protected boolean isWorking = false;
    protected boolean isWorkingLast = false;
    protected long workStateChanged;
    protected AbstractMachineRecipe currentRecipe = null;
    protected AbstractMachineRecipe currentRecipeLast = null;

    public int getEnergyTransferedLastTick() {
        return this.energyTransferedLastTick;
    }

    public abstract JSGItemStackHandler getJSGItemHandler();

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
            this.sendState(StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE));
        }
    }

    protected abstract void playLoopSound(boolean var1);

    protected abstract void playSound(boolean var1);

    public void onBreak() {
        this.isWorking = false;
        this.currentRecipe = null;
        this.func_70296_d();
        this.playLoopSound(true);
    }

    public long getMachineStart() {
        return this.machineStart;
    }

    public long getMachineEnd() {
        return this.machineEnd;
    }

    public abstract AbstractMachineRecipe getRecipeIfPossible();

    protected void workIsDone() {
        if (!this.isWorking) {
            return;
        }
        this.currentRecipe = this.getRecipeIfPossible();
        if (this.currentRecipe != null) {
            this.machineStart = this.field_145850_b.func_82737_E();
            this.machineEnd = this.field_145850_b.func_82737_E() + (long)this.currentRecipe.getWorkingTime();
            this.machineProgress = 0;
            this.isWorking = true;
        } else {
            this.machineStart = -1L;
            this.machineEnd = -1L;
            this.machineProgress = 0;
            this.isWorking = false;
            this.playSound(false);
        }
        this.func_70296_d();
    }

    public abstract StargateAbstractEnergyStorage getEnergyStorage();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.energyTransferedLastTick = this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick;
            this.energyStoredLastTick = this.getEnergyStorage().getEnergyStored();
            this.currentRecipe = this.getRecipeIfPossible();
            if (this.isWorking) {
                if (this.currentRecipe == null) {
                    this.isWorking = false;
                    this.workStateChanged = this.field_145850_b.func_82737_E();
                    this.machineProgress = 0;
                    this.machineStart = -1L;
                    this.machineEnd = -1L;
                    this.func_70296_d();
                    this.sendState(StateTypeEnum.GUI_UPDATE, this.getState(StateTypeEnum.GUI_UPDATE));
                    this.playSound(false);
                } else {
                    this.machineProgress = this.machineStart == this.machineEnd ? 0 : (int)Math.round((double)(this.field_145850_b.func_82737_E() - this.machineStart) / (double)(this.machineEnd - this.machineStart) * 100.0);
                    this.getEnergyStorage().extractEnergy(this.currentRecipe.getEnergyPerTick(), false);
                    if (this.machineProgress >= 100) {
                        this.workIsDone();
                    }
                }
            } else if (this.currentRecipe != null) {
                this.isWorking = true;
                this.workStateChanged = this.field_145850_b.func_82737_E();
                this.machineStart = this.field_145850_b.func_82737_E();
                this.machineEnd = (long)this.currentRecipe.getWorkingTime() + this.field_145850_b.func_82737_E();
                this.func_70296_d();
                this.sendState(StateTypeEnum.GUI_UPDATE, this.getState(StateTypeEnum.GUI_UPDATE));
                this.playSound(true);
            }
            if (this.isWorking != this.isWorkingLast || this.machineProgress != this.machineProgressLast || this.currentRecipe != this.currentRecipeLast) {
                this.isWorkingLast = this.isWorking;
                this.machineProgressLast = this.machineProgress;
                this.playLoopSound(!this.isWorking);
                this.sendState(StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE));
            }
            this.func_70296_d();
        }
    }

    protected void sendState(StateTypeEnum type, State state) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetPoint != null) {
            JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, type, state), this.targetPoint);
        } else {
            JSG.debug("targetPoint was null trying to send " + (Object)((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getEnergyStorage());
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getJSGItemHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    public abstract AbstractMachineRendererState getRendererState();

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("energyStorage", (NBTBase)this.getEnergyStorage().serializeNBT());
        compound.func_74782_a("itemStackHandler", (NBTBase)this.getJSGItemHandler().serializeNBT());
        compound.func_74757_a("isWorking", this.isWorking);
        compound.func_74772_a("machineStart", this.machineStart);
        compound.func_74772_a("machineEnd", this.machineEnd);
        compound.func_74768_a("progress", this.machineProgress);
        compound.func_74772_a("workStart", this.workStateChanged);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.getEnergyStorage().deserializeNBT(compound.func_74775_l("energyStorage"));
        this.getJSGItemHandler().deserializeNBT(compound.func_74775_l("itemStackHandler"));
        this.isWorking = compound.func_74767_n("isWorking");
        this.machineStart = compound.func_74763_f("machineStart");
        this.machineEnd = compound.func_74763_f("machineEnd");
        this.machineProgress = compound.func_74762_e("machineProgress");
        this.workStateChanged = compound.func_74763_f("workStart");
        super.func_145839_a(compound);
    }
}

