/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.energy;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.energy.ZPMBlock;
import tauri.dev.jsg.capability.CapabilityEnergyZPM;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.gui.container.zpmhub.ZPMHubContainerGuiUpdate;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.packet.StateUpdateRequestToServer;
import tauri.dev.jsg.power.zpm.IEnergyStorageZPM;
import tauri.dev.jsg.power.zpm.ZPMHubEnergyStorage;
import tauri.dev.jsg.renderer.zpm.ZPMRenderer;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.energy.ZPMHubRendererUpdate;
import tauri.dev.jsg.util.JSGAdvancementsUtil;
import tauri.dev.jsg.util.JSGItemStackHandler;
import tauri.dev.jsg.util.main.JSGProps;

@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers")
public class ZPMHubTile
extends TileEntity
implements ITickable,
ICapabilityProvider,
StateProviderInterface,
Environment {
    private static final int SLIDING_ANIMATION_LENGTH = 50;
    protected final ItemStackHandler itemStackHandler = new JSGItemStackHandler(this.getContainerSize()){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!ZPMHubTile.this.isSlidingUp || ZPMHubTile.this.isAnimating) {
                return false;
            }
            if (stack.func_77973_b() instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
                return itemBlock.func_179223_d() instanceof ZPMBlock;
            }
            return false;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!ZPMHubTile.this.isSlidingUp || ZPMHubTile.this.isAnimating) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ZPMHubTile.this.sendState(StateTypeEnum.RENDERER_UPDATE, ZPMHubTile.this.getState(StateTypeEnum.RENDERER_UPDATE));
            ZPMHubTile.this.updatePowerTier();
            ZPMHubTile.this.func_70296_d();
            ZPMHubTile.this.triggerAdvancement();
        }
    };
    private final ZPMHubEnergyStorage energyStorage;
    protected long energyStoredLastTick;
    protected long energyTransferedLastTick;
    private EnumFacing facing;
    public float facingAngle;
    private NetworkRegistry.TargetPoint targetPoint;
    public long animationStart;
    public boolean isAnimating;
    public boolean isSlidingUp;
    public int zpm1Level;
    public int zpm2Level;
    public int zpm3Level;
    public ZPMRenderer.ZPMModelType zpm1Type;
    public ZPMRenderer.ZPMModelType zpm2Type;
    public ZPMRenderer.ZPMModelType zpm3Type;
    private boolean addedToNetwork;
    private int currentPowerTier;
    private final Node node;

    public ZPMHubTile() {
        this.energyStorage = new ZPMHubEnergyStorage(JSGConfig.ZPM.power.zpmHubMaxEnergyTransfer){

            @Override
            protected void onEnergyChanged() {
                ZPMHubTile.this.func_70296_d();
                ZPMHubTile.this.sendState(StateTypeEnum.RENDERER_UPDATE, ZPMHubTile.this.getState(StateTypeEnum.RENDERER_UPDATE));
            }
        };
        this.energyStoredLastTick = 0L;
        this.energyTransferedLastTick = 0L;
        this.isSlidingUp = true;
        this.addedToNetwork = false;
        this.node = JSG.ocWrapper.createNode(this, "zpmhub");
    }

    public int getAnimationLength() {
        return 50;
    }

    public int getContainerSize() {
        return 3;
    }

    public void triggerAdvancement() {
        if (this.itemStackHandler.getStackInSlot(0).func_190926_b()) {
            return;
        }
        if (this.itemStackHandler.getStackInSlot(1).func_190926_b()) {
            return;
        }
        if (this.itemStackHandler.getStackInSlot(2).func_190926_b()) {
            return;
        }
        JSGAdvancementsUtil.tryTriggerRangedAdvancement(this, JSGAdvancementsUtil.EnumAdvancementType.ZPM_HUB);
    }

    public void startAnimation() {
        if (this.isAnimating) {
            return;
        }
        this.animationStart = this.field_145850_b.func_82737_E();
        this.isAnimating = true;
        this.isSlidingUp = !this.isSlidingUp;
        this.sendState(StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE));
        this.func_70296_d();
    }

    public NetworkRegistry.TargetPoint getTargetPoint() {
        return this.targetPoint;
    }

    public ZPMHubEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void onLoad() {
        this.facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
        if (!this.field_145850_b.field_72995_K) {
            this.updatePowerTier();
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        } else {
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.addedToNetwork) {
                this.addedToNetwork = true;
                JSG.ocWrapper.joinOrCreateNetwork(this);
            }
            if (!this.isSlidingUp && !this.isAnimating) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                    if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) continue;
                    int extracted = this.getEnergyStorage().extractEnergy(JSGConfig.ZPM.power.zpmHubMaxEnergyTransfer, true);
                    extracted = Objects.requireNonNull((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).receiveEnergy(extracted, false);
                    this.getEnergyStorage().extractEnergy(extracted, false);
                }
            }
            if (this.energyStoredLastTick != this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick) {
                this.sendState(StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE));
            }
            this.energyTransferedLastTick = this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick;
            if (this.energyTransferedLastTick > 0L) {
                this.energyTransferedLastTick = 0L;
            }
            this.energyStoredLastTick = this.getEnergyStorage().getEnergyStored();
            this.func_70296_d();
            if (this.isAnimating && this.animationStart + (long)this.getAnimationLength() < this.field_145850_b.func_82737_E()) {
                this.isAnimating = false;
                this.animationStart = -1L;
                this.sendState(StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE));
                this.func_70296_d();
            }
        }
    }

    protected void updatePowerTier() {
        int i;
        int powerTier = 1;
        for (i = 0; i < this.getContainerSize(); ++i) {
            if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
            ++powerTier;
        }
        if (powerTier != this.currentPowerTier) {
            this.currentPowerTier = powerTier;
            this.getEnergyStorage().clearStorages();
            for (i = 0; i < this.getContainerSize(); ++i) {
                ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                this.getEnergyStorage().addStorage((IEnergyStorageZPM)stack.getCapability(CapabilityEnergyZPM.ENERGY, null));
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        compound.func_74782_a("energyStorage", (NBTBase)this.getEnergyStorage().serializeNBT());
        compound.func_74782_a("itemStackHandler", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74757_a("isAnimating", this.isAnimating);
        compound.func_74757_a("isSlidingUp", this.isSlidingUp);
        compound.func_74772_a("animationStart", this.animationStart);
        if (this.node != null) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            this.node.save(nodeCompound);
            compound.func_74782_a("node", (NBTBase)nodeCompound);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        this.getEnergyStorage().deserializeNBT(compound.func_74775_l("energyStorage"));
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("itemStackHandler"));
        this.isAnimating = compound.func_74767_n("isAnimating");
        this.isSlidingUp = compound.func_74767_n("isSlidingUp");
        this.animationStart = compound.func_74763_f("animationStart");
        if (this.node != null && compound.func_74764_b("node")) {
            this.node.load(compound.func_74775_l("node"));
        }
        super.func_145839_a(compound);
    }

    public long getEnergyTransferedLastTick() {
        return this.energyTransferedLastTick;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergyZPM.ENERGY || capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergyZPM.ENERGY) {
            return (T)CapabilityEnergyZPM.ENERGY.cast((Object)this.getEnergyStorage());
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new EnergyStorage((int)Math.min(this.getEnergyStorage().getMaxEnergyStored(), Integer.MAX_VALUE), this.getEnergyStorage().maxReceive, this.getEnergyStorage().maxExtract, (int)Math.min(this.getEnergyStorage().getEnergyStored(), Integer.MAX_VALUE)));
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public static int getZPMPowerLevel(long energyStored, long maxEnergy) {
        return (int)Math.round((double)energyStored / (double)maxEnergy * 5.0);
    }

    protected void sendState(StateTypeEnum type, State state) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetPoint != null) {
            JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, type, state), this.targetPoint);
        } else {
            JSG.debug("targetPoint was null trying to send " + (Object)((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                ArrayList<Integer> levels = new ArrayList<Integer>(3);
                ArrayList<ZPMRenderer.ZPMModelType> types = new ArrayList<ZPMRenderer.ZPMModelType>(3);
                for (int i = 0; i < 3; ++i) {
                    ItemStack stack;
                    IEnergyStorageZPM zpmStorage;
                    if (this.getContainerSize() > i && (zpmStorage = (IEnergyStorageZPM)(stack = this.itemStackHandler.getStackInSlot(i)).getCapability(CapabilityEnergyZPM.ENERGY, null)) != null) {
                        levels.add(ZPMHubTile.getZPMPowerLevel(zpmStorage.getEnergyStored(), zpmStorage.getMaxEnergyStored()));
                        types.add(ZPMRenderer.ZPMModelType.byStack(stack));
                        continue;
                    }
                    levels.add(-1);
                    types.add(ZPMRenderer.ZPMModelType.NORMAL);
                }
                return new ZPMHubRendererUpdate(this.animationStart, this.isAnimating, this.isSlidingUp, (Integer)levels.get(0), (Integer)levels.get(1), (Integer)levels.get(2), (ZPMRenderer.ZPMModelType)((Object)types.get(0)), (ZPMRenderer.ZPMModelType)((Object)types.get(1)), (ZPMRenderer.ZPMModelType)((Object)types.get(2)), (this.facing.func_176736_b() - 2) * 90);
            }
            case GUI_UPDATE: {
                return new ZPMHubContainerGuiUpdate(this.getEnergyStorage().getEnergyStoredInternally(), this.energyTransferedLastTick);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new ZPMHubRendererUpdate();
            }
            case GUI_UPDATE: {
                return new ZPMHubContainerGuiUpdate();
            }
        }
        return null;
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                ZPMHubRendererUpdate s = (ZPMHubRendererUpdate)state;
                this.animationStart = s.animationStart;
                this.isAnimating = s.isAnimating;
                this.isSlidingUp = s.slidingUp;
                this.zpm1Level = s.zpm1Level;
                this.zpm2Level = s.zpm2Level;
                this.zpm3Level = s.zpm3Level;
                this.zpm1Type = s.zpm1Type;
                this.zpm2Type = s.zpm2Type;
                this.zpm3Type = s.zpm3Type;
                this.facingAngle = s.facing;
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                this.func_70296_d();
                break;
            }
            case GUI_UPDATE: {
                ZPMHubContainerGuiUpdate guiUpdate = (ZPMHubContainerGuiUpdate)state;
                this.getEnergyStorage().setEnergyStoredInternally(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.energyTransferedLastTick;
                break;
            }
        }
    }

    public void onChunkUnload() {
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        if (this.node != null) {
            this.node.remove();
        }
        super.func_145843_s();
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    public void sendSignal(Object context, String name, Object ... params) {
        JSG.ocWrapper.sendSignalToReachable(this.node, (Context)context, name, params);
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getJSGVersion(Context context, Arguments args) {
        return new Object[]{"1.12.2-4.11.0.8"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Toggles ZPM slots")
    public Object[] toggleSlots(Context context, Arguments args) {
        if (!this.isAnimating) {
            this.startAnimation();
            if (!this.isSlidingUp) {
                return new Object[]{null, true, "slots_toggled_down", "Slots are sliding down now!"};
            }
            return new Object[]{null, true, "slots_toggled_up", "Slots are sliding up now!"};
        }
        return new Object[]{null, false, "slots_busy", "Slots are busy!"};
    }
}

