/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.dialhomedevice;

import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.dialhomedevice.DHDPegasusRendererState;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.stargate.network.StargateAddressDynamic;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolPegasusEnum;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.dialhomedevice.DHDActivateButtonState;
import tauri.dev.jsg.state.stargate.StargateBiomeOverrideState;
import tauri.dev.jsg.tileentity.dialhomedevice.DHDAbstractTile;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargatePegasusBaseTile;
import tauri.dev.jsg.util.LinkingHelper;
import tauri.dev.jsg.util.main.JSGProps;

public class DHDPegasusTile
extends DHDAbstractTile {
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED, BiomeOverlayEnum.SOOTY);

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 40L == 0L && this.rendererStateClient != null && this.getRendererStateClient().biomeOverride == null) {
            this.rendererStateClient.setBiomeOverlay(BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.field_174879_c, SUPPORTED_OVERLAYS));
        }
        super.func_73660_a();
    }

    @Override
    public void activateSymbol(SymbolInterface symbolInt) {
        StargateAbstractBaseTile gateTile = this.getLinkedGate((IBlockAccess)this.field_145850_b);
        if (gateTile == null) {
            return;
        }
        SymbolPegasusEnum symbol = SymbolPegasusEnum.valueOf(symbolInt.getId());
        if (!gateTile.getStargateState().dialingComputer() || ((StargateClassicBaseTile)gateTile).getConfig().getOption(StargateClassicBaseTile.ConfigOptions.ENABLE_DHD_PRESS_SOUND.id).getBooleanValue()) {
            if (symbol.brb()) {
                JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.DHD_PEGASUS_PRESS_BRB);
            } else {
                JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.DHD_PEGASUS_PRESS);
            }
        }
        this.field_145850_b.func_175685_c(this.field_174879_c, (Block)JSGBlocks.DHD_PEGASUS_BLOCK, true);
        this.sendState(StateTypeEnum.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(symbol));
    }

    @Override
    public void updateLinkStatus(World world, BlockPos pos) {
        BlockPos closestGate = LinkingHelper.findClosestUnlinked(world, pos, LinkingHelper.getDhdRange(), JSGBlocks.STARGATE_PEGASUS_BASE_BLOCK, this.getLinkId());
        int linkId = LinkingHelper.getLinkId();
        if (closestGate != null) {
            StargatePegasusBaseTile gateTile = (StargatePegasusBaseTile)world.func_175625_s(closestGate);
            gateTile.setLinkedDHD(pos, linkId);
        }
        this.setLinkedGate(closestGate, linkId);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_STATE) {
            StargateAddressDynamic address = new StargateAddressDynamic(SymbolTypeEnum.PEGASUS);
            JSGTileEntityConfig config = new JSGTileEntityConfig();
            if (this.isLinked()) {
                StargateAbstractBaseTile gateTile = this.getLinkedGate((IBlockAccess)this.field_145850_b);
                address.addAll(gateTile.getDialedAddress());
                boolean brbActive = false;
                switch (gateTile.getStargateState()) {
                    case ENGAGED_INITIATING: {
                        brbActive = true;
                        break;
                    }
                    case ENGAGED: {
                        address.clear();
                        brbActive = true;
                        break;
                    }
                }
                if (gateTile instanceof StargateClassicBaseTile) {
                    config = ((StargateClassicBaseTile)gateTile).getConfig();
                }
                return new DHDPegasusRendererState(address, brbActive, this.determineBiomeOverride(), gateTile.connectedToGate, config);
            }
            return new DHDPegasusRendererState(address, false, this.determineBiomeOverride(), false, config);
        }
        throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_STATE) {
            return new DHDPegasusRendererState();
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        StargateAbstractBaseTile gateTile;
        boolean connected = false;
        if (this.isLinked() && (gateTile = this.getLinkedGate((IBlockAccess)this.field_145850_b)) != null) {
            connected = gateTile.connectedToGate;
        }
        switch (stateType) {
            case RENDERER_STATE: {
                float horizontalRotation = (float)((Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)JSGProps.ROTATION_HORIZONTAL)).intValue() * -22.5f;
                this.rendererStateClient = ((DHDPegasusRendererState)state).initClient(this.field_174879_c, horizontalRotation, BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.field_174879_c, SUPPORTED_OVERLAYS), connected);
                break;
            }
            case DHD_ACTIVATE_BUTTON: {
                if (state == null) break;
                DHDActivateButtonState activateState = (DHDActivateButtonState)state;
                this.getRendererStateClient().setIsConnected(connected);
                if (activateState.clearAll) {
                    ((DHDPegasusRendererState)this.getRendererStateClient()).clearSymbols(this.field_145850_b.func_82737_E());
                    break;
                }
                ((DHDPegasusRendererState)this.getRendererStateClient()).activateSymbol(this.field_145850_b.func_82737_E(), SymbolPegasusEnum.valueOf(activateState.symbol));
                break;
            }
            case BIOME_OVERRIDE_STATE: {
                StargateBiomeOverrideState overrideState = (StargateBiomeOverrideState)state;
                if (this.rendererStateClient == null) break;
                this.getRendererStateClient().biomeOverride = overrideState.biomeOverride;
                break;
            }
            default: {
                super.setState(stateType, state);
            }
        }
    }
}

