/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.stargate.teleportation;

import javax.vecmath.Vector2f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import tauri.dev.jsg.advancements.JSGAdvancements;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.teleportation.TeleportHelper;

public class TeleportPacket {
    private final BlockPos sourceGatePos;
    private final StargatePos targetGatePos;
    private final Entity entity;
    private final float rotation;
    private Vector2f motionVector;

    public TeleportPacket(Entity entity, BlockPos source, StargatePos target, float rotation) {
        this.entity = entity;
        this.sourceGatePos = source;
        this.targetGatePos = target;
        this.rotation = rotation;
    }

    public StargatePos getTargetGatePos() {
        return this.targetGatePos;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void teleport() {
        this.teleport(true);
    }

    public void teleport(boolean playSound) {
        if (this.entity instanceof EntityPlayerMP) {
            JSGAdvancements.WORMHOLE_GO.trigger((EntityPlayerMP)this.entity);
        }
        TeleportHelper.teleportEntity(this.entity, this.sourceGatePos, this.targetGatePos, this.rotation, this.motionVector);
        if (playSound) {
            JSGSoundHelper.playSoundEvent(this.targetGatePos.getWorld(), this.targetGatePos.getTileEntity().getGateCenterPos(), SoundEventEnum.WORMHOLE_GO);
        }
    }

    public TeleportPacket setMotion(Vector2f motion) {
        this.motionVector = motion;
        return this;
    }
}

