/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.stargate.network;

import java.util.List;
import java.util.Random;
import tauri.dev.jsg.stargate.network.StargateAddressDynamic;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolMilkyWayEnum;
import tauri.dev.jsg.stargate.network.SymbolPegasusEnum;
import tauri.dev.jsg.stargate.network.SymbolUniverseEnum;
import tauri.dev.jsg.util.EnumKeyInterface;
import tauri.dev.jsg.util.EnumKeyMap;

public enum SymbolTypeEnum implements EnumKeyInterface<Integer>
{
    MILKYWAY(0, 32, 32),
    PEGASUS(1, 27, 27),
    UNIVERSE(2, 20, 42);

    public int id;
    public int iconWidht;
    public int iconHeight;
    private static final EnumKeyMap<Integer, SymbolTypeEnum> ID_MAP;

    private SymbolTypeEnum(int id, int iconWidht, int iconHeight) {
        this.id = id;
        this.iconWidht = iconWidht;
        this.iconHeight = iconHeight;
    }

    public SymbolInterface getRandomSymbol(Random random) {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.getRandomSymbol(random);
            }
            case PEGASUS: {
                return SymbolPegasusEnum.getRandomSymbol(random);
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.getRandomSymbol(random);
            }
        }
        return null;
    }

    public SymbolInterface getBRB() {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.BRB;
            }
            case PEGASUS: {
                return SymbolPegasusEnum.BBB;
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.getTopSymbol();
            }
        }
        return null;
    }

    public SymbolInterface valueOfSymbol(int id) {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.valueOf(id);
            }
            case PEGASUS: {
                return SymbolPegasusEnum.valueOf(id);
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.valueOf(id);
            }
        }
        return null;
    }

    public boolean validateDialedAddress(StargateAddressDynamic stargateAddress) {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.validateDialedAddress(stargateAddress);
            }
            case PEGASUS: {
                return SymbolPegasusEnum.validateDialedAddress(stargateAddress);
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.validateDialedAddress(stargateAddress);
            }
        }
        return false;
    }

    public List<SymbolInterface> stripOrigin(List<SymbolInterface> dialedAddress) {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.stripOrigin(dialedAddress);
            }
            case PEGASUS: {
                return SymbolPegasusEnum.stripOrigin(dialedAddress);
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.stripOrigin(dialedAddress);
            }
        }
        return null;
    }

    public int getMinimalSymbolCountTo(SymbolTypeEnum symbolType, boolean localDial) {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.getMinimalSymbolCountTo(symbolType, localDial);
            }
            case PEGASUS: {
                return SymbolPegasusEnum.getMinimalSymbolCountTo(symbolType, localDial);
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.getMinimalSymbolCountTo(symbolType, localDial);
            }
        }
        return 0;
    }

    public SymbolInterface getOrigin() {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.getOrigin();
            }
            case PEGASUS: {
                return SymbolPegasusEnum.getOrigin();
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.getOrigin();
            }
        }
        return null;
    }

    public SymbolInterface fromEnglishName(String englishName) {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.fromEnglishName(englishName);
            }
            case PEGASUS: {
                return SymbolPegasusEnum.fromEnglishName(englishName);
            }
            case UNIVERSE: {
                SymbolUniverseEnum symbol = SymbolUniverseEnum.fromEnglishName(englishName);
                if (symbol != null) {
                    return symbol;
                }
                try {
                    int index = Integer.parseInt(englishName.replace("G", ""));
                    if (index < 1 || index > 36) {
                        return null;
                    }
                    return SymbolUniverseEnum.values()[index];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        return null;
    }

    public int getMaxSymbolsDisplay(boolean hasUpgrade) {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.getMaxSymbolsDisplay(hasUpgrade);
            }
            case PEGASUS: {
                return SymbolPegasusEnum.getMaxSymbolsDisplay(hasUpgrade);
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.getMaxSymbolsDisplay(hasUpgrade);
            }
        }
        return 0;
    }

    public float getAnglePerGlyph() {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.getAnglePerGlyph();
            }
            case PEGASUS: {
                return SymbolPegasusEnum.getAnglePerGlyph();
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.getAnglePerGlyph();
            }
        }
        return 0.0f;
    }

    public SymbolInterface getSymbolByAngle(float angle) {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.getSymbolByAngle(angle);
            }
            case PEGASUS: {
                return SymbolPegasusEnum.getSymbolByAngle(angle);
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.getSymbolByAngle(angle);
            }
        }
        return null;
    }

    public float getAngleOfNearest(float angle) {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.getAngleOfNearest(angle);
            }
            case PEGASUS: {
                return 0.0f;
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.getAngleOfNearest(angle);
            }
        }
        return 0.0f;
    }

    public SymbolInterface getTopSymbol() {
        switch (this) {
            case MILKYWAY: {
                return SymbolMilkyWayEnum.getTopSymbol();
            }
            case PEGASUS: {
                return SymbolPegasusEnum.getTopSymbol();
            }
            case UNIVERSE: {
                return SymbolUniverseEnum.getTopSymbol();
            }
        }
        return null;
    }

    public boolean hasOrigin() {
        return this.getOrigin() != null;
    }

    @Override
    public Integer getKey() {
        return this.id;
    }

    public static SymbolTypeEnum valueOf(int id) {
        return ID_MAP.valueOf(id);
    }

    static {
        ID_MAP = new EnumKeyMap((EnumKeyInterface[])SymbolTypeEnum.values());
    }
}

