/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.stargate.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.stargate.teleportation.TeleportHelper;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;

public class StargatePos
implements INBTSerializable<NBTTagCompound> {
    public int dimensionID;
    public BlockPos gatePos;
    public SymbolTypeEnum symbolType;
    public List<SymbolInterface> additionalSymbols;

    public StargatePos(int dimensionID, BlockPos gatePos, StargateAddress stargateAddress) {
        this.dimensionID = dimensionID;
        this.gatePos = gatePos;
        this.symbolType = stargateAddress.getSymbolType();
        this.additionalSymbols = new ArrayList<SymbolInterface>(2);
        this.additionalSymbols.addAll(stargateAddress.getAdditional());
    }

    public StargatePos(SymbolTypeEnum symbolType, NBTTagCompound compound) {
        this.symbolType = symbolType;
        this.additionalSymbols = new ArrayList<SymbolInterface>(2);
        this.deserializeNBT(compound);
    }

    public World getWorld() {
        return TeleportHelper.getWorld(this.dimensionID);
    }

    public StargateAbstractBaseTile getTileEntity() {
        try {
            return (StargateAbstractBaseTile)this.getWorld().func_175625_s(this.gatePos);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IBlockState getBlockState() {
        return this.getWorld().func_180495_p(this.gatePos);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dim", this.dimensionID);
        compound.func_74772_a("pos", this.gatePos.func_177986_g());
        compound.func_74768_a("last0", this.additionalSymbols.get(0).getId());
        compound.func_74768_a("last1", this.additionalSymbols.get(1).getId());
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.dimensionID = compound.func_74762_e("dim");
        this.gatePos = BlockPos.func_177969_a((long)compound.func_74763_f("pos"));
        this.additionalSymbols.add(this.symbolType.valueOfSymbol(compound.func_74762_e("last0")));
        this.additionalSymbols.add(this.symbolType.valueOfSymbol(compound.func_74762_e("last1")));
    }

    public String toString() {
        return String.format("[dim=%d, pos=%s, add=%s]", this.dimensionID, this.gatePos.toString(), this.additionalSymbols.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalSymbols == null ? 0 : this.additionalSymbols.hashCode());
        result = 31 * result + this.dimensionID;
        result = 31 * result + (this.gatePos == null ? 0 : this.gatePos.hashCode());
        result = 31 * result + (this.symbolType == null ? 0 : this.symbolType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StargatePos other = (StargatePos)obj;
        if (this.additionalSymbols == null ? other.additionalSymbols != null : !this.additionalSymbols.equals(other.additionalSymbols)) {
            return false;
        }
        if (this.dimensionID != other.dimensionID) {
            return false;
        }
        if (this.gatePos == null ? other.gatePos != null : !this.gatePos.equals((Object)other.gatePos)) {
            return false;
        }
        return this.symbolType == other.symbolType;
    }
}

