/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.stargate.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;

public class StargateAddressDynamic
extends StargateAddress {
    private int addressSize;

    public StargateAddressDynamic(SymbolTypeEnum symbolType) {
        super(symbolType);
    }

    public StargateAddressDynamic(NBTTagCompound compound) {
        super(compound);
    }

    public StargateAddressDynamic(StargateAddress address) {
        super(address.symbolType);
        this.clear();
        this.addAll(address);
    }

    @Override
    protected int getSavedSymbols() {
        return Math.min(this.addressSize, 9);
    }

    public void addSymbol(SymbolInterface symbol) {
        if (this.address.size() == 9) {
            JSG.error("Tried to add symbol to already full address");
            return;
        }
        this.address.add(symbol);
        ++this.addressSize;
    }

    public void addAll(StargateAddress stargateAddress) {
        if (this.address.size() + stargateAddress.address.size() > 9) {
            JSG.error("Tried to add symbols to already populated address");
            return;
        }
        this.address.addAll(stargateAddress.address);
        this.addressSize += stargateAddress.address.size();
    }

    public void addAll(List<SymbolInterface> stargateAddress) {
        if (this.address.size() + stargateAddress.size() > 9) {
            JSG.error("Tried to add symbols to already populated address");
            return;
        }
        this.address.addAll(stargateAddress);
        this.addressSize += stargateAddress.size();
    }

    public void addOrigin() {
        if (this.symbolType.hasOrigin()) {
            this.addSymbol(this.symbolType.getOrigin());
        }
    }

    public void clear() {
        this.address.clear();
        this.addressSize = 0;
    }

    public int size() {
        return this.address.size();
    }

    @Override
    public boolean contains(SymbolInterface symbol) {
        return this.address.contains(symbol);
    }

    public boolean validate() {
        return this.symbolType.validateDialedAddress(this);
    }

    public StargateAddress toImmutable() {
        StargateAddress stargateAddress = new StargateAddress(this.symbolType);
        stargateAddress.address.addAll(this.address);
        return stargateAddress;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("size", this.address.size());
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        this.addressSize = compound.func_74762_e("size");
        super.deserializeNBT(compound);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.address.size());
        super.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.addressSize = buf.readInt();
        super.fromBytes(buf);
    }
}

