/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.stargate.codesender;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import tauri.dev.jsg.stargate.codesender.CodeSender;
import tauri.dev.jsg.stargate.codesender.ComputerCodeSender;
import tauri.dev.jsg.stargate.codesender.PlayerCodeSender;

public enum CodeSenderType {
    PLAYER(0, PlayerCodeSender::new),
    COMPUTER(1, ComputerCodeSender::new);

    private static final Map<Integer, CodeSenderType> idMap;
    public final Supplier<CodeSender> constructor;
    public final int id;

    private CodeSenderType(int id, Supplier<CodeSender> constructor) {
        this.constructor = constructor;
        this.id = id;
    }

    public static CodeSenderType fromId(int id) {
        return idMap.get(id);
    }

    static {
        idMap = new HashMap<Integer, CodeSenderType>();
        for (CodeSenderType member : CodeSenderType.values()) {
            idMap.put(member.id, member);
        }
    }
}

