/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.stargate;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;

public class AutoCloseManager
implements INBTSerializable<NBTTagCompound> {
    private StargateAbstractBaseTile gateTile;
    private int secondsPassed;
    private int playersPassed;

    public AutoCloseManager(StargateAbstractBaseTile gateTile) {
        this.gateTile = gateTile;
    }

    public void reset() {
        this.secondsPassed = 0;
        this.playersPassed = 0;
    }

    public void playerPassing() {
        ++this.playersPassed;
    }

    public boolean shouldClose(StargatePos sourceStargatePos) {
        if (this.gateTile.func_145831_w().func_82737_E() % 20L == 0L) {
            World sourceWorld = sourceStargatePos.getWorld();
            BlockPos sourcePos = sourceStargatePos.gatePos;
            boolean sourceLoaded = sourceWorld.func_175667_e(sourcePos);
            if (this.playersPassed > 0) {
                AxisAlignedBB scanBox;
                int playerCount;
                this.secondsPassed = sourceLoaded ? ((playerCount = sourceWorld.func_175647_a(EntityPlayerMP.class, scanBox = new AxisAlignedBB(sourcePos.func_177971_a(new Vec3i(-10, -5, -10)), sourcePos.func_177971_a(new Vec3i(10, 5, 10))), player -> !player.field_70128_L).size()) == 0 ? ++this.secondsPassed : 0) : ++this.secondsPassed;
            }
            if (this.secondsPassed >= JSGConfig.Stargate.autoClose.secondsToAutoclose) {
                return true;
            }
        }
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("secondsPassed", this.secondsPassed);
        compound.func_74768_a("playersPassed", this.playersPassed);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        if (compound == null) {
            return;
        }
        this.secondsPassed = compound.func_74762_e("secondsPassed");
        this.playersPassed = compound.func_74762_e("playersPassed");
    }
}

