/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.transportrings.controller;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.transportrings.TransportRingsAddress;

public abstract class TRControllerAbstractRendererState
extends State {
    public BlockPos pos;
    public boolean ringsAreConnected;
    public TransportRingsAddress addressDialed;
    protected BiomeOverlayEnum biomeOverlay;

    public TRControllerAbstractRendererState(TransportRingsAddress addressDialed, BiomeOverlayEnum biomeOverride, boolean ringsAreConnected) {
        this.addressDialed = addressDialed;
        this.biomeOverlay = biomeOverride;
        this.ringsAreConnected = ringsAreConnected;
    }

    public TRControllerAbstractRendererState() {
    }

    public TRControllerAbstractRendererState initClient(BlockPos pos, BiomeOverlayEnum biomeOverlay, TransportRingsAbstractTile rings) {
        this.pos = pos;
        this.biomeOverlay = biomeOverlay;
        this.ringsAreConnected = rings != null && rings.isBusy();
        return this;
    }

    public void setIsConnected(boolean connected) {
        this.ringsAreConnected = connected;
    }

    public BiomeOverlayEnum getBiomeOverlay() {
        return this.biomeOverlay;
    }

    public void setBiomeOverlay(BiomeOverlayEnum biomeOverlay) {
        this.biomeOverlay = biomeOverlay;
    }

    public abstract void iterate(World var1, double var2);

    public abstract boolean isButtonActive(SymbolInterface var1);

    public abstract int getActivatedButtons();

    @Override
    public void toBytes(ByteBuf buf) {
        this.addressDialed.toBytes(buf);
        buf.writeBoolean(this.ringsAreConnected);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.addressDialed.fromBytes(buf);
        this.ringsAreConnected = buf.readBoolean();
    }
}

