/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.transportrings.controller;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import tauri.dev.jsg.block.transportrings.controller.TRControllerAbstractBlock;
import tauri.dev.jsg.renderer.transportrings.controller.TRControllerAbstractRendererState;
import tauri.dev.jsg.tileentity.transportrings.controller.TRControllerAbstractTile;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.main.JSGProps;
import tauri.dev.vector.Vector3f;

public abstract class TRControllerAbstractRenderer
extends TileEntitySpecialRenderer<TRControllerAbstractTile> {
    protected EnumFacing facing;
    protected static final Vector3f NORTH_TRANSLATION = new Vector3f(0.0f, 0.0f, 0.0f);
    protected static final Vector3f EAST_TRANSLATION = new Vector3f(1.0f, 0.0f, 0.0f);
    protected static final Vector3f SOUTH_TRANSLATION = new Vector3f(1.0f, 0.0f, 1.0f);
    protected static final Vector3f WEST_TRANSLATION = new Vector3f(0.0f, 0.0f, 1.0f);

    public static Vector3f getTranslation(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EAST_TRANSLATION;
            }
            case SOUTH: {
                return SOUTH_TRANSLATION;
            }
            case WEST: {
                return WEST_TRANSLATION;
            }
        }
        return NORTH_TRANSLATION;
    }

    public void render(TRControllerAbstractTile te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TRControllerAbstractRendererState rendererState = te.getRendererState();
        if (rendererState == null) {
            return;
        }
        if (!(te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c() instanceof TRControllerAbstractBlock)) {
            return;
        }
        rendererState.iterate(this.func_178459_a(), partialTicks);
        IBlockState blockState = te.func_145831_w().func_180495_p(te.func_174877_v());
        this.facing = (EnumFacing)blockState.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        Vector3f tr = TRControllerAbstractRenderer.getTranslation(this.facing);
        int rot = FacingHelper.getIntRotation(this.facing, false);
        GlStateManager.func_179109_b((float)tr.x, (float)tr.y, (float)tr.z);
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderController(te, rendererState);
        GlStateManager.func_179121_F();
    }

    public abstract void renderController(TRControllerAbstractTile var1, TRControllerAbstractRendererState var2);
}

