/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.stargate;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tauri.dev.jsg.renderer.activation.Activation;
import tauri.dev.jsg.renderer.activation.UniverseActivation;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargateClassicRendererState;
import tauri.dev.jsg.stargate.network.StargateAddressDynamic;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.stargate.network.SymbolUniverseEnum;

public class StargateUniverseRendererState
extends StargateClassicRendererState {
    private StargateAddressDynamic dialedAddress;
    private final Map<SymbolUniverseEnum, Float> symbolStateMap = new HashMap<SymbolUniverseEnum, Float>(36);
    private final List<Activation<SymbolUniverseEnum>> activationList = new ArrayList<Activation<SymbolUniverseEnum>>();

    public StargateUniverseRendererState() {
    }

    public StargateUniverseRendererState(StargateUniverseRendererStateBuilder builder) {
        super(builder);
        this.dialedAddress = builder.dialedAddress;
    }

    @Override
    public StargateAbstractRendererState initClient(BlockPos pos, EnumFacing facing, EnumFacing facingVertical, BiomeOverlayEnum biomeOverlay) {
        for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
            this.symbolStateMap.put(symbol, Float.valueOf(StargateUniverseRendererState.getFloatValue(this.dialedAddress.contains(symbol))));
        }
        return super.initClient(pos, facing, facingVertical, biomeOverlay);
    }

    @Override
    protected String getChevronTextureBase() {
        return "universe/universe_chevron";
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        this.dialedAddress.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dialedAddress = new StargateAddressDynamic(SymbolTypeEnum.UNIVERSE);
        this.dialedAddress.fromBytes(buf);
    }

    private boolean isSymbolActiveClientSide(SymbolUniverseEnum symbol) {
        return this.symbolStateMap.get(symbol).floatValue() > 0.0f;
    }

    public void clearSymbols(long totalWorldTime) {
        for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
            if (!this.isSymbolActiveClientSide(symbol)) continue;
            this.activationList.add(new UniverseActivation(symbol, totalWorldTime, true));
        }
    }

    public void activateSymbol(long totalWorldTime, SymbolUniverseEnum symbol) {
        this.activationList.add(new UniverseActivation(symbol, totalWorldTime, false));
    }

    public void iterate(World world, double partialTicks) {
        Activation.iterate(this.activationList, world.func_82737_E(), partialTicks, this.symbolStateMap::put);
    }

    public float getSymbolColor(SymbolUniverseEnum symbol) {
        return this.symbolStateMap.get(symbol).floatValue();
    }

    public static float getFloatValue(boolean isActive) {
        return isActive ? 0.6f : 0.0f;
    }

    public static StargateUniverseRendererStateBuilder builder() {
        return new StargateUniverseRendererStateBuilder();
    }

    public static class StargateUniverseRendererStateBuilder
    extends StargateClassicRendererState.StargateClassicRendererStateBuilder {
        private StargateAddressDynamic dialedAddress;

        public StargateUniverseRendererStateBuilder() {
        }

        public StargateUniverseRendererStateBuilder(StargateClassicRendererState.StargateClassicRendererStateBuilder superBuilder) {
            super(superBuilder);
            this.setSymbolType(superBuilder.symbolType);
            this.setActiveChevrons(superBuilder.activeChevrons);
            this.setFinalActive(superBuilder.isFinalActive);
            this.setCurrentRingSymbol(superBuilder.currentRingSymbol);
            this.setSpinDirection(superBuilder.spinDirection);
            this.setSpinning(superBuilder.isSpinning);
            this.setTargetRingSymbol(superBuilder.targetRingSymbol);
            this.setSpinStartTime(superBuilder.spinStartTime);
            this.setBiomeOverride(superBuilder.biomeOverride);
            this.setIrisState(superBuilder.irisState);
            this.setIrisType(superBuilder.irisType);
            this.setIrisAnimation(superBuilder.irisAnimation);
            this.setPlusRounds(superBuilder.plusRounds);
        }

        public StargateUniverseRendererStateBuilder setDialedAddress(StargateAddressDynamic dialedAddress) {
            this.dialedAddress = dialedAddress;
            return this;
        }

        @Override
        public StargateAbstractRendererState build() {
            return new StargateUniverseRendererState(this);
        }
    }
}

