/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.stargate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.loader.texture.Texture;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.renderer.stargate.ChevronEnum;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRenderer;
import tauri.dev.jsg.renderer.stargate.StargateClassicRendererState;
import tauri.dev.jsg.renderer.stargate.StargateRendererStatic;
import tauri.dev.jsg.stargate.EnumIrisState;
import tauri.dev.jsg.stargate.EnumIrisType;
import tauri.dev.jsg.stargate.EnumMemberVariant;
import tauri.dev.jsg.stargate.merging.StargateAbstractMergeHelper;
import tauri.dev.jsg.stargate.merging.StargateMilkyWayMergeHelper;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.JSGTextureLightningHelper;
import tauri.dev.jsg.util.main.JSGProps;

public abstract class StargateClassicRenderer<S extends StargateClassicRendererState>
extends StargateAbstractRenderer<S> {
    protected static final ResourceLocation SHIELD_TEXTURE = new ResourceLocation("jsg", "textures/tesr/iris/shield.jpg");
    public static final int PHYSICAL_IRIS_ANIMATION_LENGTH = 60;
    public static final int SHIELD_IRIS_ANIMATION_LENGTH = 10;

    public abstract float getGateDiameter();

    public abstract double getScaleMultiplier();

    @Override
    protected void applyTransformations(StargateClassicRendererState rendererState) {
        double scale = rendererState.stargateSize.renderScale * this.getScaleMultiplier();
        GlStateManager.func_179137_b((double)0.5, (double)((double)this.getGateDiameter() * scale / 2.0 + 0.2), (double)0.5);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
    }

    @Override
    protected void applyLightMap(StargateClassicRendererState rendererState, double partialTicks) {
        int chevronCount = 6;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int i = 0; i < 6; ++i) {
            list.add(FacingHelper.rotateBlock(StargateMilkyWayMergeHelper.INSTANCE.getChevronBlocks().get(i), rendererState.facing, rendererState.facingVertical).func_177971_a((Vec3i)rendererState.pos));
        }
        JSGTextureLightningHelper.resetLight(this.func_178459_a(), list);
    }

    @Override
    protected Map<BlockPos, IBlockState> getMemberBlockStates(StargateAbstractMergeHelper mergeHelper, EnumFacing facing, EnumFacing facingVertical) {
        HashMap<BlockPos, IBlockState> map = new HashMap<BlockPos, IBlockState>();
        for (BlockPos pos : mergeHelper.getRingBlocks()) {
            map.put(pos, mergeHelper.getMemberBlock().func_176223_P().func_177226_a((IProperty)JSGProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.RING)).func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)facing).func_177226_a((IProperty)JSGProps.FACING_VERTICAL, (Comparable)facingVertical));
        }
        for (BlockPos pos : mergeHelper.getChevronBlocks()) {
            map.put(pos, mergeHelper.getMemberBlock().func_176223_P().func_177226_a((IProperty)JSGProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.CHEVRON)).func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)facing).func_177226_a((IProperty)JSGProps.FACING_VERTICAL, (Comparable)facingVertical));
        }
        return map;
    }

    protected abstract void renderChevron(S var1, double var2, ChevronEnum var4, boolean var5);

    protected void renderChevrons(S rendererState, double partialTicks) {
        for (ChevronEnum chevron : ChevronEnum.values()) {
            this.setGateHeatColor((StargateClassicRendererState)rendererState);
            GlStateManager.func_179094_E();
            this.renderChevron(rendererState, partialTicks, chevron, false);
            JSGTextureLightningHelper.lightUpTexture((float)((StargateClassicRendererState)rendererState).chevronTextureList.CHEVRON_STATE_MAP.get(chevron).intValue() / 10.0f);
            this.renderChevron(rendererState, partialTicks, chevron, true);
            this.applyLightMap((StargateClassicRendererState)rendererState, partialTicks);
            GlStateManager.func_179121_F();
        }
        ((StargateClassicRendererState)rendererState).chevronTextureList.iterate(this.func_178459_a(), partialTicks);
    }

    @Override
    public void renderIris(double partialTicks, World world, S rendererState, boolean backOnly) {
        float irisAnimationStage = world.func_82737_E() - ((StargateClassicRendererState)rendererState).irisAnimation;
        EnumIrisState irisState = ((StargateClassicRendererState)rendererState).irisState;
        EnumIrisType irisType = ((StargateClassicRendererState)rendererState).irisType;
        if (irisType == null || irisState == null) {
            return;
        }
        if (irisState == EnumIrisState.OPENED) {
            return;
        }
        if (irisType == EnumIrisType.SHIELD) {
            int k;
            if ((irisAnimationStage *= 0.07f) > 0.7f) {
                irisAnimationStage = 0.7f;
            }
            if (irisAnimationStage < 0.0f) {
                irisAnimationStage = 0.0f;
            }
            if (irisState == EnumIrisState.OPENING) {
                irisAnimationStage = 0.7f - irisAnimationStage;
            }
            GlStateManager.func_179094_E();
            Texture irisTexture = TextureLoader.getTexture(SHIELD_TEXTURE);
            if (irisTexture != null) {
                irisTexture.bindTexture();
            }
            float tick = (float)((double)this.func_178459_a().func_82737_E() + partialTicks);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.13);
            int n = k = backOnly ? 1 : 0;
            while (k < 2) {
                if (k == 1) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                StargateRendererStatic.innerCircle.render(tick, false, Float.valueOf(irisAnimationStage), 0.0f, (byte)-1);
                for (StargateRendererStatic.QuadStrip strip : StargateRendererStatic.quadStrips) {
                    strip.render(tick, false, Float.valueOf(irisAnimationStage), 0.0f, (byte)-1);
                }
                ++k;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if ((irisType == EnumIrisType.IRIS_TITANIUM || irisType == EnumIrisType.IRIS_TRINIUM) && backOnly) {
            this.setIrisHeatColor((StargateClassicRendererState)rendererState);
            irisAnimationStage *= 0.028333334f;
            if (irisAnimationStage > 1.7f) {
                irisAnimationStage = 1.7f;
            }
            if (irisAnimationStage < 0.0f) {
                irisAnimationStage = 0.0f;
            }
            if (irisState == EnumIrisState.OPENING) {
                irisAnimationStage = 1.7f - irisAnimationStage;
            }
            for (float i = 0.0f; i < 20.0f; i += 1.0f) {
                float rotateIndex = 18.0f * i;
                GlStateManager.func_179094_E();
                ElementEnum.IRIS.bindTexture(((StargateClassicRendererState)rendererState).getBiomeOverlay());
                GlStateManager.func_179114_b((float)rotateIndex, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)(-irisAnimationStage), (double)(-(irisAnimationStage * 2.0f)), (double)0.02);
                ElementEnum.IRIS.render();
                GlStateManager.func_179121_F();
            }
        }
    }

    public void setIrisHeatColor(StargateClassicRendererState rendererState, float red) {
        GlStateManager.func_179124_c((float)(1.0f + red * 3.0f), (float)1.0f, (float)1.0f);
    }

    public void setIrisHeatColor(StargateClassicRendererState rendererState) {
        if (rendererState.irisHeat == -1.0) {
            this.setIrisHeatColor(rendererState, 0.0f);
            return;
        }
        float red = (float)(rendererState.irisHeat / (rendererState.irisType == EnumIrisType.IRIS_TITANIUM ? StargateClassicBaseTile.IRIS_MAX_HEAT_TITANIUM : StargateClassicBaseTile.IRIS_MAX_HEAT_TRINIUM));
        this.setIrisHeatColor(rendererState, red);
    }

    public void setGateHeatColor(StargateClassicRendererState rendererState) {
        if (rendererState.gateHeat == -1.0) {
            return;
        }
        float red = (float)(rendererState.gateHeat / StargateClassicBaseTile.GATE_MAX_HEAT);
        GlStateManager.func_179124_c((float)(1.0f + red * 2.7f), (float)1.0f, (float)1.0f);
    }
}

