/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.stargate;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRenderer;
import tauri.dev.jsg.renderer.stargate.StargateRendererStatic;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.state.State;

public class StargateAbstractRendererState
extends State {
    public BlockPos pos;
    public EnumFacing facing;
    public EnumFacing facingVertical;
    public float horizontalRotation;
    public float verticalRotation;
    private BiomeOverlayEnum biomeOverlay;
    public boolean doEventHorizonRender = false;
    public StargateAbstractRenderer.EnumVortexState vortexState = StargateAbstractRenderer.EnumVortexState.FORMING;
    public StargateRendererStatic.QuadStrip backStrip;
    public boolean backStripClamp;
    public Float whiteOverlayAlpha;
    public long gateWaitStart = 0L;
    public long gateWaitClose = 0L;
    public boolean zeroAlphaSet;
    public boolean horizonUnstable = false;
    public int horizonSegments = 0;

    public StargateAbstractRendererState() {
    }

    protected StargateAbstractRendererState(StargateAbstractRendererStateBuilder builder) {
        if (builder.stargateState.engaged()) {
            this.doEventHorizonRender = true;
            this.vortexState = StargateAbstractRenderer.EnumVortexState.STILL;
        }
    }

    public StargateAbstractRendererState initClient(BlockPos pos, EnumFacing facing, EnumFacing facingVertical, BiomeOverlayEnum biomeOverlay) {
        this.pos = pos;
        this.facing = facing;
        this.facingVertical = facingVertical;
        if (facing.func_176740_k() == EnumFacing.Axis.X) {
            facing = facing.func_176734_d();
        }
        this.horizontalRotation = facing.func_185119_l();
        this.verticalRotation = facingVertical == EnumFacing.DOWN ? 90 : (facingVertical == EnumFacing.UP ? 270 : 0);
        this.biomeOverlay = biomeOverlay;
        return this;
    }

    public void openGate(long totalWorldTime) {
        this.gateWaitStart = totalWorldTime;
        this.zeroAlphaSet = false;
        this.backStripClamp = true;
        this.whiteOverlayAlpha = Float.valueOf(1.0f);
        this.vortexState = StargateAbstractRenderer.EnumVortexState.FORMING;
        this.doEventHorizonRender = true;
    }

    public void closeGate(long totalWorldTime) {
        this.gateWaitClose = totalWorldTime;
        this.vortexState = StargateAbstractRenderer.EnumVortexState.CLOSING;
    }

    public BiomeOverlayEnum getBiomeOverlay() {
        return this.biomeOverlay;
    }

    public void setBiomeOverlay(BiomeOverlayEnum biomeOverlay) {
        this.biomeOverlay = biomeOverlay;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.doEventHorizonRender);
        buf.writeInt(this.vortexState.index);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.doEventHorizonRender = buf.readBoolean();
        this.vortexState = StargateAbstractRenderer.EnumVortexState.valueOf(buf.readInt());
    }

    public static StargateAbstractRendererStateBuilder builder() {
        return new StargateAbstractRendererStateBuilder();
    }

    public static class StargateAbstractRendererStateBuilder {
        protected EnumStargateState stargateState;

        public StargateAbstractRendererStateBuilder setStargateState(EnumStargateState stargateState) {
            this.stargateState = stargateState;
            return this;
        }

        public StargateAbstractRendererState build() {
            return new StargateAbstractRendererState(this);
        }
    }
}

