/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.stargate;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL14;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.loader.texture.Texture;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.renderer.BlockRenderer;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargateClassicRendererState;
import tauri.dev.jsg.renderer.stargate.StargateRendererStatic;
import tauri.dev.jsg.renderer.stargate.StargateUniverseRenderer;
import tauri.dev.jsg.stargate.EnumIrisState;
import tauri.dev.jsg.stargate.EnumIrisType;
import tauri.dev.jsg.stargate.merging.StargateAbstractMergeHelper;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.JSGAxisAlignedBB;
import tauri.dev.jsg.util.JSGMinecraftHelper;
import tauri.dev.jsg.util.main.JSGProps;

public abstract class StargateAbstractRenderer<S extends StargateAbstractRendererState>
extends TileEntitySpecialRenderer<StargateAbstractBaseTile> {
    protected static final String EV_HORIZON_NORMAL_TEXTURE_ANIMATED = "textures/tesr/event_horizon_animated.jpg";
    protected static final String EV_HORIZON_KAWOOSH_TEXTURE_ANIMATED = "textures/tesr/event_horizon_animated_kawoosh.jpg";
    protected static final String EV_HORIZON_DESATURATED_KAWOOSH_TEXTURE_ANIMATED = "textures/tesr/event_horizon_animated_kawoosh_unstable.jpg";
    protected static final String EV_HORIZON_DESATURATED_TEXTURE_ANIMATED = "textures/tesr/event_horizon_animated_unstable.jpg";
    protected static final String EV_HORIZON_NORMAL_TEXTURE = "textures/tesr/event_horizon.jpg";
    protected static final String EV_HORIZON_DESATURATED_TEXTURE = "textures/tesr/event_horizon_unstable.jpg";
    private static final float VORTEX_START = 5.275f;
    private static final float SPEED_FACTOR = 6.0f;
    private static final Map<ResourceLocation, Boolean> EH_RENDERED = new HashMap<ResourceLocation, Boolean>();

    public static boolean isEhAnimatedLoaded() {
        return !TextureLoader.isNotTextureLoaded(new ResourceLocation("jsg", EV_HORIZON_NORMAL_TEXTURE_ANIMATED));
    }

    public static boolean isEhKawooshLoaded() {
        if (!StargateAbstractRenderer.isEhAnimatedLoaded()) {
            return true;
        }
        return !TextureLoader.isNotTextureLoaded(new ResourceLocation("jsg", "textures/tesr/event_horizon_animated_kawoosh.jpg_0.0"));
    }

    public void render(StargateAbstractBaseTile te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        StargateAbstractRendererState rendererState = te.getRendererStateClient();
        if (rendererState != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179140_f();
            if (this.shouldRender(rendererState)) {
                if (JSGConfig.General.debug.renderBoundingBoxes || JSGConfig.General.debug.renderWholeKawooshBoundingBox) {
                    te.getEventHorizonLocalBox().render();
                    int segments = JSGConfig.General.debug.renderWholeKawooshBoundingBox ? te.getLocalKillingBoxes().size() : rendererState.horizonSegments;
                    for (int i = 0; i < segments; ++i) {
                        te.getLocalKillingBoxes().get(i).render();
                    }
                    for (JSGAxisAlignedBB b : te.getLocalInnerBlockBoxes()) {
                        b.render();
                    }
                    te.getRenderBoundingBoxForDisplay().render();
                }
                this.applyTransformations(rendererState);
                GlStateManager.func_179101_C();
                this.applyLightMap(rendererState, partialTicks);
                GlStateManager.func_179114_b((float)rendererState.horizontalRotation, (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderGate(te, rendererState, partialTicks);
                this.renderIris(partialTicks, this.func_178459_a(), rendererState, true);
                if (rendererState.doEventHorizonRender) {
                    GlStateManager.func_179094_E();
                    this.renderKawoosh(rendererState, partialTicks);
                    GlStateManager.func_179121_F();
                } else if (JSGConfig.Stargate.eventHorizon.renderEHifTheyNot) {
                    GlStateManager.func_179094_E();
                    this.preRenderKawoosh(rendererState, partialTicks);
                    GlStateManager.func_179121_F();
                }
                this.renderIris(partialTicks, this.func_178459_a(), rendererState, false);
            } else if (JSGConfig.Stargate.visual.renderStargateNotPlaced) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)32771, (int)32772);
                GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f);
                for (Map.Entry<BlockPos, IBlockState> entry : this.getMemberBlockStates(te.getMergeHelper(), rendererState.facing, rendererState.facingVertical).entrySet()) {
                    BlockPos pos = FacingHelper.rotateBlock(entry.getKey(), rendererState.facing, rendererState.facingVertical);
                    BlockPos absolutePos = pos.func_177971_a((Vec3i)rendererState.pos);
                    if (!this.func_178459_a().func_180495_p(absolutePos).func_177230_c().func_176200_f((IBlockAccess)this.func_178459_a(), absolutePos)) continue;
                    BlockRenderer.render(this.func_178459_a(), pos, entry.getValue(), absolutePos);
                }
                GlStateManager.func_179084_k();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
        }
    }

    protected boolean shouldRender(S rendererState) {
        IBlockState state = this.func_178459_a().func_180495_p(((StargateAbstractRendererState)rendererState).pos);
        return state.func_177227_a().contains(JSGProps.RENDER_BLOCK) && (Boolean)state.func_177229_b((IProperty)JSGProps.RENDER_BLOCK) == false;
    }

    protected abstract Map<BlockPos, IBlockState> getMemberBlockStates(StargateAbstractMergeHelper var1, EnumFacing var2, EnumFacing var3);

    protected abstract void applyLightMap(S var1, double var2);

    protected abstract void applyTransformations(S var1);

    protected abstract void renderGate(StargateAbstractBaseTile var1, S var2, double var3);

    protected ResourceLocation getEventHorizonTextureResource(StargateAbstractRendererState rendererState, boolean kawoosh) {
        return new ResourceLocation("jsg", this.getEventHorizonTexturePath(rendererState, kawoosh));
    }

    protected String getEventHorizonTexturePath(StargateAbstractRendererState rendererState, boolean kawoosh) {
        String texture;
        String string = rendererState.horizonUnstable ? EV_HORIZON_DESATURATED_TEXTURE_ANIMATED : (texture = kawoosh ? EV_HORIZON_KAWOOSH_TEXTURE_ANIMATED : EV_HORIZON_NORMAL_TEXTURE_ANIMATED);
        if (JSGConfig.Stargate.eventHorizon.disableAnimatedEventHorizon || !StargateAbstractRenderer.isEhAnimatedLoaded()) {
            texture = rendererState.horizonUnstable ? EV_HORIZON_DESATURATED_TEXTURE : EV_HORIZON_NORMAL_TEXTURE;
        }
        return texture;
    }

    protected void renderKawoosh(StargateAbstractRendererState rendererState, double partialTicks) {
        this.renderKawoosh(rendererState, partialTicks, true);
    }

    protected void preRenderKawoosh(StargateAbstractRendererState rendererState, double partialTicks) {
        StargateAbstractRendererState rs = new StargateAbstractRendererState().initClient(rendererState.pos, rendererState.facing, rendererState.facingVertical, rendererState.getBiomeOverlay());
        for (int i = 0; i < 2; ++i) {
            rs.vortexState = i == 0 ? EnumVortexState.STILL : EnumVortexState.FORMING;
            this.renderKawoosh(rs, partialTicks, false);
        }
    }

    protected void renderKawoosh(StargateAbstractRendererState rendererState, double partialTicks, boolean render) {
        Texture ehTexture;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        float gateWait = (float)this.func_178459_a().func_82737_E() - (float)rendererState.gateWaitStart;
        if (gateWait < 20.0f) {
            return;
        }
        boolean isKawoosh = rendererState.vortexState == EnumVortexState.FORMING || rendererState.vortexState == EnumVortexState.DECREASING || rendererState.vortexState == EnumVortexState.FULL;
        ResourceLocation ehTextureRes = this.getEventHorizonTextureResource(rendererState, isKawoosh);
        String ehTextureResKawooshPath = this.getEventHorizonTexturePath(rendererState, true);
        if (!render && EH_RENDERED.get(ehTextureRes).booleanValue()) {
            return;
        }
        EH_RENDERED.put(ehTextureRes, true);
        GlStateManager.func_179140_f();
        GlStateManager.func_179089_o();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.01);
        if (!render) {
            GlStateManager.func_179152_a((float)1.0E-7f, (float)1.0E-7f, (float)1.0E-7f);
        }
        if ((ehTexture = TextureLoader.getTexture(ehTextureRes)) != null) {
            ehTexture.bindTexture();
        }
        long kawooshStart = rendererState.gateWaitStart + 44L - 24L;
        float tick = (float)((double)(this.func_178459_a().func_82737_E() - kawooshStart) + partialTicks);
        float inner = 3.790975f - tick / 3.957f;
        float tick2 = tick / 4.0f;
        if ((double)tick2 <= 1.5707963267948966) {
            rendererState.whiteOverlayAlpha = Float.valueOf(MathHelper.func_76134_b((float)tick2));
        } else if (!rendererState.zeroAlphaSet) {
            rendererState.zeroAlphaSet = true;
            rendererState.whiteOverlayAlpha = Float.valueOf(0.0f);
        }
        if (inner >= 2.5f) {
            rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, inner - 0.2f, 3.790975f, Float.valueOf(tick));
        } else {
            if (rendererState.backStripClamp) {
                rendererState.backStripClamp = false;
                rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, 2.3f, 3.790975f, null);
                float argState = (tick - 5.275f) / 6.0f;
                if (argState < 1.342f) {
                    rendererState.vortexState = EnumVortexState.FORMING;
                } else if (argState < 4.15f) {
                    rendererState.vortexState = EnumVortexState.FULL;
                } else if (argState < 5.898f) {
                    rendererState.vortexState = EnumVortexState.DECREASING;
                } else if (rendererState.vortexState != EnumVortexState.CLOSING) {
                    rendererState.vortexState = EnumVortexState.STILL;
                }
            }
            if (rendererState.vortexState != EnumVortexState.STILL) {
                float arg = (tick - 5.275f) / 6.0f;
                if (rendererState.vortexState != EnumVortexState.CLOSING) {
                    if (rendererState.vortexState != EnumVortexState.SHRINKING) {
                        float mul;
                        if (rendererState.vortexState == EnumVortexState.FORMING && arg >= 1.342f) {
                            rendererState.vortexState = EnumVortexState.FULL;
                        }
                        float end = 0.75f;
                        if (rendererState.vortexState == EnumVortexState.DECREASING && (double)arg >= 5.398 + (double)end) {
                            rendererState.vortexState = EnumVortexState.STILL;
                        }
                        if (rendererState.vortexState == EnumVortexState.FULL) {
                            if (arg >= 3.65f + end) {
                                rendererState.vortexState = EnumVortexState.DECREASING;
                            }
                            mul = arg < 2.0f ? (arg - 1.5f) * (arg - 2.5f) / -10.0f + 0.91f : (arg > 3.0f + end ? (arg - 2.5f - end) * (arg - 3.5f - end) / -10.0f + 0.91f : 0.935f);
                        } else {
                            mul = rendererState.vortexState == EnumVortexState.FORMING ? arg * (arg - 4.0f) / -4.0f : (arg - 1.0f - end) * (arg - 5.0f - end) / -5.968f + 0.29333f;
                        }
                        boolean renderWortex = true;
                        if (rendererState instanceof StargateClassicRendererState) {
                            StargateClassicRendererState casted = (StargateClassicRendererState)rendererState;
                            if (casted.irisState == EnumIrisState.CLOSED && casted.irisType != EnumIrisType.NULL) {
                                mul = 0.0f;
                                renderWortex = false;
                            }
                        }
                        if (!JSGConfig.Stargate.eventHorizon.disableNewKawoosh && StargateAbstractRenderer.isEhKawooshLoaded()) {
                            if (mul >= 0.0f) {
                                this.renderEventHorizon(partialTicks, false, Float.valueOf(0.0f), false, mul);
                                if (renderWortex) {
                                    ResourceLocation tex;
                                    Texture texTex;
                                    GlStateManager.func_179094_E();
                                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                    float factor = Math.abs(mul);
                                    float xyFactor = 0.7f * (this instanceof StargateUniverseRenderer ? 1.3f : 1.0f);
                                    GlStateManager.func_179152_a((float)xyFactor, (float)xyFactor, (float)factor);
                                    int texIndex = (int)(tick * 4.0f % 185.0f);
                                    int x = texIndex % 14;
                                    int y = texIndex / 14;
                                    String subPathEnd = "_" + x + "." + y;
                                    if (JSGConfig.Stargate.eventHorizon.disableAnimatedEventHorizon || !StargateAbstractRenderer.isEhAnimatedLoaded()) {
                                        subPathEnd = "";
                                    }
                                    if ((texTex = TextureLoader.getTexture(tex = new ResourceLocation("jsg", ehTextureResKawooshPath + subPathEnd))) == null) {
                                        JSG.info("Texture == null!! -> " + ehTextureResKawooshPath + subPathEnd);
                                    } else {
                                        texTex.bindTexture();
                                    }
                                    ElementEnum.KAWOOSH.render();
                                    GlStateManager.func_179121_F();
                                    TextureLoader.getTexture(ehTextureRes).bindTexture();
                                }
                            }
                        } else {
                            float prevZ = 0.0f;
                            float prevRad = 0.0f;
                            boolean first = true;
                            for (Map.Entry<Float, Float> e : StargateRendererStatic.Z_RadiusMap.entrySet()) {
                                if (first) {
                                    first = false;
                                    prevZ = e.getKey().floatValue();
                                    prevRad = e.getValue().floatValue();
                                    continue;
                                }
                                float zOffset = e.getKey().floatValue();
                                float rad = e.getValue().floatValue();
                                new StargateRendererStatic.QuadStrip(8, rad, prevRad, Float.valueOf(tick)).render(tick, Float.valueOf(zOffset * mul), Float.valueOf(prevZ * mul), false, Float.valueOf(1.0f - rendererState.whiteOverlayAlpha.floatValue()), 1.0f);
                                prevZ = zOffset;
                                prevRad = rad;
                            }
                        }
                    } else {
                        long stateChange = rendererState.gateWaitClose + 35L;
                        float arg2 = (float)(((double)(this.func_178459_a().func_82737_E() - stateChange) + partialTicks) / 3.0) - 1.0f;
                        if (arg2 < 3.890975f) {
                            rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, arg2, 3.790975f, Float.valueOf(tick));
                        } else {
                            rendererState.whiteOverlayAlpha = null;
                            if (this.func_178459_a().func_82737_E() - stateChange - 9L > 7L) {
                                rendererState.doEventHorizonRender = false;
                            }
                        }
                    }
                } else if (this.func_178459_a().func_82737_E() - rendererState.gateWaitClose > 35L) {
                    float arg2 = (float)(((double)(this.func_178459_a().func_82737_E() - (rendererState.gateWaitClose + 35L)) + partialTicks) / 6.0 / 2.0);
                    if ((double)arg2 <= 0.5235987755982988) {
                        rendererState.whiteOverlayAlpha = Float.valueOf(MathHelper.func_76126_a((float)arg2));
                    } else {
                        if (rendererState.backStrip == null) {
                            rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, arg2, 3.790975f, Float.valueOf(tick));
                        }
                        rendererState.vortexState = EnumVortexState.SHRINKING;
                    }
                }
            }
        }
        if (rendererState.vortexState != null && (rendererState.vortexState == EnumVortexState.STILL || rendererState.vortexState == EnumVortexState.CLOSING)) {
            if (rendererState.vortexState == EnumVortexState.CLOSING) {
                this.renderEventHorizon(partialTicks, true, rendererState.whiteOverlayAlpha, false, 1.7f);
            } else {
                this.renderEventHorizon(partialTicks, false, null, false, rendererState.horizonUnstable ? 1.2f : 1.0f);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            return;
        }
        if (rendererState.whiteOverlayAlpha != null) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179147_l();
            if (rendererState.backStrip != null) {
                rendererState.backStrip.render(tick, Float.valueOf(0.0f), null, false, Float.valueOf(1.0f - rendererState.whiteOverlayAlpha.floatValue()), 1.0f);
            }
            this.renderEventHorizon(partialTicks, false, Float.valueOf(0.0f), true, 1.0f);
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    protected void renderEventHorizon(double partialTicks, boolean white, Float alpha, boolean backOnly, float mul) {
        int k;
        float tick = JSGMinecraftHelper.getClientTick();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        int n = k = backOnly ? 1 : 0;
        while (k < 2) {
            if (k == 1) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (alpha == null) {
                alpha = Float.valueOf(0.0f);
            }
            if (k == 1) {
                alpha = Float.valueOf(alpha.floatValue() + 0.3f);
            }
            if (white) {
                StargateRendererStatic.innerCircle.render(tick, true, alpha, mul);
            }
            StargateRendererStatic.innerCircle.render(tick, false, Float.valueOf(1.0f - alpha.floatValue()), mul);
            for (StargateRendererStatic.QuadStrip strip : StargateRendererStatic.quadStrips) {
                if (white) {
                    strip.render(tick, true, alpha, mul);
                }
                strip.render(tick, false, Float.valueOf(1.0f - alpha.floatValue()), mul);
            }
            ++k;
        }
        GlStateManager.func_179084_k();
    }

    public boolean isGlobalRenderer(@Nonnull StargateAbstractBaseTile te) {
        return true;
    }

    protected void renderIris(double partialTicks, World world, S rendererState, boolean backOnly) {
    }

    static {
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_NORMAL_TEXTURE_ANIMATED), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_KAWOOSH_TEXTURE_ANIMATED), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_DESATURATED_KAWOOSH_TEXTURE_ANIMATED), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_DESATURATED_TEXTURE_ANIMATED), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_NORMAL_TEXTURE), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_DESATURATED_TEXTURE), false);
    }

    public static enum EnumVortexState {
        FORMING(0),
        FULL(1),
        DECREASING(2),
        STILL(3),
        CLOSING(4),
        SHRINKING(5);

        private static final Map<Integer, EnumVortexState> map;
        public final int index;

        private EnumVortexState(int index) {
            this.index = index;
        }

        public static EnumVortexState valueOf(int index) {
            return map.get(index);
        }

        public boolean equals(EnumVortexState state) {
            return this.index == state.index;
        }

        static {
            map = new HashMap<Integer, EnumVortexState>();
            for (EnumVortexState packet : EnumVortexState.values()) {
                map.put(packet.index, packet);
            }
        }
    }
}

