/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.machine;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.particle.ParticleBlenderAtoms;
import tauri.dev.jsg.renderer.BlockRenderer;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.machine.AssemblerRendererState;
import tauri.dev.jsg.tileentity.machine.AssemblerTile;

@SideOnly(value=Side.CLIENT)
public class AssemblerRenderer
extends TileEntitySpecialRenderer<AssemblerTile> {
    public void render(@Nonnull AssemblerTile te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        AssemblerRendererState rendererState = (AssemblerRendererState)te.getRendererState();
        if (rendererState != null) {
            long tick = te.func_145831_w().func_82737_E();
            float color = 1.0f;
            float MIN_COLOR = 0.3f;
            int ANIMATION_TIME = 20;
            long workingTime = te.func_145831_w().func_82737_E() - rendererState.workStateChanged;
            if (workingTime < 20L) {
                color = rendererState.isWorking && rendererState.craftingStack != null ? (float)workingTime / 20.0f * 0.7f + 0.3f : 1.0f - (float)workingTime / 20.0f * 0.7f + 0.3f;
            }
            boolean isMachineOn = false;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179109_b((float)0.5f, (float)1.0f, (float)0.5f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (rendererState.craftingStack != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
                GlStateManager.func_179114_b((float)((float)tick * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)((double)0.05f * Math.sin((float)tick / 9.0f)), (double)0.0);
                BlockRenderer.renderItemOnGround(rendererState.craftingStack);
                GlStateManager.func_179121_F();
                if (rendererState.isWorking) {
                    for (int i = 0; i < 8; ++i) {
                        new ParticleBlenderAtoms(-1.0f + (float)Math.random() * 2.0f, -1.0f + (float)Math.random() * 2.0f, 2.7f, 7, 7, 1.0f, 1.0f, false, motion -> {
                            motion.x = -0.5 + Math.random() * 1.0;
                            motion.z = -0.5 + Math.random() * 1.0;
                        }).spawn(te.func_145831_w(), te.func_174877_v(), 90.0f, true);
                    }
                    isMachineOn = true;
                }
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)0.03, (double)0.03, (double)0.03);
            GlStateManager.func_179094_E();
            if (isMachineOn || workingTime < 20L) {
                TextureLoader.getTexture(TextureLoader.getTextureResource("machine/assembler/assembler_on.png")).bindTexture();
            } else {
                TextureLoader.getTexture(TextureLoader.getTextureResource("machine/assembler/assembler_off.png")).bindTexture();
            }
            GlStateManager.func_179131_c((float)color, (float)color, (float)color, (float)1.0f);
            ElementEnum.ASSEMBLER_MACHINE.render();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            ElementEnum.ASSEMBLER_MACHINE.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }
}

