/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.machine;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tauri.dev.jsg.state.State;

public abstract class AbstractMachineRendererState
extends State {
    public int machineProgress;
    public long workStateChanged;
    public boolean isWorking;
    public ItemStack craftingStack;

    public AbstractMachineRendererState() {
    }

    public AbstractMachineRendererState(long workStateChanged, int machineProgress, boolean isWorking, ItemStack workingOnItemStack) {
        this.workStateChanged = workStateChanged;
        this.machineProgress = machineProgress;
        this.isWorking = isWorking;
        this.craftingStack = workingOnItemStack;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.machineProgress);
        buf.writeBoolean(this.isWorking);
        buf.writeBoolean(this.craftingStack != null && !this.craftingStack.func_190926_b());
        if (this.craftingStack != null && !this.craftingStack.func_190926_b()) {
            buf.writeInt(this.craftingStack.func_190916_E());
            buf.writeInt(Item.func_150891_b((Item)this.craftingStack.func_77973_b()));
            buf.writeInt(this.craftingStack.func_77960_j());
        }
        buf.writeLong(this.workStateChanged);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.machineProgress = buf.readInt();
        this.isWorking = buf.readBoolean();
        if (buf.readBoolean()) {
            int size = buf.readInt();
            int id = buf.readInt();
            int meta = buf.readInt();
            this.craftingStack = new ItemStack(Item.func_150899_d((int)id), size, meta);
        }
        this.workStateChanged = buf.readLong();
    }
}

