/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.dialhomedevice;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.stargate.network.StargateAddressDynamic;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.state.State;

public abstract class DHDAbstractRendererState
extends State {
    public BlockPos pos;
    public float horizontalRotation;
    protected BiomeOverlayEnum biomeOverlay;
    public boolean stargateIsConnected;
    public StargateAddressDynamic addressDialed;
    public boolean brbActive;
    public BiomeOverlayEnum biomeOverride;
    public JSGTileEntityConfig gateConfig = new JSGTileEntityConfig();

    public DHDAbstractRendererState() {
    }

    public DHDAbstractRendererState(StargateAddressDynamic addressDialed, boolean brbActive, BiomeOverlayEnum biomeOverride, boolean stargateIsConnected, JSGTileEntityConfig gateConfig) {
        this.addressDialed = addressDialed;
        this.brbActive = brbActive;
        this.biomeOverride = biomeOverride;
        this.stargateIsConnected = stargateIsConnected;
        this.gateConfig = gateConfig;
    }

    public DHDAbstractRendererState initClient(BlockPos pos, float horizontalRotation, BiomeOverlayEnum biomeOverlay, boolean stargateIsConnected) {
        this.pos = pos;
        this.horizontalRotation = horizontalRotation;
        this.biomeOverlay = biomeOverlay;
        this.stargateIsConnected = stargateIsConnected;
        return this;
    }

    public void setIsConnected(boolean connected) {
        this.stargateIsConnected = connected;
    }

    public BiomeOverlayEnum getBiomeOverlay() {
        if (this.biomeOverride != null) {
            return this.biomeOverride;
        }
        return this.biomeOverlay;
    }

    public void setBiomeOverlay(BiomeOverlayEnum biomeOverlay) {
        this.biomeOverlay = biomeOverlay;
    }

    public abstract void iterate(World var1, double var2);

    public abstract boolean isButtonActive(SymbolInterface var1);

    public abstract int getActivatedButtons();

    @Override
    public void toBytes(ByteBuf buf) {
        this.addressDialed.toBytes(buf);
        buf.writeBoolean(this.brbActive);
        if (this.biomeOverride != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.biomeOverride.ordinal());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.stargateIsConnected);
        this.gateConfig.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.addressDialed.fromBytes(buf);
        this.brbActive = buf.readBoolean();
        if (buf.readBoolean()) {
            this.biomeOverride = BiomeOverlayEnum.values()[buf.readInt()];
        }
        this.stargateIsConnected = buf.readBoolean();
        this.gateConfig.fromBytes(buf);
    }
}

