/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeModContainer;

public class BlockRenderer {
    public static void render(World world, BlockPos relativePos, IBlockState state, BlockPos lightPos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(relativePos.func_177958_n() - lightPos.func_177958_n()), (float)(relativePos.func_177956_o() - lightPos.func_177956_o()), (float)(relativePos.func_177952_p() - lightPos.func_177952_p()));
        GlStateManager.func_179140_f();
        BlockRendererDispatcher blockRendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        blockRendererDispatcher.func_175019_b().func_187497_c((IBlockAccess)world, blockRendererDispatcher.func_184389_a(state), state, lightPos, tessellator.func_178180_c(), false, 0L);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    public static void renderItemGUI(@Nullable ItemStack stack) {
        BlockRenderer.renderItem(stack, ItemCameraTransforms.TransformType.GUI);
    }

    public static void renderItem(@Nullable ItemStack stack, ItemCameraTransforms.TransformType type) {
        BlockRenderer.renderItem(stack, type, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderItem(@Nullable ItemStack stack, ItemCameraTransforms.TransformType type, float red, float green, float blue, float alpha) {
        if (stack == null) {
            return;
        }
        ResourceLocation itemGlintTexture = new ResourceLocation("textures/misc/enchanted_item_glint.png");
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        IBakedModel bakedModel = renderItem.func_184393_a(stack, null, null);
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179131_c((float)red, (float)green, (float)1.0f, (float)alpha);
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        if (type == ItemCameraTransforms.TransformType.GUI) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
            GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        if (bakedModel.func_177556_c()) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
        bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)type, (boolean)false);
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (bakedModel.func_188618_c()) {
                GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
                GlStateManager.func_179091_B();
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            } else {
                renderItem.func_191961_a(bakedModel, stack);
                if (stack.func_77962_s()) {
                    GlStateManager.func_179132_a((boolean)false);
                    GlStateManager.func_179143_c((int)514);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    textureManager.func_110577_a(itemGlintTexture);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
                    float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
                    GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
                    renderItem.func_191965_a(bakedModel, -8372020);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
                    float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
                    GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
                    renderItem.func_191965_a(bakedModel, -8372020);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179143_c((int)515);
                    GlStateManager.func_179132_a((boolean)true);
                    textureManager.func_110577_a(TextureMap.field_110575_b);
                }
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    public static void renderItemOnGround(ItemStack stack) {
        BlockRenderer.renderItemOnGround(stack, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderItemOnGround(ItemStack stack, float red, float green, float blue, float alpha) {
        if (stack == null) {
            return;
        }
        int color = new Color(red, green, blue, alpha).hashCode();
        GlStateManager.func_179094_E();
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        IBakedModel model = renderItem.func_184393_a(stack, null, null);
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.func_188618_c()) {
                GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
                GlStateManager.func_179091_B();
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            } else {
                if (ForgeModContainer.allowEmissiveItems) {
                    ForgeHooksClient.renderLitItem((RenderItem)renderItem, (IBakedModel)model, (int)color, (ItemStack)stack);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179121_F();
                    return;
                }
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
                    renderItem.func_191970_a(bufferbuilder, model.func_188616_a((IBlockState)null, enumfacing, 0L), color, stack);
                }
                GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
                renderItem.func_191970_a(bufferbuilder, model.func_188616_a((IBlockState)null, (EnumFacing)null, 0L), color, stack);
                tessellator.func_78381_a();
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }
}

