/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.loader.texture.TextureLoader;

public class AncientRenderer {
    public static final double ONE_DIGIT_X = 5.0;
    public static final double SPACE_BETWEEN_X = 1.6666666666666667;
    public static final double HOURS_START_X = -22.5;
    public static final double MINUTES_START_X = -16.666666666666668;
    public static final double SECONDS_START_X = -10.833333333333334;
    public static final double TICKS_START_X = -5.0;

    public static void renderClock(long ticks, boolean renderWholeTime, long countToTicks, boolean twoDim) {
        int hours = (int)Math.floor((double)ticks / 72000.0);
        int minutes = (int)Math.floor((double)(ticks % 72000L) / 1200.0);
        int seconds = (int)Math.floor((double)(ticks % 1200L) / 20.0);
        int ticksDisplay = (int)(Math.floor(ticks % 20L) / 20.0 * 60.0);
        AncientRenderer.renderClock(hours, minutes, seconds, ticksDisplay, renderWholeTime, countToTicks, twoDim);
    }

    public static void renderClock(int hours, int minutes, int seconds, int ticks, boolean renderWholeTime, long countToTicks, boolean twoDim) {
        if (hours > 0 || renderWholeTime) {
            GlStateManager.func_179137_b((double)-22.5, (double)0.0, (double)0.0);
            AncientRenderer.renderTime(hours, minutes, seconds, ticks, twoDim);
        } else if (minutes > 0) {
            GlStateManager.func_179137_b((double)-16.666666666666668, (double)0.0, (double)0.0);
            AncientRenderer.renderTime(minutes, seconds, ticks, twoDim);
        } else if (countToTicks != -1L) {
            GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
            if (seconds > 0) {
                GlStateManager.func_179137_b((double)-10.833333333333334, (double)0.0, (double)0.0);
                AncientRenderer.renderTime(seconds, ticks, twoDim);
            } else {
                GlStateManager.func_179137_b((double)-5.0, (double)0.0, (double)0.0);
                AncientRenderer.renderTime(ticks, twoDim);
            }
        }
    }

    public static void renderTime(int hours, int minutes, int seconds, int ticks, boolean twoDim) {
        GlStateManager.func_179094_E();
        AncientRenderer.renderNumber((int)Math.floor((double)hours / 10.0), twoDim);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)5.0, (double)0.0, (double)0.0);
        GlStateManager.func_179094_E();
        AncientRenderer.renderNumber(hours % 10, twoDim);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)3.3333333333333335, (double)0.0, (double)0.0);
        AncientRenderer.renderNumber(-1, twoDim);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)6.666666666666667, (double)0.0, (double)0.0);
        AncientRenderer.renderTime(minutes, seconds, ticks, twoDim);
    }

    public static void renderTime(int minutes, int seconds, int ticks, boolean twoDim) {
        GlStateManager.func_179094_E();
        AncientRenderer.renderNumber((int)Math.floor((double)minutes / 10.0), twoDim);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)5.0, (double)0.0, (double)0.0);
        GlStateManager.func_179094_E();
        AncientRenderer.renderNumber(minutes % 10, twoDim);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)3.3333333333333335, (double)0.0, (double)0.0);
        AncientRenderer.renderNumber(-1, twoDim);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)6.666666666666667, (double)0.0, (double)0.0);
        AncientRenderer.renderTime(seconds, ticks, twoDim);
    }

    public static void renderTime(int seconds, int ticks, boolean twoDim) {
        GlStateManager.func_179094_E();
        AncientRenderer.renderNumber((int)Math.floor((double)seconds / 10.0), twoDim);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)5.0, (double)0.0, (double)0.0);
        GlStateManager.func_179094_E();
        AncientRenderer.renderNumber(seconds % 10, twoDim);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)3.3333333333333335, (double)0.0, (double)0.0);
        AncientRenderer.renderNumber(-2, twoDim);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)6.666666666666667, (double)0.0, (double)0.0);
        AncientRenderer.renderTime(ticks, twoDim);
    }

    public static void renderTime(int ticks, boolean twoDim) {
        GlStateManager.func_179094_E();
        AncientRenderer.renderNumber((int)Math.floor((double)ticks / 10.0), twoDim);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)5.0, (double)0.0, (double)0.0);
        GlStateManager.func_179094_E();
        AncientRenderer.renderNumber(ticks % 10, twoDim);
        GlStateManager.func_179121_F();
    }

    public static void renderString(String s, boolean twoDim) {
        s = s.toLowerCase();
        for (int i = 0; i < s.length(); ++i) {
            GlStateManager.func_179094_E();
            try {
                String newPart;
                char c = s.charAt(i);
                if (AncientRenderer.isCharNotAllowed(s.charAt(i))) {
                    c = '_';
                }
                if ((newPart = c + "").equals(".")) {
                    newPart = "dot";
                }
                if (newPart.equals(",")) {
                    newPart = "comma";
                }
                if (newPart.equals(":")) {
                    newPart = "colon";
                }
                if (newPart.equals("?")) {
                    newPart = "question";
                }
                if (newPart.equals("!")) {
                    newPart = "exclamation";
                }
                if (newPart.equals("_")) {
                    newPart = "under";
                }
                if (newPart.equals("-")) {
                    newPart = "dash";
                }
                AncientRenderer.renderCharacter(newPart, twoDim);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179137_b((double)5.0, (double)0.0, (double)0.0);
        }
    }

    public static boolean isCharNotAllowed(char c) {
        c = Character.toLowerCase(c);
        String allowed = "abcdefghijklmnopqrstuvwxyz1234567890_-:.,!? ";
        for (int i = 0; i < "abcdefghijklmnopqrstuvwxyz1234567890_-:.,!? ".length(); ++i) {
            char s = "abcdefghijklmnopqrstuvwxyz1234567890_-:.,!? ".charAt(i);
            if (s != c) continue;
            return false;
        }
        return true;
    }

    private static void renderCharacter(String character, boolean twoDim) {
        try {
            String path = "ancient/alphabet/" + character + ".png";
            ResourceLocation tex = TextureLoader.getTextureResource(path);
            if (TextureLoader.isNotTextureLoaded(tex)) {
                return;
            }
            GlStateManager.func_179094_E();
            if (!twoDim) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (Objects.equals(character, "comma")) {
                GlStateManager.func_179137_b((double)0.0, (double)1.6666666666666667, (double)0.0);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179098_w();
            GlStateManager.func_179140_f();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
            int uvSizeX = 3;
            int uvSizeY = 10;
            AncientRenderer.drawTexturedModalRect(0, 0, 0.0f, 0.0f, uvSizeX, uvSizeY, uvSizeX, uvSizeY);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
        catch (Exception e) {
            JSG.error("Error while rendering ancient character: " + character, e);
        }
    }

    public static void renderNumber(int number, boolean twoDim) {
        if (number < -2) {
            number = -2;
        }
        if (number > 9) {
            number = 9;
        }
        String character = number == -2 ? "dot_center" : (number == -1 ? "colon" : number + "");
        AncientRenderer.renderCharacter(character, twoDim);
    }

    public static void drawTexturedModalRect(int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

